<?php

if (basename($_SERVER['PHP_SELF']) == basename(__FILE__)) {
    die('Error , cannot Access To this File .');
}
function error_template($error_number,$goback){
    $message = '';

    $er_404 = "We couldn't find the file to download.";
    $er_423 = "This file has already been downloaded.";
    $er_498 = "This download has expired.";
    $er_499 = "No download key was provided. Please return to the previous page and try again.";
    $er_400 = "No file was found to download.";
    $er_403 = "You Must Use History Purchase For Download This file";
    $er_401 = 'Access to this resource on the server is denied!';
    $direction = 'ltr';
    $go = 'GO';
    $back = 'BACK';
    if (isset($_GET['lang'])&& $_GET['lang']=='fa_IR'){
        $er_404 = "فایلی برای دانلود پیدا نشد.";
        $er_423 = "این فایل قبلا دانلود شده است.";
        $er_498 = "زمان استفاده برای دانلود این فایل پایان یافته است.";
        $er_499 = "لینک اشتباه است.";
        $er_400 = " درخواست اشتباه است.";
        $er_403 = "برای دانلود این فایل باید از صفحه کاربری خود اقدام نمایید.";
        $er_401 = 'دسترسی شما محدود شده است.';
        $direction = 'rtl';
        $go = 'بازگشت به ';
        $back = 'سایت';
    }
    switch ($error_number) {
        case 404:
            header("HTTP/1.1 404 File not Found.");
            $message = $er_404;
            break;
        case 423:
            header("HTTP/1.1 423 File Has been Downloaded.");
            $message = $er_423;
            break;
        case 498:
            header("HTTP/1.1 498 Link Expired.");
            $message = $er_498;
            break;
        case 499:
            header("HTTP/1.1 499 Token Required.");
            $message = $er_499;
            break;
        case 400:
            header("HTTP/1.1 400 Bad Request.");
            $message = $er_400;
            break;
        case 403:
            header("HTTP/1.1 403 Invalid IP");
            $message = $er_403;
            break;
        case 401 :
            header("HTTP/1.1 401 Unauthorized ");
            $message = $er_401;
            break;
    }
    ?>
    <!DOCTYPE html>
    <html>
    <head>
    <meta charset="UTF-8">
    <link href="../assets/error.css" rel="stylesheet">
    </head>
    <body style="direction:<?php echo $direction;?>;">
    <div class="wrapper row2">
        <div id="container" class="clear">
            <section id="fof" class="clear">
                <div class="positioned">
                    <div class="hgroup">
                        <h1>!</h1>
                        <h2><?php echo $error_number;?></h2><br>
                           <p> <?php echo $message;?></p>
                    </div>
                    <?php if (!empty($goback)):?>
                    <p> <?php echo $go;?> <a href="<?php echo $goback;?>" ><?php echo $back;?></a></p>
                    <?php endif;?>
                </div>
            </section>
        </div>
    </div>
    </body>
    </html>
    <?php
    die();
}

