<?php
/**
 * The template for displaying 404 pages (not found)
 *
 */
get_header();

$ahe = new MiionHeaderElements;
$aps = new MiionPostSettings;
$template = 'page'; // template id
$aps->miionSetPostTemplate( $template );
$template_class = $aps->miionTemplateContentClass();
?>
<div class="wrap">
	<div id="primary" class="content-area error-404-area miion-page">
		<main id="main" class="site-main">
		
			<?php $ahe->miionPageTitle( $template ); ?>
		
			<section class="error-404 not-found text-center">
				<div class="container">
					<header class="page-header">
						
						<div class="image-wrap-404">
							<img src="<?php echo esc_url( MIION_ASSETS . '/images/404.png' ); ?>">
							
						</div>	
						
						<div class="relative mb-2">
							<h3 class="page-title"><?php esc_html_e( 'Page Not Found', 'miion' ); ?></h3>
						</div>
						<?php 
							$home_url = home_url( '/' ); 
						?>
							<p class="error-description">
								<?php esc_html_e( 'Congratulations you have found our error Page', 'miion' ); ?>
								<?php esc_html_e( 'go back to home', 'miion' ); ?>
							</p>							
							<a class="home-link" href="<?php echo esc_url( $home_url ); ?>">
								<?php esc_html_e( 'Home Page', 'miion' ); ?>
							</a>
					</header><!-- .page-header -->
				</div><!-- .container -->
			</section><!-- .error-404 -->
		</main><!-- #main -->
	</div><!-- #primary -->
</div><!-- .wrap -->
<?php get_footer();