<?php

//Theme Option -> Custom Post Type
$cpt_config_panel = new Miion_WP_Customize_Panel( $wp_customize, 'cpt_config_panel', array(
	'title'			=> esc_html__( 'Custom Post Types', 'miion' ),
	'description'	=> esc_html__( 'Custom Post Type Settings Area.', 'miion' ),
	'priority'		=> 10,
	'panel'			=> 'miion_theme_panel'
));
$wp_customize->add_panel( $cpt_config_panel );

//Custom Post Type -> General Settings
$miion_cpt_general_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_cpt_general_section', array(
	'title'			=> esc_html__( 'General Settings', 'miion' ),
	'description'	=> esc_html__( 'This is custom post type settings area.', 'miion' ),
	'priority'		=> 1,
	'panel'			=> 'cpt_config_panel'
));
$wp_customize->add_section( $miion_cpt_general_section );

//General Settings
$wp_customize->add_setting('ajax_trigger_miion_cpt_general_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_cpt_general_section', array(
	'section'		=> 'miion_cpt_general_section'
)));

//Custom Post Types
$miion_options = get_option( 'miion_theme_options_new' );
$selected_cpt = isset( $miion_options['cpt-opts'] ) && !empty( $miion_options['cpt-opts'] ) ? $miion_options['cpt-opts'] : '';

//Custom Post Type -> Team
if( !empty( $selected_cpt ) && is_array( $selected_cpt ) && in_array( 'team', $selected_cpt ) ){
	
	$miion_cpt_team_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_cpt_team_section', array(
		'title'			=> esc_html__( 'Team', 'miion' ),
		'description'	=> esc_html__( 'This is custom post type team setting.', 'miion' ),
		'priority'		=> 2,
		'panel'			=> 'cpt_config_panel'
	));
	$wp_customize->add_section( $miion_cpt_team_section );

	//Team
	$wp_customize->add_setting('ajax_trigger_miion_cpt_team_section', array(
		'default'           => '',
		'sanitize_callback' 	=> 'esc_attr'
	));
	$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_cpt_team_section', array(
		'section'		=> 'miion_cpt_team_section'
	)));

}// team CPT check end

//Custom Post Type -> Testimonial
if( !empty( $selected_cpt ) && is_array( $selected_cpt ) && in_array( 'testimonial', $selected_cpt ) ){
	$miion_cpt_testimonial_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_cpt_testimonial_section', array(
		'title'			=> esc_html__( 'Testimonial', 'miion' ),
		'description'	=> esc_html__( 'This is custom post type testimonial setting.', 'miion' ),
		'priority'		=> 3,
		'panel'			=> 'cpt_config_panel'
	));
	$wp_customize->add_section( $miion_cpt_testimonial_section );
	
	//Testimonial
	$wp_customize->add_setting('ajax_trigger_miion_cpt_testimonial_section', array(
		'default'           => '',
		'sanitize_callback' 	=> 'esc_attr'
	));
	$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_cpt_testimonial_section', array(
		'section'		=> 'miion_cpt_testimonial_section'
	)));
	
}// testimonial CPT check end

//Custom Post Type -> Events
if( !empty( $selected_cpt ) && is_array( $selected_cpt ) && in_array( 'events', $selected_cpt ) ){
	$miion_cpt_events_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_cpt_events_section', array(
		'title'			=> esc_html__( 'Events', 'miion' ),
		'description'	=> esc_html__( 'This is custom post type events setting.', 'miion' ),
		'priority'		=> 4,
		'panel'			=> 'cpt_config_panel'
	));
	$wp_customize->add_section( $miion_cpt_events_section );

	//Events
	$wp_customize->add_setting('ajax_trigger_miion_cpt_events_section', array(
		'default'           => '',
		'sanitize_callback' 	=> 'esc_attr'
	));
	$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_cpt_events_section', array(
		'section'		=> 'miion_cpt_events_section'
	)));
	
}// events CPT check end

//Custom Post Type -> Services
if( !empty( $selected_cpt ) && is_array( $selected_cpt ) && in_array( 'services', $selected_cpt ) ){
	$miion_cpt_services_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_cpt_services_section', array(
		'title'			=> esc_html__( 'Services', 'miion' ),
		'description'	=> esc_html__( 'This is custom post type Services setting.', 'miion' ),
		'priority'		=> 5,
		'panel'			=> 'cpt_config_panel'
	));
	$wp_customize->add_section( $miion_cpt_services_section );
	
	//Services
	$wp_customize->add_setting('ajax_trigger_miion_cpt_services_section', array(
		'default'           => '',
		'sanitize_callback' 	=> 'esc_attr'
	));
	$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_cpt_services_section', array(
		'section'		=> 'miion_cpt_services_section'
	)));
	
}// services CPT check end

//Custom Post Type -> Portfolio
if( !empty( $selected_cpt ) && is_array( $selected_cpt ) && in_array( 'portfolio', $selected_cpt ) ){
	$miion_cpt_portfolio_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_cpt_portfolio_section', array(
		'title'			=> esc_html__( 'Portfolio', 'miion' ),
		'description'	=> esc_html__( 'This is custom post type portfolio setting.', 'miion' ),
		'priority'		=> 6,
		'panel'			=> 'cpt_config_panel'
	));
	$wp_customize->add_section( $miion_cpt_portfolio_section );
	
	//Portfolio
	$wp_customize->add_setting('ajax_trigger_miion_cpt_portfolio_section', array(
		'default'           => '',
		'sanitize_callback' 	=> 'esc_attr'
	));
	$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_cpt_portfolio_section', array(
		'section'		=> 'miion_cpt_portfolio_section'
	)));
	
}// portfolio CPT check end