<?php

//Layout Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Layout', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Portfolio Template
$settings = array(
	'id'			=> 'portfolio-page-template',
	'type'			=> 'radioimage',
	'title'			=> esc_html__( 'Portfolio Template', 'miion' ),
	'description'	=> esc_html__( 'Choose your current portfolio single outer template.', 'miion' ),
	'default'		=> 'no-sidebar',
	'items' 		=> array(
		'no-sidebar'	=> MIION_ADMIN_URL . '/customizer/assets/images/page-layouts/1.png',
		'right-sidebar'	=> MIION_ADMIN_URL . '/customizer/assets/images/page-layouts/2.png',
		'left-sidebar'	=> MIION_ADMIN_URL . '/customizer/assets/images/page-layouts/3.png',
		'both-sidebar'	=> MIION_ADMIN_URL . '/customizer/assets/images/page-layouts/4.png'		
	),
	'cols'			=> '4',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Left Sidebar
$settings = array(
	'id'			=> 'portfolio-left-sidebar',
	'type'			=> 'sidebars',
	'title'			=> esc_html__( 'Left Sidebar', 'miion' ),
	'description'	=> esc_html__( 'Select widget area for showing on left side.', 'miion' ),
	'default'		=> 'sidebar-1',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Right Sidebar
$settings = array(
	'id'			=> 'portfolio-right-sidebar',
	'type'			=> 'sidebars',
	'title'			=> esc_html__( 'Right Sidebar', 'miion' ),
	'description'	=> esc_html__( 'Select widget area for showing on right side.', 'miion' ),
	'default'		=> 'sidebar-1',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Meta Items
$settings = array(
	'id'			=> 'portfolio-meta-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Portfolio Meta Items for single page', 'miion' ),
	'description'	=> esc_html__( 'Drag & Drop portfolio meta items which are needed for single portfolio page.', 'miion' ),
	'default' 		=> array(
		'Enabled' 	=> array(
			'date'		=> esc_html__( 'Date', 'miion' ),
			'client'	=> esc_html__( 'Client', 'miion' ),
			'duration'	=> esc_html__( 'Duration', 'miion' ),
			'category'	=> esc_html__( 'Category', 'miion' ),
			'tag'		=> esc_html__( 'Tags', 'miion' ),
			'share'		=> esc_html__( 'Share', 'miion' )			
		),		
		'Disabled' 	=> array(
			'estimation'=> esc_html__( 'Estimation', 'miion' ),
			'url'		=> esc_html__( 'Url', 'miion' ),
			'place'		=> esc_html__( 'Place', 'miion' )
		)
	),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Single Layouts
$settings = array(
	'id'			=> 'portfolio-layout',
	'type'			=> 'radioimage',
	'title'			=> esc_html__( 'Portfolio Single Layouts', 'miion' ),
	'description'	=> esc_html__( 'This is layout settings for portfolio single page.', 'miion' ),
	'default'		=> '1',
	'items' 		=> array(
		'1'	=> MIION_ADMIN_URL . '/customizer/assets/images/portfolio-layouts/1.png',
		'2'	=> MIION_ADMIN_URL . '/customizer/assets/images/portfolio-layouts/2.png',
		'3'	=> MIION_ADMIN_URL . '/customizer/assets/images/portfolio-layouts/3.png',
		'4'	=> MIION_ADMIN_URL . '/customizer/assets/images/portfolio-layouts/4.png'		
	),
	'cols'			=> '4',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Archive Layout Start
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Portfolio Detail Labels', 'miion' ),
	'description'	=> esc_html__( 'This is layout settings for portfolio archive page.', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Archive Layout Grid Columns
$settings = array(
	'id'			=> 'portfolio-grid-cols',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Grid Columns', 'miion' ),
	'description'	=> esc_html__( 'Select grid columns for portfolio archive layout.', 'miion' ),
	'choices'		=> array(
		'2'	=> esc_html__( '2 Columns', 'miion' ),
		'3'	=> esc_html__( '3 Columns', 'miion' ),
		'4'	=> esc_html__( '4 Columns', 'miion' )
	),
	'default'		=> 'select',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Archive Layout Grid Gutter
$settings = array(
	'id'			=> 'portfolio-grid-gutter',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Portfolio Grid Gutter', 'miion' ),
	'description'	=> esc_html__( 'Enter grid gutter size. Example 20.', 'miion' ),
	'default'		=> '20',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Archive Layout Grid Type
$settings = array(
	'id'			=> 'portfolio-grid-type',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Grid Columns', 'miion' ),
	'description'	=> esc_html__( 'Select grid columns for portfolio archive layout.', 'miion' ),
	'choices'		=> array(
			'normal'	=> esc_html__( 'Normal Grid', 'miion' ),
			'isotope'	=> esc_html__( 'Isotope Grid', 'miion' )
		
	),
	'default'		=> 'isotope',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Archive Layout End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );

//Portfolio Title
$settings = array(
	'id'			=> 'portfolio-title-opt',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Portfolio Title', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable page title on single portfolio page.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Layout End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Text Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Custom Text', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Detail Labels  - Client
$settings = array(
	'id'			=> 'portfolio-client-label',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Client', 'miion' ),
	'description'	=> esc_html__( 'Enter portfolio client label.', 'miion' ),
	'default'		=> 'Client',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Detail Labels  - Date
$settings = array(
	'id'			=> 'portfolio-date-label',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Date', 'miion' ),
	'description'	=> esc_html__( 'Enter portfolio date label.', 'miion' ),
	'default'		=> 'Date',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Detail Labels  - Duration
$settings = array(
	'id'			=> 'portfolio-duration-label',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Duration', 'miion' ),
	'description'	=> esc_html__( 'Enter portfolio duration label.', 'miion' ),
	'default'		=> 'Duration',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Detail Labels  - Estimation
$settings = array(
	'id'			=> 'portfolio-estimation-label',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Estimation', 'miion' ),
	'description'	=> esc_html__( 'Enter portfolio estimation label.', 'miion' ),
	'default'		=> 'Estimation',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Detail Labels  - Place
$settings = array(
	'id'			=> 'portfolio-place-label',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Place', 'miion' ),
	'description'	=> esc_html__( 'Enter portfolio place label.', 'miion' ),
	'default'		=> 'Place',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Detail Labels  - URL
$settings = array(
	'id'			=> 'portfolio-url-label',
	'type'			=> 'text',
	'title'			=> esc_html__( 'URL', 'miion' ),
	'description'	=> esc_html__( 'Enter portfolio url label.', 'miion' ),
	'default'		=> 'URL',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Detail Labels  - Category
$settings = array(
	'id'			=> 'portfolio-category-label',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Category', 'miion' ),
	'description'	=> esc_html__( 'Enter portfolio category label.', 'miion' ),
	'default'		=> 'Category',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Detail Labels  - Tags
$settings = array(
	'id'			=> 'portfolio-tags-label',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Tags', 'miion' ),
	'description'	=> esc_html__( 'Enter portfolio tags label.', 'miion' ),
	'default'		=> 'Tags',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Detail Labels  - Share
$settings = array(
	'id'			=> 'portfolio-share-label',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Share', 'miion' ),
	'description'	=> esc_html__( 'Enter portfolio share label.', 'miion' ),
	'default'		=> 'Share',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Text End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );

//Advanced Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Advanced', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Slug
$settings = array(
	'id'			=> 'cpt-portfolio-slug',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Portfolio Slug', 'miion' ),
	'description'	=> esc_html__( 'Enter portfolio slug for register custom post type, after entered new slug click Publish button. Then go to WordPress Settings -> Permalinks -> Click save changes button to regenerate the permalinks.', 'miion' ),
	'default'		=> 'portfolio',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Category Slug
$settings = array(
	'id'			=> 'cpt-portfolio-category-slug',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Portfolio Category Slug', 'miion' ),
	'description'	=> esc_html__( 'Enter portfolio category slug for register custom post type, after entered new slug click Publish button. Then go to WordPress Settings -> Permalinks -> Click save changes button to regenerate the permalinks.', 'miion' ),
	'default'		=> 'portfolio-category',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Tag Slug
$settings = array(
	'id'			=> 'cpt-portfolio-tag-slug',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Portfolio Tag Slug', 'miion' ),
	'description'	=> esc_html__( 'Enter portfolio tag slug for register custom post type, after entered new slug click Publish button. Then go to WordPress Settings -> Permalinks -> Click save changes button to regenerate the permalinks.', 'miion' ),
	'default'		=> 'portfolio-tag',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Sidebar on Mobile
$settings = array(
	'id'			=> 'portfolio-page-hide-sidebar',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Sidebar on Mobile', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable to show or hide sidebar on mobile.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Related Slider
$settings = array(
	'id'			=> 'portfolio-related-opt',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Related Slider', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable portfolio related slider.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Related Sliders Settings Start
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Related Sliders Settings', 'miion' ),
	'description'	=> esc_html__( 'Settings for related sliders in single portfolio page.', 'miion' ),
	'section_stat'	=> true,
	'required'		=> array( 'portfolio-related-opt', '=', 1 )
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Related Slider Items to Display
$settings = array(
	'id'			=> 'portfolio-related-slide-items',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Items to Display', 'miion' ),
	'description'	=> esc_html__( 'Enter number of slider items to display', 'miion' ),
	'default'		=> '3',
	'required'		=> array( 'portfolio-related-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Related Slider Items to Display Tab
$settings = array(
	'id'			=> 'portfolio-related-slide-tab',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Items to Display Tab', 'miion' ),
	'description'	=> esc_html__( 'Enter number of slider items to display on tab', 'miion' ),
	'default'		=> '1',
	'required'		=> array( 'portfolio-related-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Related Slider Items to Display on Mobile
$settings = array(
	'id'			=> 'portfolio-related-slide-mobile',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Items to Display on Mobile', 'miion' ),
	'description'	=> esc_html__( 'Enter items to display on mobile view. Example 1', 'miion' ),
	'default'		=> '1',
	'required'		=> array( 'portfolio-related-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Related Slider Items Scrollby
$settings = array(
	'id'			=> 'portfolio-related-slide-scrollby',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Items Scrollby', 'miion' ),
	'description'	=> esc_html__( 'Enter slider items scrollby. Example 1', 'miion' ),
	'default'		=> '1',
	'required'		=> array( 'portfolio-related-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Related Slider Slide Autoplay
$settings = array(
	'id'			=> 'portfolio-related-slide-autoplay',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Slide Autoplay', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable slide autoplay.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'portfolio-related-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Related Slider Slide Center
$settings = array(
	'id'			=> 'portfolio-related-slide-center',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Slide Center', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable slide center.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'portfolio-related-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Related Slider Slide Duration
$settings = array(
	'id'			=> 'portfolio-related-slide-duration',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Slide Duration', 'miion' ),
	'description'	=> esc_html__( 'Enter slide duration for each (in Milli Seconds). Example 5000', 'miion' ),
	'default'		=> '5000',
	'required'		=> array( 'portfolio-related-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Related Slider Slide Smart Speed
$settings = array(
	'id'			=> 'portfolio-related-slide-smartspeed',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Slide Smart Speed', 'miion' ),
	'description'	=> esc_html__( 'Enter slide smart speed for each (in Milli Seconds). Example 250', 'miion' ),
	'default'		=> '250',
	'required'		=> array( 'portfolio-related-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Related Slider Infinite Loop
$settings = array(
	'id'			=> 'portfolio-related-slide-center',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Infinite Loop', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable infinite loop.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'portfolio-related-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Related Slider Slide Items Margin
$settings = array(
	'id'			=> 'portfolio-related-slide-margin',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Slide Items Margin', 'miion' ),
	'description'	=> esc_html__( 'Enter slide item margin( item spacing ). Example 10', 'miion' ),
	'default'		=> '10',
	'required'		=> array( 'portfolio-related-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Related Slider Slide Pagination
$settings = array(
	'id'			=> 'portfolio-related-slide-pagination',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Slide Pagination', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable slide pagination.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'portfolio-related-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Related Slider Slide Navigation
$settings = array(
	'id'			=> 'portfolio-related-slide-navigation',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Slide Navigation', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable slide navigation.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'portfolio-related-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Related Slider Slide Auto Height
$settings = array(
	'id'			=> 'portfolio-related-slide-autoheight',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Slide Auto Height', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable slide item auto height.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'portfolio-related-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Related Sliders Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false,
	'required'		=> array( 'portfolio-related-opt', '=', 1 )
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Single Page Sliders Option
$settings = array(
	'id'			=> 'portfolio-single-slider-opt',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Portfolio Single Slider Option', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable portfolio single page slider.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Single Page Sliders Settings Start
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Single Page Sliders Settings', 'miion' ),
	'description'	=> esc_html__( 'Settings for single page sliders in single portfolio page.', 'miion' ),
	'section_stat'	=> true,
	'required'		=> array( 'portfolio-single-slider-opt', '=', 1 )
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Single Page Slider Items to Display
$settings = array(
	'id'			=> 'portfolio-single-slide-items',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Items to Display', 'miion' ),
	'description'	=> esc_html__( 'Enter number of slider items to display', 'miion' ),
	'default'		=> '3',
	'required'		=> array( 'portfolio-single-slider-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Single Page Slider Items to Display Tab
$settings = array(
	'id'			=> 'portfolio-single-slide-tab',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Items to Display Tab', 'miion' ),
	'description'	=> esc_html__( 'Enter number of slider items to display on tab', 'miion' ),
	'default'		=> '1',
	'required'		=> array( 'portfolio-single-slider-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Single Page Slider Items to Display on Mobile
$settings = array(
	'id'			=> 'portfolio-single-slide-mobile',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Items to Display on Mobile', 'miion' ),
	'description'	=> esc_html__( 'Enter items to display on mobile view. Example 1', 'miion' ),
	'default'		=> '1',
	'required'		=> array( 'portfolio-single-slider-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Single Page Slider Items Scrollby
$settings = array(
	'id'			=> 'portfolio-single-slide-scrollby',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Items Scrollby', 'miion' ),
	'description'	=> esc_html__( 'Enter slider items scrollby. Example 1', 'miion' ),
	'default'		=> '1',
	'required'		=> array( 'portfolio-single-slider-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Single Page Slider Slide Autoplay
$settings = array(
	'id'			=> 'portfolio-single-slide-autoplay',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Slide Autoplay', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable slide autoplay.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'portfolio-single-slider-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Single Page Slider Slide Center
$settings = array(
	'id'			=> 'portfolio-single-slide-center',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Slide Center', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable slide center.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'portfolio-single-slider-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Single Page Slider Slide Duration
$settings = array(
	'id'			=> 'portfolio-single-slide-duration',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Slide Duration', 'miion' ),
	'description'	=> esc_html__( 'Enter slide duration for each (in Milli Seconds). Example 5000', 'miion' ),
	'default'		=> '5000',
	'required'		=> array( 'portfolio-single-slider-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Single Page Slider Slide Smart Speed
$settings = array(
	'id'			=> 'portfolio-single-slide-smartspeed',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Slide Smart Speed', 'miion' ),
	'description'	=> esc_html__( 'Enter slide smart speed for each (in Milli Seconds). Example 250', 'miion' ),
	'default'		=> '250',
	'required'		=> array( 'portfolio-single-slider-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Single Page Slider Infinite Loop
$settings = array(
	'id'			=> 'portfolio-single-slide-center',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Infinite Loop', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable infinite loop.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'portfolio-single-slider-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Single Page Slider Slide Items Margin
$settings = array(
	'id'			=> 'portfolio-single-slide-margin',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Slide Items Margin', 'miion' ),
	'description'	=> esc_html__( 'Enter slide item margin( item spacing ). Example 10', 'miion' ),
	'default'		=> '10',
	'required'		=> array( 'portfolio-single-slider-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Single Page Slider Slide Pagination
$settings = array(
	'id'			=> 'portfolio-single-slide-pagination',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Slide Pagination', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable slide pagination.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'portfolio-single-slider-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Single Page Slider Slide Navigation
$settings = array(
	'id'			=> 'portfolio-single-slide-navigation',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Slide Navigation', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable slide navigation.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'portfolio-single-slider-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Single Page Slider Slide Auto Height
$settings = array(
	'id'			=> 'portfolio-single-slide-autoheight',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Slide Auto Height', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable slide item auto height.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'portfolio-single-slider-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Custom Post Type Portfolio Single Page Sliders Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false,
	'required'		=> array( 'portfolio-single-slider-opt', '=', 1 )
);
MiionCustomizerConfig::buildFields( $settings );

//Advanced End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );