<?php

//Layout Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Layout', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Footer Layout
$settings = array(
	'id'			=> 'footer-layout',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Footer Layout', 'miion' ),
	'description'	=> esc_html__( 'Choose footer layout boxed or wide.', 'miion' ),
	'choices'		=> array(
		'boxed'		=> esc_html__( 'Boxed', 'miion' ),
		'wide'		=> esc_html__( 'Wide', 'miion' )
	),
	'default'		=> 'wide',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Footer Template
$settings = array(
	'id'			=> 'footer-template',
	'type'			=> 'radioimage',
	'title'			=> esc_html__( 'Footer Template', 'miion' ),
	'description'	=> esc_html__( 'Choose footer template. Current footer layout needed option values you can see after refresh this customizer page.', 'miion' ),
	'default'		=> '1',
	'items' 		=> array(
		'1'		=> MIION_ADMIN_URL . '/customizer/assets/images/footer-layouts/1.jpg',
		'2'		=> MIION_ADMIN_URL . '/customizer/assets/images/footer-layouts/2.jpg',
		'3'		=> MIION_ADMIN_URL . '/customizer/assets/images/footer-layouts/3.jpg',
		'4'		=> MIION_ADMIN_URL . '/customizer/assets/images/footer-layouts/4.jpg',
		'5'		=> MIION_ADMIN_URL . '/customizer/assets/images/footer-layouts/5.jpg',
		'6'		=> MIION_ADMIN_URL . '/customizer/assets/images/footer-layouts/6.jpg',
		'7'		=> MIION_ADMIN_URL . '/customizer/assets/images/footer-layouts/7.jpg',
		'8'		=> MIION_ADMIN_URL . '/customizer/assets/images/footer-layouts/8.jpg',
		'custom'=> MIION_ADMIN_URL . '/customizer/assets/images/footer-layouts/custom.jpg'
	),
	'cols'			=> '1',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Footer Items
$settings = array(
	'id'			=> 'footer-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Footer Items', 'miion' ),
	'description'	=> esc_html__( 'Needed footer items drag from disabled and put enabled.', 'miion' ),
	'default' 		=> array(
		'Enabled'  => array(
			'footer-middle'	=> esc_html__( 'Footer Middle', 'miion' ),
			'footer-bottom'	=> esc_html__( 'Footer Bottom', 'miion' )
		),
		'disabled' => array(
			'footer-top' 	=> esc_html__( 'Footer Top', 'miion' )
		)
	),
	'required'		=> array( 'footer-template', '=', 'custom' ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Layout End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );

//Style Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Style', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Back to Top
$settings = array(
	'id'			=> 'back-to-top',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Back to Top', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable back to top icon.', 'miion' ),
	'default'		=> 1,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Back to Top Button Position
$settings = array(
	'id'			=> 'back-to-top-position',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Back to Top Button Position', 'miion' ),
	'description'	=> esc_html__( 'Choose position right/left for back to top button.', 'miion' ),
	'choices'		=> array(
		'right'		=> esc_html__( 'Right', 'miion' ),
		'left'		=> esc_html__( 'Left', 'miion' )
	),
	'default'		=> 'right',
	'required'		=> array( 'back-to-top', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Hidden Footer
$settings = array(
	'id'			=> 'hidden-footer',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Hidden Footer', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable hidden footer.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Footer Link Color
$settings = array(
	'id'			=> 'footer-link-color',
	'type'			=> 'link',
	'title'			=> esc_html__( 'Footer Link Color', 'miion' ),
	'description'	=> esc_html__( 'Choose footer general link color.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Footer Border
$settings = array(
	'id'			=> 'footer-border',
	'type'			=> 'border',
	'title'			=> esc_html__( 'Footer Border', 'miion' ),
	'description'	=> esc_html__( 'Here you can set border. No need to put dimension units like px, em etc. Example 10 10 20 10.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Footer Padding Option
$settings = array(
	'id'			=> 'footer-padding',
	'type'			=> 'dimension',
	'title'			=> esc_html__( 'Footer Padding Option', 'miion' ),
	'description'	=> esc_html__( 'Here no need to put dimension units like px, em etc. Example 10 10 20 10.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Footer Background
$settings = array(
	'id'			=> 'footer-background',
	'type'			=> 'background',
	'title'			=> esc_html__( 'Footer Background', 'miion' ),
	'description'	=> esc_html__( 'This is settings for footer background.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Footer Background Overlay
$settings = array(
	'id'			=> 'footer-background-overlay',
	'type'			=> 'alpha',
	'title'			=> esc_html__( 'Footer Background Overlay', 'miion' ),
	'description'	=> esc_html__( 'Choose footer background overlay color and opacity.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Style End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );