<?php

//Layout Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Layout', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Page Title Option
$settings = array(
	'id'			=> 'single-post-page-title-opt',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Page Title Option', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable page title.', 'miion' ),
	'default'		=> 1,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Page Title Items
$settings = array(
	'id'			=> 'template-single-post-pagetitle-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Page Title Items', 'miion' ),
	'description'	=> esc_html__( 'Needed items for page title wrap, drag from disabled and put enabled.', 'miion' ),
	'default' 		=> array(
		'disabled' => array(),
		'Left'  => array(
			'title' => esc_html__( 'Page Title Text', 'miion' ),
		),
		'Center' => array(),
		'Right'  => array(
			'breadcrumb'	=> esc_html__( 'Breadcrumb', 'miion' )
		)
	),
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Settings
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Archive Settings', 'miion' ),
	'description'	=> esc_html__( 'This is settings for single post page layout, sidebar sticky and etc.', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Archive Template
$settings = array(
	'id'			=> 'single-post-page-template',
	'type'			=> 'radioimage',
	'title'			=> esc_html__( 'Archive Template', 'miion' ),
	'description'	=> esc_html__( 'Choose your current single post page template.', 'miion' ),
	'default'		=> 'right-sidebar',
	'items' 		=> array(
		'no-sidebar'	=> MIION_ADMIN_URL . '/customizer/assets/images/page-layouts/1.png',
		'right-sidebar'	=> MIION_ADMIN_URL . '/customizer/assets/images/page-layouts/2.png',
		'left-sidebar'	=> MIION_ADMIN_URL . '/customizer/assets/images/page-layouts/3.png',
		'both-sidebar'	=> MIION_ADMIN_URL . '/customizer/assets/images/page-layouts/4.png'		
	),
	'cols'			=> '4',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Left Sidebar
$settings = array(
	'id'			=> 'single-post-left-sidebar',
	'type'			=> 'sidebars',
	'title'			=> esc_html__( 'Left Sidebar', 'miion' ),
	'description'	=> esc_html__( 'Select widget area for showing on left side.', 'miion' ),
	'default'		=> 'sidebar-1',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Right Sidebar
$settings = array(
	'id'			=> 'single-post-right-sidebar',
	'type'			=> 'sidebars',
	'title'			=> esc_html__( 'Right Sidebar', 'miion' ),
	'description'	=> esc_html__( 'Select widget area for showing on right side.', 'miion' ),
	'default'		=> 'sidebar-1',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Full Width Wrap
$settings = array(
	'id'			=> 'single-post-full-wrap',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Full Width Wrap', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable to show or hide full width post wrapper.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Single Post Article Top Meta Items
$settings = array(
	'id'			=> 'single-post-topmeta-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Single Post Article Top Meta Items', 'miion' ),
	'description'	=> esc_html__( 'Needed single post article top meta items drag from disabled and put enabled part. ie: Left or Right.', 'miion' ),
	'default' 		=> array(
		'Left'  => array(
			'author'	=> esc_html__( 'Author', 'miion' )						
		),
		'Right'  => array(
			'date'		=> esc_html__( 'Date', 'miion' )
		),
		'disabled' => array(
			'social'	=> esc_html__( 'Social Share', 'miion' ),						
			'likes'		=> esc_html__( 'Likes', 'miion' ),
			'author'	=> esc_html__( 'Author', 'miion' ),
			'views'		=> esc_html__( 'Views', 'miion' ),
			'tag'		=> esc_html__( 'Tags', 'miion' ),
			'favourite'	=> esc_html__( 'Favourite', 'miion' ),						
			'comments'	=> esc_html__( 'Comments', 'miion' ),
			'category'	=> esc_html__( 'Category', 'miion' )
		)
	),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Single Post Article Bottom Meta Items
$settings = array(
	'id'			=> 'single-post-bottommeta-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Single Post Article Bottom Meta Items', 'miion' ),
	'description'	=> esc_html__( 'Needed single post article bottom meta items drag from disabled and put enabled part. ie: Left or Right.', 'miion' ),
	'default' 		=> array(
		'Left'  => array(
			'category'	=> esc_html__( 'Category', 'miion' ),
		),
		'Right'  => array(),
		'disabled' => array(
			'social'	=> esc_html__( 'Social Share', 'miion' ),
			'date'		=> esc_html__( 'Date', 'miion' ),						
			'social'	=> esc_html__( 'Social Share', 'miion' ),						
			'likes'		=> esc_html__( 'Likes', 'miion' ),
			'author'	=> esc_html__( 'Author', 'miion' ),
			'views'		=> esc_html__( 'Views', 'miion' ),
			'favourite'	=> esc_html__( 'Favourite', 'miion' ),
			'comments'	=> esc_html__( 'Comments', 'miion' ),
			'tag'		=> esc_html__( 'Tags', 'miion' )
		)
	),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Single Post Article Items
$settings = array(
	'id'			=> 'single-post-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Single Post Article Items', 'miion' ),
	'description'	=> esc_html__( 'Needed single post article items drag from disabled and put enabled part. Thumbnail part covers the post format either image/audio/video/gallery/quote/link.', 'miion' ),
	'default' 		=> array(
		'Enabled'  => array(
			'title'	=> esc_html__( 'Title', 'miion' ),
			'top-meta'	=> esc_html__( 'Top Meta', 'miion' ),
			'thumb'	=> esc_html__( 'Thumbnail', 'miion' ),
			'content'	=> esc_html__( 'Content', 'miion' ),
			'bottom-meta'	=> esc_html__( 'Bottom Meta', 'miion' ),
		),
		'disabled' => array()
	),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Single Post Article Overlay
$settings = array(
	'id'			=> 'single-post-overlay-opt',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Single Post Article Overlay', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable single post article overlay.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Single Post Article Overlay Items
$settings = array(
	'id'			=> 'single-post-overlay-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Single Post Article Overlay Items', 'miion' ),
	'description'	=> esc_html__( 'Needed single post article overlay items drag from disabled and put enabled part.', 'miion' ),
	'default' 		=> array(
		'Enabled'  => array(
			'title'			=> esc_html__( 'Title', 'miion' ),
		),
		'disabled' => array(
			'top-meta'		=> esc_html__( 'Top Meta', 'miion' ),
			'bottom-meta'	=> esc_html__( 'Bottom Meta', 'miion' )
		)
	),
	'required'		=> array( 'single-post-overlay-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Single Post Page Items
$settings = array(
	'id'			=> 'single-post-page-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Single Post Page Items', 'miion' ),
	'description'	=> esc_html__( 'Needed single post items drag from disabled and put enabled part.', 'miion' ),
	'default' 		=> array(
		'Enabled'  => array(
			'post-items'	=> esc_html__( 'Post Items', 'miion' ),
			'author-info'	=> esc_html__( 'Author Info', 'miion' ),
			'post-nav'		=> esc_html__( 'Post Navigation', 'miion' ),
			'related-slider'=> esc_html__( 'Related Slider', 'miion' ),
			'comment'		=> esc_html__( 'Comment', 'miion' )
		),
		'disabled' => array()
	),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Single Post Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );

//Layout End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );

//Style Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Style', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Page Title Settings
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Page Title Settings', 'miion' ),
	'description'	=> esc_html__( 'This is page title style settings shows only when page title option active.', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Font Color
$settings = array(
	'id'			=> 'template-single-post-color',
	'type'			=> 'color',
	'title'			=> esc_html__( 'Font Color', 'miion' ),
	'description'	=> esc_html__( 'This is font color for current field.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Single Post Template  Link Color
$settings = array(
	'id'			=> 'template-single-post-link-color',
	'type'			=> 'link',
	'title'			=> esc_html__( 'Single Post Template  Link Color', 'miion' ),
	'description'	=> esc_html__( 'Choose Single post title bar link color.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Single Post Template  Border
$settings = array(
	'id'			=> 'template-single-post-border',
	'type'			=> 'border',
	'title'			=> esc_html__( 'Single Post Template  Border', 'miion' ),
	'description'	=> esc_html__( 'Here you can set border. No need to put dimension units like px, em etc. Example 10 10 20 10.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Single Post Template  Padding Option
$settings = array(
	'id'			=> 'template-single-post-padding',
	'type'			=> 'dimension',
	'title'			=> esc_html__( 'Single Post Template  Padding Option', 'miion' ),
	'description'	=> esc_html__( 'Here no need to put dimension units like px, em etc. Example 10 10 20 10.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Single Post Template  Background
$settings = array(
	'id'			=> 'template-single-post-background-all',
	'type'			=> 'background',
	'title'			=> esc_html__( 'Single Post Template  Background', 'miion' ),
	'description'	=> esc_html__( 'This is settings for footer background.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Background Parallax
$settings = array(
	'id'			=> 'single-post-page-title-parallax',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Background Parallax', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable page title background parallax.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Background Video
$settings = array(
	'id'			=> 'single-post-page-title-bg',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Background Video', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable page title background video.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Page Title Background Video
$settings = array(
	'id'			=> 'single-post-page-title-video',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Page Title Background Video', 'miion' ),
	'description'	=> esc_html__( 'Set page title background video for page. Only allowed youtube video id. Example: UWF7dZTLW4c', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'single-post-page-title-bg', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Page Title Overlay
$settings = array(
	'id'			=> 'single-post-page-title-overlay',
	'type'			=> 'alpha',
	'title'			=> esc_html__( 'Page Title Overlay', 'miion' ),
	'description'	=> esc_html__( 'Choose page title overlay rgba color.', 'miion' ),
	'default'		=> '',
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Page Title Items Option
$settings = array(
	'id'			=> 'template-single-post-page-title-items-opt',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Page Title Items Option', 'miion' ),
	'description'	=> esc_html__( 'Enable to make page title items custom layout.', 'miion' ),
	'default'		=> 0,
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Page Title Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false,
	'required'		=> array( 'single-post-page-title-opt', '=', 1 )
);
MiionCustomizerConfig::buildFields( $settings );

//Single Post Article Skin Settings
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Single Post Article Skin Settings', 'miion' ),
	'description'	=> esc_html__( 'This is skin settings for each single post article.', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Article Font Color
$settings = array(
	'id'			=> 'single-post-article-color',
	'type'			=> 'color',
	'title'			=> esc_html__( 'Article Font Color', 'miion' ),
	'description'	=> esc_html__( 'This is font color for single post article.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Article Link Color
$settings = array(
	'id'			=> 'single-post-article-link-color',
	'type'			=> 'link',
	'title'			=> esc_html__( 'Article Link Color', 'miion' ),
	'description'	=> esc_html__( 'Choose single post article link color for single post article.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Article Border
$settings = array(
	'id'			=> 'single-post-article-border',
	'type'			=> 'border',
	'title'			=> esc_html__( 'Article Border', 'miion' ),
	'description'	=> esc_html__( 'Here you can set border. No need to put dimension units like px, em etc. Example 10 10 20 10.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Article Padding Option
$settings = array(
	'id'			=> 'single-post-article-padding',
	'type'			=> 'dimension',
	'title'			=> esc_html__( 'Article Padding Option', 'miion' ),
	'description'	=> esc_html__( 'Here no need to put dimension units like px, em etc. Example 10 10 20 10.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Article Background
$settings = array(
	'id'			=> 'single-post-article-background',
	'type'			=> 'color',
	'title'			=> esc_html__( 'Article Background Color', 'miion' ),
	'description'	=> esc_html__( 'This is background color for single post article.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 0
);
MiionCustomizerConfig::buildFields( $settings );

//Single Post Article Skin Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );

//Single Post Article Overlay Skin Settings
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Single Post Article Overlay Skin Settings', 'miion' ),
	'description'	=> esc_html__( 'This is overlay skin settings for each single post article.', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Article Font Color
$settings = array(
	'id'			=> 'single-post-article-overlay-color',
	'type'			=> 'color',
	'title'			=> esc_html__( 'Article Font Color', 'miion' ),
	'description'	=> esc_html__( 'This is font color for single post article.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Article Link Color
$settings = array(
	'id'			=> 'single-post-article-overlay-link-color',
	'type'			=> 'link',
	'title'			=> esc_html__( 'Article Link Color', 'miion' ),
	'description'	=> esc_html__( 'Choose single post article overlay link color for single post article.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 0
);
MiionCustomizerConfig::buildFields( $settings );

//Article Border
$settings = array(
	'id'			=> 'single-post-article-overlay-border',
	'type'			=> 'border',
	'title'			=> esc_html__( 'Article Border', 'miion' ),
	'description'	=> esc_html__( 'Here you can set border. No need to put dimension units like px, em etc. Example 10 10 20 10.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Article Padding Option
$settings = array(
	'id'			=> 'single-post-article-overlay-padding',
	'type'			=> 'dimension',
	'title'			=> esc_html__( 'Article Padding Option', 'miion' ),
	'description'	=> esc_html__( 'Here no need to put dimension units like px, em etc. Example 10 10 20 10.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Article Background
$settings = array(
	'id'			=> 'single-post-article-overlay-background',
	'type'			=> 'color',
	'title'			=> esc_html__( 'Article Background Color', 'miion' ),
	'description'	=> esc_html__( 'This is background color for single post article.', 'miion' ),
	'default'		=> '',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Single Post Article Overlay Skin Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );

//Style End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );

//Advanced Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Advanced', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Post Format Settings Start
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Post Format Settings', 'miion' ),
	'description'	=> esc_html__( 'This is post format settings for single post.', 'miion' ),
	'section_stat'	=> true
);
MiionCustomizerConfig::buildFields( $settings );

//Video Format
$settings = array(
	'id'			=> 'single-post-video-format',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Video Format', 'miion' ),
	'description'	=> esc_html__( 'Choose single post page video post format settings.', 'miion' ),
	'choices'		=> array(
		'onclick' 	=> esc_html__( 'On Click Run Video', 'miion' ),
		'overlay' 	=> esc_html__( 'Modal Box Video', 'miion' ),
		'direct' 	=> esc_html__( 'Direct Video', 'miion' )
	),
	'default'		=> 'onclick',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Quote Format
$settings = array(
	'id'			=> 'single-post-quote-format',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Quote Format', 'miion' ),
	'description'	=> esc_html__( 'Choose single post page quote post format settings.', 'miion' ),
	'choices'		=> array(
		'featured' 		=> esc_html__( 'Dark Overlay', 'miion' ),
		'theme-overlay' => esc_html__( 'Theme Overlay', 'miion' ),
		'theme' 		=> esc_html__( 'Theme Color Background', 'miion' ),
		'none' 			=> esc_html__( 'None', 'miion' )
	),
	'default'		=> 'featured',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Link Format
$settings = array(
	'id'			=> 'single-post-link-format',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Link Format', 'miion' ),
	'description'	=> esc_html__( 'Choose single post page link post format settings.', 'miion' ),
	'choices'		=> array(
		'featured' 		=> esc_html__( 'Dark Overlay', 'miion' ),
		'theme-overlay' => esc_html__( 'Theme Overlay', 'miion' ),
		'theme' 		=> esc_html__( 'Theme Color Background', 'miion' ),
		'none' 			=> esc_html__( 'None', 'miion' )
	),
	'default'		=> 'featured',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Gallery Format
$settings = array(
	'id'			=> 'single-post-gallery-format',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Gallery Format', 'miion' ),
	'description'	=> esc_html__( 'Choose single post page gallery post format settings.', 'miion' ),
	'choices'		=> array(
		'default'	=> esc_html__( 'Default Gallery', 'miion' ),
		'popup' 	=> esc_html__( 'Popup Gallery', 'miion' ),
		'grid' 		=> esc_html__( 'Grid Popup Gallery', 'miion' )
	),
	'default'		=> 'default',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Post Format Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );

//Single Post Featured Slider
$settings = array(
	'id'			=> 'single-post-featured-slider',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Single Post Featured Slider', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable single post featured slider.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Sidebar Sticky
$settings = array(
	'id'			=> 'single-post-sidebar-sticky',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Sidebar Sticky', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable sidebar sticky.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Sidebar on Mobile
$settings = array(
	'id'			=> 'single-post-page-hide-sidebar',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Sidebar on Mobile', 'miion' ),
	'description'	=> esc_html__( 'Enable/Disable to show or hide sidebar on mobile.', 'miion' ),
	'default'		=> 0,
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Related Post Max Limit
$settings = array(
	'id'			=> 'related-max-posts',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Related Post Max Limit', 'miion' ),
	'description'	=> esc_html__( 'Enter related post maximum limit for get from posts query. Example 5', 'miion' ),
	'default'		=> '5',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Related Posts From
$settings = array(
	'id'			=> 'related-posts-filter',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Related Posts From', 'miion' ),
	'description'	=> esc_html__( 'Select related posts gets from category or tag.', 'miion' ),
	'choices'		=> array(
		'category'	=> esc_html__( 'Category', 'miion' ),
		'tag'		=> esc_html__( 'Tag', 'miion' )
	),
	'default'		=> 'category',
	'refresh'		=> 1
);
MiionCustomizerConfig::buildFields( $settings );

//Advanced End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
MiionCustomizerConfig::buildFields( $settings );