<?php

//Theme Option -> General
$theme_general_panel = new Miion_WP_Customize_Panel( $wp_customize, 'theme_general_panel', array(
	'title'			=> esc_html__( 'General', 'miion' ),
	'description'	=> esc_html__( 'These are the general settings of Miion theme', 'miion' ),
	'priority'		=> 1,
	'panel'			=> 'miion_theme_panel'
));
$wp_customize->add_panel( $theme_general_panel );

//General -> Layout
$miion_layout_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_layout_section', array(
	'title'			=> esc_html__( 'Layout', 'miion' ),
	'description'	=> esc_html__( 'This is the setting for theme layouts', 'miion' ),
	'priority'		=> 1,
	'panel'			=> 'theme_general_panel'
));
$wp_customize->add_section( $miion_layout_section );

//Layout
$wp_customize->add_setting('ajax_trigger_miion_layout_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_layout_section', array(
	'section'		=> 'miion_layout_section'
)));

//General -> Loaders
$miion_loader_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_loader_section', array(
	'title'			=> esc_html__('Loaders', 'miion'),
	'description'	=> esc_html__( 'This is the setting for theme loader images.', 'miion' ),
	'priority'		=> 2,
	'panel'			=> 'theme_general_panel'
));
$wp_customize->add_section( $miion_loader_section );

//Loaders
$wp_customize->add_setting('ajax_trigger_miion_loader_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_loader_section', array(
	'section'		=> 'miion_loader_section'
)));

//General -> Theme Logo
$miion_logo_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_logo_section', array(
	'title'			=> esc_html__('Site Logo\'s', 'miion'),
	'description'	=> esc_html__( 'This is the setting for all the site logo\'s.', 'miion' ),
	'priority'		=> 3,
	'panel'			=> 'theme_general_panel'
));
$wp_customize->add_section( $miion_logo_section );

//Theme Logo
$wp_customize->add_setting('ajax_trigger_miion_logo_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_logo_section', array(
	'section'		=> 'miion_logo_section'
)));

//General -> API's
$miion_api_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_api_section', array(
	'title'			=> esc_html__('API', 'miion'),
	'description'	=> esc_html__( 'This is the setting for all the api\'s where used in this site.', 'miion' ),
	'priority'		=> 4,
	'panel'			=> 'theme_general_panel'
));
$wp_customize->add_section( $miion_api_section );

//API's
$wp_customize->add_setting('ajax_trigger_miion_api_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_api_section', array(
	'section'		=> 'miion_api_section'
)));

//General -> Comments
$miion_comments_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_comments_section', array(
	'title'			=> esc_html__('Comments', 'miion'),
	'description'	=> esc_html__( 'This is the setting for comments.', 'miion' ),
	'priority'		=> 5,
	'panel'			=> 'theme_general_panel'
));
$wp_customize->add_section( $miion_comments_section );

//Comments
$wp_customize->add_setting('ajax_trigger_miion_comments_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_comments_section', array(
	'section'		=> 'miion_comments_section'
)));

//General -> Smooth Scroll
$miion_smooth_scroll_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_smooth_scroll_section', array(
	'title'			=> esc_html__('Smooth Scroll', 'miion'),
	'description'	=> esc_html__( 'This is the setting for page smooth scroll.', 'miion' ),
	'priority'		=> 6,
	'panel'			=> 'theme_general_panel'
));
$wp_customize->add_section( $miion_smooth_scroll_section );

//Smooth Scroll
$wp_customize->add_setting('ajax_trigger_miion_smooth_scroll_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_smooth_scroll_section', array(
	'section'		=> 'miion_smooth_scroll_section'
)));

//General -> Media Settings
$miion_media_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_media_section', array(
	'title'			=> esc_html__('Media Settings', 'miion'),
	'description'	=> esc_html__( 'This is the setting for media sizes', 'miion' ),
	'priority'		=> 7,
	'panel'			=> 'theme_general_panel'
));
$wp_customize->add_section( $miion_media_section );

//Media Settings
$wp_customize->add_setting('ajax_trigger_miion_media_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_media_section', array(
	'section'		=> 'miion_media_section'
)));

//General -> RTL
$miion_rtl_section = new Miion_WP_Customize_Section( $wp_customize, 'miion_rtl_section', array(
	'title'			=> esc_html__('RTL', 'miion'),
	'description'	=> esc_html__( 'This is the setting for theme view RTL', 'miion' ),
	'priority'		=> 8,
	'panel'			=> 'theme_general_panel'
));
$wp_customize->add_section( $miion_rtl_section );

//RTL
$wp_customize->add_setting('ajax_trigger_miion_rtl_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_miion_rtl_section', array(
	'section'		=> 'miion_rtl_section'
)));