<?php

/**
 * Miion Theme Customize Config
 */
 
if ( ! class_exists( 'WP_Customize_Control' ) ) {
	return null;
}

 
class Miion_Theme_Customize_Config {

	public static $miion_options = '';
	
	public static $miion_theme_opt_def = array();

	public static function miion_register ( $wp_customize ) {
	
		// Be safe.
		if ( ! isset( $wp_customize ) ) {
				return;
		}
		
		//update_option( 'miion_theme_options_t', '' );
		
		//Custom Panel and Section
		$wp_customize->register_panel_type( 'Miion_WP_Customize_Panel' );
		$wp_customize->register_section_type( 'Miion_WP_Customize_Section' );
			 
		// Add three levels on panels
		$miion_theme_panel = new Miion_WP_Customize_Panel( $wp_customize, 'miion_theme_panel', array(
			'priority'       => 10,
			'capability'     => 'edit_theme_options',
			'title'          => esc_html__( 'Miion Theme Options', 'miion' ),
			'description'    => esc_html__( 'Several settings pertaining my theme', 'miion' ),
		));
		$wp_customize->add_panel( $miion_theme_panel );
		
		//General Config
		require_once MIION_ADMIN .'/customizer/config-parts/general-config.php';
		
		//Skin Config
		require_once MIION_ADMIN .'/customizer/config-parts/skin-config.php';
		
		//Typography Config
		if ( class_exists( 'MiionFamework' ) ) {
			require_once MIION_ADMIN .'/customizer/config-parts/typo-config.php';
		}

		//Header Config
		require_once MIION_ADMIN .'/customizer/config-parts/header-config.php';
		
		//Footer Config
		require_once MIION_ADMIN .'/customizer/config-parts/footer-config.php';
		
		//Theme Template
		require_once MIION_ADMIN .'/customizer/config-parts/theme-template-config.php';
		
		//Theme Sliders
		require_once MIION_ADMIN .'/customizer/config-parts/slider-config.php';
		
		//Social Links
		require_once MIION_ADMIN .'/customizer/config-parts/social-config.php';
		
		//CPT Settings
		require_once MIION_ADMIN .'/customizer/config-parts/cpt-config.php';
		
		//Maintenance
		require_once MIION_ADMIN .'/customizer/config-parts/maintenance-config.php';
		
		//Woo
		if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
			require_once MIION_ADMIN .'/customizer/config-parts/woo-config.php';
		}
		
		//Member
		if ( in_array( 'miion-member-addon/zozo-member-addon.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
			require_once MIION_ADMIN .'/customizer/config-parts/member-config.php';
		}
		
		//Import and Export
		require_once MIION_ADMIN .'/customizer/config-parts/import-export-config.php';
		
		if ( isset( $wp_customize->selective_refresh ) ) {
			//Site title
			$wp_customize->selective_refresh->add_partial(
				'blogname',
				array(
					'selector'	=> '.site-title',
					'render_callback'     => function(){ bloginfo( 'name' ); }
				)
			);
			//Tagline
			$wp_customize->selective_refresh->add_partial(
				'blogdescription',
				array(
					'selector'	=> '.logo-tagline'
				)
			);
		}
		
	}
	
	
}

add_action( 'customize_register' , array( 'Miion_Theme_Customize_Config' , 'miion_register' ) );