<?php
/**
 * The arcihve template for displaying all custom post types
 */
 
get_header(); 
$ahe = new MiionHeaderElements;
$aps = new MiionPostSettings;
$template = 'blog'; // template id
if( $aps->miionCheckTemplateExists( 'archive' ) ){
	$template = 'archive';
}
$aps->miionSetPostTemplate( $template );
$template_class = $aps->miionTemplateContentClass();
$full_width_class = '';
$acpt = new MiionCPT;

?>
<div class="miion-content <?php echo esc_attr( 'miion-' . $template ); ?>">
		
		<?php $ahe->miionHeaderSlider('bottom'); ?>
		
		<?php $ahe->miionPageTitle( $template ); ?>
		<div class="miion-content-inner">
			<div class="container">
	
				<div class="row">
					
					<div class="<?php echo esc_attr( $template_class['content_class'] ); ?>">
						<div id="primary" class="content-area">
							<?php
								$q_object = get_queried_object();
								$cpt = '';
								if( isset($q_object->name) )
									$cpt = $q_object->name;

								if( $cpt == 'miion-portfolio' ){
									$acpt->miionCPTCallTaxTemplate( 'portfolio-archive' );
								}elseif( $cpt == 'miion-team' ){
									$acpt->miionCPTCallTaxTemplate( 'team-archive' );
								}elseif( $cpt == 'miion-services' ){
									$acpt->miionCPTCallTaxTemplate( 'services-archive' );
								}elseif( $cpt == 'miion-events' ){
									$acpt->miionCPTCallTaxTemplate( 'events-archive' );
								}elseif( $cpt == 'miion-testimonial' ){
									$acpt->miionCPTCallTaxTemplate( 'testimonial-archive' );
								}else{
									require_once get_template_directory() . '/template-parts/post/content-none.php';
								}
							?>				
						</div><!-- #primary -->
					</div><!-- main col -->
					
					<?php if( $template_class['lsidebar_class'] != '' ) : ?>
					<div class="<?php echo esc_attr( $template_class['lsidebar_class'] ); ?>">
						<aside class="widget-area left-widget-area<?php echo esc_attr( $template_class['sticky_class'] ); ?>">
							<?php dynamic_sidebar( $template_class['left_sidebar'] ); ?>
						</aside>
					</div><!-- sidebar col -->
					<?php endif; ?>
					
					<?php if( $template_class['rsidebar_class'] != '' ) : ?>
					<div class="<?php echo esc_attr( $template_class['rsidebar_class'] ); ?>">
						<aside class="widget-area right-widget-area<?php echo esc_attr( $template_class['sticky_class'] ); ?>">
							<?php dynamic_sidebar( $template_class['right_sidebar'] ); ?>
						</aside>
					</div><!-- sidebar col -->
					<?php endif; ?>
					
				</div><!-- row -->
			
		</div><!-- .container -->
	</div><!-- .miion-content-inner -->
</div><!-- .miion-content -->
<?php get_footer();