<?php

define( 'naga_updraftplus_min_reqiered_php', '7.4' ); // without dot (not 7.4.0)
define( 'naga_updraftplus_min_reqiered_ioncube', '12' ); // without dot (not 12.0.0)

add_action( 'init', function() {
	load_textdomain( 'naga-updraftplus-notices', plugin_dir_path( __FILE__ ) . 'languages/' . 'naga-updraftplus-notices-fa_IR.mo' );
});

require_once( plugin_dir_path( __FILE__ ) . 'includes/naga-updraftplus-notices.php' );

// Load NagaTheme License, RTL and Persian Files
if( version_compare( PHP_VERSION, naga_updraftplus_min_reqiered_php ) >= 0 ) {
	
	if( extension_loaded( 'ionCube Loader' ) ) {
		
		if( function_exists( 'ioncube_loader_version' ) && version_compare( ioncube_loader_version(), naga_updraftplus_min_reqiered_ioncube ) >= 0 ) {
			
			require_once( plugin_dir_path( __FILE__ ) . 'naga-updraftplus-ic.php' );
			
		} else {
			
			add_action( 'admin_notices', 'naga_updraftplus_ioncube_version_notice' );
			add_action( 'admin_init', 'naga_updraftplus_deactivate_licenses' );
			
		}
			
	} else {
		
		add_action( 'admin_notices', 'naga_updraftplus_ioncube_notice' );
		add_action( 'admin_init', 'naga_updraftplus_deactivate_licenses' );
		
	}
} else {
	
	add_action( 'admin_notices', 'naga_updraftplus_php_notice' );
	add_action( 'admin_init', 'naga_updraftplus_deactivate_licenses' );

}