<?php
/**
 * Plugin Name: Bina Elementor Extension
 * Description: افزونه مکمل المنتور قالب بینا
 * Plugin URI:  https://porii.ir/
 * Version:     1.1.1
 * Author:      pouria zamani
 * Author URI:  https://porii.ir/
 * Text Domain: Bina-extension
 * Domain Path: /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 *
 * The main class that initiates and runs the plugin.
 *
 * @since 1.0.0
 */
final class Elementor_Bina_Extension {

	/**
	 * Plugin Version
	 *
	 * @since 1.0.0
	 *
	 * @var string The plugin version.
	 */
	const VERSION = '1.0.0';

	/**
	 * Minimum Elementor Version
	 *
	 * @since 1.0.0
	 *
	 * @var string Minimum Elementor version required to run the plugin.
	 */
	const MINIMUM_ELEMENTOR_VERSION = '2.4.1';

	/**
	 * Minimum PHP Version
	 *
	 * @since 1.0.0
	 *
	 * @var string Minimum PHP version required to run the plugin.
	 */
	const MINIMUM_PHP_VERSION = '7.0';

	/**
	 * Instance
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 * @static
	 *
	 * @var Elementor_Bina_Extension The single instance of the class.
	 */
	private static $_instance = null;

	/**
	 * Instance
	 *
	 * Ensures only one instance of the class is loaded or can be loaded.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 * @static
	 *
	 * @return Elementor_Bina_Extension An instance of the class.
	 */
	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;

	}

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function __construct() {

		add_action( 'init', [ $this, 'i18n' ] );
		add_action( 'plugins_loaded', [ $this, 'init' ] );

	}

	/**
	 * Load Textdomain
	 *
	 * Load plugin localization files.
	 *
	 * Fired by `init` action hook.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function i18n() {

		load_plugin_textdomain( 'Bina-extension', FALSE, basename( dirname( __FILE__ ) ) . '/languages/' );

	}

	/**
	 * Initialize the plugin
	 *
	 * Load the plugin only after Elementor (and other plugins) are loaded.
	 * Checks for basic plugin requirements, if one check fail don't continue,
	 * if all check have passed load the files required to run the plugin.
	 *
	 * Fired by `plugins_loaded` action hook.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function init() {

		// Check if Elementor installed and activated
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
			return;
		}

		// Check for required Elementor version
		if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
			return;
		}

		// Check for required PHP version
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
			return;
		}

		// Register Widget Styles
		add_action( 'elementor/frontend/after_enqueue_styles', [ $this, 'widget_styles' ] );

		add_action('elementor/frontend/after_enqueue_scripts', [ $this, 'widget_scripts' ] );

		// Add Plugin actions
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'init_widgets' ] );
		add_action( 'elementor/controls/controls_registered', [ $this, 'init_controls' ] );
        // icon bezaram?
		add_filter('elementor/icons_manager/native',array($this,'add_custom_icon_to_elementor_icons'));
        // Category Init
		add_action( 'elementor/init', [ $this, 'elementor_common_category' ] );

	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have Elementor installed or activated.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function admin_notice_missing_main_plugin() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor */
			esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'Bina-extension' ),
			'<strong>' . esc_html__( 'Bina Elementor Extension', 'Bina-extension' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'Bina-extension' ) . '</strong>'
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have a minimum required Elementor version.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function admin_notice_minimum_elementor_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'Bina-extension' ),
			'<strong>' . esc_html__( 'Bina Elementor Extension', 'Bina-extension' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'Bina-extension' ) . '</strong>',
			 self::MINIMUM_ELEMENTOR_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have a minimum required PHP version.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function admin_notice_minimum_php_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: PHP 3: Required PHP version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'Bina-extension' ),
			'<strong>' . esc_html__( 'Bina Elementor Extension', 'Bina-extension' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'Bina-extension' ) . '</strong>',
			 self::MINIMUM_PHP_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	/**
	 * Init Widgets
	 *
	 * Include widgets files and register them
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function init_widgets() {

		require_once( __DIR__ . '/widgets/pori-infobox.php' );
		require_once( __DIR__ . '/widgets/pori-counterup.php' );
		require_once( __DIR__ . '/widgets/pori-price.php' );
		require_once( __DIR__ . '/widgets/pori-iconbox.php' );
		require_once( __DIR__ . '/widgets/pori-iconbox1.php' );
		require_once( __DIR__ . '/widgets/pori-iconbox2.php' );
		require_once( __DIR__ . '/widgets/pori-iconbox3.php' );
		require_once( __DIR__ . '/widgets/pori-iconbox4.php' );
	//	require_once( __DIR__ . '/widgets/pori-iconbox5.php' );
		require_once( __DIR__ . '/widgets/pori-iconboxs.php' );
		require_once( __DIR__ . '/widgets/pori-price2.php' );
		require_once( __DIR__ . '/widgets/pori-team.php' );
		require_once( __DIR__ . '/widgets/pori-title.php' );
		require_once( __DIR__ . '/widgets/pori-title2.php' );
		require_once( __DIR__ . '/widgets/pori-title3.php' );
		require_once( __DIR__ . '/widgets/pori-infobox1.php' );
		require_once( __DIR__ . '/widgets/pori-infobox2.php' );
		require_once( __DIR__ . '/widgets/pori-service.php' );
		require_once( __DIR__ . '/widgets/pori-service2.php' );
		require_once( __DIR__ . '/widgets/pori-service3.php' );
		require_once( __DIR__ . '/widgets/pori-service4.php' );
		require_once( __DIR__ . '/widgets/pori-service5.php' );
		require_once( __DIR__ . '/widgets/pori-servicep.php' );
		require_once( __DIR__ . '/widgets/pori-team1.php' );
		require_once( __DIR__ . '/widgets/pori-team2.php' );
		require_once( __DIR__ . '/widgets/pori-team3.php' );
		require_once( __DIR__ . '/widgets/pori-team4.php' );
		require_once( __DIR__ . '/widgets/pori-portfolio.php' );
		require_once( __DIR__ . '/widgets/pori-category.php' );
		require_once( __DIR__ . '/widgets/pori-category2.php' );
		require_once( __DIR__ . '/widgets/pori-project.php' );
		require_once( __DIR__ . '/widgets/pori-imgbox.php' );
		require_once( __DIR__ . '/widgets/pori-docbox.php' );
		require_once( __DIR__ . '/widgets/pori-docwork.php' );
		require_once( __DIR__ . '/widgets/pori-docteam.php' );
		require_once( __DIR__ . '/widgets/pori-doctesti.php' );
		require_once( __DIR__ . '/widgets/pori-accordion.php' );
		require_once( __DIR__ . '/widgets/pori-slider.php' );
	//	require_once( __DIR__ . '/widgets/pori-slider2.php' );
		require_once( __DIR__ . '/widgets/pori-about.php' );
		require_once( __DIR__ . '/widgets/pori-about2.php' );
		require_once( __DIR__ . '/widgets/pori-about3.php' );
		require_once( __DIR__ . '/widgets/pori-aboutimage.php' );
		require_once( __DIR__ . '/widgets/pori-sab.php' );
		require_once( __DIR__ . '/widgets/pori-cou.php' );
		require_once( __DIR__ . '/widgets/pori-category3.php' );
		require_once( __DIR__ . '/widgets/pori-gallery.php' );
		require_once( __DIR__ . '/widgets/pori-testi.php' );
		require_once( __DIR__ . '/widgets/pori-flipbox.php' );
		require_once( __DIR__ . '/widgets/widgets/pori-post.php' );
		require_once( __DIR__ . '/widgets/pori-anim.php' );
		require_once( __DIR__ . '/widgets/pori-cf7.php' );
		require_once( __DIR__ . '/widgets/pori-address.php' );
	//	require_once( __DIR__ . '/widgets/pori-blog.php' );

		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_feabox_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_infobox_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_infobox2_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_iconboxmoren_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_iconboxclassic_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_iconboxnum_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_iconboxdoki_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_iconboxs_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_cf7_bina() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_counter_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_iconbox_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_Price_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_Price2_bina() );		
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_title_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_title2_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_title3_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_service_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_service2_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_service3_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_service4_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_service5_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_servicepez_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_Price3_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_Team_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_Team2_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_Team3_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_Team4_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_portfolio_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_category_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_category2_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_category3_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_project_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_imgbox_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_docbox_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_docwork_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_docteam_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Pori_doctesti_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_Accordion_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_slider_bina() );
	//	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_slider2_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_about_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_about2_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_about3_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_aboutimage_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_sab_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_cou_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_gallery_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_testi_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_flipbox_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_post_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_anim_bina() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_address_bina() );
	//	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \pori_blog2_bina() );
	}

	/**
	 * Init Controls
	 *
	 * Include controls files and register them
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function init_controls() {

		/*
		* Todo: this block needs to be commented out when the custom control is ready
		*
		*
		// Include Control files
		require_once( __DIR__ . '/controls/test-control.php' );
		// Register control
		\Elementor\Plugin::$instance->controls_manager->register_control( 'control-type-', new \Test_Control() );
		*/

	}

	// Custom CSS
	public function widget_styles() {

	
		wp_register_style( 'Bina-theme-style', plugins_url( 'js/theme.css', __FILE__ ) );
		wp_register_style( 'flaticon', plugins_url( 'css/flaticon.css', __FILE__ ) );
		wp_register_style( 'Bina-extension-style', plugins_url( 'css/style.css', __FILE__ ) );
		wp_register_style( 'venobox', plugins_url( 'css/venobox.css', __FILE__ ) );
		wp_register_style( 'owl', plugins_url( 'css/owl.carousel.min.css', __FILE__ ) );
		wp_enqueue_style('flaticon');
		wp_enqueue_style('venobox');
		wp_enqueue_style('Bina-extension-style');
		wp_enqueue_style('owl');

	}	

    // Custom JS
	public function widget_scripts() {
		
		wp_register_script( 'Bina-main-js', plugins_url( 'js/main.js', __FILE__ ) );
		wp_register_script( 'magnific-popup', plugins_url( 'js/jquery.magnific-popup.js', __FILE__ ) );
		wp_register_script( 'flaticon', plugins_url( 'js/flaticon.js', __FILE__ ) );
		wp_register_script( 'counterup', plugins_url( 'js/jquery.counterup.min.js', __FILE__ ) );
		wp_register_script( 'waypoints', plugins_url( 'js/jquery.waypoints.min.js', __FILE__ ) );
		wp_register_script( 'venobox', plugins_url( 'js/venobox.js', __FILE__ ) );
		wp_register_script( 'pori-js', plugins_url( 'js/pori-js.js', __FILE__ ) );
		wp_register_script( 'slider', plugins_url( 'js/slider.js', __FILE__ ) );
		wp_register_script( 'owl', plugins_url( 'js/owl.carousel.min.js', __FILE__ ) );
	//	wp_register_script( 'imgcompare', plugins_url( 'js/imgcompare.js', __FILE__ ) );
		wp_register_script( 'pori-slick', plugins_url( 'js/slick.min.js', __FILE__ ) );
		wp_register_script( 'pori-gallery', plugins_url( 'js/isotop.min.js', __FILE__ ) );
		wp_register_script( 'blob', plugins_url( 'js/blob.js', __FILE__ ) );
		wp_enqueue_script('Bina-main-js');
		wp_enqueue_script('magnific-popup');
		wp_enqueue_script('flaticon');
		wp_enqueue_script('counterup');
		wp_enqueue_script('waypoints');
		wp_enqueue_script('venobox');
		wp_enqueue_script('pori-js');
		wp_enqueue_script('slider');
		wp_enqueue_script('owl');
	//	wp_enqueue_script('imgcompare');
		wp_enqueue_script('pori-slick');
		wp_enqueue_script('pori-gallery');
		wp_enqueue_script('blob');
	}

    // Custom Category
    public function elementor_common_category () {

	   \Elementor\Plugin::$instance->elements_manager->add_category( 
	   	'Bina-category',
	   	[
	   		'title' => __( 'Bina addon', 'Bina-extension' ),
	   		'icon' => 'fa fa-plug', //default icon
	   	]
	   );

	}


/**
		 * Adding custom icon to icon control in Elementor
		 */
		public function modify_controls( $controls_registry ) {
			// Get existing icons
			$icons = $controls_registry->get_control( 'icon' )->get_settings( 'options' );

			// Append new icons

			$new_icons = array_merge(
				array(
					'flaticon-graphic-design'           => esc_html__( 'graphic-design', 'Bina-extension' ),
					'flaticon-vector'                   => esc_html__( 'vector', 'Bina-extension' ),
					'flaticon-paint-palette'            => esc_html__( 'paint-palette', 'Bina-extension' ),
					'flaticon-responsive'               => esc_html__( 'responsive', 'Bina-extension' ),
					'flaticon-layers'                   => esc_html__( 'layers', 'Bina-extension' ),
					'flaticon-layers-1'                 => esc_html__( 'layers 1', 'Bina-extension' ),
					'flaticon-layers-2'                 => esc_html__( 'layers 2', 'Bina-extension' ),
					'flaticon-picture'                  => esc_html__( 'picture', 'Bina-extension' ),
					'flaticon-camera'                   => esc_html__( 'camera', 'Bina-extension' ),
					'flaticon-picture-1'                => esc_html__( 'picture-1', 'Bina-extension' ),
					'flaticon-picture-2'                => esc_html__( 'picture-2', 'Bina-extension' ),
					'flaticon-apple'                    => esc_html__( 'apple', 'Bina-extension' ),
					'flaticon-apple-1'                  => esc_html__( 'apple-2', 'Bina-extension' ),
					'flaticon-android-logo'             => esc_html__( 'android-logo', 'Bina-extension' ),
					'flaticon-android-character-symbol' => esc_html__( 'android-character', 'Bina-extension' ),
					'flaticon-android-logo-1'           => esc_html__( 'android', 'Bina-extension' ),
					'flaticon-windows'                  => esc_html__( 'windows', 'Bina-extension' ),
					'flaticon-windows-8'                => esc_html__( 'windows-8', 'Bina-extension' ),
					'flaticon-windows-logo-silhouette'  => esc_html__( 'windows-logo-silhouette', 'Bina-extension' ),
					'flaticon-rating'                   => esc_html__( 'rating', 'Bina-extension' ),
					'flaticon-review'                   => esc_html__( 'review', 'Bina-extension' ),
					'flaticon-review-1'                 => esc_html__( 'review', 'Bina-extension' ),
					'flaticon-conversation'             => esc_html__( 'conversation', 'Bina-extension' ),
					'flaticon-support'                  => esc_html__( 'support', 'Bina-extension' ),
					'flaticon-communication'            => esc_html__( 'communication', 'Bina-extension' ),
					'flaticon-customer-service'         => esc_html__( 'customer-service', 'Bina-extension' ),
					'flaticon-chat'                     => esc_html__( 'chat', 'Bina-extension' ),
					'flaticon-email'                    => esc_html__( 'email', 'Bina-extension' ),
					'flaticon-mail'                     => esc_html__( 'mail', 'Bina-extension' ),
					'flaticon-message'                  => esc_html__( 'message', 'Bina-extension' ),
					'flaticon-email-1'                  => esc_html__( 'email-1', 'Bina-extension' ),
					'flaticon-award'                    => esc_html__( 'award', 'Bina-extension' ),
					'flaticon-cap'                      => esc_html__( 'cap', 'Bina-extension' ),
					'flaticon-medal'                    => esc_html__( 'medal', 'Bina-extension' ),
					'flaticon-trophy'                   => esc_html__( 'trophy', 'Bina-extension' ),
					'flaticon-trophy-1'                 => esc_html__( 'trophy', 'Bina-extension' ),
					'flaticon-badge'                    => esc_html__( 'badge', 'Bina-extension' ),
					'flaticon-trophy-2'                 => esc_html__( 'trophy-2', 'Bina-extension' ),
					'flaticon-settings'                 => esc_html__( 'settings', 'Bina-extension' ),
					'flaticon-settings-1'               => esc_html__( 'settings', 'Bina-extension' ),
					'flaticon-tools'                    => esc_html__( 'tools', 'Bina-extension' ),
					'flaticon-customer-support'         => esc_html__( 'customer-support', 'Bina-extension' ),
					'flaticon-settings-2'               => esc_html__( 'settings-2', 'Bina-extension' ),
					'flaticon-shield'                   => esc_html__( 'shield', 'Bina-extension' ),
					'flaticon-shield-1'                 => esc_html__( 'shield', 'Bina-extension' ),
					'flaticon-checked'                  => esc_html__( 'checked', 'Bina-extension' ),
					'flaticon-analytics'                => esc_html__( 'analytics', 'Bina-extension' ),
					'flaticon-conversation-1'           => esc_html__( 'conversation', 'Bina-extension' ),
					'flaticon-speech-bubble'            => esc_html__( 'speech-bubble', 'Bina-extension' ),
					'flaticon-chat-1'                   => esc_html__( 'chat-1', 'Bina-extension' ),
					'flaticon-database'                 => esc_html__( 'database', 'Bina-extension' ),
					'flaticon-data-protection'          => esc_html__( 'protection', 'Bina-extension' ),
					'flaticon-cloud'                    => esc_html__( 'cloud', 'Bina-extension' )
					
				),
				$icons
			);

			// Then we set a new list of icons as the options of the icon control
			$controls_registry->get_control( 'icon' )->set_settings( 'options', $new_icons );
		}

/**
		 * elementor custom icons
		 * @since 2.0.0
		 * */
		public function add_custom_icon_to_elementor_icons($icons){

		

			$icons['flaticon'] = [
				'name' => 'flaticon',
				'label' => esc_html__( 'Flaticon', 'Bina-extension' ),
				'prefix' => 'flaticon-', //prefix ( like fas-fa  )
				'displayPrefix' => '', //prefix to display icon
				'labelIcon' => 'flaticon-graphic-design', //tab icon of elementor icons library
				'ver' => '1.0.0',
				'native' => true,
			];

        	return $icons;
        }
	


}

Elementor_Bina_Extension::instance();