(function ($) {
    "use strict";

    var editMode = false;
    
// accordion script starts

var binaAccordion = function( $scope, $ ) {
    var accordionTitle = $scope.find( '.pori-accordion-title' );

    // Open default actived tab
    accordionTitle.each(function(){
        if($(this).hasClass( 'active-default' ) ){
            $(this).addClass( 'active' );
            $(this).next( '.pori-accordion-content' ).slideDown();
        }
    });
    
    // Remove multiple click event for nested accordion
    accordionTitle.unbind( 'click' );

    //$accordionWrapper.children('.pori-accordion-content').first().show();
    accordionTitle.click(function(e){
        e.preventDefault();
        if ($(this).hasClass( 'active' ) ) {
            $(this).removeClass( 'active' );
            $(this).next().slideUp( 400 );
        } else {
            $(this).parent().parent().find( '.pori-accordion-title' ).removeClass( 'active' );
            $(this).parent().parent().find( '.pori-accordion-content' ).slideUp( 400 );
            $(this).toggleClass( 'active' );
            $(this).next().slideToggle( 400 );
        }	
    } );        
}

// accordion script ends

var elb_counter_loading = function ($scope, $) {
    $(".elb-counter-value").on('inview', function(isInView) {
        var elem = $(this);
        var isDone = ( (elem.attr('data-isdone') != 'yes' && elem.attr('data-repeat') != 'yes') || (elem.attr('data-repeat') == 'yes'));
        if (isInView && isDone){
            var counterOptions = {
                endVal : elem.attr('data-end-val'), 
                options : {
                    separator: elem.attr('data-separator'),
                    decimal : elem.attr('data-decimal'), 
                    duration : elem.attr('data-duration')
                }
            };
            elem.ElbCounter(counterOptions);
            elem.attr('data-isdone','yes')
        } 
        else
            elem.unbind('inview');                              
    });
};




$(window).on('elementor/frontend/init', function () {
    if( elementorFrontend.isEditMode() ) {
        editMode = true;
    }
    elementorFrontend.hooks.addAction('frontend/element_ready/elb-counter-widget.default', elb_counter_loading);
    elementorFrontend.hooks.addAction( 'frontend/element_ready/pori-bina-accordion.default', binaAccordion );
    
});	

}(jQuery));
