<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor about Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class pori_about_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve about widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'about';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve about widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'درباره ما', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve about widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-pencil';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the about widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register about widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		
// about Title
$this->add_control(
	'about_title',
	[
		'label' => __( 'عنوان', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'label_block' => true,
		'default'     => esc_html__( 'درباره ما', 'Bina-extension' ),
		'placeholder' => __( 'درباره ما', 'Bina-extension' ),
	]
);
    
         // about Sub Title
		$this->add_control(
			'about_dec',
			[
				'label' => __( 'توضیحات', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'لورم ایپیسوم متن ساختگی طراحان در سایت بینا می باشد.', 'Bina-extension' ),
				'placeholder' => __( 'توضیحات', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
            // about Sub Title
		$this->add_control(
			'about_read',
			[
				'label' => __( 'بیشتر بخوانید', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default'     => esc_html__( 'بیشتر بخوانید', 'Bina-extension' ),
				'placeholder' => __( 'بیشتر بخوانید', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
		// Team Icon Link
		$this->add_control(
			'read_link',
			[
				'label' => __( 'لینک بیشتر بخوانید', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'نمایش لینک', 'Bina-extension' ),
			]
        );
		$this->add_control(
			'show_social_icon',
			[
				'label' => __( 'نمایش آیتم ها', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'Bina-extension' ),
				'label_off' => __( 'Hide', 'Bina-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'team_title', [
				'label' => __( 'عنوان ایتم', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'طب نوین در پزشکی' , 'Bina-extension' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'team_icon',
			[
				'label' => __( 'آیکون', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-telegram',
					'library' => 'solid',
				],
			]
		);
        
        

		$this->add_control(
			'team_social_list',
			[
				'label' => __( 'اضافه کردن مورد', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ team_title }}}',
				'condition' => [
					'show_social_icon' => 'yes'
				]
			]
		);
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );


        // Sub Title Options
		$this->add_control(
			'aboutp_subtitle_heading',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'aboutp_subtitl_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .about-item h2' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'aboutp_subtitl_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .about-item h2',
			]
        );
        
        // Title Options
		$this->add_control(
			'title_heading',
			[
				'label' => __( 'توضیحات', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Title Color
        $this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} .about-item p' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .about-item p',
			]
        );

		

        // aboutp Icon Color
        $this->add_control(
			'aboutp_icon_color',
			[
				'label' => __( 'رنگ آیکون', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} .about-item ul li i' => 'color: {{VALUE}}',
				],
			]
        );

		// aboutp Icon Color
        $this->add_control(
			'abouthp_icon_color',
			[
				'label' => __( 'رنگ دکمه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} .about-item a' => 'background: {{VALUE}}',
				],
			]
        );

        $this->end_controls_section();
	}

	/**
	 * Render about widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $about_style = $settings['about_style'];
        $about_title = $settings['about_title'];
		$about_read = $settings['about_read'];
		$about_dec = $settings['about_dec'];
		$read_link = $settings['read_link']['url'];
		$show_social_icon = $settings['show_social_icon'];
		$about_image = $settings['about_image']['url'];
    ?>

<div  class="about-item about-right">
    
    <h2><?php echo $about_title; ?></h2>
    <p >
	<?php echo $about_dec; ?></p>
	<?php if($show_social_icon === 'yes') {
				?>
    <ul >
	<?php
		if ( $settings['team_social_list'] ) {
			foreach (  $settings['team_social_list'] as $item ) {
		?>
        <li ><i  class="<?php echo $item['team_icon']['value'];?>"></i><?php echo $item['team_title'];?></li>
		<?php } } ?>
    </ul>
    <a  href="<?php echo $read_link; ?>"><?php echo $about_read; ?></a>
</div>
<?php } ?>
<?php
	}

}