<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor about Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class pori_about2_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve about widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'about2';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve about widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'درباره ما مدرن', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve about widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-preferences';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the about widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register about widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		
// about Title
$this->add_control(
	'about2_title',
	[
		'label' => __( 'عنوان', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'label_block' => true,
		'default'     => esc_html__( 'درباره ما', 'Bina-extension' ),
		'placeholder' => __( 'درباره ما', 'Bina-extension' ),
	]
);

         // about Sub Title
		$this->add_control(
			'about2_dec',
			[
				'label' => __( 'توضیحات', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'لورم ایپیسوم متن ساختگی طراحان در سایت بینا می باشد.', 'Bina-extension' ),
				'placeholder' => __( 'توضیحات', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
            // about Sub Title
		$this->add_control(
			'about2_read',
			[
				'label' => __( 'عدد', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default'     => esc_html__( '45', 'Bina-extension' ),
				'placeholder' => __( 'عدد', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
		// Team Icon Link
		$this->add_control(
			'about2_sal',
			[
				'label' => __( 'سال', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( 'سال', 'Bina-extension' ),
				'label_block' => true,
			]
        );
		$this->add_control(
			'about2_tajrobe',
			[
				'label' => __( 'تجربه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'تجربه کاری', 'Bina-extension' ),
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'team_title', [
				'label' => __( 'عنوان ایتم', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'طب نوین در پزشکی' , 'Bina-extension' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'team_icon',
			[
				'label' => __( 'آیکون', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-telegram',
					'library' => 'solid',
				],
			]
		);
        
        

		$this->add_control(
			'team_social_list',
			[
				'label' => __( 'اضافه کردن مورد', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ team_title }}}',
				'condition' => [
					'about2_tajrobe' => 'yes'
				]
			]
		);
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );


        // Sub Title Options
		$this->add_control(
			'aboutp_subtitle_heading',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'aboutp_subtitl_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .pori-abu2__content .title_style1' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'aboutp_subtitl_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-abu2__content .title_style1',
			]
        );
        
        // Title Options
		$this->add_control(
			'title_heading',
			[
				'label' => __( 'توضیحات', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Title Color
        $this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} .pori-abu2__content p' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-abu2__content p',
			]
        );

		

        // aboutp Icon Color
        $this->add_control(
			'aboutp_icon_color',
			[
				'label' => __( 'رنگ آیکون', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} .pori-abu2__experience--content i' => 'color: {{VALUE}}',
				],
			]
        );

		// aboutp Icon Color
        $this->add_control(
			'abouthp_icon_color',
			[
				'label' => __( 'رنگ عدد', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} .pori-abu2__experience--content h2' => 'color: {{VALUE}}',
				],
			]
        );
// aboutp Icon Color
$this->add_control(
	'abouthp_icon_color',
	[
		'label' => __( 'رنگ عناوین باکس', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'scheme' => [
			'type' => \Elementor\Core\Schemes\Color::get_type(),
			'value' => \Elementor\Core\Schemes\Color::COLOR_1,
		],
		'default' => '#2371ff',
		'selectors' => [
			'{{WRAPPER}} .pori-abu2__experience--content .pori-abu2_experience_text' => 'background: {{VALUE}}',
		],
	]
);
        $this->end_controls_section();
	}

	/**
	 * Render about widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $about2_style = $settings['about2_style'];
        $about2_title = $settings['about2_title'];
		$about2_read = $settings['about2_read'];
		$about2_dec = $settings['about2_dec'];
		$about2_sal = $settings['about2_sal'];
		$about2_tajrobe = $settings['about2_tajrobe'];
		
    ?>


<div class="pori-abu2__content">
    <div class="title_style1">
        <h5><?php echo $about2_title; ?></h5>
        <h2><?php echo $about2_title2; ?></h2>
    </div>
    <p><?php echo $about2_dec; ?></p>
    <div class="pori-abu2__experience mt-40">
        <div class="pori-abu2__experience--content">
            <h2><?php echo $about2_read; ?><span>+</span></h2>
            <i class="far fa-paper-plane"></i>
            <div class="pori-abu2_experience_text">
                <h4><?php echo $about2_sal; ?></h4>
                <h3><?php echo $about2_tajrobe; ?></h3>
            </div>
        </div>
    </div>
</div>
<?php
	}

}