<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor about Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class pori_about3_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve about widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'about3';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve about widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'درباره ما سه', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve about widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-preferences';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the about widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register about widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		
// about Title
$this->add_control(
	'about3_title',
	[
		'label' => __( 'عنوان', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'label_block' => true,
		'default'     => esc_html__( 'درباره ما', 'Bina-extension' ),
		'placeholder' => __( 'درباره ما', 'Bina-extension' ),
	]
);

         // about Sub Title
		$this->add_control(
			'about3_dec',
			[
				'label' => __( 'توضیحات', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'لورم ایپیسوم متن ساختگی طراحان در سایت بینا می باشد.', 'Bina-extension' ),
				'placeholder' => __( 'توضیحات', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
            // about Sub Title
		$this->add_control(
			'about3_read',
			[
				'label' => __( 'عدد', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default'     => esc_html__( '45', 'Bina-extension' ),
				'placeholder' => __( 'عدد', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
		// Team Icon Link
		$this->add_control(
			'about3_sal',
			[
				'label' => __( 'سال', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( 'سال', 'Bina-extension' ),
				'label_block' => true,
			]
        );
		$this->add_control(
			'about3_tajrobe',
			[
				'label' => __( 'تجربه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'تجربه کاری', 'Bina-extension' ),
			]
		);
		$this->add_control(
			'about3_readmore',
			[
				'label' => __( 'بیشتر بخوانید', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'بیشتر بخوانید', 'Bina-extension' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'about3_readmoreurl',
			[
				'label' => __( 'لینک', 'Bina-extension' ),
                'type'        => Controls_Manager::URL,
                'label_block' => true,
                'default'     => [
                    'url'     => '#'
                ]
            ]
        );
		$this->add_control(
			'about3_call',
			[
				'label' => __( 'تماس با ما', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'تماس با ما', 'Bina-extension' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'about3_calllink',
			[
				'label' => __( 'لینک', 'Bina-extension' ),
                'type'        => Controls_Manager::URL,
                'label_block' => true,
                'default'     => [
                    'url'     => '#'
                ]
            ]
        );
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );


        // Sub Title Options
		$this->add_control(
			'aboutp_subtitle_heading',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'aboutp_subtitl_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#0c59db',
				'selectors' => [
					'{{WRAPPER}} .pori-title .title-tag' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'aboutp_subtitl_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-title .title-tag',
			]
        );
        
        // Title Options
		$this->add_control(
			'title_heading',
			[
				'label' => __( 'توضیحات', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Title Color
        $this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .about-text-block p' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .about-text-block p',
			]
        );

		

        

		// aboutp Icon Color
        $this->add_control(
			'abouthp_icon_color',
			[
				'label' => __( 'رنگ عدد', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#0c59db',
				'selectors' => [
					'{{WRAPPER}} .about-text-block .about-experience h3' => 'color: {{VALUE}}',
				],
			]
        );
// aboutp Icon Color

$this->add_control(
	'btm1_color',
	[
		'label' => __( 'رنگ دکمه اول', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'scheme' => [
			'type' => \Elementor\Core\Schemes\Color::get_type(),
			'value' => \Elementor\Core\Schemes\Color::COLOR_1,
		],
		'default' => '#0c59db',
		'selectors' => [
			'{{WRAPPER}} .mainpori-btn' => 'background-color: {{VALUE}}',
		],
	]
);
$this->add_control(
	'btm1_color1',
	[
		'label' => __( 'رنگ دکمه اول', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'scheme' => [
			'type' => \Elementor\Core\Schemes\Color::get_type(),
			'value' => \Elementor\Core\Schemes\Color::COLOR_1,
		],
		'default' => '#ffc500',
		'selectors' => [
			'{{WRAPPER}} .mainpori-btn-2' => 'background-color: {{VALUE}}',
		],
	]
);
        $this->end_controls_section();
	}

	/**
	 * Render about widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $about3_style = $settings['about3_style'];
        $about3_title = $settings['about3_title'];
		$about3_read = $settings['about3_read'];
		$about3_dec = $settings['about3_dec'];
		$about3_sal = $settings['about3_sal'];
		$about3_tajrobe = $settings['about3_tajrobe'];
		$about3_readmore = $settings['about3_readmore'];
		$about3_readmoreurl = $settings['about3_readmoreurl']['url'];
		$about3_call = $settings['about3_call'];
		$about3_calllink = $settings['about3_calllink']['url'];
		
    ?>
<div class="about-text-block pl-lg-5 mt-md-gap-60">
	<div class="pori-title mb-20">
		<span class="title-tag"><?php echo $about3_title; ?></span>
		<h2 class="title"><?php echo $about3_title2; ?></h2>
	</div>
	<p class="text-color-3"><?php echo $about3_dec; ?></p>
	<div class="about-experience pr-10 pb-40 pt-20">
		<h3><?php echo $about3_read; ?></h3>
		<span><?php echo $about3_sal; ?><br><?php echo $about3_tajrobe; ?></span>
	</div>
	<ul class="about-btns">
		<li>
			<a class="mainpori-btn" href="<?php echo $about3_readmoreurl; ?>"><?php echo $about3_readmore; ?></a>
		</li>
		<li>
			<a class="mainpori-btn mainpori-btn-2" href="<?php echo $about3_calllink; ?>">
				<i class="fa fa-envelope"></i> <?php echo $about3_call; ?>
			</a>
		</li>
	</ul>
</div>
<?php
	}

}