<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */

if ( ! defined( 'ABSPATH' ) ) exit;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;
use \Elementor\Control_Media;
use \Elementor\Icons_Manager;
use \Elementor\Repeater;
use \Elementor\Widget_Base;


class pori_accordion_bina extends Widget_Base {

	public function get_name() {
		return 'pori-bina-accordion';
	}

	public function get_title() {
		return esc_html__( 'آکاردئون', 'bina-addons-elementor' );
	}

	public function get_icon() {
		return 'eicon-accordion';
	}


	

   public function get_categories() {
		return [ 'Bina-category' ];
	}

	protected function register_controls() {
		
  		/**
  		 * bina Accordion Content Settings
  		 */
  		$this->start_controls_section(
  			'pori_section_bina_accordion_content_settings',
  			[
  				'label' => esc_html__( 'محتوا', 'bina-addons-elementor' )
  			]
  		);

  		$repeater = new Repeater();

        $repeater->start_controls_tabs('pori_accordion_item_tabs');

        $repeater->start_controls_tab('pori_accordion_item_content_tab', ['label' => __('Content', 'bina-addons-elementor')]);

        $repeater->add_control(
			'pori_bina_accordion_default_active', [
				'label'        => esc_html__( 'فعال به عنوا پیش فرض؟', 'bina-addons-elementor' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'no',
				'return_value' => 'yes'
			]
		);

        $repeater->add_control(
			'pori_bina_accordion_icon_show', [
				'label'        => esc_html__( 'فعالسازی آیکون عنوان', 'bina-addons-elementor' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'	   => __( 'On', 'bina-addons-elementor' ),
				'label_off'    => __( 'Off', 'bina-addons-elementor' ),
				'default'      => 'no',
				'return_value' => 'yes'
			]
		);
		
		$repeater->add_control(
			'pori_bina_accordion_title_icon',
			[
				'label'       => __( 'آیکون', 'bina-addons-elementor' ),
				'type'        => Controls_Manager::ICONS,
				'label_block' => true,
				'default'     => [
					'value'   => 'far fa-user',
					'library' => 'fa-regular'
				],
				'condition'   => [
					'pori_bina_accordion_icon_show' => 'yes'
				]
			]
		);

        $repeater->add_control(
			'pori_bina_accordion_title', [
				'label'   => esc_html__( 'عنوان', 'bina-addons-elementor' ),
				'type'    => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => esc_html__( 'عنوان آکاردئون', 'bina-addons-elementor' ),
				'dynamic' => [ 'active' => true ]
			]
		);
		
        $repeater->add_control(
			'pori_bina_accordion_content', [
				'label'   => esc_html__( 'محتوا', 'bina-addons-elementor' ),
				'type'    => Controls_Manager::WYSIWYG,
				'default' => esc_html__( 'لورم ایپیسوم متن ساختگی طراح در سایت بینا می باشد برای نمایش محتوا استفاده می شود', 'bina-addons-elementor' )
			]
		);

        $repeater->add_control(
            'pori_accordion_show_read_more_btn',
            [
                'label'        => esc_html__( 'فعال سازی دکمه', 'bina-addons-elementor' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'	   => __( 'On', 'bina-addons-elementor' ),
				'label_off'    => __( 'Off', 'bina-addons-elementor' ),
                'default'      => 'no',
                'return_value' => 'yes',
                'separator'	   => 'before'
            ]
        );  

        $repeater->add_control(
            'pori_accordion_read_more_btn_text',
            [   
				'label'       => esc_html__( 'متن دکمه', 'bina-addons-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__('مشاهده اطلاعات', 'bina-addons-elementor'),
				'default'     => esc_html__('مشاهده اطلاعات', 'bina-addons-elementor' ),
				'condition'   => [
                    '.pori_accordion_show_read_more_btn' => 'yes'
                ],
				'dynamic' => [
					'active' => true,
				]
            ]
        );

        $repeater->add_control(
            'pori_accordion_read_more_btn_url',
            [   
                'label'         => esc_html__( 'لینک', 'bina-addons-elementor' ),
                'type'          => Controls_Manager::URL,
                'default'       => [
                    'url'           => '#',
                    'is_external'   => ''
                ],
                'show_external'     => true,
                'placeholder'       => __( 'http://porii.ir', 'bina-addons-elementor' ),
                'condition'     => [
                    '.pori_accordion_show_read_more_btn' => 'yes'
                ]
            ]
        );

        $repeater->end_controls_tab();

   		$repeater->start_controls_tab('pori_accordion_item_image_tab', ['label' => __('عکس', 'bina-addons-elementor')]);

        $repeater->add_control(
			'pori_accordion_image', [
				'label' => esc_html__( 'انتخاب عکس', 'bina-addons-elementor' ),
				'type'  => Controls_Manager::MEDIA
			]
		);

        $repeater->end_controls_tab();

   		$repeater->start_controls_tab('pori_accordion_item_style_tab', ['label' => __('استایل', 'bina-addons-elementor')]);

        $repeater->add_control(
            'pori_accordion_each_item_container_style',
            [
				'label' => esc_html__( 'کلیت', 'bina-addons-elementor' ),
				'type'  => Controls_Manager::HEADING
            ]
        );

		$repeater->add_control(
		    'pori_accordion_each_item_container_bg_color',
		    [
		        'label'     => __( 'رنگ زمینه', 'bina-addons-elementor' ),
		        'type'      => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} {{CURRENT_ITEM}}.pori-accordion-single-item' => 'background-color: {{VALUE}};'
		        ]
		    ]
		);

        $repeater->add_control(
            'pori_accordion_each_item_title_style',
            [
				'label'     => esc_html__( 'Title', 'bina-addons-elementor' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );

		$repeater->add_control(
		    'pori_accordion_each_item_title_color',
		    [
		        'label'     => __( 'رنگ متن', 'bina-addons-elementor' ),
		        'type'      => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} {{CURRENT_ITEM}}.pori-accordion-single-item .pori-accordion-title h3' => 'color: {{VALUE}};'
		        ]
		    ]
		);

		$repeater->add_control(
		    'pori_accordion_each_item_title_bg_color',
		    [
		        'label'     => __( 'رنگ زمینه', 'bina-addons-elementor' ),
		        'type'      => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} {{CURRENT_ITEM}}.pori-accordion-single-item .pori-accordion-title' => 'background-color: {{VALUE}};'
		        ]
		    ]
		);

		$repeater->add_control(
		    'pori_accordion_each_item_title_hover_color',
		    [
		        'label'     => __( 'رنگ شناور', 'bina-addons-elementor' ),
		        'type'      => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} {{CURRENT_ITEM}}.pori-accordion-single-item .pori-accordion-title:hover h3' => 'color: {{VALUE}};'
		        ]
		    ]
		);

		$repeater->add_control(
		    'pori_accordion_each_item_title_hover_bg_color',
		    [
		        'label'     => __( 'رنگ شناور زمینه', 'bina-addons-elementor' ),
		        'type'      => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} {{CURRENT_ITEM}}.pori-accordion-single-item .pori-accordion-title:hover' => 'background-color: {{VALUE}};'
		        ]
		    ]
		);

        $repeater->add_control(
            'pori_accordion_each_item_content_style',
            [
				'label'     => esc_html__( 'محتوا', 'bina-addons-elementor' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );

		$repeater->add_group_control(
		    Group_Control_Border::get_type(),
		    [
				'name'     => 'pori_accordion_each_item_container_border',
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}.pori-accordion-single-item'
		    ]
		);

        $repeater->end_controls_tab();

        $repeater->end_controls_tabs();

  		$this->add_control(
			'pori_bina_accordion_tab',
			[
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default'	=> [
					[ 
						'pori_bina_accordion_title'          => esc_html__( 'عنوان اول', 'bina-addons-elementor' ),
						'pori_bina_accordion_default_active' => 'yes'
					],
					[ 'pori_bina_accordion_title' => esc_html__( 'عنوان دوم', 'bina-addons-elementor' ) ],
					[ 'pori_bina_accordion_title' => esc_html__( 'عنوان سوم', 'bina-addons-elementor' ) ]
				],
				'title_field' => '{{pori_bina_accordion_title}}'
			]
		);

        $this->add_control(
			'pori_bina_accordion_tab_title_show_active_inactive_icon',
			[
				'label'        => esc_html__( 'فعال سازی یا غیرفعال سازی', 'bina-addons-elementor' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'separator'	   => 'before' 
			]
		);

		$this->add_control(
			'pori_bina_accordion_tab_title_active_icon',
			[
				'label'       => __( 'فعال سازی آیکون', 'bina-addons-elementor' ),
				'type'        => Controls_Manager::ICONS,
				'default'     => [
					'value'   => 'fas fa-angle-up',
					'library' => 'fa-solid'
				],
				'condition'   => [
					'pori_bina_accordion_tab_title_show_active_inactive_icon' => 'yes'
				]
			]
		);

		$this->add_control(
			'pori_bina_accordion_tab_title_inactive_icon',
			[
				'label'       => __( 'غیر فعال سازی آیکون', 'bina-addons-elementor' ),
				'type'        => Controls_Manager::ICONS,
				'default'     => [
					'value'   => 'fas fa-angle-down',
					'library' => 'fa-solid'
				],
				'condition'   => [
					'pori_bina_accordion_tab_title_show_active_inactive_icon' => 'yes'
				]
			]
		);

  		$this->end_controls_section();

  		/**
		 * -------------------------------------------
		 * Tab Style bina Accordion Container Style
		 * -------------------------------------------
		 */
		$this->start_controls_section(
			'pori_section_bina_accordions_container_style',
			[
				'label'	=> esc_html__( 'کلیت', 'bina-addons-elementor' ),
				'tab'	=> Controls_Manager::TAB_STYLE
			]
		);		

		$this->add_control(
			'pori_accordion_container_background_color',
			[
				'label'		=> esc_html__( 'رنگ زمینه', 'bina-addons-elementor' ),
				'type'		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item' => 'background-color: {{VALUE}};'
				]
			]
		);

        $this->add_responsive_control(
            'pori_bina_accordion_container_padding',
            [
				'label'      => __('فاصله داخلی', 'bina-addons-elementor'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
                    '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'pori_bina_accordion_container_margin',
            [
				'label'        => __('فاصله خارجی', 'bina-addons-elementor'),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => ['px', '%'],
				'default'      => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '20',
					'left'     => '0',
					'isLinked' => false
				],
                'selectors'    => [
                    '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
        	Group_Control_Border::get_type(),
            [
				'name'     => 'pori_bina_accordion_container_border',
				'selector' => '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item'
            ]
		);
		
		$this->add_responsive_control(
            'pori_bina_accordion_container_border_radius',
            [
				'label'      => __('حاشیه لبه', 'bina-addons-elementor'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'default'    => [
					'top'    => '0',
					'right'  => '0',
					'bottom' => '0',
					'left'   => '0'
				],
                'selectors'  => [
                    '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'pori_accordion_container_box_shadow',
				'selector' => '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'pori_section_bina_accordions_tab_style',
			[
				'label' => esc_html__( 'عنوان', 'bina-addons-elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'            => 'pori_bina_accordion_title_typography',
				'selector'        => '{{WRAPPER}} .pori-accordion-single-item h3',
                'fields_options'  => [
                    'font_weight' => [
                        'default' => '600'
                    ]
                ]
			]
		);

        $this->add_responsive_control(
            'pori_bina_accordion_title_padding',
            [
				'label'      => __('فاصله داخلی', 'bina-addons-elementor'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'default'    => [
					'top'    => '20',
					'right'  => '20',
					'bottom' => '20',
					'left'   => '20'
				],
                'selectors'  => [
                    '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'pori_bina_accordion_title_margin',
            [
				'label'      => __('فاصله خارجی', 'bina-addons-elementor'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'default'    => [
					'top'    => '0',
					'right'  => '0',
					'bottom' => '0',
					'left'   => '0'
				],
                'selectors'  => [
                    '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
        	Group_Control_Border::get_type(),
            [
				'name'               => 'pori_bina_accordion_title_border',
				'fields_options'     => [
                    'border' 	     => [
                        'default'    => 'solid'
                    ],
                    'width'  	     => [
                        'default' 	 => [
                            'top'    => '1',
                            'right'  => '1',
                            'bottom' => '1',
                            'left'   => '1'
                        ]
                    ],
                    'color' 	     => [
                        'default'    => '#000000'
                    ]
                ],
                'selector'           => '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title'
            ]
        );

		$this->add_responsive_control(
			'pori_accordion_title_border_radius',
			[
				'label'      => esc_html__( 'حاشیه لبه', 'bina-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px'],
				'selectors'  => [
					'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title'=> 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'pori_accordion_title_box_shadow',
				'selector' => '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title'
			]
		);

		$this->start_controls_tabs( 'pori_bina_accordion_header_tabs' );

			# Normal State Tab
			$this->start_controls_tab( 'pori_bina_accordion_header_normal', [ 'label' => esc_html__( 'Normal', 'bina-addons-elementor' ) ] );
				$this->add_control(
					'pori_bina_accordion_tab_text_color',
					[
						'label'		=> esc_html__( 'رنگ متن', 'bina-addons-elementor' ),
						'type'		=> Controls_Manager::COLOR,
						'default'	=> '#000000',
						'selectors'	=> [
							'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item h3' => 'color: {{VALUE}};'
						]
					]
				);

				$this->add_control(
					'pori_bina_accordion_tab_color',
					[
						'label'     => esc_html__( 'رنگ زمینه', 'bina-addons-elementor' ),
						'type'      => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title' => 'background-color: {{VALUE}};'
						]
					]
				);
				
			$this->end_controls_tab();

			#Hover State Tab
			$this->start_controls_tab( 'pori_bina_accordion_header_hover', [ 'label' => esc_html__( 'Hover', 'bina-addons-elementor' ) ] );
				$this->add_control(
					'pori_bina_accordion_tab_text_color_hover',
					[
						'label'		=> esc_html__( 'رنگ متن', 'bina-addons-elementor' ),
						'type'		=> Controls_Manager::COLOR,
						'selectors'	=> [
							'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title:hover h3' => 'color: {{VALUE}};',
							'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title.active:hover h3' => 'color: {{VALUE}};'
						]
					]
				);

				$this->add_control(
					'pori_bina_accordion_tab_color_bg_hover',
					[
						'label'		=> esc_html__( 'رنگ زمینه', 'bina-addons-elementor' ),
						'type'		=> Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title:hover' => 'background-color: {{VALUE}};'
						]
					]
				);

			$this->end_controls_tab();

			#Active State Tab
			$this->start_controls_tab( 'pori_bina_accordion_header_active', [ 'label' => esc_html__( 'Active', 'bina-addons-elementor' ) ] );
				$this->add_control(
					'pori_bina_accordion_tab_text_color_active',
					[
						'label'		=> esc_html__( 'رنگ متن', 'bina-addons-elementor' ),
						'type'		=> Controls_Manager::COLOR,
						'selectors'	=> [
							'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title.active h3' => 'color: {{VALUE}} !important;'
						]
					]
				);

				$this->add_control(
					'pori_bina_accordion_tab_color_bg_active',
					[
						'label'		=> esc_html__( 'رنگ زمینه', 'bina-addons-elementor' ),
						'type'		=> Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title.active' => 'background-color: {{VALUE}};'
						]
					]
				);

			$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

		$this->start_controls_section(
			'pori_accordion_tab_title_icon_style',
			[
				'label'	=> esc_html__( 'عنوان ایکون', 'bina-addons-elementor' ),
				'tab'	=> Controls_Manager::TAB_STYLE
			]
		);

		$this->add_responsive_control(
            'pori_accordion_title_icon_size',
            [
                'label'        => __( 'سایز', 'bina-addons-elementor' ),
                'type'         => Controls_Manager::SLIDER,
                'range'        => [
                    'px'       => [
                        'min'  => 10,
                        'max'  => 150,
                        'step' => 2
                    ]
                ],
                'default'      => [
                    'unit'     => 'px',
                    'size'     => 20
                ],
                'selectors'    => [
                    '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title span.pori-tab-title-icon i' => 'font-size: {{SIZE}}{{UNIT}};'
                ]
            ]
        );   

	    $this->add_responsive_control(
      		'pori_accordion_title_icon_width',
      		[
				'label'    => esc_html__( 'عرض', 'bina-addons-elementor' ),
				'type'     => Controls_Manager::SLIDER,
				'default'  => [
		      		'size' => 70
		    	],
		        'range'    => [
		          	'px'   => [
		              	'max' => 100
		          	]
		        ],
		        'selectors' => [
		          	'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title span.pori-tab-title-icon' => 'width: {{SIZE}}px;'
		        ]
	      	]
	    );

        $this->add_group_control(
        	Group_Control_Border::get_type(),
            [
				'name'     => 'pori_accordion_title_icon_border',
				'selector' => '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title span.pori-tab-title-icon'
            ]
        );

        $this->add_responsive_control(
            'pori_accordion_title_icon_padding',
            [
				'label'      => __('فاصله داخلی', 'bina-addons-elementor'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
                    '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title span.pori-tab-title-icon i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'pori_accordion_title_icon_margin',
            [
				'label'      => __('فاصله خارجی', 'bina-addons-elementor'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
                    '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title span.pori-tab-title-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->start_controls_tabs( 'pori_accordion_title_icon_style_tabs' );

        	// normal state tab
        	$this->start_controls_tab( 'pori_accordion_title_icon_general_style', [ 'label' => esc_html__( 'Normal', 'bina-addons-elementor' ) ] );

			$this->add_control(
				'pori_accordion_tab_title_icon_color',
				[
					'label'		=> esc_html__( 'رنگ', 'bina-addons-elementor' ),
					'type'		=> Controls_Manager::COLOR,
					'selectors'	=> [
						'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title span.pori-tab-title-icon' => 'color: {{VALUE}};'
					]
				]
			);

			$this->add_control(
				'pori_accordion_tab_title_icon_bg_color',
				[
					'label'		=> esc_html__( 'رنگ زمینه', 'bina-addons-elementor' ),
					'type'		=> Controls_Manager::COLOR,
					'selectors'	=> [
						'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title span.pori-tab-title-icon' => 'background-color: {{VALUE}};'
					]
				]
			);

			$this->end_controls_tab();

			// active state tab
        	$this->start_controls_tab( 'pori_accordion_title_icon_active_style', [ 'label' => esc_html__( 'Active', 'bina-addons-elementor' ) ] );

			$this->add_control(
				'pori_accordion_title_icon_active_color',
				[
					'label'		=> esc_html__( 'رنگ', 'bina-addons-elementor' ),
					'type'		=> Controls_Manager::COLOR,
					'selectors'	=> [
						'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title.active span.pori-tab-title-icon i' => 'color: {{VALUE}};'
					]
				]
			);

			$this->add_control(
				'pori_accordion_title_icon_active_bg_color',
				[
					'label'		=> esc_html__( 'رنگ زمینه', 'bina-addons-elementor' ),
					'type'		=> Controls_Manager::COLOR,
					'selectors'	=> [
						'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title.active span.pori-tab-title-icon' => 'background-color: {{VALUE}};'
					]
				]
			);

			$this->end_controls_tab();
		$this->end_controls_tabs();


		$this->end_controls_section();

		$this->start_controls_section(
			'pori_accordion_active_inactive_icon_style',
			[
				'label'     => esc_html__( ' ایکون', 'bina-addons-elementor' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'pori_bina_accordion_tab_title_show_active_inactive_icon' => 'yes'
				]
			]
		);

	    $this->add_responsive_control(
      		'pori_accordion_active_inactive_icon_size',
      		[
				'label'        => esc_html__( 'سایز', 'bina-addons-elementor' ),
				'type'         => Controls_Manager::SLIDER,
                'range'        => [
                    'px'       => [
                        'min'  => 10,
                        'max'  => 150,
                        'step' => 2
                    ]
                ],
                'default'      => [
                    'unit'     => 'px',
                    'size'     => 20
                ],
				'selectors'    => [
		          	'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title .pori-active-inactive-icon i' => 'font-size: {{SIZE}}px;'
		        ]
	      	]
	    );

	    $this->add_responsive_control(
      		'pori_accordion_active_inactive_icon_width',
      		[
				'label'       => esc_html__( 'عرض', 'bina-addons-elementor' ),
				'type'        => Controls_Manager::SLIDER,
				'default'     => [
		      		'size'    => 70
		    	],
		        'range'       => [
		          	'px'      => [
		              	'max' => 100
		          	]
		        ],
		        'selectors'   => [
		          	'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title .pori-active-inactive-icon' => 'width: {{SIZE}}px;'
		        ]
	      	]
	    );

        $this->add_group_control(
        	Group_Control_Border::get_type(),
            [
				'name'     => 'pori_accordion_active_inactive_icon_border',
				'selector' => '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title .pori-active-inactive-icon'
            ]
        );

        $this->start_controls_tabs( 'pori_accordion_active_inactive_icon_style_tabs' );

        	// normal state tab
        	$this->start_controls_tab( 'pori_accordion_general_style', [ 'label' => esc_html__( 'Normal', 'bina-addons-elementor' ) ] );

			$this->add_control(
				'pori_accordion_general_icon_color',
				[
					'label'		=> esc_html__( 'رنگ', 'bina-addons-elementor' ),
					'type'		=> Controls_Manager::COLOR,
					'default'	=> '#000000',
					'selectors'	=> [
						'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title .pori-active-inactive-icon i' => 'color: {{VALUE}};'
					]
				]
			);

			$this->add_control(
				'pori_accordion_general_icon_bg_color',
				[
					'label'		=> esc_html__( 'رنگ زمینه', 'bina-addons-elementor' ),
					'type'		=> Controls_Manager::COLOR,
					'selectors'	=> [
						'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title .pori-active-inactive-icon' => 'background-color: {{VALUE}};'
					]
				]
			);

			$this->end_controls_tab();

			// active state tab
        	$this->start_controls_tab( 'pori_accordion_active_style', [ 'label' => esc_html__( 'Active', 'bina-addons-elementor' ) ] );

			$this->add_control(
				'pori_accordion_active_icon_color',
				[
					'label'		=> esc_html__( 'رنگ', 'bina-addons-elementor' ),
					'type'		=> Controls_Manager::COLOR,
					'default'	=> '#000000',
					'selectors'	=> [
						'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title.active .pori-active-inactive-icon i' => 'color: {{VALUE}};'
					]
				]
			);

			$this->add_control(
				'pori_accordion_active_icon_bg_color',
				[
					'label'		=> esc_html__( 'رنگ زمینه', 'bina-addons-elementor' ),
					'type'		=> Controls_Manager::COLOR,
					'selectors'	=> [
						'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-title.active .pori-active-inactive-icon' => 'background-color: {{VALUE}};'
					]
				]
			);

			$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
		
  		/**
		 * -------------------------------------------
		 * Tab Style bina Accordion Content Style
		 * -------------------------------------------
		 */

		$this->start_controls_section(
			'pori_section_accordion_tab_content_style_settings',
			[
				'label'	=> esc_html__( 'محتوا', 'bina-addons-elementor' ),
				'tab'	=> Controls_Manager::TAB_STYLE
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'pori_bina_accordion_content_typography',
				'selector' => '{{WRAPPER}} .pori-accordion-single-item .pori-accordion-text'
			]
		);

		$this->add_control(
			'pori_accordion_content_bg_color',
			[
				'label'		=> esc_html__( 'رنگ زمینه', 'bina-addons-elementor' ),
				'type'		=> Controls_Manager::COLOR,
				'default'	=> '',
				'selectors'	=> [
					'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-content .pori-accordion-content-wrapper' => 'background-color: {{VALUE}};'
				]
			]
		);

		$this->add_control(
			'pori_accordion_content_text_color',
			[
				'label'		=> esc_html__( 'رنگ متن', 'bina-addons-elementor' ),
				'type'		=> Controls_Manager::COLOR,
				'default'	=> '#000000',
				'selectors' => [
					'{{WRAPPER}} .pori-accordion-single-item .pori-accordion-text' => 'color: {{VALUE}};'
				]
			]
		);

        $this->add_responsive_control(
            'pori_accordion_content_padding',
            [
				'label'      => __('فاصله داخلی', 'bina-addons-elementor'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'default'    => [
					'top'    => '20',
					'right'  => '20',
					'bottom' => '20',
					'left'   => '20'
				],
                'selectors'  => [
                    '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-content .pori-accordion-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'pori_accordion_content_margin',
            [
				'label'      => __('فاصله خارجی', 'bina-addons-elementor'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'default'    => [
					'top'    => '0',
					'right'  => '0',
					'bottom' => '0',
					'left'   => '0'
				],
                'selectors'  => [
                    '{{WRAPPER}} .pori-accordion-single-item .pori-accordion-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
        	Group_Control_Border::get_type(),
            [
				'name'                 => 'pori_bina_accordion_content_border',
				'fields_options'       => [
                    'border' 	       => [
                        'default'      => 'solid'
                    ],
                    'width'  		   => [
                        'default' 	   => [
							'top'      => '0',
							'right'    => '1',
							'bottom'   => '1',
							'left'     => '1',
							'isLinked' => false
                        ]
                    ],
                    'color' 		   => [
                        'default' 	   => '#000000'
                    ]
                ],
                'selector'             => '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-content .pori-accordion-content-wrapper'
            ]
		);
		
		$this->add_responsive_control(
            'pori_accordion_content_border_radius',
            [
				'label'      => __('حاشیه لبه', 'bina-addons-elementor'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'default'    => [
					'top'    => '0',
					'right'  => '0',
					'bottom' => '0',
					'left'   => '0'
				],
                'selectors'  => [
                    '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-content .pori-accordion-content-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

  		$this->end_controls_section();

		$this->start_controls_section(
			'pori_section_accordion_tab_image_style',
			[
				'label'	=> esc_html__( 'عکس', 'bina-addons-elementor' ),
				'tab'	=> Controls_Manager::TAB_STYLE

			]
		);

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
				'name'    => 'pori_accordion_image_size',
				'label'   => esc_html__( 'نوع عکس', 'bina-addons-elementor' ),
				'default' => 'medium'
            ]
        );

        $this->add_control(
            'pori_accordion_image_align',
            [
                'label'         => esc_html__( 'موقعیت عکس', 'bina-addons-elementor' ),
                'type'          => Controls_Manager::CHOOSE,
                'toggle'        => false,
                'options'       => [
                    'left'      => [
                        'title' => esc_html__( 'چپ', 'bina-addons-elementor' ),
                        'icon'  => 'eicon-angle-left'
                    ],
                    'right'     => [
                        'title' => esc_html__( 'راست', 'bina-addons-elementor' ),
                        'icon'  => 'eicon-angle-right'
                    ]
                ],
                'default'       => 'right'
            ]
        );

        $this->add_responsive_control(
            'pori_accordion_image_padding',
            [
				'label'      => __('فاصله داخلی', 'bina-addons-elementor'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'default'    => [
                    'top'    => '20',
                    'right'  => '20',
                    'bottom' => '20',
                    'left'   => '20'
                ],
                'selectors'  => [
                    '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'pori_accordion_image_margin',
            [
				'label'      => __('فاصله خارجی', 'bina-addons-elementor'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
                    '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
		);
		
		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			[
				'name' => 'pori_accordion_image_css_filter',
				'selector' => '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-image img',
			]
		);

  		$this->end_controls_section();

		$this->start_controls_section(
            'pori_accordion_details_btn_style_section',
            [
				'label' => esc_html__( 'دکمه', 'bina-addons-elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
				'name'     => 'pori_accordion_details_btn_typography',
				'selector' => '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-button a'
            ]
        );

        $this->add_responsive_control(
            'pori_accordion_details_btn_padding',
            [
				'label'      => esc_html__( 'فاصله داخلی', 'bina-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,           
				'size_units' => [ 'px', 'em', '%' ],
				'default'    => [
					'top'    => '15',
					'right'  => '40',
					'bottom' => '15',
					'left'   => '40'
				],
                'selectors'  => [
                    '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-button a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'pori_accordion_details_btn_margin',
            [
				'label'      => esc_html__( 'فاصله خارجی', 'bina-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],   
				'default'    => [
					'top'    => '30',
					'right'  => '0',
					'bottom' => '0',
					'left'   => '0'
				],              
                'selectors'  => [
                    '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-button a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->start_controls_tabs( 'pori_accordion_details_button_style_tabs' );

            // normal state tab
            $this->start_controls_tab( 'pori_accordion_details_btn_normal', [ 'label' => esc_html__( 'Normal', 'bina-addons-elementor' ) ] );

            $this->add_control(
                'pori_accordion_details_btn_normal_text_color',
                [
                    'label'     => esc_html__( 'رنگ متن', 'bina-addons-elementor' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '#ffffff',
                    'selectors' => [
                        '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-button a' => 'color: {{VALUE}};'
                    ]
                ]
            );

            $this->add_control(
                'pori_accordion_details_btn_normal_bg_color',
                [
                    'label'     => esc_html__( 'رنگ زمینه', 'bina-addons-elementor' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '#000000',
                    'selectors' => [
                        '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-button a' => 'background-color: {{VALUE}};'
                    ]
                ]
            );

            $this->add_group_control(
            	Group_Control_Border::get_type(),
                [
					'name'               => 'pori_accordion_details_btn_border',
					'fields_options'     => [
	                    'border' 	     => [
	                        'default'    => 'solid'
	                    ],
	                    'width'  	     => [
	                        'default'    => [
	                            'top'    => '1',
	                            'right'  => '1',
	                            'bottom' => '1',
	                            'left'   => '1'
	                        ]
	                    ],
	                    'color' 	     => [
	                        'default'    => '#000000'
	                    ]
	                ],
                    'selector'           => '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-button a'
                ]
            );

			$this->add_responsive_control(
				'pori_accordion_details_button_border_radius',
				[
					'label'      => esc_html__( 'حاشیه لبه', 'bina-addons-elementor' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px'],
					'selectors'  => [
						'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-button a'=> 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					]
				]
			);

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name'      => 'pori_accordion_details_button_shadow',
                    'selector'  => '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-button a'
                ]
            );

            $this->end_controls_tab();

            // hover state tab
            $this->start_controls_tab( 'pori_accordion_details_btn_hover', [ 'label' => esc_html__( 'Hover', 'bina-addons-elementor' ) ] );

            $this->add_control(
                'pori_accordion_details_btn_hover_text_color',
                [
                    'label'     => esc_html__( 'رنگ متن', 'bina-addons-elementor' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '#000000',
                    'selectors' => [
                        '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-button a:hover' => 'color: {{VALUE}};'
                    ]
                ]
            );

            $this->add_control(
                'pori_accordion_details_btn_hover_bg_color',
                [
                    'label'     => esc_html__( 'رنگ زمینه', 'bina-addons-elementor' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '#ffffff',
                    'selectors' => [
                        '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-button a:hover' => 'background-color: {{VALUE}};'
                    ]
                ]
            );

			$this->add_group_control(
            	Group_Control_Border::get_type(),
                [
					'name'     => 'pori_accordion_details_btn_hover_border',
					'selector' => '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-button a:hover'
                ]
            );

			$this->add_responsive_control(
				'pori_accordion_details_button_border_radius_hover',
				[
					'label'      => esc_html__( 'حاشیه لبه', 'bina-addons-elementor' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px'],
					'selectors'  => [
						'{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-button a:hover'=> 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					]
				]
			);

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name'      => 'pori_accordion_details_button_hover_shadow',
                    'selector'  => '{{WRAPPER}} .pori-accordion-items .pori-accordion-single-item .pori-accordion-button a:hover'
                ]
            );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();  		

	}

    private function render_image( $accordion, $settings ) {
        $image_id   = $accordion['pori_accordion_image']['id'];
        $image_size = $settings['pori_accordion_image_size_size'];
        if ( 'custom' === $image_size ) {
            $image_src = Group_Control_Image_Size::get_attachment_image_src( $image_id, 'pori_accordion_image_size', $settings );
        } else {
            $image_src = wp_get_attachment_image_src( $image_id, $image_size );
            $image_src = $image_src[0];
        }

        return sprintf( '<img src="%s" alt="'.Control_Media::get_image_alt( $accordion['pori_accordion_image'] ).'" />', esc_url($image_src) );
    }

	protected function render() {

        $settings   = $this->get_settings_for_display();
        
        $this->add_render_attribute( 'pori_accordion_heading', 'class', 'pori-accordion-heading' );
        $this->add_render_attribute( 'pori_accordion_details', 'class', 'pori-accordion-text' );
        $this->add_render_attribute( 'pori_accordion_button', 'class', 'pori-accordion-button' );

		?>
    
        <div class="pori-accordion-items">
        	<?php do_action('pori_accordion_wrapper_before');
            foreach( $settings['pori_bina_accordion_tab'] as $key => $accordion ) :
            	do_action('pori_accordion_each_item_wrapper_before');
                
                $accordion_item_setting_key = $this->get_repeater_setting_key('pori_bina_accordion_title', 'pori_bina_accordion_tab', $key);

                $accordion_class = ['pori-accordion-title'];

                if ( $accordion['pori_bina_accordion_default_active'] === 'yes' ) {
                    $accordion_class[] = 'active-default';
                } 

                $this->add_render_attribute( $accordion_item_setting_key, 'class', $accordion_class );

				$has_image = !empty( $accordion['pori_accordion_image']['url'] ) ? 'yes' : 'no';
				$link_key  = 'link_' . $key;

				?>

                <div class="pori-accordion-single-item elementor-repeater-item-<?php echo esc_attr($accordion['_id']); ?>">
                    <div <?php echo $this->get_render_attribute_string($accordion_item_setting_key); ?>>

						<?php if ( ! empty( $accordion['pori_bina_accordion_title_icon']['value'] ) && 'yes' === $accordion['pori_bina_accordion_icon_show'] ) : ?>
							<span class="pori-tab-title-icon">
								<?php Icons_Manager::render_icon( $accordion['pori_bina_accordion_title_icon'], [ 'aria-hidden' => 'true' ] ); ?>
							</span>
						<?php endif; ?>

                        <h3 <?php echo $this->get_render_attribute_string( 'pori_accordion_heading' ); ?>><?php echo esc_attr($accordion['pori_bina_accordion_title']); ?></h3>

                        <?php if( 'yes' === $settings['pori_bina_accordion_tab_title_show_active_inactive_icon']) : ?>
                            <div class="pori-active-inactive-icon">
                                <?php if( !empty( $settings['pori_bina_accordion_tab_title_active_icon']['value'])) { ?>
                                    <span class="pori-active-icon">
                                        <?php Icons_Manager::render_icon( $settings['pori_bina_accordion_tab_title_active_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </span>                            
                                <?php } ?>
                                <?php if( !empty( $settings['pori_bina_accordion_tab_title_inactive_icon']['value'] ) ) { ?>
                                    <span class="pori-inactive-icon">
                                        <?php Icons_Manager::render_icon( $settings['pori_bina_accordion_tab_title_inactive_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </span>
                                <?php } ?>
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="pori-accordion-content">
                        <div class="pori-accordion-content-wrapper has-image-<?php echo esc_attr($has_image); ?> image-position-<?php echo esc_attr( $settings['pori_accordion_image_align'] ); ?>">
                            <div <?php echo $this->get_render_attribute_string( 'pori_accordion_details' ); ?>>
                                <div> <?php echo wp_kses_post( $accordion['pori_bina_accordion_content'] ); ?></div>
                                <?php if( 'yes' === $accordion['pori_accordion_show_read_more_btn'] ) : ?>
									<?php if( $accordion['pori_accordion_read_more_btn_url']['url'] ) { ?>
									    <?php $this->add_render_attribute( $link_key, 'href', esc_url( $accordion['pori_accordion_read_more_btn_url']['url'] ) ); ?>
									    <?php if( $accordion['pori_accordion_read_more_btn_url']['is_external'] ) { ?>
									        <?php $this->add_render_attribute( $link_key, 'target', '_blank' ); ?>
									    <?php } ?>
									    <?php if( $accordion['pori_accordion_read_more_btn_url']['nofollow'] ) { ?>
									        <?php $this->add_render_attribute( $link_key, 'rel', 'nofollow' ); ?>
									    <?php } ?>
									<?php } ?>
                                    <?php if ( ! empty( $accordion['pori_accordion_read_more_btn_text'] ) ) : ?>
                                        <div <?php echo $this->get_render_attribute_string( 'pori_accordion_button' ); ?>>
                                            <a <?php echo $this->get_render_attribute_string( $link_key ); ?>>
                                            	<?php echo esc_html( $accordion['pori_accordion_read_more_btn_text'] ); ?>
                                            </a>
                                        </div> 
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>

                            <?php if ( ! empty( $accordion['pori_accordion_image']['url'] ) ) { ?>
                                <div class="pori-accordion-image">
                                    <?php echo $this->render_image( $accordion, $settings ); ?>
                                </div>
                            <?php } ?>

                        </div>
                    </div>
                </div>
                <?php do_action('pori_accordion_each_item_wrapper_after'); ?>
            <?php endforeach; ?>
            <?php do_action('pori_accordion_wrapper_after'); ?>
        </div>
	<?php
    }
}