<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Color;
use Elementor\Scheme_Typography;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class pori_address_bina extends Widget_Base{

	/**
	 * Retrieve the widget name.
	*/
	public function get_name(){
		return 'bina_address_info';
	}

	/**
	 * Retrieve the widget title.
	*/
	public function get_title(){
		return esc_html__( 'اطلاعات تماس', 'bina-ext' );
	}

	/**
	 * Retrieve the widget icon.
	*/
	public function get_icon() {
		return 'fa fa-address-book';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	*/
	public function get_categories() {
		return ['Bina-category'];
	}

	
	protected function _register_controls(){

		$this->start_controls_section(
			'section_address_info',
			[
				'label' => esc_html__( 'اطلاعات تماس', 'bina-ext' ),
			]
		);
		$this->add_control(
			'address_title',
			[
				'label' => esc_html__( 'عنوان', 'bina-ext' ),
				'type' => Controls_Manager::TEXT,
				'default'     => esc_html__( 'اطلاعات تماس', 'Bina-extension' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'address_text',
			[
				'label' => esc_html__( 'توضیحات', 'bina-ext' ),
				'type' => Controls_Manager::TEXT,
				'default'     => esc_html__( 'لورم ایپیسوم متن ساختگی', 'Bina-extension' ),
				'label_block' => true,
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'list_icon',
			[
				'label' => esc_html__( 'آیکون', 'bina-ext' ),
				'type' => Controls_Manager::ICONS,
				
				'frontend_available' => true,
				
			]
		);
		$repeater->add_control(
			'list_title',
			[
				'label' => esc_html__( 'عنوان لیست', 'bina-ext' ),
				'type' => Controls_Manager::TEXT,
				'default'     => esc_html__( 'آدرس:', 'Bina-extension' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_text',
			[
				'label' => esc_html__( 'عنوان آدرس', 'bina-ext' ),
				'type' => Controls_Manager::TEXT,
				'default'     => esc_html__( 'قزوین میدان انقلاب خیابان تیرداد', 'Bina-extension' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_title_link',
			[
				'label' => esc_html__( 'لینک', 'bina-ext' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://porii.ir', 'bina-ext' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->add_control(
			'listItems_groups',
			[
				'label' => esc_html__( 'اطلاعات ایمیل', 'bina-ext' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'list_title' => esc_html__( 'عنوان', 'bina-ext' ),
					],

				],
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ list_title }}}',
			]
		);

		$this->end_controls_section();// end: Section

		$this->start_controls_section(
			'section_address_info_title_style',
			[
				'label' => esc_html__( 'عنوان', 'bina-ext' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sasadd_title_typography',
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .binacontact-info .section-title',
			]
		);
		$this->add_control(
			'list_title_color',
			[
				'label' => esc_html__( 'رنگ', 'bina-ext' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .binacontact-info .section-title' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		$this->start_controls_section(
			'section_address_info_cont_style',
			[
				'label' => esc_html__( 'محتوا', 'bina-ext' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'list_content_typography',
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .binacontact-info .section-title-wrap p',
			]
		);
		$this->add_control(
			'list_content_color',
			[
				'label' => esc_html__( 'رنگ', 'bina-ext' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .binacontact-info .section-title-wrap p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		// Icon
		$this->start_controls_section(
			'section_address_info_icon_style',
			[
				'label' => esc_html__( 'آیکون', 'bina-ext' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'list_icon_color',
			[
				'label' => esc_html__( 'رنگ', 'bina-ext' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .binacontact-info ul li i' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'icon_size',
			[
				'label' => esc_html__( 'سایز ایکون', 'bina-ext' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 33,
						'max' => 200,
						'step' => 1,
					],
				],
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} .binacontact-info ul li .binapori-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'icon_width',
			[
				'label' => esc_html__( 'عرض ایکون', 'bina-ext' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 33,
						'max' => 200,
						'step' => 1,
					],
				],
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} .binacontact-info ul li .binapori-icon' => 'width: calc({{SIZE}}{{UNIT}} + 15px);',
				],
			]
		);
		$this->end_controls_section();// end: Section

		$this->start_controls_section(
			'section_text_link_style',
			[
				'label' => esc_html__( 'لینک ها', 'bina-ext' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'link_text_typography',
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .binacontact-info ul li',
			]
		);
		$this->add_control(
			'link_title_color',
			[
				'label' => esc_html__( 'رنگ عنوان', 'bina-ext' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-inner-info span.list-title' => 'color: {{VALUE}};',
				],
			]
		);
		$this->start_controls_tabs( 'title_style' );
		$this->start_controls_tab(
			'title_normal',
			[
				'label' => esc_html__( 'نرمال', 'bina-ext' ),
			]
		);
		$this->add_control(
			'link_text_color',
			[
				'label' => esc_html__( 'رنگ', 'bina-ext' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-inner-info a, {{WRAPPER}} .contact-inner-info' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();  // end:Normal tab
			$this->start_controls_tab(
				'title_hover',
				[
					'label' => esc_html__( 'شناور', 'bina-ext' ),
				]
			);
		$this->add_control(
			'link_text_color_hov',
			[
				'label' => esc_html__( 'رنگ شناور', 'bina-ext' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-inner-info a:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();  // end:Hover tab
		$this->end_controls_tabs(); // end tabs
		$this->end_controls_section();// end: Section

	}

	/**
	 * Render Address Info widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	*/
	protected function render() {
		$settings = $this->get_settings_for_display();
		$address_title = !empty( $settings['address_title'] ) ? $settings['address_title'] : [];
		$address_text = !empty( $settings['address_text'] ) ? $settings['address_text'] : [];
		$listItems_groups = !empty( $settings['listItems_groups'] ) ? $settings['listItems_groups'] : [];
		$icon = $settings['icon']['value'];
		$address_title = $address_title ? '<h2 class="section-title">'.$address_title.'</h2>' : '';
		$address_text = $address_text ? '<p>'.$address_text.'</p>' : '';

	  $output = '<div class="binapori-contact">
				        <div class="binacontact-info">
				          <div class="section-title-wrap title-style-two">
				            '.$address_title.$address_text.'
				          </div>
				          <ul>';
                    // Group Param Output
										if( is_array( $listItems_groups ) && !empty( $listItems_groups ) ){
										  foreach ( $listItems_groups as $each_list ) {

										  $list_title = !empty( $each_list['list_title'] ) ? $each_list['list_title'] : '';
										  $icon = !empty( $each_list['list_icon'] ['value']) ? $each_list['list_icon'] ['value']: '';
										  $list_text = !empty( $each_list['list_text'] ) ? $each_list['list_text'] : '';
										  $list_title_link = !empty( $each_list['list_title_link']['url'] ) ? $each_list['list_title_link']['url'] : '';
											$list_title_link_external = !empty( $each_list['list_title_link']['is_external'] ) ? 'target="_blank"' : '';
											$list_title_link_nofollow = !empty( $each_list['list_title_link']['nofollow'] ) ? 'rel="nofollow"' : '';
											$list_title_link_attr = !empty( $list_title_link ) ?  $list_title_link_external.' '.$list_title_link_nofollow : '';

											$list_icon = $icon ? ' <div class="binapori-icon"><i class="'.$icon.'" aria-hidden="true"></i></div>' : '';
											$list_title_actual = $list_title ? '<span class="list-title">'.$list_title.'</span>' : '';
											$list_txt = $list_title_link ? '<a href="'.$list_title_link.'" '.$list_title_link_attr.'>'.$list_text.'</a>' : $list_text;

										  $output .= '<li>'.$list_icon.'<div class="contact-inner-info">'.$list_title_actual.$list_txt.'</div></li>';
										  }
										}

      $output .= '</ul></div></div>';

		echo $output;

	}

	/**
	 * Render Address Info widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	*/

	//protected function _content_template(){}

}

