<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor categ Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_category_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve categ widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'category';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve categ widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'دسته بندی', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve categ widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-archive-title';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the categ widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register categ widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		
// categ Title
$this->add_control(
	'categ_title',
	[
		'label' => __( 'عنوان دسته بندی', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'label_block' => true,
		'default'     => esc_html__( 'سئو', 'Bina-extension' ),
		'placeholder' => __( 'سئو', 'Bina-extension' ),
	]
);
       
        
        // categp Image
		$this->add_control(
			'categp_image',
			[
				'label' => __( 'انتخاب عکس', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
                'label_block' => true,
                'separator'=> 'before',
				'default' => [
                    'url' => Utils::get_placeholder_image_src()
                ],
				'placeholder' => __( 'انتخاب عکس', 'Bina-extension' ),
			]
        );
	
		$repeater = new \Elementor\Repeater();
		

		
        // categ Icon Link
		$repeater->add_control(
			'pori', [
				'label' => __( 'زیر دسته ها', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'گوگل آنالتیکس' , 'Bina-extension' ),
				'label_block' => true,
			]
		);
        // categ Icon Link
		$repeater->add_control(
			'categ_icon_link',
			[
				'label' => __( 'لینک آیتم', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( ' لینک', 'Bina-extension' ),
			]
        );

		$this->add_control(
			'categ_social_list',
			[
				'label' => __( 'دسته بندی ها', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ pori }}}',
				
			]
		);
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		// categp Area Background Options
		$this->add_control(
			'categp_area_back_heading',
			[
				'label' => __( 'رنگ زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		// categp Area Background Color
        $this->add_control(
			'categp_area_backh',
			[
				'label' => __( 'رنگ زمینه ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} .pori-bg-cg' => 'background-color: {{VALUE}}',
				],
			]
        );

        // Sub Title Options
		$this->add_control(
			'categp_subtitle_heading',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'categp_subtitl_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .pori-onvan h4' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'categp_subtitl_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-onvan h4',
			]
        );
        
        // Title Options
		$this->add_control(
			'title_heading',
			[
				'label' => __( 'آیتم ها', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Title Color
        $this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .pori-li' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-li',
			]
        );
        $this->end_controls_section();
	}

	/**
	 * Render categ widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $categ_style = $settings['categ_style'];
        $categ_title = $settings['categ_title'];
		$categ_tit = $settings['categ_tit'];
		$pori = $settings['pori'];
		$categ_takhasos = $settings['categ_takhasos'];
		$show_social_icon = $settings['show_social_icon'];
        $categp_image = $settings['categp_image']['url'];

		
    ?>

<div
    class="pori-bg-cg border border-radius h-100 overflow-hidden d-flex align-items-start flex-columnbg-light border border-radius h-100 overflow-hidden d-flex align-items-start flex-columnbg-light border border-radius h-100 d-flex align-items-start flex-column"
>
    <div class="p-4 mb-auto pori-onvan">
        <h4><?php echo $categ_title; ?></h4>

        
			<ul class="list-unstyled">
				<?php
						if ( $settings['categ_social_list'] ) {
							foreach (  $settings['categ_social_list'] as $item ) {
					?>
			
					<li class="mt-2 pori-li"> <a href="<?php echo $item['categ_icon_link']['url'];?>"><?php echo $item['pori']?></a></li>
				
				<?php } } ?>
			</ul>
		
    </div>
    
    <div class="d-flex justify-content-end w-100">
        <img class="img-fluid w-75 pori-left-m" src="<?php echo $categp_image;?>" alt="" />
    </div>
</div>

<?php
	}

}