<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor categ Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_category2_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve categ widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'category2';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve categ widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'دسته بندی دو', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve categ widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-archive-title';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the categ widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register categ widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		
// categ Title
$this->add_control(
	'categ_title',
	[
		'label' => __( 'عنوان دسته بندی', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'label_block' => true,
		'default'     => esc_html__( 'سئو', 'Bina-extension' ),
		'placeholder' => __( 'سئو', 'Bina-extension' ),
	]
);
       
        
$this->add_control( 'icon', [
			'label'       => esc_html__( 'آیکون', 'Bina-extension' ),
			'type'        => Controls_Manager::ICONS,
			
			'description' => esc_html__( 'انتخاب آیکون', 'Bina-extension' )
		] );
	
		$repeater = new \Elementor\Repeater();
		
		
		
        // categ Icon Link
		$repeater->add_control(
			'pori', [
				'label' => __( 'زیر دسته ها', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'گوگل آنالتیکس' , 'Bina-extension' ),
				'label_block' => true,
			]
		);
        // categ Icon Link
		$repeater->add_control(
			'categ_icon_link',
			[
				'label' => __( 'لینک آیتم', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( ' لینک', 'Bina-extension' ),
			]
        );

		$this->add_control(
			'categ_social_list',
			[
				'label' => __( 'دسته بندی ها', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ pori }}}',
				
			]
		);
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		// categp Area Background Options
		$this->add_control(
			'categp_area_back_heading',
			[
				'label' => __( 'رنگ زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		// categp Area Background Color
        $this->add_control(
			'categp_area_backh',
			[
				'label' => __( 'رنگ زمینه ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#ebf6fa',
				'selectors' => [
					'{{WRAPPER}} .card-cate' => 'background-color: {{VALUE}}',
				],
			]
        );
 // Sub Title Color
 $this->add_control(
	'categp_subtitlf_color',
	[
		'label' => __( 'رنگ آیکون', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'scheme' => [
			'type' => \Elementor\Core\Schemes\Color::get_type(),
			'value' => \Elementor\Core\Schemes\Color::COLOR_1,
		],
		'default' => '#00b761',
		'selectors' => [
			'{{WRAPPER}} .card-cate figure' => 'color: {{VALUE}}',
		],
	]
);
        // Sub Title Options
		$this->add_control(
			'categp_subtitle_heading',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'categp_subtitl_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .card-heading .card-title' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'categp_subtitl_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .card-heading .card-title',
			]
        );
        
        // Title Options
		$this->add_control(
			'title_heading',
			[
				'label' => __( 'آیتم ها', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Title Color
        $this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .card-menu .menu-item a' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .card-menu .menu-item a',
			]
        );

		

       

		

        $this->end_controls_section();
	}

	/**
	 * Render categ widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $categ_style = $settings['categ_style'];
        $categ_title = $settings['categ_title'];
		$categ_tit = $settings['categ_tit'];
		$pori = $settings['pori'];
		$categ_takhasos = $settings['categ_takhasos'];
		$show_social_icon = $settings['show_social_icon'];
        $icon = $settings['icon']['value'];

		
    ?>

<div class="card-cate">
    <div class="card-heading">
	
        <figure>
		<i class="<?php echo $icon;?>"></i>
        </figure>
		
        <h4 class="card-title"><?php echo $categ_title; ?></h4>
    </div>
    <div class="card-content">
        <ul class="card-menu ls-20">
		<?php
			if ( $settings['categ_social_list'] ) {
				foreach (  $settings['categ_social_list'] as $item ) {
		?>
            <li class="menu-item"><i class="far fa-caret-left"></i><a href="<?php echo $item['categ_icon_link']['url'];?>" class="item-link"><?php echo $item['pori']?></a></li>
            <?php } } ?>
        </ul>
    </div>
	
</div>







<?php
	}

}