<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor categ3 Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_category3_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve categ3 widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'categ3ory3';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve categ3 widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'دسته بندی سه', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve categ3 widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-archive-title';
	}

	/**
	 * Get widget categ3ories.
	 *
	 * Retrieve the list of categ3ories the categ3 widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categ3ories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register categ3 widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		
// categ3 Title
$this->add_control(
	'categ3_title',
	[
		'label' => __( 'عنوان دسته بندی', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'label_block' => true,
		'default'     => esc_html__( 'سئو', 'Bina-extension' ),
		'placeholder' => __( 'سئو', 'Bina-extension' ),
	]
);
       // categ3 url
$this->add_control(
	'categ3_link',
	[
		'label' => __( 'لینک', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::URL,
		'label_block' => true,
		
	]
);
        
$this->add_control( 'icon', [
			'label'       => esc_html__( 'آیکون', 'Bina-extension' ),
			'type'        => Controls_Manager::ICONS,
			
			'description' => esc_html__( 'انتخاب آیکون', 'Bina-extension' )
		] );
	
		$repeater = new \Elementor\Repeater();
		
		
		
        // categ3 Icon Link
		$repeater->add_control(
			'pori', [
				'label' => __( 'زیر دسته ها', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'گوگل آنالتیکس' , 'Bina-extension' ),
				'label_block' => true,
			]
		);
        // categ3 Icon Link
		$repeater->add_control(
			'categ3_icon_link',
			[
				'label' => __( 'لینک آیتم', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( ' لینک', 'Bina-extension' ),
			]
        );

		$this->add_control(
			'categ3_social_list',
			[
				'label' => __( 'دسته بندی ها', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ pori }}}',
				
			]
		);
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		// categ3p Area Background Options
		$this->add_control(
			'categ3p_area_back_heading',
			[
				'label' => __( 'رنگ زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		// categ3p Area Background Color
        $this->add_control(
			'categ3p_area_backh',
			[
				'label' => __( 'رنگ زمینه ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#161616',
				'selectors' => [
					'{{WRAPPER}} .grid-item-inner' => 'background-color: {{VALUE}}',
				],
			]
        );

        // Sub Title Options
		$this->add_control(
			'categ3p_subtitle_heading',
			[
				'label' => __( 'متن', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'categ3p_subtitl_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .item--title ' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'categ3p_subtitl_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .item--title ',
			]
        );
        
        // Title Options
		$this->add_control(
			'title_heading',
			[
				'label' => __( 'آیتم ها', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Title Color
        $this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .item--feature li' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .item--feature li',
			]
        );

		

       

		

        $this->end_controls_section();
	}

	/**
	 * Render categ3 widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $categ3_style = $settings['categ3_style'];
        $categ3_title = $settings['categ3_title'];
		$categ3_tit = $settings['categ3_tit'];
		$pori = $settings['pori'];
		$categ3_takhasos = $settings['categ3_takhasos'];
		$show_social_icon = $settings['show_social_icon'];
        $icon = $settings['icon']['value'];
		$categ3_link = $settings['categ3_link']['url'];

		
    ?>


<div class="grid-item-inner active" data-wow-duration="1.2s">
    <div class="item--icon-abs"><i class="<?php echo $icon;?>"></i></div>
    <div class="item--holder">
        <div class="item--icon"><i class="<?php echo $icon;?>"></i></div>
        <h3 class="item--title">
            <a href="<?php echo $categ3_link;?>"><?php echo $categ3_title; ?></a>
        </h3>
        <ul class="item--feature">
		<?php
			if ( $settings['categ3_social_list'] ) {
				foreach (  $settings['categ3_social_list'] as $item ) {
		?>
            <li><?php echo $item['pori']?></li>
            <?php } } ?>
        </ul>
    </div>
    <div class="item-readmore">
        <a href="<?php echo $categ3_link;?>"><i class="fa fa-angle-left"></i></a>
    </div>
    <div class="item--line"></div>
</div>
<?php
	}

}