<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
// Elementor Classes.
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Color;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;



if ( ! defined( 'ABSPATH' ) ) {
	exit; // If this file is called directly, abort.
}

/**
 * Class pori_Contactform
 */
class Pori_cf7_bina extends Widget_Base {

	/**
	 * Retrieve Widget Name.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function get_name() {
		return 'pori-contact-form';
	}

	/**
	 * Retrieve Widget Title.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function get_title() {
		return 'فرم تماس';
	}

	/**
	 * Retrieve Widget Icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string widget icon.
	 */
	public function get_icon() {
		return 'eicon-form-horizontal';
	}

	/**
	 * Retrieve Widget Categories.
	 *
	 * @since 1.5.1
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'Bina-category' );
	}

	/**
	 * Retrieve Widget Dependent CSS.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array CSS style handles.
	 */
	
	/**
	 * Register Contact Form 7 controls.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() { // phpcs:ignore PSR2.Methods.MethodDeclaration.Underscore

		$this->start_controls_section(
			'pori_section_wpcf7_form',
			array(
				'label' => __( 'فرم تماس', 'pori-addons-elementor' ),
			)
		);

		$this->add_control(
			'pori_wpcf7_form',
			array(
				'label'       => __( 'لطفا فرم خود را انتخاب کنید', 'pori-addons-elementor' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT,
				'options'     => $this->get_wpcf_forms(),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'pori_wpcf7_fields',
			array(
				'label' => __( 'فیلد', 'pori-addons-elementor' ),
			)
		);

		$this->add_control(
			'pori_wpcf7_fields_heading',
			array(
				'label' => __( 'عرض', 'pori-addons-elementor' ),
				'type'  => Controls_Manager::HEADING,
			)
		);

		$this->add_responsive_control(
			'pori_elements_input_width',
			array(
				'label'      => __( 'ورودی فیلد', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', '%' ),
				'range'      => array(
					'px' => array(
						'min' => 10,
						'max' => 1200,
					),
					'em' => array(
						'min' => 1,
						'max' => 80,
					),
				),
				'default'    => array(
					'size' => 100,
					'unit' => '%',
				),
				'selectors'  => array(
					'{{WRAPPER}} .pori-cf7-container input.wpcf7-text, {{WRAPPER}} .pori-cf7-container .wpcf7-file' => 'width: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'pori_elements_textarea_width',
			array(
				'label'      => __( 'فیلد پیام', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', '%' ),
				'range'      => array(
					'px' => array(
						'min' => 10,
						'max' => 1200,
					),
					'em' => array(
						'min' => 1,
						'max' => 80,
					),
				),
				'default'    => array(
					'size' => 100,
					'unit' => '%',
				),
				'selectors'  => array(
					'{{WRAPPER}} .pori-cf7-container textarea.wpcf7-textarea' => 'width: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'pori_wpcf7_fields_height_heading',
			array(
				'label' => __( 'ارتفاع', 'pori-addons-elementor' ),
				'type'  => Controls_Manager::HEADING,
			)
		);

		$this->add_responsive_control(
			'pori_elements_input_height',
			array(
				'label'      => __( 'ورودی فیلد', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em' ),
				'range'      => array(
					'px' => array(
						'min' => 10,
						'max' => 500,
					),
					'em' => array(
						'min' => 1,
						'max' => 40,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .pori-cf7-container input.wpcf7-text' => 'height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'pori_elements_textarea_height',
			array(
				'label'      => __( 'متن', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em' ),
				'range'      => array(
					'px' => array(
						'min' => 10,
						'max' => 1200,
					),
					'em' => array(
						'min' => 1,
						'max' => 80,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .pori-cf7-container textarea.wpcf7-textarea' => 'height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'pori_wpcf7_button',
			array(
				'label' => __( 'دکمه', 'pori-addons-elementor' ),
			)
		);

		$this->add_responsive_control(
			'pori_elements_button_width',
			array(
				'label'      => __( 'عرض', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', '%' ),
				'range'      => array(
					'px' => array(
						'min' => 10,
						'max' => 1200,
					),
					'em' => array(
						'min' => 1,
						'max' => 80,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .pori-cf7-container input.wpcf7-submit' => 'width: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'pori_elements_button_height',
			array(
				'label'      => __( 'ارتفاع', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em' ),
				'range'      => array(
					'px' => array(
						'min' => 10,
						'max' => 500,
					),
					'em' => array(
						'min' => 1,
						'max' => 40,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .pori-cf7-container input.wpcf7-submit' => 'height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_contact_form_styles',
			array(
				'label' => __( 'فرم', 'pori-addons-elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'pori_elements_input_background',
			array(
				'label'     => __( 'رنگ زمینه فیلد', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .pori-cf7-container input, {{WRAPPER}} .pori-cf7-container textarea' => 'background: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'pori_elements_input_padding',
			array(
				'label'      => __( 'فاصله', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .pori-cf7-container input, {{WRAPPER}} .pori-cf7-container textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'pori_elements_input_border',
				'selector' => '{{WRAPPER}} .pori-cf7-container input, {{WRAPPER}} .pori-cf7-container textarea',
			)
		);

		$this->add_responsive_control(
			'pori_elements_input_border_radius',
			array(
				'label'      => __( 'انجنای مرز', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					'{{WRAPPER}} .pori-cf7-container input, {{WRAPPER}} .pori-cf7-container textarea' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'pori_elements_input_margin',
			array(
				'label'      => __( 'فاصله از بیرون', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .pori-cf7-container input, {{WRAPPER}} .pori-cf7-container textarea' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'pori_elements_input_focus',
			array(
				'label'     => __( 'تمرکز رنگ کادر', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .pori-cf7-container input.wpcf7-text:focus, {{WRAPPER}} .pori-cf7-container textarea.wpcf7-textarea:focus , {{WRAPPER}} .pori-cf7-container .wpcf7-file:focus' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'pori_elements_input_focus_border_animation',
			array(
				'label'        => __( 'انیمیشن کادر', 'pori-addons-elementor' ),
				'type'         => Controls_Manager::SWITCHER,
				'prefix_class' => 'pori-contact-form-anim-',
			)
		);

		$this->add_control(
			'pori_elements_input_focus_border_color',
			array(
				'label'     => __( 'رنگ خط', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'condition' => array(
					'pori_elements_input_focus_border_animation' => 'yes',
				),
				'selectors' => array(
					'{{WRAPPER}}.pori-contact-form-anim-yes .wpcf7-span.is-focused::after' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'input_button_shadow',
				'selector' => '{{WRAPPER}} .pori-cf7-container input.wpcf7-text, {{WRAPPER}} .pori-cf7-container textarea.wpcf7-textarea, {{WRAPPER}} .pori-cf7-container .wpcf7-file',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_contact_form_typography',
			array(
				'label' => __( 'عنوان', 'pori-addons-elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'pori_elements_heading_default',
			array(
				'type'  => Controls_Manager::HEADING,
				'label' => __( 'فونت', 'pori-addons-elementor' ),
			)
		);

		$this->add_control(
			'pori_elements_contact_form_color',
			array(
				'label'     => __( 'رنگ فونت', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'scheme'    => array(
					'type'  => Color::get_type(),
					'value' => Color::COLOR_1,
				),
				'selectors' => array(
					'{{WRAPPER}} .pori-cf7-container, {{WRAPPER}} .pori-cf7-container label' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'pori_elements_contact_form_default_typography',
				'scheme'   => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-cf7-container',
			)
		);

		$this->add_control(
			'pori_elements_heading_input',
			array(
				'type'      => Controls_Manager::HEADING,
				'label'     => __( 'فونت ', 'pori-addons-elementor' ),
				'separator' => 'before',
			)
		);

		$this->add_control(
			'pori_elements_contact_form_field_color',
			array(
				'label'     => __( 'رنگ فونت ورودی فیلد', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'scheme'    => array(
					'type'  => Color::get_type(),
					'value' => Color::COLOR_1,
				),
				'selectors' => array(
					'{{WRAPPER}} .pori-cf7-container input.wpcf7-text, {{WRAPPER}} .pori-cf7-container textarea.wpcf7-textarea' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'pori_elements_contact_form_field_typography',
				'scheme'   => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-cf7-container input.wpcf7-text, {{WRAPPER}} .pori-cf7-container textarea.wpcf7-textarea',
			)
		);

		$this->add_control(
			'pori_elements_contact_form_placeholder_color',
			array(
				'label'     => __( 'رنگ متن داخل فیلد', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .pori-cf7-container ::-webkit-input-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .pori-cf7-container ::-moz-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .pori-cf7-container ::-ms-input-placeholder' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_contact_form_submit_button_styles',
			array(
				'label' => __( 'دکمه', 'pori-addons-elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'section_title_pori_btn_typography',
				'scheme'   => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-cf7-container input.wpcf7-submit',
			)
		);

		$this->add_responsive_control(
			'section_title_pori_btn_padding',
			array(
				'label'      => __( 'فاصله', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .pori-cf7-container input.wpcf7-submit' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->start_controls_tabs( 'pori_elements_button_tabs' );

		$this->start_controls_tab( 'normal', array( 'label' => __( 'نرمال', 'pori-addons-elementor' ) ) );

		$this->add_control(
			'pori_elements_button_text_color',
			array(
				'label'     => __( 'رنگ متن', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .pori-cf7-container input.wpcf7-submit' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'pori_elements_button_background_color',
			array(
				'label'     => __( 'رنگ زمینه', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'scheme'    => array(
					'type'  => Color::get_type(),
					'value' => Color::COLOR_1,
				),
				'selectors' => array(
					'{{WRAPPER}} .pori-cf7-container input.wpcf7-submit' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'pori_elements_btn_border',
				'selector' => '{{WRAPPER}} .pori-cf7-container input.wpcf7-submit',
			)
		);

		$this->add_responsive_control(
			'pori_elements_btn_border_radius',
			array(
				'label'     => __( 'انحنای مرز', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array(
						'max' => 100,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .pori-cf7-container input.wpcf7-submit' => 'border-radius: {{SIZE}}px;',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'pori_elements_hover',
			array(
				'label' => __( 'شناور', 'pori-addons-elementor' ),
			)
		);

		$this->add_control(
			'pori_elements_button_hover_text_color',
			array(
				'label'     => __( 'رنگ متن', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .pori-cf7-container input.wpcf7-submit:hover' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'pori_elements_button_hover_background_color',
			array(
				'label'     => __( 'رنگ زمینه', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .pori-cf7-container input.wpcf7-submit:hover' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'pori_elements_button_hover_border_color',
			array(
				'label'     => __( 'رنگ مرز', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .pori-cf7-container input.wpcf7-submit:hover' => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'button_box_shadow',
				'selector' => '{{WRAPPER}} .pori-cf7-container input.wpcf7-submit',
			)
		);

		$this->end_controls_section();

	}

	/**
	 * Get WPCF Forms
	 *
	 * @since 1.0.0
	 * @access public
	 */
	protected function get_wpcf_forms() {

		if ( ! class_exists( 'WPCF7_ContactForm' ) ) {
			return array();
		}

		$forms = \WPCF7_ContactForm::find(
			array(
				'orderby' => 'title',
				'order'   => 'ASC',
			)
		);

		if ( empty( $forms ) ) {
			return array();
		}

		$result = array();

		foreach ( $forms as $item ) {
			$key            = sprintf( '%1$s::%2$s', $item->id(), $item->title() );
			$result[ $key ] = $item->title();
		}

		return $result;
	}

	/**
	 * Render Contact Form 7 widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		$settings = $this->get_settings();

		if ( ! empty( $settings['pori_wpcf7_form'] ) ) {

			$this->add_render_attribute( 'container', 'class', 'pori-cf7-container' );

			?>

			<div <?php echo wp_kses_post( $this->get_render_attribute_string( 'container' ) ); ?>>
				<?php echo do_shortcode( '[contact-form-7 id="' . $settings['pori_wpcf7_form'] . '" ]' ); ?>
			</div>

			<?php
		}

	}
}
