<?php
/**
 * Bina elementor ext Theme 
 * author : pouria zamani
 * author url : https://porii.ir
 */

use \Elementor\Controls_Manager;
use \Elementor\Widget_Base;
use \Elementor\Group_Control_Typography;

class pori_counter_bina extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'counterup-bina';
	}
	public function get_script_depends() {
		return [ 'Bina-main-js'];
	}
	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return esc_html__( 'شمارشگر', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-counter';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @return array Widget categories.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'settings_section',
			[
				'label' => esc_html__( 'تنظیمات عمومی', 'Bina-extension' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'title', [
			'label'       => esc_html__( 'عنوان', 'Bina-extension' ),
			'type'        => Controls_Manager::TEXT,
			'default'     => esc_html__( 'همکار در بینا', 'Bina-extension' ),
			'description' => esc_html__( 'عنوان', 'Bina-extension' )
		] );
		$this->add_control( 'icon', [
			'label'       => esc_html__( 'آیکون', 'Bina-extension' ),
			'type'        => Controls_Manager::ICONS,
			
			'description' => esc_html__( 'انتخاب آیکون', 'Bina-extension' )
		] );
		$this->add_control( 'number', [
			'label'       => esc_html__( 'عدد', 'Bina-extension' ),
			'type'        => Controls_Manager::TEXT,
			'default'     => esc_html__( '85', 'Bina-extension' ),
			'description' => esc_html__( 'عدد وارد کنید', 'Bina-extension' )
		] );
		

		$this->end_controls_section();

		$this->start_controls_section(
			'styling_section',
			[
				'label' => esc_html__( 'تنظیمات استایل', 'Bina-extension' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control('icon_color',[
			'label' => esc_html__('رنگ آیکون','Bina-extension'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .single-counterup-style-02 .icon" => "color: {{VALUE}}"
			]
		]);
		$this->add_control('title_color',[
			'label' => esc_html__('رنگ عنوان','Bina-extension'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .single-counterup-style-02 .content .title" => "color: {{VALUE}}"
			]
		]);
		$this->add_control('number_color',[
			'label' => esc_html__('رنگ عدد','Bina-extension'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .single-counterup-style-02 .content .count-wrap" => "color: {{VALUE}}"
			]
		]);
		$this->add_control('styling_divider',[
			'type' => Controls_Manager::DIVIDER
		]);
		$this->add_group_control(Group_Control_Typography::get_type(),[
			'label' => esc_html__('فونت'),
			'name' => 'title_typography',
			'selector' => "{{WRAPPER}} .single-counterup-style-02 .content .title"
		]);
		$this->add_control('styling_divider_01',[
			'type' => Controls_Manager::DIVIDER
		]);
		$this->add_group_control(Group_Control_Typography::get_type(),[
			'label' => esc_html__('فونت عدد'),
			'name' => 'number_typography',
			'selector' => "{{WRAPPER}} .single-counterup-style-02 .content .count-wrap"
		]);
		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings  = $this->get_settings_for_display();
   
        $title = $settings['title'];
        $number = $settings['number'];
		$icon = $settings['icon']['value'];
		?>
        <div class="single-counterup-style-02">
            <div class="icon">
               <i class="<?php echo $icon;?>"></i>
            </div>
            <div class="content">
                <div class="count-wrap"><span class="count-num"><?php echo esc_html($number);?></span></div>
                <div class="title"><?php echo esc_html($title);?></div>
            </div>
        </div>
		<?php
	}
}