<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor docbox Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_docbox_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve docbox widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'docbox';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve docbox widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'اطلاعات دکتر', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve docbox widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-info-box';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the docbox widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register docbox widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		
// docbox Title
$this->add_control(
	'docbox_title',
	[
		'label' => __( 'نام', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'label_block' => true,
		'default'     => esc_html__( 'پوریا زمانی', 'Bina-extension' ),
		'placeholder' => __( 'نام', 'Bina-extension' ),
	]
);
        // docbox Sub Title
		$this->add_control(
			'docbox_takhasos',
			[
				'label' => __( 'تخصص', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'چشم پزشکی', 'Bina-extension' ),
				'placeholder' => __( 'تخصص', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
        // docbox Sub Title
		$this->add_control(
			'docbox_address',
			[
				'label' => __( 'آدرس', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'قزوین-خیابان رجایی- ساختمان پزشکان ', 'Bina-extension' ),
				'placeholder' => __( 'آدرس', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
		// docbox Sub Title
		$this->add_control(
			'docbox_call',
			[
				'label' => __( 'شماره تماس', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( '02833445566', 'Bina-extension' ),
				'placeholder' => __( 'شماره تماس', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
		// docbox Sub Title
		$this->add_control(
			'docbox_time',
			[
				'label' => __( 'ساعات کاری', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'همه روزه از 9 صبح تا 9 شب', 'Bina-extension' ),
				'placeholder' => __( 'ساعت کاری', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
        // docboxp Image
		$this->add_control(
			'docboxp_image',
			[
				'label' => __( 'انتخاب عکس', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
                'label_block' => true,
                'separator'=> 'before',
				'default' => [
                    'url' => Utils::get_placeholder_image_src()
                ],
				'placeholder' => __( 'انتخاب عکس', 'Bina-extension' ),
			]
        );
		
		$this->add_control(
			'readmore_url',
			[
				'label' => __( 'لینک', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
                'label_block' => true,
			//	'default'     => 'porii.ir' ,
			]
        );
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		// docboxp Area Background Options
		$this->add_control(
			'docboxp_area_back_heading',
			[
				'label' => __( 'رنگ زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		// docboxp Area Background Color
        $this->add_control(
			'docboxp_area_backh',
			[
				'label' => __( 'رنگ زمینه متن', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .single-doctors-card' => 'background-color: {{VALUE}}',
				],
			]
        );

        // Sub Title Options
		$this->add_control(
			'docboxp_subtitle_heading',
			[
				'label' => __( 'رنگ  و فونت متن', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'docboxp_subtitl_color',
			[
				'label' => __( 'رنگ عناوین', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} .single-doctors-card .doctors-content h3 a , .single-doctors-card .doctors-content .doc-location p,.single-doctors-card .doctors-content span' => 'color: {{VALUE}}',
				],
			]
        );
        // Sub Title Color
        $this->add_control(
			'docboxp_subtitll_color',
			[
				'label' => __( 'رنگ آدرس', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .single-doctors-card .doctors-content .doc-location span' => 'color: {{VALUE}}',
				],
			]
        );
		$this->add_control(
			'docboxp_sfubtitll_color',
			[
				'label' => __( 'رنگ شماره تماس', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .single-doctors-card .doctors-content .doc-info li' => 'color: {{VALUE}}',
				],
			]
        );
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'docboxp_subtitl_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .single-doctors-card .doctors-content h3 a , .single-doctors-card .doctors-content .doc-location p,.single-doctors-card .doctors-content span,.single-doctors-card .doctors-content .doc-info li ,.single-doctors-card .doctors-content .doc-location span',
			]
        );
        
        $this->end_controls_section();
	}

	/**
	 * Render docbox widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $docbox_style = $settings['docbox_style'];
        $docbox_title = $settings['docbox_title'];
		$docbox_takhasos = $settings['docbox_takhasos'];
		$docbox_address = $settings['docbox_address'];
		$docbox_time = $settings['docbox_time'];
		$docbox_call = $settings['docbox_call'];
		$readmore_url = $settings['readmore_url']['url'];
        $docboxp_image = $settings['docboxp_image']['url'];

		
    ?>

<div class="single-doctors-card">
    <div class="doctors-image">
        <a href="<?php echo $readmore_url;?>"><img src="<?php echo $docboxp_image;?>" alt="image" width="100px" height="65px"/></a>
    </div>
    <div class="doctors-content">
        <h3>
            <a href="<img src="<?php echo $readmore_url;?>"><?php echo $docbox_title;?></a>
        </h3>
        <ul class="doc-info">
            <li><?php echo $docbox_call;?></li>
            
        </ul>
        <span><?php echo $docbox_takhasos;?></span>
        <div class="doc-location">
            <p><?php echo $docbox_time;?></p>
            <span><?php echo $docbox_address;?></span>
        </div>
    </div>
</div>


<?php
	}

}