<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use Elementor\Icons_Manager;
use Elementor\Controls_Manager;
use Elementor\Utils;
/**
 * Elementor docteam Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_docteam_bina extends \Elementor\Widget_Base
{
    /**
     * Get widget name.
     *
     * Retrieve docteam widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'docteam';
    }

    /**
     * Get widget title.
     *
     * Retrieve docteam widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('تیم - مدرن', 'Bina-extension');
    }

    /**
     * Get widget icon.
     *
     * Retrieve docteam widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-user-circle-o';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the docteam widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['Bina-category'];
    }

    /**
     * Register docteam widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function _register_controls()
    {
        $this->start_controls_section('content_section', [
            'label' => __('محتوا', 'Bina-extension'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]);

        // service Title
        $this->add_control('docteam_title', [
            'label' => __('نام', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'label_block' => true,
            'default' => esc_html__('پوریا زمانی', 'Bina-extension'),
        ]);
        // service Title
        $this->add_control('docteam_takhasos', [
            'label' => __('تخصص', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'label_block' => true,
            'default' => esc_html__('بیولوژی', 'Bina-extension'),
        ]);
        $this->add_control('show_social_icon', [
            'label' => __('نمایش آیکون شبکه اجتماعی', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => __('Show', 'Bina-extension'),
            'label_off' => __('Hide', 'Bina-extension'),
            'return_value' => 'yes',
            'default' => 'yes',
        ]);
        // Teamp Image
        $this->add_control('docteamp_image', [
            'label' => __('انتخاب عکس', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'label_block' => true,
            'separator' => 'before',
            'default' => [
                'url' => Utils::get_placeholder_image_src(),
            ],
            'placeholder' => __('انتخاب عکس', 'Bina-extension'),
        ]);
        $repeater = new \Elementor\Repeater();
        $repeater->add_control('team_title', [
            'label' => __('نام شبکه', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('نام شبکه اجتماعی', 'Bina-extension'),
            'label_block' => true,
        ]);

        $repeater->add_control('team_icon', [
            'label' => __('آیکون', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::ICONS,
            'default' => [
                'value' => 'fab fa-telegram',
                'library' => 'solid',
            ],
        ]);

        // Team Icon Link
        $repeater->add_control('team_icon_link', [
            'label' => __('لینک شبکه اجتماعی', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::URL,
            'placeholder' => __('نمایش لینک', 'Bina-extension'),
        ]);

        $this->add_control('team_social_list', [
            'label' => __('شبکه اجتماعی', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'title_field' => '{{{ team_title }}}',
            'condition' => [
                'show_social_icon' => 'yes',
            ],
        ]);
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section('style_section', [
            'label' => __('استایل', 'Bina-extension'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);

        // docteamp Area Background Options
        $this->add_control('docteamp_area_back_heading', [
            'label' => __('رنگ زمینه', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::HEADING,
        ]);

        // docteamp Area Background Color
        $this->add_control('docteamp_area_backh', [
            'label' => __('رنگ زمینه متن', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'scheme' => [
                'type' => \Elementor\Core\Schemes\Color::get_type(),
                'value' => \Elementor\Core\Schemes\Color::COLOR_1,
            ],
            'default' => '#fff',
            'selectors' => [
                '{{WRAPPER}} .team-item' => 'background-color: {{VALUE}}',
            ],
        ]);

        // Sub Title Options
        $this->add_control('docteamp_subtitle_heading', [
            'label' => __('رنگ  و فونت متن', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ]);

        
        // Sub Title Color
        $this->add_control('docteamp_subtitll_color', [
            'label' => __('رنگ متن', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'scheme' => [
                'type' => \Elementor\Core\Schemes\Color::get_type(),
                'value' => \Elementor\Core\Schemes\Color::COLOR_1,
            ],
            'default' => '#000',
            'selectors' => [
                '{{WRAPPER}} .team-item .team-content .team-information .designation ,.team-item .team-content .team-information a' => 'color: {{VALUE}}',
            ],
        ]);
        
        // Sub Title Typography
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), [
            'name' => 'docteamp_subtitl_typography',
            'label' => __('فونت', 'Bina-extension'),
            'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
            'selector' =>
                '{{WRAPPER}} .team-item .team-content .team-information .designation ,.team-item .team-content .team-information a',
        ]);

        $this->end_controls_section();
    }

    /**
     * Render docteam widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $docteam_style = $settings['docteam_style'];
        $docteam_title = $settings['docteam_title'];
        $docteam_takhasos = $settings['docteam_takhasos'];
        $readmore_url = $settings['readmore_url']['url'];
        $docteamp_image = $settings['docteamp_image']['url'];
        $show_social_icon = $settings['show_social_icon'];
        ?>

<div class="team-item">
    <div class="team-thumb">
        <img class="w-100" src="<?php echo $docteamp_image; ?>" alt="" />
        <div class="team-social">
		<?php if ($show_social_icon === 'yes') { ?>
            <ul class="styled-icons icon-team-list icon-bordered icon-circled">
			<?php if ($settings['team_social_list']) {
       foreach ($settings['team_social_list'] as $item) { ?>
                <li>
                    <a  class="social-link" href="<?php echo $item['team_icon_link']['url']; ?>"><i class="<?php echo $item['team_icon']['value']; ?>"></i></a>
                </li>
                <?php }
   } ?>
            </ul>
        </div>
		<?php } ?>
    </div>
    <div class="team-content">
        <div class="team-information">
            <h4 class="team-name"><a href="<?php echo $readmore_url; ?>"><?php echo $docteam_title; ?></a></h4>
            <h6 class="designation mb-0"><?php echo $docteam_takhasos; ?></h6>
        </div>
    </div>
</div>




<?php
    }
}
