<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use Elementor\Icons_Manager;
use Elementor\Controls_Manager;
use Elementor\Utils;
/**
 * Elementor doctesti Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_doctesti_bina extends \Elementor\Widget_Base
{
    /**
     * Get widget name.
     *
     * Retrieve doctesti widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'doctesti';
    }

    /**
     * Get widget title.
     *
     * Retrieve doctesti widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('نظر', 'Bina-extension');
    }

    /**
     * Get widget icon.
     *
     * Retrieve doctesti widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-testimonial';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the doctesti widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['Bina-category'];
    }

    /**
     * Register doctesti widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function _register_controls()
    {
        $this->start_controls_section('content_section', [
            'label' => __('محتوا', 'Bina-extension'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]);

        // service Title
        $this->add_control('doctesti_name', [
            'label' => __('نام', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'label_block' => true,
            'default' => esc_html__('پوریا زمانی', 'Bina-extension'),
        ]);
        // service Title
        $this->add_control('doctesti_nazar', [
            'label' => __('نظر', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'label_block' => true,
            'default' => esc_html__('لورم ایپیسوم متن ساختگی طراحان می باشد', 'Bina-extension'),
        ]);
       
        // Teamp Image
        $this->add_control('doctestip_image', [
            'label' => __('انتخاب عکس', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'label_block' => true,
            'separator' => 'before',
            'default' => [
                'url' => Utils::get_placeholder_image_src(),
            ],
            'placeholder' => __('انتخاب عکس', 'Bina-extension'),
        ]);
       
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section('style_section', [
            'label' => __('استایل', 'Bina-extension'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);

        // doctestip Area Background Options
        $this->add_control('doctestip_area_back_heading', [
            'label' => __('رنگ زمینه', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::HEADING,
        ]);

        // doctestip Area Background Color
        $this->add_control('doctestip_area_backh', [
            'label' => __('رنگ زمینه ', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'scheme' => [
                'type' => \Elementor\Core\Schemes\Color::get_type(),
                'value' => \Elementor\Core\Schemes\Color::COLOR_1,
            ],
            'default' => '#fff',
            'selectors' => [
                '{{WRAPPER}} .pori-testi' => 'background-color: {{VALUE}}',
            ],
        ]);
// doctestip Area Background Color
$this->add_control('doctestip_areah_backh', [
    'label' => __('رنگ زمینه متن', 'Bina-extension'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'scheme' => [
        'type' => \Elementor\Core\Schemes\Color::get_type(),
        'value' => \Elementor\Core\Schemes\Color::COLOR_1,
    ],
    'default' => '#0b114a',
    'selectors' => [
        '{{WRAPPER}} .pori-testi .lower-cont' => 'background-color: {{VALUE}}',
    ],
]);
// doctestip Area Background Color
$this->add_control('doctestip_arzeah_backh', [
    'label' => __('رنگ زمینه آیکون', 'Bina-extension'),
    'type' => \Elementor\Controls_Manager::COLOR,
    'scheme' => [
        'type' => \Elementor\Core\Schemes\Color::get_type(),
        'value' => \Elementor\Core\Schemes\Color::COLOR_1,
    ],
    'default' => '#ff6e9d',
    'selectors' => [
        '{{WRAPPER}} .pori-testi .quote' => 'background-color: {{VALUE}}',
    ],
]);
        // Sub Title Options
        $this->add_control('doctestip_subtitle_heading', [
            'label' => __('رنگ  و فونت متن', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ]);

        
        // Sub Title Color
        $this->add_control('doctestip_subtitll_color', [
            'label' => __('رنگ متن', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'scheme' => [
                'type' => \Elementor\Core\Schemes\Color::get_type(),
                'value' => \Elementor\Core\Schemes\Color::COLOR_1,
            ],
            'default' => '#000',
            'selectors' => [
                '{{WRAPPER}} .cont-box p' => 'color: {{VALUE}}',
            ],
        ]);
        
        // Sub Title Typography
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), [
            'name' => 'doctestip_subtitl_typography',
            'label' => __('فونت', 'Bina-extension'),
            'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
            'selector' =>
                '{{WRAPPER}} .cont-box p',
        ]);

        // Sub Title Color
        $this->add_control('doctegstip_subtitll_color', [
            'label' => __('رنگ نام', 'Bina-extension'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'scheme' => [
                'type' => \Elementor\Core\Schemes\Color::get_type(),
                'value' => \Elementor\Core\Schemes\Color::COLOR_1,
            ],
            'default' => '#fff',
            'selectors' => [
                '{{WRAPPER}} .pori-testi .lower-cont h5' => 'color: {{VALUE}}',
            ],
        ]);
        
        // Sub Title Typography
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), [
            'name' => 'doctestip_subtitlf_typography',
            'label' => __('فونت', 'Bina-extension'),
            'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
            'selector' =>
                '{{WRAPPER}} .pori-testi .lower-cont h5',
        ]);
        $this->end_controls_section();
    }

    /**
     * Render doctesti widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $doctesti_style = $settings['doctesti_style'];
        $doctesti_nazar = $settings['doctesti_nazar'];
        $doctesti_name = $settings['doctesti_name'];
        $readmore_url = $settings['readmore_url']['url'];
        $doctestip_image = $settings['doctestip_image']['url'];
        $show_social_icon = $settings['show_social_icon'];
        ?>

<div class="pori-testi">
    <div class="img-box">
        <img src="<?php echo $doctestip_image; ?>" alt="" />
    </div>
    <div class="cont-box">
        <p><?php echo $doctesti_nazar; ?></p>
    </div>
    <span class="quote"><i class="fas fa-quote-right"></i></span>
    <div class="lower-cont">
        <h5><?php echo $doctesti_name; ?></h5>
    </div>
</div>



<?php
    }
}
