<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor docbox Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_docwork_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve docbox widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'docwork';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve docbox widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'ساعت کاری', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve docbox widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-time-line';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the docbox widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register docbox widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


        $repeater = new \Elementor\Repeater();
		

		
        // categ Icon Link
		$repeater->add_control(
			'pori', [
				'label' => __( 'عنوان دسته', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'شنبه' , 'Bina-extension' ),
				'label_block' => true,
			]
		);
        // categ Icon Link
		$repeater->add_control(
			'pori-date',
			[
				'label' => __( 'تاریخ ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( ' 1400', 'Bina-extension' ),
			]
        );
		$repeater->add_control(
			'pori-time',
			[
				'label' => __( 'ساعت ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( ' 9:00', 'Bina-extension' ),
			]
        );
		 // categ Icon Link
		 $repeater->add_control(
			'pori-sh1', [
				'label' => __( 'نام دکتر شنبه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'دکتر پوریا زمانی' , 'Bina-extension' ),
				'label_block' => true,
			]
		);
        // categ Icon Link
		$repeater->add_control(
			'pori-sh1-2',
			[
				'label' => __( 'تخصص ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'چشم پزشکی' , 'Bina-extension' ),
				'placeholder' => __( 'چشم پزشکی', 'Bina-extension' ),
			]
        );
		// categ Icon Link
		$repeater->add_control(
			'pori-ye1', [
				'label' => __( 'نام دکتر یک شنبه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'دکتر ساجده رضایی' , 'Bina-extension' ),
				'label_block' => true,
			]
		);
        // categ Icon Link
		$repeater->add_control(
			'pori-ye1-2',
			[
				'label' => __( 'تخصص ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'اورولوژی' , 'Bina-extension' ),
				'placeholder' => __( 'اورولوژی', 'Bina-extension' ),
			]
        );
		// categ Icon Link
		$repeater->add_control(
			'pori-do1', [
				'label' => __( 'نام دکتر دو شنبه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'دکتر محمد امین کریمی' , 'Bina-extension' ),
				'label_block' => true,
			]
		);
        // categ Icon Link
		$repeater->add_control(
			'pori-do1-2',
			[
				'label' => __( 'تخصص ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'عمومی' , 'Bina-extension' ),
				'placeholder' => __( 'عمومی', 'Bina-extension' ),
			]
        );
		// categ Icon Link
		$repeater->add_control(
			'pori-se1', [
				'label' => __( 'نام دکتر سه شنبه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'دکتر سمانه ملکی' , 'Bina-extension' ),
				'label_block' => true,
			]
		);
        // categ Icon Link
		$repeater->add_control(
			'pori-se1-2',
			[
				'label' => __( 'تخصص ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'گوارش' , 'Bina-extension' ),
				'placeholder' => __( 'گوارش', 'Bina-extension' ),
			]
        );
		// categ Icon Link
		$repeater->add_control(
			'pori-ch1', [
				'label' => __( 'نام دکتر چهارشنبه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'دکتر حسن حسینی' , 'Bina-extension' ),
				'label_block' => true,
			]
		);
        // categ Icon Link
		$repeater->add_control(
			'pori-ch1-2',
			[
				'label' => __( 'تخصص ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'قلب' , 'Bina-extension' ),
				'placeholder' => __( 'قلب', 'Bina-extension' ),
			]
        );
		// categ Icon Link
		$repeater->add_control(
			'pori-pj1', [
				'label' => __( 'نام دکتر پنج شنبه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'دکتر محمود شیر باقری' , 'Bina-extension' ),
				'label_block' => true,
			]
		);
        // categ Icon Link
		$repeater->add_control(
			'pori-pj1-2',
			[
				'label' => __( 'تخصص ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'فیزیوتراپ' , 'Bina-extension' ),
				'placeholder' => __( 'فیزیوتراپ', 'Bina-extension' ),
			]
        );
		// categ Icon Link
		$repeater->add_control(
			'pori-j1', [
				'label' => __( 'نام دکتر جمعه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'دکتر مریم فرهادی' , 'Bina-extension' ),
				'label_block' => true,
			]
		);
        // categ Icon Link
		$repeater->add_control(
			'pori-j1-2',
			[
				'label' => __( 'تخصص ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'عمومی' , 'Bina-extension' ),
				'placeholder' => __( 'عمومی', 'Bina-extension' ),
			]
        );
		$this->add_control(
			'categ_social_list',
			[
				'label' => __( 'دسته بندی ها', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ pori }}}',
				
			]
		);

        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		// docboxp Area Background Options
		$this->add_control(
			'docboxp_area_back_heading',
			[
				'label' => __( 'رنگ زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		// docboxp Area Background Color
        $this->add_control(
			'docboxp_area_backh',
			[
				'label' => __( 'رنگ زمینه عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#00b761',
				'selectors' => [
					'{{WRAPPER}} .doctor-calendar-table table thead tr th' => 'background-color: {{VALUE}}',
				],
			]
        );

        // Sub Title Options
		$this->add_control(
			'docboxp_subtitle_heading',
			[
				'label' => __( 'رنگ  و فونت متن', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        
        // Sub Title Color
        $this->add_control(
			'docboxp_subtitll_color',
			[
				'label' => __( 'رنگ زمینه تاریخ و ساعات', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#ffc500',
				'selectors' => [
					'{{WRAPPER}} .doctor-calendar-table table tbody tr td span.time' => 'background-color: {{VALUE}}',
				],
			]
        );
		
        
        $this->end_controls_section();
	}

	/**
	 * Render docbox widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $docbox_style = $settings['docbox_style'];
        $docbox_title = $settings['docbox_title'];
		$docbox_takhasos = $settings['docbox_takhasos'];
		$docbox_address = $settings['docbox_address'];
		$docbox_time = $settings['docbox_time'];
		$docbox_call = $settings['docbox_call'];
		$readmore_url = $settings['readmore_url']['url'];
        $docboxp_image = $settings['docboxp_image']['url'];

		
    ?>

<div class="doctor-calendar-table table-responsive">
    <table class="table">
        <thead>
            <tr>
                <th>تاریخ و ساعت</th>
                <th>شنبه</th>
                <th>یکشنبه</th>
                <th>دوشنبه</th>
                <th>سه شنبه</th>
                <th>چهارشنبه</th>
                <th>پنج شنبه</th>
				<th>جمعه</th>
            </tr>
        </thead>
        <tbody>
		<?php
		 if ( $settings['categ_social_list'] ) {
			foreach (  $settings['categ_social_list'] as $item ) {
	    ?>
            <tr>
                <td><span class="time">
					<ul>
						<li><?php echo $item['pori-date']?></li>
						<li><?php echo $item['pori-time']?></li>
					</ul>
				</span></td>
                <td>
                    <h3><?php echo $item['pori-sh1']?></h3>
                    <span><?php echo $item['pori-sh1-2']?></span>
                </td>
                <td>
                    <h3><?php echo $item['pori-ye1']?></h3>
                    <span><?php echo $item['pori-ye1-2']?></span>
                </td>
                <td>
                    <h3><?php echo $item['pori-do1']?></h3>
                    <span><?php echo $item['pori-do1-2']?></span>
                </td>
                <td><h3><?php echo $item['pori-se1']?></h3>
                    <span><?php echo $item['pori-se1-2']?></span></td>
                <td>
                    <h3><?php echo $item['pori-ch1']?></h3>
                    <span><?php echo $item['pori-ch1-2']?></span>
                </td>
                <td>
                    <h3><?php echo $item['pori-pj1']?></h3>
                    <span><?php echo $item['pori-p1-2']?></span>
                </td>
				<td>
                    <h3><?php echo $item['pori-j1']?></h3>
                    <span><?php echo $item['pori-j1-2']?></span>
                </td>
				<?php } } ?>
        </tbody>
    </table>
</div>



<?php
	}

}