<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Utils as Utils;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor pori_FlipBox
 *
 * Elementor widget for pori_FlipBox.
 *
 * @since 1.0.0
 */
class pori_flipbox_bina extends Widget_Base {

    public function __construct( $data = array(), $args = null ) {
		parent::__construct( $data, $args );
	
	}
	
	public function get_name() {
		return 'pori-flip-box';
	}
	
	public function get_title() {
		return __( 'جعبه برگردان', 'pori' );
	}
	
	public function get_icon() {
		return 'eicon-flip-box';
	}

	public function get_categories() {
		return [ 'Bina-category' ];
    }
    
    public function get_keywords() {
		return [ 'جعبه', 'flip', 'box' ];
    }


	
	protected function _register_controls() {

        // Front
		$this->start_controls_section(
			'section_front',
			[
				'label' => __( 'Front', 'pori' ),
			]
		);

            $this->add_control(
                'front_graphic_element',
                [
                    'label' => __( 'المان محتوا', 'pori' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'icon',
                    'options' => [
                        'none'  => __( 'هیچ', 'pori' ),
                        'image' => __( 'عکس', 'pori' ),
                        'icon' => __( 'آیکون', 'pori' ),
                    ],
                ]
            );

            $this->add_control(
                'front_choose_image',
                [
                    'label' => __( 'انتخاب عکس', 'pori' ),
                    'type' => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                    'condition' => [
                        'front_graphic_element' => 'image',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'front_image_dimension', // // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                    'default' => 'large',
                    'condition' => [
                        'front_graphic_element' => 'image',
                    ],
                ]
            );

            $this->add_control(
                'front_choose_icon',
                [
                    'label' => __( 'آیکون', 'pori' ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'far fa-lightbulb',
                        'library' => 'regular',
                    ],
                    'condition' => [
                        'front_graphic_element' => 'icon',
                    ],
                ]
            );

            $this->add_control(
                'front_title',
                [
                    'label' => __( 'عنوان', 'pori' ),
                    'type' => Controls_Manager::TEXT,
                    'placeholder' => __( 'Front Title', 'pori' ),
                    'default' => __( 'تیرداد', 'pori'),
                ]
            );

            $this->add_control(
                'front_description',
                [
                    'label' => __( 'توضیحات', 'pori' ),
                    'type' => Controls_Manager::WYSIWYG,
                    'placeholder' => __( 'توضیحات شما', 'pori' ),
                    'default' => __( 'بهترین ایده برای رسیدن به موفقیت', 'pori'),
                ]
            );

        $this->end_controls_section();

        // Back
        $this->start_controls_section(
			'section_back',
			[
				'label' => __( 'پشت', 'pori' ),
			]
		);

            $this->add_control(
                'back_graphic_element',
                [
                    'label' => __( 'المان', 'pori' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'none',
                    'options' => [
                        'none'  => __( 'هیچ', 'pori' ),
                        'image' => __( 'عکس', 'pori' ),
                        'icon' => __( 'آیکون', 'pori' ),
                    ],
                ]
            );

            $this->add_control(
                'back_choose_image',
                [
                    'label' => __( 'انتخاب عکس', 'pori' ),
                    'type' => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                    'condition' => [
                        'back_graphic_element' => 'image',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'back_choose_image_size',
                    'default' => 'large',
                    'condition' => [
                        'back_graphic_element' => 'image',
                    ],
                ]
            );

            $this->add_control(
                'back_choose_icon',
                [
                    'label' => __( 'آیکون', 'pori' ),
                    'type' => Controls_Manager::ICONS,
                    'condition' => [
                        'back_graphic_element' => 'icon',
                    ],
                ]
            );

            $this->add_control(
                'back_title',
                [
                    'label' => __( 'عنوان', 'pori' ),
                    'type' => Controls_Manager::TEXT,
                    'placeholder' => __( 'Back Title', 'pori' ),
                    'default' => 'شرکت تیرداد',
                ]
            );

            $this->add_control(
                'back_description',
                [
                    'label' => __( 'توضیحات', 'pori' ),
                    'type' => Controls_Manager::WYSIWYG,
                    'placeholder' => __( 'توضیحات شما', 'pori' ),
                    'default' => __( 'هر ایده ای قابل اجراست', 'pori'),
                ]
            );

            $this->add_control(
                'back_button_text',
                [
                    'label' => __( 'عنوان دکمه', 'pori' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'مشاهده بیشتر', 'pori' ),
                    'placeholder' => __( 'متن دکمه', 'pori' ),
                ]
            );

            $this->add_control(
                'back_button_link',
                [
                    'label' => __( 'لینک', 'pori' ),
                    'type' => \Elementor\Controls_Manager::URL,
                    'placeholder' => __( 'https://porii.ir', 'pori' ),
                    'show_external' => true,
                    'condition' => [
                        'back_button_text!' => "",
                    ],
                    'default' => [
                        'url' => '',
                        'is_external' => true,
                        'nofollow' => true,
                    ],
                ]
            );

        $this->end_controls_section();

        // Common Settings
        $this->start_controls_section(
			'section_common_settings',
			[
				'label' => __( 'تنظیمات', 'pori' ),
			]
        );

            $this->add_control(
                'flip_effect',
                [
                    'label' => __( 'افکت', 'pori' ),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'ma-flip',
                    'options' => [
                        'ma-flip'  => __( 'برعکس', 'pori' ),
                        'ma-slide' => __( 'اسلاید', 'pori' ),
                        'ma-push' => __( 'هم پوشانی', 'pori' ),
                        'ma-zoom-in' => __( 'بززگنمایی به داخل', 'pori' ),
                        'ma-zoom-out' => __( 'بزرگنمایی به خارج', 'pori' ),
                        'ma-fade' => __( 'گذری', 'pori' ),
                    ],
                ]
            );

            $this->add_control(
                'flip_direction',
                [
                    'label' => __( 'جهت', 'pori' ),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'left',
                    'options' => [
                        'up'  => __( 'بالا', 'pori' ),
                        'down' => __( 'پایین', 'pori' ),
                        'left' => __( 'چپ', 'pori' ),
                        'right' => __( 'راست', 'pori' ),
                    ],
                    'condition' => [
                        'flip_effect' => ['ma-flip', 'ma-slide', 'ma-push']
                    ]
                ]
            );

            $this->add_responsive_control(
                'flipbox_height',
                [
                    'label' => __( 'ارتفاع', 'pori' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', 'vh' ],
                    'range' => [
                        'px' => [
                            'min' => 100,
                            'max' => 1000,
                            'step' => 5,
                        ],
                        'vh' => [
                            'min' => 10,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 250,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-card' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
        
        $this->end_controls_section();
        
        // Front Styling
        $this->start_controls_section(
            'section_flipbox_front_style',
            [
                'label' => __( 'جلو', 'pori' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_control(
                'front_horizontal_alignment',
                [
                    'label' => __( 'چیدمان عمودی', 'pori' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => __( 'Left', 'pori' ),
                            'icon' => 'fa fa-align-left',
                        ],
                        'center' => [
                            'title' => __( 'Center', 'pori' ),
                            'icon' => 'fa fa-align-center',
                        ],
                        'right' => [
                            'title' => __( 'Right', 'pori' ),
                            'icon' => 'fa fa-align-right',
                        ],
                    ],
                    'default' => 'center',
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-front' => "text-align: {{VALUE}}; text-align: -webkit-{{VALUE}};",
                    ]
                ]
            );

            $this->add_control(
                'front_vertical_alignment',
                [
                    'label' => __( 'چیدمان افقی', 'pori' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'ma-v-align-top' => [
                            'title' => __( 'Top', 'pori' ),
                            'icon' => 'eicon-v-align-top',
                        ],
                        'ma-v-align-middle' => [
                            'title' => __( 'Middle', 'pori' ),
                            'icon' => 'eicon-v-align-middle',
                        ],
                        'ma-v-align-bottom' => [
                            'title' => __( 'Bottom', 'pori' ),
                            'icon' => 'eicon-v-align-bottom',
                        ],
                    ],
                    'default' => 'ma-v-align-middle',
                    'toggle' => true,
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'front_background',
                    'label' => __( 'زمینه', 'pori' ),
                    'selector' => '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front',
                ]
            );

            $this->add_responsive_control(
                'front_padding',
                [
                    'label' => __( 'فاصله', 'pori' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'rem' ],
                    'default' => [
                        'top' =>  '20',
                        'right' => '20',
                        'bottom' => '20',
                        'left' => '20',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'front_card',
                    'label' => __( 'خط دور', 'pori' ),
                    'default' => 'solid',
                    'selector' => '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front',
                ]
            );

            $this->add_control(
                'front_border_radius',
                [
                    'label' => __( 'حاشیه لبه', 'pori' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'front_box_shadow',
                    'label' => __( 'سایه', 'pori' ),
                    'selector' => '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front',
                    'condition' => [
                        'flip_effect!' => ['ma-slide', 'ma-push']
                    ]
                ]
            );

            // Icon Styling for Front
            $this->add_control(
                'heading_front_icon_style',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __( 'آیکون', 'pori' ),
                    'condition' => [
                        'front_graphic_element' => 'icon',
                    ],
                    'separator' => 'before',
                ]
            );
            
            $this->add_responsive_control(
                'front_icon_spacing',
                [
                    'label' => __( 'فضای ایکون', 'pori' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ]
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 15,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-icon' => 'margin-bottom: {{SIZE}}{{UNIT}};'
                    ],
                    'condition' => [
                        'front_graphic_element' => 'icon',
                    ],
                ]
            );

            $this->add_control(
                'front_icon_color',
                [
                    'label' => __( 'رنگ آیکون', 'pori' ),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#ffc600',
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-icon i' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-icon svg' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'front_graphic_element' => 'icon',
                    ],
                ]
            );

            $this->add_responsive_control(
                'front_icon_size',
                [
                    'label' => __( 'سایز آیکون', 'pori' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 5,
                            'max' => 600,
                            'step' => 1,
                        ]
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 55,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-icon svg' => 'font-size: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'front_graphic_element' => 'icon',
                    ],
                ]
            );

            $this->add_control(
                'front_icon_bgcolor',
                [
                    'label' => __( 'رنگ زمینه', 'pori' ),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => 'rgba(64, 84, 178, 0)',
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-icon' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'front_graphic_element' => 'icon',
                    ],
                ]
            );

            $this->add_responsive_control(
                'front_icon_padding',
                [
                    'label' => __( 'فاصله', 'pori' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 0,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-icon i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-icon svg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'front_graphic_element' => 'icon',
                    ],
                ]
            );

            $this->add_control(
                'front_icon_rotate',
                [
                    'label' => __( 'چرخش آیکون', 'pori' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 360,
                            'step' => 1,
                        ]
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-icon i' => 'transform: rotate({{SIZE}}deg);',
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-icon svg' => 'transform: rotate({{SIZE}}deg);',
                    ],
                    'condition' => [
                        'front_graphic_element' => 'icon',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'front_icon_border',
                    'label' => __( 'دور کادر', 'pori' ),
                    'selector' => '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-icon',
                    'condition' => [
                        'front_graphic_element' => 'icon',
                    ],
                ]
            );

            $this->add_control(
                'front_icon_border_radius',
                [
                    'label' => __( 'حاشیه لبه', 'pori' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 50,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'front_graphic_element' => 'icon',
                    ],
                ]
            );

            // Image Styling for Front
            $this->add_control(
                'heading_front_image_style',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __( 'عکس', 'pori' ),
                    'condition' => [
                        'front_graphic_element' => 'image',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'front_image_spacing',
                [
                    'label' => __( 'فضای بین عکس', 'pori' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ]
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 10,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-image img' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'front_graphic_element' => 'image',
                    ],
                ]
            );
            
            $this->add_control(
                'front_image_size',
                [
                    'label' => __( 'سایز عکس', 'pori' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 10,
                            'max' => 500,
                            'step' => 1,
                        ]
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 70,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-image img' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'front_graphic_element' => 'image',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'front_image_padding',
                [
                    'label' => __( 'فاصله', 'pori' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-image img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'front_graphic_element' => 'image',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'front_image_border',
                    'label' => __( 'دور کادر', 'pori' ),
                    'selector' => '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-image img',
                    'condition' => [
                        'front_graphic_element' => 'image',
                    ],
                ]
            );

            $this->add_responsive_control(
                'front_image_border_radius',
                [
                    'label' => __( 'حاشیه لبه', 'pori' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'front_graphic_element' => 'image',
                    ],
                ]
            );

            // Title Styling for Front
            $this->add_control(
                'heading_front_title_style',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __( 'عنوان', 'pori' ),
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'front_title_spacing',
                [
                    'label' => __( 'فضا', 'pori' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ]
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 10,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ]
                ]
            );

            $this->add_control(
                'front_title_color',
                [
                    'label' => __( 'رنگ عنوان', 'pori' ),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => "#000",
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'front_title_typography',
                    'label' => __( 'فونت', 'pori' ),
                    'selector' => '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-title',
                ]
            );

            // Description Styling for Front
            $this->add_control(
                'heading_front_description_style',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __( 'توضیحات', 'pori' ),
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'front_description_color',
                [
                    'label' => __( 'رنگ توضیحات', 'pori' ),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#000',
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-description' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'front_description_typography',
                    'label' => __( 'فونت', 'pori' ),
                    'selector' => '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-front .pori-flipbox-description',
                ]
            );

        $this->end_controls_section();

        // Back Styling
        $this->start_controls_section(
            'section_flipbox_back_style',
            [
                'label' => __( 'پشت', 'pori' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_control(
                'back_horizontal_alignment',
                [
                    'label' => __( 'چیدمان عمودی', 'pori' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => __( 'Left', 'pori' ),
                            'icon' => 'fa fa-align-left',
                        ],
                        'center' => [
                            'title' => __( 'Center', 'pori' ),
                            'icon' => 'fa fa-align-center',
                        ],
                        'right' => [
                            'title' => __( 'Right', 'pori' ),
                            'icon' => 'fa fa-align-right',
                        ],
                    ],
                    'default' => 'center',
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-back' => "text-align: {{VALUE}}; text-align: -webkit-{{VALUE}};",
                    ]
                ]
            );

            $this->add_control(
                'back_vertical_alignment',
                [
                    'label' => __( 'چیدمان افقی', 'pori' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'ma-v-align-top' => [
                            'title' => __( 'بالا', 'pori' ),
                            'icon' => 'eicon-v-align-top',
                        ],
                        'ma-v-align-middle' => [
                            'title' => __( 'وسط', 'pori' ),
                            'icon' => 'eicon-v-align-middle',
                        ],
                        'ma-v-align-bottom' => [
                            'title' => __( 'پایین', 'pori' ),
                            'icon' => 'eicon-v-align-bottom',
                        ],
                    ],
                    'default' => 'ma-v-align-middle',
                    'toggle' => true,
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'back_background',
                    'label' => __( 'زمینه', 'pori' ),
                    'selector' => '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back',
                ]
            );

            $this->add_responsive_control(
                'back_padding',
                [
                    'label' => __( 'فاصله', 'pori' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'default' => [
                        'top' =>  '20',
                        'right' => '20',
                        'bottom' => '20',
                        'left' => '20',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'back_card',
                    'label' => __( 'کادر دور', 'pori' ),
                    'selector' => '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back',
                ]
            );

            $this->add_control(
                'back_border_radius',
                [
                    'label' => __( 'حاشیه لبه', 'pori' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'back_box_shadow',
                    'label' => __( 'سایه', 'pori' ),
                    'selector' => '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back',
                    'condition' => [
                        'flip_effect!' => ['ma-slide', 'ma-push']
                    ]
                ]
            );

            // Icon Styling for Back
            $this->add_control(
                'heading_back_icon_style',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __( 'آیکون', 'pori' ),
                    'condition' => [
                        'back_graphic_element' => 'icon',
                    ],
                    'separator' => 'before',
                ]
            );
            
            $this->add_responsive_control(
                'back_icon_spacing',
                [
                    'label' => __( 'فضای ایکون', 'pori' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ]
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 10,
                    ],                    
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-icon' => 'margin-bottom: {{SIZE}}{{UNIT}};'
                    ],
                    'condition' => [
                        'back_graphic_element' => 'icon',
                    ],
                ]
            );

            $this->add_control(
                'back_icon_color',
                [
                    'label' => __( 'رنگ آیکون', 'pori' ),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#ffc600',
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-icon i' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-icon svg' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'back_graphic_element' => 'icon',
                    ],
                ]
            );

            $this->add_responsive_control(
                'back_icon_size',
                [
                    'label' => __( 'سایز آیکون', 'pori' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 5,
                            'max' => 600,
                            'step' => 1,
                        ]
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 50,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-icon svg' => 'font-size: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'back_graphic_element' => 'icon',
                    ],
                ]
            );

            $this->add_control(
                'back_icon_bgcolor',
                [
                    'label' => __( 'رنگ زمینه', 'pori' ),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#fff',
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-icon' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'back_graphic_element' => 'icon',
                    ],
                ]
            );

            $this->add_responsive_control(
                'back_icon_padding',
                [
                    'label' => __( 'فاصله', 'pori' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 10,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-icon i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-icon svg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'back_graphic_element' => 'icon',
                    ],
                ]
            );

            $this->add_control(
                'back_icon_rotate',
                [
                    'label' => __( 'چرخش ایکون', 'pori' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 360,
                            'step' => 1,
                        ]
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-icon i' => 'transform: rotate({{SIZE}}deg);',
					    '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-icon svg' => 'transform: rotate({{SIZE}}deg);',
                    ],
                    'condition' => [
                        'back_graphic_element' => 'icon',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'back_icon_border',
                    'label' => __( 'کادر دور', 'pori' ),
                    'selector' => '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-icon',
                    'condition' => [
                        'back_graphic_element' => 'icon',
                    ],
                ]
            );

            $this->add_control(
                'back_icon_border_radius',
                [
                    'label' => __( 'حاشیه لبه', 'pori' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 50,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'back_graphic_element' => 'icon',
                    ],
                ]
            );

            // Image Styling for Back
            $this->add_control(
                'heading_back_image_style',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __( 'عکس', 'pori' ),
                    'condition' => [
                        'back_graphic_element' => 'image',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'back_image_spacing',
                [
                    'label' => __( 'فضای بین عکس', 'pori' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ]
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 10,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-image img' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'back_graphic_element' => 'image',
                    ],
                ]
            );
            
            $this->add_control(
                'back_image_size',
                [
                    'label' => __( 'سایز عکس', 'pori' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 10,
                            'max' => 500,
                            'step' => 1,
                        ]
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 50,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-image img' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'back_graphic_element' => 'image',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'back_image_padding',
                [
                    'label' => __( 'فاصله', 'pori' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-image img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'back_graphic_element' => 'image',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'back_image_border',
                    'label' => __( 'کادر دور', 'pori' ),
                    'selector' => '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-image img',
                    'condition' => [
                        'back_graphic_element' => 'image',
                    ],
                ]
            );

            $this->add_responsive_control(
                'back_image_border_radius',
                [
                    'label' => __( 'حاشیه لبه', 'pori' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'back_graphic_element' => 'image',
                    ],
                ]
            );

            // Title Styling for Back
            $this->add_control(
                'heading_back_title_style',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __( 'عنوان', 'pori' ),
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'back_title_spacing',
                [
                    'label' => __( 'فضا', 'pori' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ]
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 10,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ]
                ]
            );

            $this->add_control(
                'back_title_color',
                [
                    'label' => __( 'رنگ عنوان', 'pori' ),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#fff',
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'back_title_typography',
                    'label' => __( 'فونت', 'pori' ),
                    'selector' => '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-title',
                ]
            );

            // Description Styling for Back
            $this->add_control(
                'heading_back_description_style',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __( 'توضیحات', 'pori' ),
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'back_description_spacing',
                [
                    'label' => __( 'فضا', 'pori' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ]
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 10,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-description' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ]
                ]
            );

            $this->add_control(
                'back_description_color',
                [
                    'label' => __( 'رنگ توضیحات', 'pori' ),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#fff',
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-description' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'back_description_typography',
                    'label' => __( 'فونت', 'pori' ),
                    'selector' => '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-description',
                ]
            );

            // Button Styling for Back
            $this->add_control(
                'heading_back_button_style',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __( 'دکمه', 'pori' ),
                    'separator' => 'before',
                    'condition' => [
                        'back_button_text!' => '',
                    ]
                ]
            );

            $this->add_control(
                'button_size',
                [
                    'label' => __('سایز دکمه', 'pori'),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'ma-btn-md',
                    'options' => [
                        'ma-btn-sm' => __('Small', 'pori'),
                        'ma-btn-md' => __('Medium', 'pori'),
                        'ma-btn-lg' => __('Large', 'pori'),
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'button_typogrpahy',
                    'label' => __( 'فونت', 'pori' ),
                    'selector' => '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-button a',
                ]
            );

            $this->add_control(
                'button_text_color',
                [
                    'label' => __( 'رنگ متن', 'pori' ),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#fff',
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-button a' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'button_bg_color',
                [
                    'label' => __( 'رنگ زمینه', 'pori' ),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#000',
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-button a' => 'background-color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'border',
                    'label' => __( 'کادر دور', 'pori' ),
                    'selector' => '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-button a',
                ]
            );

            $this->add_responsive_control(
                'button_border-radius',
                [
                    'label' => __( 'حاشیه لبه', 'pori' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-flipbox-wrapper .pori-flipbox-card .pori-flipbox-back .pori-flipbox-button a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();
	}
	
	protected function render() {
        $settings = $this->get_settings_for_display();

        // Effects
        $direction = "";
        $flipEffect = $settings['flip_effect'];
        if ( $flipEffect == "ma-flip" || $flipEffect == "ma-slide" || $flipEffect == "ma-push" ) {
            $direction = "ma-flip-dir-" . $settings['flip_direction'];
        }
        $flipClass = $flipEffect . " " . $direction;
    ?>
        <div class="pori-flipbox-wrapper <?php echo $flipClass; ?>">
            <div class="pori-flipbox-card">
                <div class="pori-flipbox-front <?php echo $settings['front_vertical_alignment']; ?>">
                    <?php if( $settings['front_graphic_element'] == 'image' ) : ?>
                    <div class="pori-flipbox-image">
                        <?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'front_image_dimension', 'front_choose_image' ); ?>
                    </div>
                    <?php endif; ?>

                    <?php if( $settings['front_graphic_element'] == 'icon' ) : ?>
                    <div class="pori-flipbox-wrapper">
                        <span class="pori-flipbox-icon">
                            <?php \Elementor\Icons_Manager::render_icon( $settings['front_choose_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </span>
                    </div>
                    <?php endif; ?>
                    
                    <h3 class="pori-flipbox-title"><?php echo $settings['front_title']; ?></h3>
                    <div class="pori-flipbox-description">
                        <?php echo $settings['front_description']; ?>
                    </div>
                </div>

                <div class="pori-flipbox-back <?php echo $settings['back_vertical_alignment']; ?>">
                    <?php if( $settings['back_graphic_element'] == 'image' ) : ?>
                    <div class="pori-flipbox-image">
                        <?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'back_image_dimension', 'back_choose_image' ); ?>
                    </div>
                    <?php endif; ?>

                    <?php if( $settings['back_graphic_element'] == 'icon' ) : ?>
                    <div class="pori-flipbox-wrapper">
                        <span class="pori-flipbox-icon">
                            <?php \Elementor\Icons_Manager::render_icon( $settings['back_choose_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </span>
                    </div>
                    <?php endif; ?>
                    
                    <h3 class="pori-flipbox-title"><?php echo $settings['back_title']; ?></h3>
                    <div class="pori-flipbox-description">
                        <?php echo $settings['back_description']; ?>
                    </div>

                    <?php if ( $settings['back_button_text'] !== "" ) { ?>
                    <div class="pori-flipbox-button pori-button">
                    <?php
                        $target = $settings['back_button_link']['is_external'] ? ' target="_blank"' : '';
		                $nofollow = $settings['back_button_link']['nofollow'] ? ' rel="nofollow"' : '';
                        echo '<a class="ma-btn ' . $settings['button_size'] . '" href="' . $settings['back_button_link']['url'] . '"' . $target . $nofollow . '>' . $settings['back_button_text'] .'</a>';
                    ?>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    <?php
	}
	
	protected function _content_template() {
	}
}
