<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
if (!defined('ABSPATH')) exit;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Control_Media;
use \Elementor\REPEATER;
use \Elementor\Icons_Manager;
use \Elementor\Utils;
use \Elementor\Widget_Base;


class pori_gallery_bina extends Widget_Base
{

    public function get_name(){
        return 'pori-filterable-gallery';
    }

    public function get_title(){
        return esc_html__('گالری عکس', 'pori-addons-elementor');
    }

    public function get_icon(){
        return 'eicon-gallery-grid';
    }

    public function get_categories(){
        return ['Bina-category'];
    }

    public function get_script_depends(){
        return [ 'pori-gallery' ];
    }

    public function get_keywords() {
        return [ 'pori', 'gallery', 'filter', 'masonry', 'portfolio', 'filterable', 'grid' ];
    }

    protected function register_controls() {
        $pori_primary_color   = get_option( 'pori_primary_color_option', '#ffc600' );
        $pori_secondary_color = get_option( 'pori_secondary_color_option', '#001659' );
        
        /**
         * Filter Gallery Grid Settings
         */
        $this->start_controls_section(
            'pori_section_fg_grid_settings',
            [
                'label' => esc_html__('ایتم ها', 'pori-addons-elementor')
            ]
        );

        $filter_repeater = new Repeater();

        $filter_repeater->add_control(
			'pori_fg_gallery_item_title',
			[
                'label'       => esc_html__('عنوان', 'pori-addons-elementor'),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__('عنوان ایتم های گالری', 'pori-addons-elementor'),
                'dynamic' => [
					'active' => true,
				]
            ]
        );

        $filter_repeater->add_control(
			'pori_fg_gallery_item_content',
			[
                'label'       => esc_html__('اطلاعات', 'pori-addons-elementor'),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default'     => esc_html__('قالب شرکتی بینا وردپرس', 'pori-addons-elementor'),
                'dynamic' => [
					'active' => true,
				]
            ]
        );

        

        $filter_repeater->add_control(
			'pori_fg_gallery_img',
			[
                'label'       => esc_html__('عکس', 'pori-addons-elementor'),
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url'     => Utils::get_placeholder_image_src()
                ]
            ]
        );

        $filter_repeater->add_control(
			'pori_fg_gallery_img_link',
			[
                'type'        => Controls_Manager::URL,
                'label_block' => true,
                'default'     => [
                    'url'     => '#'
                ]
            ]
        );

        $this->add_control(
            'pori_fg_gallery_items',
            [
                'type'      => Controls_Manager::REPEATER,
                'fields'  => $filter_repeater->get_controls(),
                'seperator' => 'before',
                'default' => [
                    ['pori_fg_gallery_control_name' => 'Design, Branding'],
                    ['pori_fg_gallery_control_name' => 'Interior'],
                    ['pori_fg_gallery_control_name' => 'Development'],
                    ['pori_fg_gallery_control_name' => 'Design, Interior'],
                    ['pori_fg_gallery_control_name' => 'Branding, Development'],
                    ['pori_fg_gallery_control_name' => 'Design, Development']
                ],
                'title_field' => '{{pori_fg_gallery_item_title}}'
            ]
        );

        $this->end_controls_section();

        /**
         * Filter Gallery Settings
         */
        $this->start_controls_section(
            'pori_section_fg_settings',
            [
                'label' => esc_html__('تنظیمات', 'pori-addons-elementor')
            ]
        );

        $this->add_control(
            'pori_fg_columns',
            [
                'label'   => esc_html__('ستون', 'pori-addons-elementor'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'pori-col-3',
                'options' => [
                    'pori-col-1' => esc_html__('1', 'pori-addons-elementor'),
                    'pori-col-2' => esc_html__('2',   'pori-addons-elementor'),
                    'pori-col-3' => esc_html__('3', 'pori-addons-elementor'),
                    'pori-col-4' => esc_html__('4',  'pori-addons-elementor')
                ]
            ]
        );

        $this->add_control(
            'pori_fg_grid_hover_style',
            [
                'label'   => esc_html__('استایل شناور', 'pori-addons-elementor'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'pori-zoom-in',
                'options' => [
                    'pori-zoom-in'      => esc_html__('بزرگنمایی', 'pori-addons-elementor'),
                    'pori-slide-left'   => esc_html__('اسلاید در چپ',   'pori-addons-elementor'),
                    'pori-slide-right'  => esc_html__('اسلاید در راست', 'pori-addons-elementor'),
                    'pori-slide-top'    => esc_html__('اسلاید در بالا', 'pori-addons-elementor'),
                    'pori-slide-bottom' => esc_html__('اسلاید در پایین', 'pori-addons-elementor')
                ]
            ]
        );

        $this->add_control(
            'pori_fg_show_icons',
            [
                'label'   => __('Show Icons', 'pori-addons-elementor'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'both',
                'options' => [
                    'popup' => 'PopUp',
                    'link'  => 'Link',
                    'both'  => 'PopUp and Link',
                    'none'  => 'None'
                ]
            ]
        );

        $this->add_control(
            'pori_section_fg_zoom_icon',
            [
                'label'   => esc_html__('آیکون شناور', 'pori-addons-elementor'),
                'type'    => Controls_Manager::ICONS,
                'default' => [
                    'value'   => 'fas fa-search',
                    'library' => 'fa-solid'
                ],
                'condition' => [
                    'pori_fg_show_icons' => [ 'popup', 'both']
                ]
            ]
        );

        $this->add_control(
            'pori_section_fg_link_icon',
            [
                'label'   => esc_html__('لینک آیکون', 'pori-addons-elementor'),
                'type'    => Controls_Manager::ICONS,
                'default' => [
                    'value'   => 'fas fa-link',
                    'library' => 'fa-solid'
                ],
                'condition' => [
                    'pori_fg_show_icons' => [ 'link', 'both']
                ]
            ]
        );

        

        $this->add_control(
            'pori_fg_all_items_text',
            [
                'label'     => esc_html__('متن برای همه موارد', 'pori-addons-elementor'),
                'type'      => Controls_Manager::TEXT,
                'default'   => __('All', 'pori-addons-elementor'),
                'condition' => [
                    'pori_fg_show_constrols' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'pori_fg_show_title',
            [
                'label'        => __('عنوان را فعال کنید.', 'pori-addons-elementor'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'On', 'pori-addons-elementor' ),
                'label_off'    => __( 'Off', 'pori-addons-elementor' ),
                'default'      => 'yes',
                'return_value' => 'yes'
            ]
        );

        $this->add_control(
            'pori_fg_show_details',
            [
                'label'        => __('فعال کردن جزئیات', 'pori-addons-elementor'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'On', 'pori-addons-elementor' ),
                'label_off'    => __( 'Off', 'pori-addons-elementor' ),
                'default'      => 'yes',
                'return_value' => 'yes'
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'    => 'pori_filter_image_size',
                'default' => 'full'
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'pori_fg_item_container_style',
            [
                'label' => esc_html__('مورد گالری', 'pori-addons-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'pori_fg_container_padding',
            [
                'label'        => esc_html__('فاصله', 'pori-addons-elementor'),
                'type'         => Controls_Manager::DIMENSIONS,
                'size_units'   => ['px', 'em', '%'],
                'default'      => [
                    'top'      => '0',
                    'right'    => '10',
                    'bottom'   => '0',
                    'left'     => '10',
                    'unit'     => 'px',
                    'isLinked' => false
                ],
                'selectors'    => [
                    '{{WRAPPER}} .pori-gallery-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'pori_fg_container_margin',
            [
                'label'        => esc_html__('حاشیه', 'pori-addons-elementor'),
                'type'         => Controls_Manager::DIMENSIONS,
                'size_units'   => ['px', 'em', '%'],
                'default'      => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '20',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => false
                ],
                'selectors'    => [
                    '{{WRAPPER}} .pori-gallery-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'           => 'pori_fg_container_shadow',
                'selector'       => '{{WRAPPER}} .pori-gallery-content-wrapper'
            ]
        );

        $this->end_controls_section();

        

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        /**
         * -------------------------------------------
         * Tab Style (Filterable Gallery Item Style)
         * -------------------------------------------
         */
        $this->start_controls_section(
            'pori_section_fg_item_style_settings',
            [
                'label'     => esc_html__('آیکون', 'pori-addons-elementor'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'pori_fg_show_icons!' => 'none'
                ]
            ]
        );

        $this->add_responsive_control(
            'pori_fg_item_icon_box_size',
            [
                'label'          => esc_html__('سایز جعبه', 'pori-addons-elementor'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px'],
                'default'        => [
                    'size'       => 60,
                    'unit'       => 'px'
                ],
                'tablet_default' => [
                    'size'       => 50,
                    'unit'       => 'px'
                ],
                'mobile_default' => [
                    'size'       => 40,
                    'unit'       => 'px'
                ],
                'range'          => [
                    'px'         => [
                        'min'    => 0,
                        'max'    => 120
                    ]
                ],
                'selectors'      => [
                    '{{WRAPPER}} .pori-gallery-item .pori-gallery-item-overlay .pori-gallery-item-overlay-content a' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};'
                ] 
            ]
        );   

        $this->add_responsive_control(
            'pori_fg_item_icon_font_size',
            [
                'label'          => esc_html__('سایز', 'pori-addons-elementor'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px'],
                'range'          => [
                    'px'         => [
                        'min'    => 0,
                        'max'    => 80
                    ]
                ],
                'selectors'      => [
                    '{{WRAPPER}} .pori-gallery-item .pori-gallery-item-overlay .pori-gallery-item-overlay-content a i' => 'font-size: {{SIZE}}{{UNIT}};'
                ] 
            ]
        );

        // Tabs
        $this->start_controls_tabs('pori_fg_item_icon_tabs');

            // Normal icon Tab
            $this->start_controls_tab('pori_fg_item_icon_normal', ['label' => esc_html__('Normal', 'pori-addons-elementor')]);
        
                $this->add_control(
                    'pori_fg_item_icon_normal_color',
                    [
                        'label'     => esc_html__('رنگ', 'pori-addons-elementor'),
                        'type'      => Controls_Manager::COLOR,
                        'default'   => '#ffc600',
                        'selectors' => [
                            '{{WRAPPER}} .pori-gallery-item .pori-gallery-item-overlay .pori-gallery-item-overlay-content a i' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'pori_fg_item_icon_normal_bg_color',
                    [
                        'label'     => esc_html__('رنگ زمینه', 'pori-addons-elementor'),
                        'type'      => Controls_Manager::COLOR,
                        'default'   => '#001659',
                        'selectors' => [
                            '{{WRAPPER}} .pori-gallery-item .pori-gallery-item-overlay .pori-gallery-item-overlay-content a' => 'background: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

            // Hover icon Tab
            $this->start_controls_tab('pori_fg_item_icon_hover', ['label' => esc_html__('Hover', 'pori-addons-elementor')]);
        
                $this->add_control(
                    'pori_fg_item_icon_hover_color',
                    [
                        'label'     => esc_html__('رنگ', 'pori-addons-elementor'),
                        'type'      => Controls_Manager::COLOR,
                        'default'   => '#ffffff',
                        'selectors' => [
                            '{{WRAPPER}} .pori-gallery-item .pori-gallery-item-overlay .pori-gallery-item-overlay-content a:hover i' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'pori_fg_item_icon_hover_bg_color',
                    [
                        'label'     => esc_html__('رنگ زمینه', 'pori-addons-elementor'),
                        'type'      => Controls_Manager::COLOR,
                        'default'   => '#222222',
                        'selectors' => [
                            '{{WRAPPER}} .pori-gallery-item .pori-gallery-item-overlay .pori-gallery-item-overlay-content a:hover' => 'background: {{VALUE}};'
                        ]
                    ]
                );
                
            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        /**
         * -------------------------------------------
         * Tab Style (Filterable Gallery Item Content Style)
         * -------------------------------------------
         */
        $this->start_controls_section(
            'pori_section_fg_item_content_style_settings',
            [
                'label' => esc_html__('محتوا', 'pori-addons-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'pori_fg_grid_content_position',
            [
                'label'   => esc_html__('موقعیت', 'pori-addons-elementor'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'over-image',
                'options' => [
                    'over-image'  => esc_html__('روی عکس', 'pori-addons-elementor'),
                    'below-image' => esc_html__('زیر عکس',   'pori-addons-elementor')
                ]
            ]
        );

        $this->add_control(
            'pori_fg_content_area_style',
            [
                'label'     => esc_html__('منطقه محتوا', 'pori-addons-elementor'),
                'type'      => Controls_Manager::HEADING
            ]
        );

        $this->add_control(
            'pori_fg_item_content_bg_color',
            [
                'label'     => esc_html__('رنگ زمینه', 'pori-addons-elementor'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pori-gallery-items .pori-gallery-item-content' => 'background-color: {{VALUE}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'pori_fg_content_padding',
            [
                'label'        => esc_html__('فاصله', 'pori-addons-elementor'),
                'type'         => Controls_Manager::DIMENSIONS,
                'size_units'   => ['px', 'em', '%'],
                'default'      => [
                    'top'      => '0',
                    'right'    => '20',
                    'bottom'   => '15',
                    'left'     => '20',
                    'unit'     => 'px',
                    'isLinked' => false
                ],
                'selectors'    => [
                    '{{WRAPPER}} .pori-gallery-item .pori-gallery-item-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'pori_fg_item_content_alignment',
            [
                'label'         => esc_html__('چینش', 'pori-addons-elementor'),
                'type'          => Controls_Manager::CHOOSE,
                'toggle'        => false,
                'label_block'   => true,
                'options'       => [
                    'left'      => [
                        'title' => esc_html__('Left', 'pori-addons-elementor'),
                        'icon'  => 'eicon-text-align-left'
                    ],
                    'center'    => [
                        'title' => esc_html__('Center', 'pori-addons-elementor'),
                        'icon'  => 'eicon-text-align-center'
                    ],
                    'right'     => [
                        'title' => esc_html__('Right', 'pori-addons-elementor'),
                        'icon'  => 'eicon-text-align-right'
                    ]
                ],
                'selectors'     => [
                    '{{WRAPPER}} .pori-gallery-items .pori-gallery-item-content' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'pori_fg_item_content_title_typography_settings',
            [
                'label'     => esc_html__('عنوان', 'pori-addons-elementor'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'pori_fg_show_title' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'pori_fg_item_content_title_color',
            [
                'label'     => esc_html__('رنگ', 'pori-addons-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => $pori_secondary_color,
                'selectors' => [
                    '{{WRAPPER}} .pori-gallery-items .pori-gallery-item-content h2' => 'color: {{VALUE}};'
                ],
                'condition' => [
                    'pori_fg_show_title' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'pori_fg_item_content_title_typography',
                'selector'  => '{{WRAPPER}} .pori-gallery-items .pori-gallery-item-content h2',
                'fields_options'   => [
                    'font_size'    => [
                        'default'  => [
                            'unit' => 'px',
                            'size' => 20
                        ]
                    ]
                ],
                'condition' => [
                    'pori_fg_show_title' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'pori_fg_item_content_title_margin',
            [
                'label'        => esc_html__('حاشیه', 'pori-addons-elementor'),
                'type'         => Controls_Manager::DIMENSIONS,
                'size_units'   => ['px', 'em', '%'],
                'default'      => [
                    'top'      => '10',
                    'right'    => '0',
                    'bottom'   => '10',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => false
                ],
                'selectors'    => [
                    '{{WRAPPER}} .pori-gallery-items .pori-gallery-item-content h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'condition'    => [
                    'pori_fg_show_title' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'pori_fg_item_details_text_typography_settings',
            [
                'label'     => esc_html__('اطلاعات', 'pori-addons-elementor'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'pori_fg_show_details' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'pori_fg_item_details_text_color',
            [
                'label'     => esc_html__('رنگ', 'pori-addons-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => $pori_secondary_color,
                'selectors' => [
                    '{{WRAPPER}} .pori-gallery-items .pori-gallery-item-content p' => 'color: {{VALUE}};'
                ],
                'condition' => [
                    'pori_fg_show_details' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'pori_fg_item_details_text_typography',
                'selector'  => '{{WRAPPER}} .pori-gallery-items .pori-gallery-item-content p',
                'condition' => [
                    'pori_fg_show_details' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'pori_fg_item_details_title_margin',
            [
                'label'        => esc_html__('حاشیه', 'pori-addons-elementor'),
                'type'         => Controls_Manager::DIMENSIONS,
                'size_units'   => ['px', 'em', '%'],
                'default'      => [
                    'top'      => '10',
                    'right'    => '0',
                    'bottom'   => '10',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => false
                ],
                'selectors'    => [
                    '{{WRAPPER}} .pori-gallery-items .pori-gallery-item-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'condition'    => [
                    'pori_fg_show_details' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'pori_fg_hover_overlay_style',
            [
                'label'     => esc_html__('زمینه شناور', 'pori-addons-elementor'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'pori_fg_item_overlay_color',
            [
                'label'     => esc_html__('زمینه شناور', 'pori-addons-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#FFC600A6',
                'selectors' => [
                    '{{WRAPPER}} .pori-gallery-element .pori-gallery-item .pori-gallery-item-overlay' => 'background-color: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();
    }

    private function filterable_gallery_content( $position, $show_title, $show_details, $title, $content ) {
        $content_position = 'below-image' === $position ? ' below-image' : ''; 

        $output = '<div class="pori-gallery-item-content'.esc_attr( $content_position ).'">';
            $output .= do_action( 'pori_fg_content_wrapper_before' );
            if( 'yes' === $show_title && !empty( $title ) ):
                
            endif;
            if( 'yes' === $show_details && !empty( $content ) ):
                $output .= '<p>'.wp_kses_post( $content ).'</p>';
            endif;
            $output .= do_action('pori_fg_content_wrapper_after');
        $output .= '</div>';
        return $output;
    }

    private function render_editor_script() { ?>
        <script type="text/javascript">
            ( function($) {
                if ( $.isFunction( $.fn.isotope ) ) {
                    $( '.pori-gallery-items' ).each( function() {
                        var $container  = $( this ).find( '.pori-gallery-element' );
                        var carouselNav = $container.attr( 'id' );

                        var galleryItem = '#' + $(this).attr( 'id' );
                        $container.isotope( {
                            filter: '*',
                            animationOptions: {
                                queue: true
                            }
                        } );

                        $( galleryItem + ' .pori-gallery-menu button' ).click(function(){
                            $( galleryItem + ' .pori-gallery-menu button.current' ).removeClass( 'current' );
                            $(this).addClass('current');
                     
                            var selector = $(this).attr( 'data-filter' );
                            $container.isotope( {
                                filter: selector,
                                animationOptions: {
                                    queue: true
                                }
                            } );
                            return false;
                        } );
                    } );
                }
            } )(jQuery);
            
        </script>
    <?php
    }

    protected function render() {
        
        $settings     = $this->get_settings_for_display();
        $show_title   = $settings['pori_fg_show_title'];
        $show_details = $settings['pori_fg_show_details'];
        $position     = $settings['pori_fg_grid_content_position'];

        do_action('pori_fg_wrapper_before'); ?>

        <div id ="pori-filterable-gallery-id-<?php echo $this->get_id(); ?>" class="pori-gallery-items">
            <div class="pori-gallery-one pori-gallery-wrapper">
            <?php
                if( 'yes' === $settings['pori_fg_show_constrols'] ): ?>
                    <div class="pori-gallery-menu">
                    <?php
                        do_action( 'pori_fg_controls_wrapper_before' );
                        if( !empty( $settings['pori_fg_all_items_text'] ) ) : ?>
                            <button data-filter="*" class="filter-item current"><?php echo esc_html($settings['pori_fg_all_items_text']); ?></button>
                        <?php    
                        endif;
                        $pori_gallerycontrols             = array_column( $settings['pori_fg_gallery_items'], 'pori_fg_gallery_control_name' );
                        $pori_fg_controls_comma_separated = implode( ', ', $pori_gallerycontrols );
                        $pori_fg_controls_array           = explode( ",",$pori_fg_controls_comma_separated );
                        $pori_fg_controls_lowercase       = array_map( 'strtolower', $pori_fg_controls_array );
                        $pori_fg_controls_remove_space    = array_filter( array_map( 'trim', $pori_fg_controls_lowercase ) );
                        $pori_fg_controls_items           = array_unique( $pori_fg_controls_remove_space );

                        foreach( $pori_fg_controls_items as $control ) :
                            $control_attribute = preg_replace( '#[ -]+#', '-', $control );
                            echo '<button class="filter-item" data-filter=".'.esc_attr( $control_attribute ).'">'.esc_html( $control ).'</button>';
                        endforeach;
                        do_action( 'pori_fg_controls_wrapper_after' );
                        ?>
                    </div>
                    <?php    
                endif;
                ?>

                <div id="filters-<?php echo $this->get_id(); ?>" class="pori-gallery-element">
                <?php
                    foreach( $settings['pori_fg_gallery_items'] as $index => $gallery ) :
                        $pori_controls                = $gallery['pori_fg_gallery_control_name'];
                        $pori_controls_to_array       = explode( ",",$pori_controls );
                        $pori_controls_to_lowercase   = array_map( 'strtolower', $pori_controls_to_array );
                        $pori_controls_remove_space   = array_filter( array_map( 'trim', $pori_controls_to_lowercase ) );
                        $pori_controls_space_replaced = array_map( function($val) { return str_replace( ' ', '-', $val ); }, $pori_controls_remove_space );
                        $pori_control                 = implode ( " ", $pori_controls_space_replaced );
                        $title                        = $gallery['pori_fg_gallery_item_title'];
                        $content                      = $gallery['pori_fg_gallery_item_content'];

                        do_action( 'pori_fg_item_wrapper_before' ); ?>
                        <div class="pori-gallery-item <?php echo esc_attr( $pori_control ). ' '.esc_attr( $settings['pori_fg_columns'] );?>">
                            <div class="pori-gallery-content-wrapper">
                                <div class="pori-gallery-image">
                                <?php 
                                    $fg_image         = $gallery['pori_fg_gallery_img'];
                                    $fg_image_src_url = Group_Control_Image_Size::get_attachment_image_src( $fg_image['id'], 'pori_filter_image_size', $settings );

                                    if( empty( $fg_image_src_url ) ) {
                                        $fg_image_url = $fg_image['url']; 
                                    } else { 
                                        $fg_image_url = $fg_image_src_url;
                                    }
                                    ?>

                                    <div class="pori-gallery-thumbnail-holder" style="background-image: url('<?php echo esc_url( $fg_image_url ); ?>'); ?>"></div>
                                        <div class="pori-gallery-item-overlay <?php echo esc_attr( $settings['pori_fg_grid_hover_style'] ); ?>">
                                            <div class="pori-gallery-item-overlay-content">
                                            <?php 
                                            if( 'none' !== $settings['pori_fg_show_icons'] ) : ?>
                                                <div class="pori-fg-icons">
                                                <?php
                                                    if( ( 'popup' || 'both' === $settings['pori_fg_show_icons'] ) && !empty( $settings['pori_section_fg_zoom_icon'] ) ) :

                                                        $link_key = 'link_' . $index;
                                                        $this->add_render_attribute( $link_key, [
                                                            'href'                              => esc_url( $gallery['pori_fg_gallery_img']['url'] ),
                                                            'data-elementor-open-lightbox'      => 'default',
                                                            'data-elementor-lightbox-slideshow' => $this->get_id(),
                                                            'data-elementor-lightbox-index'     => $index
                                                        ] );
                                                        if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
                                                            $this->add_render_attribute( $link_key, [
                                                                'class' => 'elementor-clickable'
                                                            ] );
                                                        }
                                                        ?>

                                                        <a <?php echo $this->get_render_attribute_string( $link_key ); ?>>
                                                            <?php Icons_Manager::render_icon( $settings['pori_section_fg_zoom_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                        </a>
                                                    <?php     
                                                    endif; 

                                                    if( ( 'link' || 'both' === $settings['pori_fg_show_icons'] )  && !empty($settings['pori_section_fg_link_icon']) ) :
                                                        $href = $target = '';
                                                        if ( $gallery['pori_fg_gallery_img_link']['url'] ) {
                                                            $href = 'href="'.esc_url($gallery['pori_fg_gallery_img_link']['url']).'"';
                                                        }
                                                        if ( 'on' === $gallery['pori_fg_gallery_img_link']['is_external'] ) {
                                                            $target = ' target= _blank';
                                                        }
                                                        if ( 'on' === $gallery['pori_fg_gallery_img_link']['nofollow'] ) {
                                                            $target .= ' rel= nofollow ';
                                                        }
                                                        ?>
                                                        <a <?php echo $href.$target; ?>>
                                                            <?php Icons_Manager::render_icon( $settings['pori_section_fg_link_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                            <?php     
                                            endif; 

                                            if( 'over-image' === $position && ( 'yes' === $show_title || $show_details ) ) :
                                                echo $this->filterable_gallery_content( $position, $show_title, $show_details, $title, $content );
                                            endif;
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <?php             
                                if( 'below-image' === $position && ( 'yes' === $show_title || $show_details ) ) :
                                    echo $this->filterable_gallery_content( $position, $show_title, $show_details, $title, $content );
                                endif;
                                ?>
                            </div>
                        </div>
                        <?php do_action('pori_fg_item_wrapper_after');
                    endforeach;
                    ?>
                </div>
            </div>
        </div>
        <?php do_action('pori_fg_wrapper_after');

        if (\Elementor\Plugin::instance()->editor->is_edit_mode()) {
            $this->render_editor_script();
        }
    }

}