<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Controls_Manager;
use \Elementor\Widget_Base;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Background;;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;


class Pori_iconbox_bina extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'pori-ico-box';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'جعبه آیکون', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-alert';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'settings_section',
			[
				'label' => esc_html__( 'تنظیمات عمومی', 'Bina-extension' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'theme',
			[
				'label'       => esc_html__( 'ظاهر', 'Bina-extension' ),
				'type'        => Controls_Manager::SELECT,
				'options' => array(
                    'theme-01' => esc_html__('یک','Bina-extension'),
                    'theme-02' => esc_html__('دو','Bina-extension'),
                    'theme-03' => esc_html__('سه','Bina-extension'),
                ),
				'description' => esc_html__( 'انتخاب قالب.', 'Bina-extension' ),
				'default'     => 'theme-01'
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'عنوان', 'Bina-extension' ),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'عناون.', 'Bina-extension' ),
				'default'     => esc_html__('قالب وردپرس بینا','Bina-extension')
			]
		);
		$this->add_control(
			'icon',
			[
				'label'       => esc_html__( 'آیکون', 'Bina-extension' ),
				'type'        => Controls_Manager::ICON,
				'description' => esc_html__( 'انتخاب آیکون', 'Bina-extension' ),
				'default'     => 'flaticon-layers-2'
			]
		);
		$this->add_control(
			'description',
			[
				'label'       => esc_html__( 'توضیحات', 'Bina-extension' ),
				'type'        => Controls_Manager::TEXTAREA,
				'description' => esc_html__( 'توضیحات', 'Bina-extension' ),
				'default'     => esc_html__('لورم ایپیسوم یک متن ساختگی برای سایت بینا می باشد','Bina-extension')
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'settings_styling',
			[
				'label' => esc_html__( 'استایل', 'Bina-extension' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(Group_Control_Background::get_type(),[
			'name' => 'featured_background',
			'selector' => "{{WRAPPER}} .single-connect-you-item",
			'description' => esc_html__('رنگ زمینه آیکون','Bina-extension')
		]);
		$this->add_control( 'icon_box_icon_color', [
			'label'       => esc_html__( 'رنگ آیکون', 'Bina-extension' ),
			'type'        => Controls_Manager::COLOR,
			'description' => esc_html__( 'تغییر رنگ', 'Bina-extension' ),
			'default'     => '#fff',
			'selectors'   => [
				"{{WRAPPER}} .single-connect-you-item .icon" => "color: {{VALUE}}"
			]
		] );
		$this->add_control( 'icon_box_title_color', [
			'label'       => esc_html__( 'رنگ عنوان', 'Bina-extension' ),
			'type'        => Controls_Manager::COLOR,
			'description' => esc_html__( 'تغییر رنگ', 'Bina-extension' ),
			'default'     => '#fff',
			'selectors'   => [
				"{{WRAPPER}} .single-connect-you-item .content .title" => "color: {{VALUE}}"
			]
		] );
		$this->add_control( 'icon_box_text_color', [
			'label'       => esc_html__( 'رنگ متن', 'Bina-extension' ),
			'type'        => Controls_Manager::COLOR,
			'description' => esc_html__( 'رنگ متن', 'Bina-extension' ),
			'default'     => 'rgba(255, 255, 255, 0.9)',
			'selectors'   => [
				"{{WRAPPER}} .single-connect-you-item .content p" => "color: {{VALUE}}"
			]
		] );

		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
        <div class="single-connect-you-item <?php echo esc_attr($settings['theme'])?>">
            <div class="icon">
                <i class="<?php echo esc_attr($settings['icon'])?>"></i>
            </div>
            <div class="content">
                <h4 class="title"><?php echo esc_html__($settings['title'])?></h4>
                <p><?php echo esc_html__($settings['description'])?></p>
            </div>
        </div>
		<?php
	}
}
