<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor icon Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_iconboxmoren_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve icon widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'iconboxmodern';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve icon widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'جعبه اطلاعات مدرن', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve icon widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the icon widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register icon widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		
// icon Title
$this->add_control(
	'icon_title',
	[
		'label' => __( 'عنوان', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'label_block' => true,
		'default'     => esc_html__( 'آدرس', 'Bina-extension' ),
		'placeholder' => __( 'آدرس', 'Bina-extension' ),
	]
);
        // icon Sub Title
		$this->add_control(
			'icon_takhasos',
			[
				'label' => __( 'آدرس اصلی', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'قزوین میدان انقلاب ', 'Bina-extension' ),
				'placeholder' => __( 'قزوین', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
        
        
		$this->add_control(
			'icon_icon',
			[
				'label' => __( 'آیکون', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-telegram',
					'library' => 'solid',
				],
			]
		);
		
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		// iconp Area Background Options
		$this->add_control(
			'iconp_area_back_heading',
			[
				'label' => __( 'رنگ زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		// iconp Area Background Color
        $this->add_control(
			'iconp_area_backh',
			[
				'label' => __( 'رنگ زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} .icon-modern__item' => 'background-color: {{VALUE}}',
				],
			]
        );
// iconp Area Background Color
$this->add_control(
	'iconp_area_back',
	[
		'label' => __( 'رنگ شناور زمینه آیکون', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'scheme' => [
			'type' => \Elementor\Core\Schemes\Color::get_type(),
			'value' => \Elementor\Core\Schemes\Color::COLOR_1,
		],
		'default' => 'rgba(12,90,219,0.85)',
		'selectors' => [
			'{{WRAPPER}} .icon-modern__item:hover .icon-modern__thumb' => 'background-color: {{VALUE}}',
		],
	]
);
        // Sub Title Options
		$this->add_control(
			'iconp_subtitle_heading',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'iconp_subtitl_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .icon-modern__content h4' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'iconp_subtitl_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .icon-modern__content h4',
			]
        );
        
        // Title Options
		$this->add_control(
			'title_heading',
			[
				'label' => __( 'زیر عنوان', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Title Color
        $this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#797979',
				'selectors' => [
					'{{WRAPPER}} .icon-modern__content p' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .icon-modern__content p',
			]
        );

		


        $this->end_controls_section();
	}

	/**
	 * Render icon widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $icon_style = $settings['icon_style'];
        $icon_title = $settings['icon_title'];
		$icon_takhasos = $settings['icon_takhasos'];
		$icon_icon = $settings['icon_icon']['value'];
        $iconp_image = $settings['iconp_image']['url'];

		
    ?>
	<div class="icon-modern__item mb-30">
    <div class="icon-modern__thumb-wrapper">
        <div class="icon-modern__thumb">
		
            <i class="<?php echo $icon_icon;?>"></i>
			
        </div>
    </div>
    <div class="icon-modern__content">
        <h4><?php echo $icon_title; ?></h4>
        <p class="m-0"><?php echo $icon_takhasos; ?></p>
    </div>
</div>
<?php
	}

}