<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor icon Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_iconboxnum_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve icon widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'iconboxes3';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve icon widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'جعبه اطلاعات شمارشی', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve icon widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the icon widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register icon widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'icon_num',
			[
				'label' => __( 'عدد', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => esc_html__( '1', 'Bina-extension' ),
				'placeholder' => __( 'عدد', 'Bina-extension' ),
			]
		);
		
// icon Title
$this->add_control(
	'icon_title2',
	[
		'label' => __( 'عنوان', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'label_block' => true,
		'default'     => esc_html__( 'قالب وردپرس بینا', 'Bina-extension' ),
		'placeholder' => __( 'عنوان', 'Bina-extension' ),
	]
);
        // icon Sub Title
		$this->add_control(
			'icon_dec2',
			[
				'label' => __( 'توضیحات', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'لورم ایپیسوم متن ساختگی طراحان برای سایت بینا می باشد ', 'Bina-extension' ),
				'placeholder' => __( 'توضیحات', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
        
        
		$this->add_control(
			'icon_icon2',
			[
				'label' => __( 'آیکون', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-telegram',
					'library' => 'solid',
				],
			]
		);
		
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		// iconp Area Background Options
		$this->add_control(
			'iconp_area_back_heading',
			[
				'label' => __( 'رنگ زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		// iconp Area Background Color
        $this->add_control(
			'iconp_area_backh',
			[
				'label' => __( 'رنگ زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .work-process-card' => 'background-color: {{VALUE}}',
				],
			]
        );
		// iconp Area Background Color
        $this->add_control(
			'iconp_area_bacgkh',
			[
				'label' => __( 'رنگ زمینه عدد', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#0071dc',
				'selectors' => [
					'{{WRAPPER}} .work-process-card::before' => 'background-color: {{VALUE}}',
				],
			]
        );
// iconp Area Background Color
$this->add_control(
	'iconp_area_back',
	[
		'label' => __( 'رنگ آیکون', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'scheme' => [
			'type' => \Elementor\Core\Schemes\Color::get_type(),
			'value' => \Elementor\Core\Schemes\Color::COLOR_1,
		],
		'default' => '#0071dc',
		'selectors' => [
			'{{WRAPPER}} .work-process-card i' => 'color: {{VALUE}}',
		],
	]
);
        // Sub Title Options
		$this->add_control(
			'iconp_subtitle_heading',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'iconp_subtitl_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .work-process-card h4' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'iconp_subtitl_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .work-process-card h4',
			]
        );
        
        // Title Options
		$this->add_control(
			'title_heading',
			[
				'label' => __( 'توضیحات', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Title Color
        $this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .work-process-card p' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .work-process-card p',
			]
        );

		


        $this->end_controls_section();
	}

	/**
	 * Render icon widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $icon_style = $settings['icon_style'];
        $icon_title2 = $settings['icon_title2'];
		$icon_dec2 = $settings['icon_dec2'];
		$icon_num = $settings['icon_num'];
		$icon_icon2 = $settings['icon_icon2']['value'];
        

		
    ?>
<div class="work-process-card">
    <i class="<?php echo $icon_icon2;?>"></i>
	<h4><?php echo $icon_title2;?></h4>
	<p><?php echo $icon_dec2;?> </p>
	<div class="number"><?php echo $icon_num;?></div>
</div>


<?php
	}

}