<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor icon Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_iconboxdoki_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve icon widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'iconboxes4';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve icon widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'جعبه اطلاعات پزشکی', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve icon widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the icon widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register icon widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		
// icon Title
$this->add_control(
	'icondokiz_title2',
	[
		'label' => __( 'عنوان', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'label_block' => true,
		'default'     => esc_html__( 'قالب وردپرس بینا', 'Bina-extension' ),
		'placeholder' => __( 'عنوان', 'Bina-extension' ),
	]
);
        // icon Sub Title
		$this->add_control(
			'icondokiz_dec2',
			[
				'label' => __( 'توضیحات', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'لورم ایپیسوم متن ساختگی طراحان برای سایت بینا می باشد ', 'Bina-extension' ),
				'placeholder' => __( 'توضیحات', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
        
        
		$this->add_control(
			'icondokiz_icon2',
			[
				'label' => __( 'آیکون', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-telegram',
					'library' => 'solid',
				],
			]
		);
		
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'bps_subtfidtl_fcolor',
			[
				'label' => __( 'رنگ عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#001659',
				'selectors' => [
					'{{WRAPPER}} .porim-dokijoon .robi-element-title' => 'color: {{VALUE}}',
				],
			]
        );
		// Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'iconp_sufbdtitlf_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .porim-dokijoon .robi-element-title',
			]
        );
		$this->add_control(
			'bps_subtfidtlf_fcolor',
			[
				'label' => __( 'رنگ متن توضیح', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#001659',
				'selectors' => [
					'{{WRAPPER}} .porim-dokijoon .robi-heading-desc' => 'color: {{VALUE}}',
				],
			]
        );
		// Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'iconpf_sufbdtitlf_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .porim-dokijoon .robi-heading-desc',
			]
        );
		$this->add_control(
			'bps_subtfidtl_fcoflor',
			[
				'label' => __( 'رنگ شناور متن', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .porim-dokijoon:hover .robi-heading-desc ,.porim-dokijoon:hover .robi-element-title' => 'color: {{VALUE}}',
				],
			]
        );
// iconp Area Background Color
$this->add_control(
	'iconp_area_back',
	[
		'label' => __( 'رنگ آیکون', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'scheme' => [
			'type' => \Elementor\Core\Schemes\Color::get_type(),
			'value' => \Elementor\Core\Schemes\Color::COLOR_1,
		],
		'default' => '#00b761',
		'selectors' => [
			'{{WRAPPER}} .porim-dokijoon .porim-icon-wrapper' => 'color: {{VALUE}}',
		],
	]
);
		


        $this->end_controls_section();
	}

	/**
	 * Render icon widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $icondokiz_style = $settings['icondokiz_style'];
        $icondokiz_title2 = $settings['icondokiz_title2'];
		$icondokiz_dec2 = $settings['icondokiz_dec2'];
		$icondokiz_num = $settings['icondokiz_num'];
		$icondokiz_icon2 = $settings['icondokiz_icon2']['value'];
    ?>
	<div class="porim porim-dokijoon">
<div class="porim-box d-flex align-items-top">
    <div class="porim-icon">
        <div class="porim-icon-wrapper"><i class="<?php echo $icondokiz_icon2;?>"></i></div>
    </div>
    <div class="porim-contents">
        <h2 class="robi-element-title"><?php echo $icondokiz_title2;?></h2>
        <div class="robi-heading-desc"><?php echo $icondokiz_dec2;?></div>
    </div>
</div>
</div>
<?php
	}

}