<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor icon Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_iconboxs_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve icon widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'iconboxesw';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve icon widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'جعبه اطلاعات شناور1', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve icon widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the icon widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register icon widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'porsaz_title',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => esc_html__( 'پلن حرفه ای', 'Bina-extension' ),
				'placeholder' => __( 'عنوان', 'Bina-extension' ),
			]
		);

$this->add_control(
	'porsaz_title2',
	[
		'label' => __( 'زیر عنوان', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'label_block' => true,
		'default'     => esc_html__( 'قالب وردپرس بینا', 'Bina-extension' ),
		'placeholder' => __( 'عنوان', 'Bina-extension' ),
	]
);
$this->add_control(
	'iconsd',
	[
		'label' => __( 'آیکون', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::ICONS,
		'default' => [
			'value' => 'fab fa-telegram',
			'library' => 'solid',
		],
	]
);
        // icon Sub Title
		$this->add_control(
			'porsaz_dec2',
			[
				'label' => __( 'توضیحات', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'لورم ایپیسوم متن ساختگی طراحان برای سایت بینا می باشد ', 'Bina-extension' ),
				'placeholder' => __( 'توضیحات', 'Bina-extension' ),
                'separator'=> 'before',
			]
        ); 
		
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'bps_subtitl_color',
			[
				'label' => __( 'رنگ عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#001659',
				'selectors' => [
					'{{WRAPPER}} .pori-icon-shen.type5.custom-design .icon-content h5' => 'color: {{VALUE}}',
				],
			]
        );
		// Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'iconp_subtitl_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-icon-shen.type5.custom-design .icon-content h5',
			]
        );
		 // Title Options
		 $this->add_control(
			'title_heading',
			[
				'label' => __( 'زیر عنوان', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);
		$this->add_control(
			'bps_subtfitl_color',
			[
				'label' => __( 'رنگ زیر عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#001659',
				'selectors' => [
					'{{WRAPPER}} .pori-icon-shen.type5.custom-design .icon-content h4' => 'color: {{VALUE}}',
				],
			]
        );
		// Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'iconp_subtitlf_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-icon-shen.type5.custom-design .icon-content h4',
			]
        );
		 // Title Options
		 $this->add_control(
			'title_heading',
			[
				'label' => __( 'توضیحات', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);
		$this->add_control(
			'bps_subtfitl_fcolor',
			[
				'label' => __( 'رنگ توضیحات', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#001659',
				'selectors' => [
					'{{WRAPPER}} .pori-icon-shen.type5.custom-design p' => 'color: {{VALUE}}',
				],
			]
        );
		// Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'iconp_sufbtitlf_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-icon-shen.type5.custom-design p',
			]
        );
		// Title Options
		$this->add_control(
			'title_heading',
			[
				'label' => __( 'آیکون', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);
		$this->add_control(
			'icohnp_argea_back',
			[
				'label' => __( 'رنگ زمینه آیکون', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default' => '#001659',
				'selectors' => [
					'{{WRAPPER}} .pori-icon-shen.type5.custom-design.top-left .icon-wrapper' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'icohnp_argea_fback',
			[
				'label' => __( 'رنگ زمینه شناورآیکون', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default' => '#ffc500',
				'selectors' => [
					'{{WRAPPER}} .pori-icon-shen.type5.custom-design.top-left:hover .icon-wrapper' => 'background: {{VALUE}}',
				],
			]
		);
// iconp Area Background Color
$this->add_control(
	'icohnp_area_back',
	[
		'label' => __( 'رنگ آیکون', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'scheme' => [
			'type' => \Elementor\Core\Schemes\Color::get_type(),
			'value' => \Elementor\Core\Schemes\Color::COLOR_1,
		],
		'default' => '#fff',
		'selectors' => [
			'{{WRAPPER}} .pori-icon-shen.type5 .icon-wrapper li' => 'color: {{VALUE}}',
		],
	]
);
		


        $this->end_controls_section();
	}

	/**
	 * Render icon widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $porsaz_style = $settings['porsaz_style'];
        $porsaz_title2 = $settings['porsaz_title2'];
		$porsaz_title = $settings['porsaz_title'];
		$porsaz_dec2 = $settings['porsaz_dec2'];
		$porsaz_img = $settings['porsaz_img']['url'];
		$iconsd = $settings['iconsd']['value'];
    ?>

<div class="pori-icon-shen type5 custom-design alignleft top-left">
    <div class="icon-wrapper">
	<li class="<?php echo $iconsd; ?>"></li>
	</div>
    <div class="icon-content">
        <h5><?php echo $porsaz_title;?></h5>
        <h4><?php echo $porsaz_title2;?></h4>
        <p><?php echo $porsaz_dec2;?></p>
    </div>
</div>


<?php
	}

}