<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor imgbox Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_imgbox_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve imgbox widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'imgbox';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve imgbox widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'جعبه عکس', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve imgbox widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-image';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the imgbox widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register imgbox widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		
// imgbox Title
$this->add_control(
	'imgbox_title',
	[
		'label' => __( 'عنوان', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'label_block' => true,
		'default'     => esc_html__( 'اورولوژی', 'Bina-extension' ),
		'placeholder' => __( 'عنوان', 'Bina-extension' ),
	]
);
        // imgbox Sub Title
		$this->add_control(
			'imgbox_takhasos',
			[
				'label' => __( 'توضیحات', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'لورم ایپیسوم متن ساختگی طراحان', 'Bina-extension' ),
				'placeholder' => __( 'توضیحات', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
        
        // imgboxp Image
		$this->add_control(
			'imgboxp_image',
			[
				'label' => __( 'انتخاب عکس', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
                'label_block' => true,
                'separator'=> 'before',
				'default' => [
                    'url' => Utils::get_placeholder_image_src()
                ],
				'placeholder' => __( 'انتخاب عکس', 'Bina-extension' ),
			]
        );
		
		$this->add_control(
			'readmore_url',
			[
				'label' => __( 'لینک', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
                'label_block' => true,
			//	'default'     => 'porii.ir' ,
			]
        );
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		// imgboxp Area Background Options
		$this->add_control(
			'imgboxp_area_back_heading',
			[
				'label' => __( 'رنگ زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		// imgboxp Area Background Color
        $this->add_control(
			'imgboxp_area_backh',
			[
				'label' => __( 'رنگ زمینه متن', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .symptom-item' => 'background-color: {{VALUE}}',
				],
			]
        );

        // Sub Title Options
		$this->add_control(
			'imgboxp_subtitle_heading',
			[
				'label' => __( 'رنگ  و فونت متن', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'imgboxp_subtitl_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} .mt-0 a' => 'color: {{VALUE}}',
				],
			]
        );
        // Sub Title Color
        $this->add_control(
			'imgboxp_subtitll_color',
			[
				'label' => __( 'رنگ توضیحات', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .symptom-content span' => 'color: {{VALUE}}',
				],
			]
        );
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'imgboxp_subtitl_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .symptom-content span , .mt-0 a',
			]
        );
        
        $this->end_controls_section();
	}

	/**
	 * Render imgbox widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $imgbox_style = $settings['imgbox_style'];
        $imgbox_title = $settings['imgbox_title'];
		$imgbox_takhasos = $settings['imgbox_takhasos'];
		$readmore_url = $settings['readmore_url']['url'];
        $imgboxp_image = $settings['imgboxp_image']['url'];

		
    ?>

<div class="symptom-item">
    <div class="symptom-image">
        <img src="<?php echo $imgboxp_image; ?>" alt="Symptom" width="140px" height="100px"/>
    </div>
    <div class="symptom-content">
        <h4 class="mt-0"><a href="<?php echo $readmore_url;?>"><?php echo $imgbox_title; ?></a></h4>
        <span><?php echo $imgbox_takhasos; ?></span>
    </div>
</div>

<?php
	}

}