<?php
/**
 * Bina elementor ext Theme 
 * author : pouria zamani
 * author url : https://porii.ir
 */
use \Elementor\Controls_Manager;
use \Elementor\Widget_Base;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Icons_Manager;

class pori_feabox_bina extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'appside-feature-box-two-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return esc_html__( 'جعبه اطلاعات بینا', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-icon-box';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @return array Widget categories.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'settings_section',
			[
				'label' => esc_html__( 'تنظیمات عمومی', 'Bina-extension' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'color_theme', [

			'label'       => esc_html__( 'رنگ پوسته', 'Bina-extension' ),
			'type'        => Controls_Manager::SELECT,
			'options'     => array(
				''      => esc_html__( 'رنگی', 'Bina-extension' ),
				'white' => esc_html__( 'سفید', 'Bina-extension' )
			),
			'default'     => '',
			'description' => esc_html__( 'انتخاب پوسته', 'Bina-extension' )
		] );
		$this->add_control( 'theme', [
			'label'       => esc_html__( 'قالب رنگی آیکون', 'Bina-extension' ),
			'type'        => Controls_Manager::SELECT,
			'options'     => array(
				'gdbg-1' => esc_html__( '1', 'Bina-extension' ),
				'gdbg-2' => esc_html__( '2', 'Bina-extension' ),
				'gdbg-3' => esc_html__( '3', 'Bina-extension' ),
				'gdbg-4' => esc_html__( '4', 'Bina-extension' ),
			),
			'default'     => 'gdbg-1',
			'description' => esc_html__( 'انتخاب رنگ آیکون', 'Bina-extension' )
		] );
		$this->add_control( 'icon', [
			'label'       => esc_html__( 'آیکون', 'Bina-extension' ),
			'type'        => Controls_Manager::ICON,
			'default'     => 'flaticon-support',
			'description' => esc_html__( 'انتخاب آیکون', 'Bina-extension' )
		] );
		$this->add_control( 'title', [
			'label'       => esc_html__( 'عنوان', 'Bina-extension' ),
			'type'        => Controls_Manager::TEXT,
			'default'     => esc_html__( 'جعبه اطلاعات بینا', 'Bina-extension' ),
			'description' => esc_html__( 'عنوان', 'Bina-extension' )
		] );
		$this->add_control( 'description', [
			'label'       => esc_html__( 'توضیحات', 'Bina-extension' ),
			'type'        => Controls_Manager::TEXTAREA,
			'default'     => esc_html__( 'جعبه اطلاعات بینا ابزاری برای به نمایش گذاشتن اطلاعات', 'Bina-extension' ),
			'description' => esc_html__( 'توضیحات', 'Bina-extension' )
		] );

		$this->end_controls_section();

		$this->start_controls_section(
			'styling_section',
			[
				'label' => esc_html__( 'تنظیمات', 'Bina-extension' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs(
			'style_tabs'
		);

		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => __( 'نرمال', 'Bina-extension' ),
			]
		);
		$this->add_group_control( Group_Control_Background::get_type(), [
			'label'       => esc_html__( 'زمینه', 'Bina-extension' ),
			'name'        => 'why_us_background',
			'selector'    => "{{WRAPPER}} .single-why-us-item",
			'description' => esc_html__( 'زمینه', 'Bina-extension' )
		] );
		$this->add_control( 'divider', [
			'type' => Controls_Manager::DIVIDER
		] );
		$this->add_group_control( Group_Control_Background::get_type(), [
			'label'       => esc_html__( 'زمینه آیکون', 'Bina-extension' ),
			'name'        => 'feature_box_icon_hover_background',
			'selector'    => "{{WRAPPER}} .single-why-us-item .icon",
			'description' => esc_html__( 'زمینه آیکون', 'Bina-extension' )
		] );
		$this->add_control( 'icon_color', [
			'label'     => esc_html__( 'رنگ آیکون', 'Bina-extension' ),
			'type'      => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .single-why-us-item .icon" => "color: {{VALUE}}"
			],
			'description' => esc_html__( 'رنگ آیکون', 'Bina-extension' )
		] );
		$this->add_control( 'divider_01', [
			'type' => Controls_Manager::DIVIDER
		] );
		$this->add_control( 'title_color', [
			'label'     => esc_html__( 'رنگ عنوان', 'Bina-extension' ),
			'type'      => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .single-why-us-item .content .title" => "color: {{VALUE}}"
			]
		] );
		$this->add_control( 'description_color', [
			'label'     => esc_html__( 'رنگ توضیحات', 'Bina-extension' ),
			'type'      => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .single-why-us-item .content p" => "color: {{VALUE}}"
			]
		] );

		$this->end_controls_tab();

		$this->start_controls_tab(
			'style_hover_tab',
			[
				'label' => __( 'رنگ شناور', 'plugin-name' ),
			]
		);
		$this->add_group_control( Group_Control_Background::get_type(), [
			'label'       => esc_html__( 'زمینه', 'Bina-extension' ),
			'name'        => 'why_us_hover_background',
			'selector'    => "{{WRAPPER}} .single-why-us-item:hover",
			'description' => esc_html__( 'زمینه', 'Bina-extension' )
		] );
		$this->add_control( 'divider_02', [
			'type' => Controls_Manager::DIVIDER
		] );
		$this->add_group_control( Group_Control_Background::get_type(), [
			'label'       => esc_html__( 'زمینه آیکون', 'Bina-extension' ),
			'name'        => 'gd_two_hover_hover_background',
			'selector'    => "{{WRAPPER}} .single-why-us-item:hover .icon",
			'description' => esc_html__( 'زمینه آیکون', 'Bina-extension' )
		] );
		$this->add_control( 'divider_03', [
			'type' => Controls_Manager::DIVIDER
		] );
		$this->add_control( 'title_hover_color', [
			'label'     => esc_html__( 'رنگ عنوان', 'Bina-extension' ),
			'type'      => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .single-why-us-item:hover .content .title" => "color: {{VALUE}}"
			]
		] );
		$this->add_control( 'description_hover_color', [
			'label'     => esc_html__( 'رنگ توضیحات', 'Bina-extension' ),
			'type'      => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .single-why-us-item:hover .content p" => "color: {{VALUE}}"
			]
		] );

		$this->end_controls_tab();

		$this->end_controls_tabs();


		$this->add_control( 'divider_04', [
			'type' => Controls_Manager::DIVIDER
		] );
		$this->add_group_control( Group_Control_Typography::get_type(), [
			'name'     => 'title_typography',
			'label'    => esc_html__( 'فونت عنوان', 'Bina-extension' ),
			'selector' => "{{WRAPPER}} .single-why-us-item .content .title"
		] );
		$this->add_group_control( Group_Control_Typography::get_type(), [
			'name'     => 'description_typography',
			'label'    => esc_html__( 'فونت توضیحات', 'Bina-extension' ),
			'selector' => "{{WRAPPER}} .single-why-us-item .content p"
		] );
		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>
        <div class="single-why-us-item <?php echo esc_attr( $settings['color_theme'] ); ?>">
            <div class="icon <?php echo esc_attr( $settings['theme'] ) ?>">
                <i class="<?php echo esc_attr( $settings['icon'] ); ?>"></i>
            </div>
            <div class="content">
                <h4 class="title"><?php echo esc_html( $settings['title'] ); ?></h4>
                <p><?php echo esc_html( $settings['description'] ) ?></p>
            </div>
        </div>

		<?php
	}
}

