<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
/**
 * Elementor infobox Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class pori_infobox2_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve infobox widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'infobox1';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve infobox widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'جعبه اطلاعات بینا سه', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve infobox widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-icon-box';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the infobox widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register infobox widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		// infobox Title
		$this->add_control(
			'infobox_title',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default'     => esc_html__( 'قالب بینا', 'Bina-extension' ),
				
			]
        );

        // infobox Sub Title
		$this->add_control(
			'infobox_desc',
			[
				'label' => __( 'توضیحات', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'لورم ایپیسوم متن ساختگی', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
        $this->add_control(
			'readmore',
			[
				'label' => __( 'عنوان دکمه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default'     => esc_html__( 'بیشتر بخوانید', 'Bina-extension' ),
				
			]
        );
		$this->add_control(
			'readmore_url',
			[
				'label' => __( 'لینک', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
                'label_block' => true,
				//'default'     => esc_html__( 'https://porii.ir', 'Bina-extension' ),
			]
        );
        

		
		
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		// infoboxp Area Background Options
		$this->add_control(
			'infoboxp_area_back_heading',
			[
				'label' => __( ' زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		// infoboxp Area Background Color
        $this->add_control(
			'infoboxp_area_back',
			[
				'label' => __( 'رنگ زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .service_style_bina' => 'background-color: {{VALUE}}',
				],
			]
        );

        // Sub Title Options
		$this->add_control(
			'infoboxp_subtitle_heading',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'infoboxp_subtitl_color',
			[
				'label' => __( 'رنگ عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} ..service_style_bina_title h4' => 'color: {{VALUE}}',
				],
			]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'عنوان',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} ..service_style_bina_title h4',
			]
        );
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'توضیحات',
				'label' => __( 'فونت توضیحات', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .service_style_bina_text p',
			]
        );
        
        

        // Title Color
        $this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => 'tomato',
				'selectors' => [
					'{{WRAPPER}} .service_style_bina_text p' => 'color: {{VALUE}}',
				],
			]
        );
        
        

		// Title Separator Color
        $this->add_control(
			'title_separator_color',
			[
				'label' => __( 'رنگ زمینه شناور', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} .service_style_bina:hover' => 'background-color: {{VALUE}}',
				],
			]
        );
        
        

		

		
        $this->end_controls_section();
	}

	/**
	 * Render infobox widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $infobox_style = $settings['infobox_style'];
        $infobox_title = $settings['infobox_title'];
		$readmore = $settings['readmore'];
		$readmore_url = $settings['readmore_url']['url'];
		$infobox_title_hover = $settings['infobox_title_hover'];
		$infobox_desc = $settings['infobox_desc'];
		$infobox_desc_hover = $settings['infobox_desc_hover'];
		$icon = $settings['icon'];
        

		
    ?>
	
	<div class="service_style_bina pt-40 pb-40 pr-25 pr-3">
    <div class="service_style_bina_icon mb-30">
        <div class="icon">
            <i class="<?php echo $icon;?>"></i>
        </div>
    </div>
    <div class="service_style_bina_title mb-2">
        <h4><?php echo $infobox_title;?></h4>
    </div>
    <div class="service_style_bina_text">
        <p><?php echo $infobox_desc;?></p>
    </div>
    <div class="service_style_bina_button pt-10">
        <a href="<?php echo $readmore_url;?>"><?php echo $readmore;?></a>
    </div>
</div>




<?php
	}

}