<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

use \Elementor\Controls_Manager;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Control_Media;
use \Elementor\Utils;
use \Elementor\Widget_Base;

class pori_logo_bina extends Widget_Base {
	
	public function get_name() {
		return 'pori-logo-carousel';
	}

	public function get_title() {
		return esc_html__( 'لوگو همکاران', 'pori-addons-elementor' );
	}

	public function get_icon() {
		return 'eicon-logo';
	}

	public function get_categories() {
		return [ 'Bina-category' ];
	}

	public function get_script_depends() {
		return [ 'pori-slick' ];
	}

	
	
	protected function register_controls() {
		$pori_primary_color   = get_option( 'pori_primary_color_option', '#ffc600' );
		
	    /*
	    * Logo carousel Image
	    */
	    $this->start_controls_section(
			'pori_logo_carousel_content',
			[
				'label' => esc_html__( 'محتوا', 'pori-addons-elementor' )
			]
		);

        $logo_repeater = new Repeater();

		$logo_repeater->add_control(
			'pori_logo_carousel_image',
			[
				'label'   => __( 'لوگو', 'pori-addons-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src()
				]
			]
        );
        
		$logo_repeater->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name'      => 'logo_image_size',
				'default'   => 'full',
				'condition' => [
					'pori_logo_carousel_image[url]!' => ''
				]
			]
		);
        
        $this->add_control(
			'pori_logo_carousel_repeater',
			[
				'label'   => esc_html__( 'لوکو همکاران', 'pori-addons-elementor' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $logo_repeater->get_controls(),
				'default' => [
					[ 'pori_logo_carousel_image' => Utils::get_placeholder_image_src() ],
					[ 'pori_logo_carousel_image' => Utils::get_placeholder_image_src() ],
					[ 'pori_logo_carousel_image' => Utils::get_placeholder_image_src() ],
					[ 'pori_logo_carousel_image' => Utils::get_placeholder_image_src() ]
				]	
			]
		);

		$this->end_controls_section();
		
		$this->start_controls_section(
			'pori_logo_carousel_settings',
			[
				'label' => esc_html__( 'تنظیمات کاروسل', 'pori-addons-elementor' )
			]
		);

		$this->add_control(
			'pori_logo_slide_to_show',
			[
				'label'   => esc_html__( 'ستون ها', 'pori-addons-elementor' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => '3'
			]
		);

		$this->add_control(
			'pori_logo_slide_to_scroll',
			[
				'label'   => esc_html__( 'برای پیمایش اسلاید کنید', 'pori-addons-elementor' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => '1'
			]
		);

		$this->add_control(
			'pori_logo_carousel_nav',
			[
				'label'     => esc_html__( 'جهت یابی', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'arrows',
				'separator' => 'before',
				'options' => [
                    'arrows' => esc_html__( 'پیکان', 'pori-addons-elementor' ),
                    'dots'   => esc_html__( 'نقطه', 'pori-addons-elementor' ),
                    'both'   => esc_html__( 'پیکان و نقطه', 'pori-addons-elementor' ),
                    'none'   => esc_html__( 'هیچ', 'pori-addons-elementor' )
                    
                ]
			]
		);

		$this->add_control(
			'pori_logo_autoplay',
			[
				'label'     => esc_html__( 'پخش خودکار', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::SWITCHER,
				'separator' => 'before',
				'default'   => 'no'
			]
		);

		$this->add_control(
			'pori_logo_autoplay_speed',
			[
				'label'     => esc_html__( 'سرعت پخش', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 3000,
				'condition' => [
					'pori_logo_autoplay' => 'yes'
				]
			]
		);

		$this->add_control(
			'pori_logo_loop',
			[
				'label'   => esc_html__( 'حلقه بی نهایت', 'pori-addons-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);

		$this->end_controls_section();

		/*
		* Logo Carousel Styling Section
		*/

		$this->start_controls_section(
			'pori_logo_carousel_style_background',
			[
				'label' => esc_html__( 'سبک عمومی', 'pori-addons-elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control(
            'pori_logo_carousel_max_height_enable',
            [
                'label'        => __( 'حداقل ارتفاع', 'pori-addons-elementor' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'pori-addons-elementor' ),
                'label_off'    => __( 'Hide', 'pori-addons-elementor' ),
                'return_value' => 'yes',
                'default'      => 'no'
            ]
        );

        $this->add_responsive_control(
			'pori_logo_carousel_max_height',
			[
				'label' => __( 'ارتفاع', 'pori-addons-elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
                ],
                'default' => [
					'unit' => 'px',
					'size' => 150,
				],
				'selectors' => [
					'{{WRAPPER}} .pori-logo-carousel-element.pori-logo-carousel-max-height-yes .pori-logo-carousel-item' => 'min-height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'pori_logo_carousel_max_height_enable' => 'yes'
                ]
			]
		);

		$this->add_control(
			'pori_logo_carousel_alignment',
			[
				'label'       => esc_html__( 'چینش', 'pori-addons-elementor' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'label_block' => true,
				'options'     => [
					'pori-logo-carousel-left'   => [
						'title' => esc_html__( 'Left', 'pori-addons-elementor' ),
						'icon'  => 'eicon-text-align-left'
					],
					'pori-logo-carousel-center' => [
						'title' => esc_html__( 'Center', 'pori-addons-elementor' ),
						'icon'  => 'eicon-text-align-center'
					],
					'pori-logo-carousel-right'  => [
						'title' => esc_html__( 'Right', 'pori-addons-elementor' ),
						'icon'  => 'eicon-text-align-right'
					]
				],
				'default'     => 'pori-logo-carousel-center'
			]
		);

		$this->add_responsive_control(
			'pori_logo_carousel_item_radius',
			[
				'label'      => esc_html__( 'شعاع لبه', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'    => '0',
					'right'  => '0',
					'bottom' => '0',
					'left'   => '0'
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-logo-carousel .pori-logo-carousel-element .pori-logo-carousel-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_logo_carousel_item_margin',
			[
				'label'      => esc_html__( 'حاشیه آیتم', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px'],
				'default'    => [
					'top'    => '0',
					'right'  => '10',
					'bottom' => '20',
					'left'   => '10'
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-logo-carousel .pori-logo-carousel-element .pori-logo-carousel-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_logo_carousel_item_padding',
			[
				'label'      => esc_html__( 'حاشیه', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px'],
				'selectors'  => [
					'{{WRAPPER}} .pori-logo-carousel .pori-logo-carousel-element .pori-logo-carousel-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->start_controls_tabs( 'pori_logo_carousel_background_tabs' );

			$this->start_controls_tab( 'pori_logo_carousel_background_control', [ 'label' => esc_html__( 'Normal', 'pori-addons-elementor' ) ] );

				$this->add_control(
					'pori_logo_carousel_background',
					[
						'label'     => esc_html__( 'زمینه', 'pori-addons-elementor' ),
						'type'      => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-item' => 'background: {{VALUE}};'
						]
					]
				);
				$this->add_control(
					'pori_logo_carousel_opacity_normal',
					[
						'label'     => __('شفافیت', 'pori-addons-elementor'),
						'type'      => Controls_Manager::NUMBER,
						'range'     => [
							'min'   => 0,
							'max'   => 1
						],
						'selectors' => [
							'{{WRAPPER}} .pori-logo-carousel .pori-logo-carousel-element .pori-logo-carousel-item img' => 'opacity: {{VALUE}};'
						]
					]
				);
				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name'     => 'pori_logo_carousel_border_normal',
						'selector' => '{{WRAPPER}} .pori-logo-carousel .pori-logo-carousel-element .pori-logo-carousel-item'
					]
				);

				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name'     => 'pori_logo_carousel_shadow_normal',
						'selector' => '{{WRAPPER}} .pori-logo-carousel .pori-logo-carousel-element .pori-logo-carousel-item'
					]
				);

			$this->end_controls_tab();

			$this->start_controls_tab( 'pori_logo_carousel_background_hover_control', [ 'label' => esc_html__( 'Hover', 'pori-addons-elementor' ) ] );

				$this->add_control(
					'pori_logo_carousel_background_hover',
					[
						'label'     => esc_html__( 'Background Hover', 'pori-addons-elementor' ),
						'type'      => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-item:hover' => 'background: {{VALUE}};'
						]
					]
				);

				$this->add_control(
					'pori_logo_carousel_opacity_hover',
					[
						'label'     => __('شفافیت', 'pori-addons-elementor'),
						'type'      => Controls_Manager::NUMBER,
						'range'     => [
							'min'   => 0,
							'max'   => 1
						],
						'selectors' => [
							'{{WRAPPER}} .pori-logo-carousel .pori-logo-carousel-element .pori-logo-carousel-item:hover img' => 'opacity: {{VALUE}};'
						]
					]
				);

				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name'     => 'pori_logo_carousel_border_hover',
						'selector' => '{{WRAPPER}} .pori-logo-carousel .pori-logo-carousel-element .pori-logo-carousel-item:hover'
					]
				);

				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name'     => 'pori_logo_carousel_shadow_hover',
						'selector' => '{{WRAPPER}} .pori-logo-carousel .pori-logo-carousel-element .pori-logo-carousel-item:hover'
					]
				);

			$this->end_controls_tab();

		$this->end_controls_tabs();
		
		$this->end_controls_section();

		$this->start_controls_section(
            'pori_logo_carousel_arrow_controls_style_section',
            [
                'label'     => __('کنترل پیکان', 'pori-addons-elementor' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'pori_logo_carousel_nav' => ['arrows', 'both']
                ]               
            ]
        );

        $this->add_control(
            'pori_logo_carousel_arrows_style',
            [
				'label' => esc_html__( 'پیکان', 'pori-addons-elementor' ),
				'type'  => Controls_Manager::HEADING
            ]
        );

        $this->add_responsive_control(
            'pori_logo_carousel_arrows_size',
            [
                'label'         => __( 'سایز', 'pori-addons-elementor' ),
                'type'          => Controls_Manager::SLIDER,
                'default'       => [
                    'size'      => 20
                ],
                'range'         => [
                    'px'        => [
                        'min'   => 1,
                        'max'   => 70,
                        'step'  => 1
                    ]
                ],
                'selectors'     => [
                    '{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-prev i, {{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-next i' => 'font-size: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'pori_logo_carousel_arrow_width',
            [
                'label'         => __( 'عرض', 'pori-addons-elementor' ),
                'type'          => Controls_Manager::SLIDER,
                'default'       => [
                    'size'      => 60
                ],
                'range'         => [
                    'px'        => [
                        'min'   => 1,
                        'max'   => 200,
                        'step'  => 1
                    ]
                ],
                'selectors'     => [
                    '{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-next, {{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-prev' => 'width: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'pori_logo_carousel_arrow_height',
            [
                'label'         => __( 'ارتفاع', 'pori-addons-elementor' ),
                'type'          => Controls_Manager::SLIDER,
                'default'       => [
                    'size'      => 60
                ],
                'range'         => [
                    'px'        => [
                        'min'   => 1,
                        'max'   => 200,
                        'step'  => 1
                    ]
                ],
                'selectors'     => [
                    '{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-next, {{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-prev' => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};'
                ]
            ]
		);
		
		$this->add_control(
			'pori_logo_carousel_prev_arrow_position',
			[
				'label' => __( 'موقعیت پیکان قبلی', 'pori-addons-elementor' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'label_off' => __( 'Default', 'pori-addons-elementor' ),
				'label_on' => __( 'Custom', 'pori-addons-elementor' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
        );
        
        $this->start_popover();

            $this->add_responsive_control(
                'pori_logo_carousel_prev_arrow_position_x_offset',
                [
                    'label' => __( 'X Offset', 'pori-addons-elementor' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => -500,
                            'max' => 500,
                        ],
                        '%' => [
                            'min' => -100,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 30,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-prev' => 'left: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'pori_logo_carousel_prev_arrow_position_y_offset',
                [
                    'label' => __( 'Y Offset', 'pori-addons-elementor' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => -500,
                            'max' => 500,
                        ],
                        '%' => [
                            'min' => -100,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => '%',
                        'size' => 50,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-prev' => 'top: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_popover();

        $this->add_control(
			'pori_logo_carousel_next_arrow_position',
			[
				'label' => __( 'موقعیت پیکان بعدی', 'pori-addons-elementor' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'label_off' => __( 'Default', 'pori-addons-elementor' ),
				'label_on' => __( 'Custom', 'pori-addons-elementor' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
        );
        
        $this->start_popover();

            $this->add_responsive_control(
                'pori_logo_carousel_next_arrow_position_x_offset',
                [
                    'label' => __( 'X Offset', 'pori-addons-elementor' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => -500,
                            'max' => 500,
                        ],
                        '%' => [
                            'min' => -100,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 30,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-next' => 'right: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'pori_logo_carousel_next_arrow_position_y_offset',
                [
                    'label' => __( 'Y Offset', 'pori-addons-elementor' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => -500,
                            'max' => 500,
                        ],
                        '%' => [
                            'min' => -100,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => '%',
                        'size' => 50,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-next' => 'top: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

		$this->end_popover();
		
		$this->add_control(
			'pori_logo_carousel_arrows_border_radius',
			[
				'label'      => esc_html__( 'حاشیه لبه', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ '%'],
				'selectors'  => [
					'{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-next,{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-prev'=> 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'default'    => [
					'top'    => 50,
					'right'  => 50,
					'bottom' => 50,
					'left'   => 50
				] 
			]
		);

		$this->start_controls_tabs( 'pori_logo_carousel_arrows_style_tabs' );

        	// normal state tab
        	$this->start_controls_tab( 'pori_logo_carousel_arrow_normal_style', [ 'label' => esc_html__( 'Normal', 'pori-addons-elementor' ) ] );

		        $this->add_control(
		            'pori_logo_carousel_arrows_color',
		            [
		                'label'         => __( 'رنگ', 'pori-addons-elementor' ),
		                'type'          => Controls_Manager::COLOR,
		                'default'       => '#000000',
		                'selectors'     => [
		                    '{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-next i, {{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-prev i' => 'color: {{VALUE}}'
		                ]          
		            ]
		        );

		        $this->add_control(
		            'pori_logo_carousel_arrows_bg_color',
		            [
		                'label'         => __( 'رنگ زمینه', 'pori-addons-elementor' ),
		                'type'          => Controls_Manager::COLOR,
		                'default'       => '#dddddd',
		                'selectors'     => [
		                    '{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-next, {{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-prev' => 'background-color: {{VALUE}}'
		                ]            
		            ]
		        );

		        $this->add_group_control(
		        	Group_Control_Border::get_type(),
		            [
		                'name'      => 'pori_logo_carousel_arrows_border',
		                'selector'  => '{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-next, {{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-prev'
		            ]
		        );

				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name'     => 'pori_logo_carousel_arrows_shadow',
						'selector' => '{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-prev, {{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-next'
					]
				);

			$this->end_controls_tab();


        	// hover state tab
        	$this->start_controls_tab( 'pori_logo_carousel_arrow_hover_style', [ 'label' => esc_html__( 'Hover', 'pori-addons-elementor' ) ] );

		        $this->add_control(
		            'pori_logo_carousel_arrows_hover_color',
		            [
		                'label'         => __( 'رنگ', 'pori-addons-elementor' ),
		                'type'          => Controls_Manager::COLOR,
		                'default'       => '#ffffff',
		                'selectors'     => [
		                    '{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-next:hover i, {{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-prev:hover i' => 'color: {{VALUE}}'
		                ]          
		            ]
		        );

		        $this->add_control(
		            'pori_logo_carousel_arrows_hover_bg_color',
		            [
		                'label'         => __( 'رنگ زمینه', 'pori-addons-elementor' ),
		                'type'          => Controls_Manager::COLOR,
		                'default'       => $pori_primary_color,
		                'selectors'     => [
		                    '{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-next:hover, {{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-prev:hover' => 'background-color: {{VALUE}}'
		                ]          
		            ]
		        );

		        $this->add_group_control(
		        	Group_Control_Border::get_type(),
		            [
		                'name'      => 'pori_logo_carousel_arrows_hover_border',
		                'selector'  => '{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-next:hover, {{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-prev:hover'
		            ]
		        );

				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name'     => 'pori_logo_carousel_arrows_hover_shadow',
						'selector' => '{{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-prev:hover, {{WRAPPER}} .pori-logo-carousel-element .pori-logo-carousel-next:hover'
					]
				);

			$this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'pori_logo_carousel_dot_bullet_controls_style_section',
            [
                'label'     => __('نقطه', 'pori-addons-elementor' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'pori_logo_carousel_nav' => ['dots', 'both']
                ]                
            ]
        );

        $this->add_responsive_control(
            'pori_logo_carousel_dot_bullet_margin',
            [
                'label'      => __('Margin', 'pori-addons-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default'    => [
					'top'    => 0,
					'right'  => 10,
					'bottom' => 0,
					'left'   => 0
                ], 
                'selectors'  => [
                    '{{WRAPPER}} .pori-logo-carousel .slick-dots li button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->start_controls_tabs( 'pori_logo_carousel_dot_bullet_style_tabs' );

        // normal state tab
        $this->start_controls_tab( 'pori_logo_carousel_dot_bullet_normal', [ 'label' => esc_html__( 'Normal', 'pori-addons-elementor' ) ] );

            $this->add_responsive_control(
                'pori_logo_carousel_dot_bullet_height',
                [
                    'label'  => __( 'ارتفاع', 'pori-addons-elementor' ),
                    'type'   => Controls_Manager::SLIDER,
                    'range'  => [
                        'px' => [
                            'min' => 1,
                            'max' => 100
                        ]
                    ],
                    'default'  => [
                        'size' => 10,
                        'unit' => 'px'
                    ],
                    'selectors'=> [
                        '{{WRAPPER}} .pori-logo-carousel .slick-dots li button' => 'height: {{SIZE}}{{UNIT}};'
                    ]
                ]
            );

            $this->add_responsive_control(
                'pori_logo_carousel_dot_bullet_width',
                [
                    'label'  => __( 'عرض', 'pori-addons-elementor' ),
                    'type'   => Controls_Manager::SLIDER,
                    'range'  => [
                        'px' => [
                            'min' => 1,
                            'max' => 100
                        ]
                    ],
                    'default'  => [
                        'size' => 10,
                        'unit' => 'px'
                    ],
                    'selectors'=> [
                        '{{WRAPPER}} .pori-logo-carousel .slick-dots li button' => 'width: {{SIZE}}{{UNIT}};'
                    ]
                ]
            );

            $this->add_control(
                'pori_logo_carousel_dot_bullet_color',
                [
                    'label'     => esc_html__( 'رنگ', 'pori-addons-elementor' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '#dadada',
                    'selectors' => [
                        '{{WRAPPER}} .pori-logo-carousel .slick-dots li button' => 'background-color: {{VALUE}};'
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name'            => 'pori_logo_carousel_dot_bullet_border',
                    'selector'        => '{{WRAPPER}} .pori-logo-carousel .slick-dots li button',
                ]
            );

            $this->add_responsive_control(
                'pori_logo_carousel_dot_bullet_border_radius',
                [
                    'label'      => esc_html__( 'حاشیه لبه', 'pori-addons-elementor' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'default'    => [
                        'top'    => 100,
                        'right'  => 100,
                        'bottom' => 100,
                        'left'   => 100,
                        'unit'   => '%'
                    ],                
                    'size_units'    => [ 'px', 'em', '%' ],
                    'selectors'  => [
                        '{{WRAPPER}} .pori-logo-carousel .slick-dots li button'=> 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ]
                ]
            );

            $this->end_controls_tab();

            // active state tab
            $this->start_controls_tab( 'pori_logo_carousel_dot_bullet_active', [ 'label' => esc_html__( 'Active', 'pori-addons-elementor' ) ] );

            $this->add_responsive_control(
                'pori_logo_carousel_dot_bullet_active_height',
                [
                    'label'  => __( 'ارتفاع', 'pori-addons-elementor' ),
                    'type'   => Controls_Manager::SLIDER,
                    'range'  => [
                        'px' => [
                            'min' => 1,
                            'max' => 100
                        ]
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .pori-logo-carousel .slick-dots li.slick-active button' => 'height: {{SIZE}}{{UNIT}};'
                    ]
                ]
            );

            $this->add_responsive_control(
                'pori_logo_carousel_dot_bullet_active_width',
                [
                    'label'  => __( 'عرض', 'pori-addons-elementor' ),
                    'type'   => Controls_Manager::SLIDER,
                    'range'  => [
                        'px' => [
                            'min' => 1,
                            'max' => 100
                        ]
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .pori-logo-carousel .slick-dots li.slick-active button' => 'width: {{SIZE}}{{UNIT}};'
                    ]
                ]
            );

            $this->add_control(
                'pori_logo_carousel_dot_bullet_active_color',
                [
                    'label'     => esc_html__( 'رنگ', 'pori-addons-elementor' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => $pori_primary_color,
                    'selectors' => [
                        '{{WRAPPER}} .pori-logo-carousel .slick-dots li.slick-active button' => 'background-color: {{VALUE}};'
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
					'name'     => 'pori_logo_carousel_dot_bullet_active_border',
					'selector' => '{{WRAPPER}} .pori-logo-carousel .slick-dots li.slick-active button'
                ]
            );

            $this->add_responsive_control(
                'pori_logo_carousel_dot_bullet_active_border_radius',
                [
                    'label'      => esc_html__( 'Border Radius', 'pori-addons-elementor' ),
                    'type'       => Controls_Manager::DIMENSIONS,         
                    'size_units'    => [ 'px', 'em', '%' ],
                    'selectors'  => [
                        '{{WRAPPER}} .pori-logo-carousel .slick-dots li.slick-active button'=> 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ]
                ]
            );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();


	}
	protected function render() {
		$settings  = $this->get_settings_for_display();
		$direction = is_rtl() ? 'true' : 'false';

		$this->add_render_attribute( 
			'pori_logo_carousel', 
			[ 
				'class'               => ['pori-logo-carousel-element', 'pori-logo-carousel-max-height-'.esc_attr($settings['pori_logo_carousel_max_height_enable'])],
				'data-carousel-nav'   => esc_attr( $settings['pori_logo_carousel_nav'] ),
				'data-slidestoshow'   => esc_attr( $settings['pori_logo_slide_to_show'] ),
				'data-slidestoscroll' => esc_attr( $settings['pori_logo_slide_to_scroll'] ),
				'data-direction'      => esc_attr( $direction )
			]
		);

		if ( 'yes' === $settings['pori_logo_loop'] ) {
			$this->add_render_attribute( 'pori_logo_carousel', 'data-loop', 'true' );
		}
		if ( 'yes' === $settings['pori_logo_autoplay'] ) {
			$this->add_render_attribute( 'pori_logo_carousel', 'data-autoplay', 'true' );
			$this->add_render_attribute( 'pori_logo_carousel', 'data-autoplayspeed', esc_attr( $settings['pori_logo_autoplay_speed'] ) );
		}

		if ( is_array( $settings['pori_logo_carousel_repeater'] ) ) : ?>
			<div class="pori-logo-carousel">
				<div <?php echo $this->get_render_attribute_string('pori_logo_carousel') ;?> >
					<?php foreach ( $settings['pori_logo_carousel_repeater'] as $logo ) :?>
						<div class="pori-logo-carousel-item <?php echo esc_attr( $settings['pori_logo_carousel_alignment'] );?>">
							<?php echo Group_Control_Image_Size::get_attachment_image_html( $logo, 'logo_image_size', 'pori_logo_carousel_image' ); ?>
						</div>					
					<?php endforeach; ?>
				</div>
			</div>
		<?php
		endif;
	}
}