<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor portfolio Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_portfolio_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve portfolio widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'portfolio';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve portfolio widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'نمونه کار', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve portfolio widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-call-to-action';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the portfolio widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register portfolio widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		
// portfolio Title
$this->add_control(
	'portfolio_title',
	[
		'label' => __( 'نام', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'label_block' => true,
		'default'     => esc_html__( 'پوریا زمانی', 'Bina-extension' ),
		'placeholder' => __( 'مثل : پوریا زمانی', 'Bina-extension' ),
	]
);
        // portfolio Sub Title
		$this->add_control(
			'portfolio_takhasos',
			[
				'label' => __( 'عنوان شغلی', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'مدیر تیم', 'Bina-extension' ),
				'placeholder' => __( 'سئو', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
        
        // portfoliop Image
		$this->add_control(
			'portfoliop_image',
			[
				'label' => __( 'انتخاب عکس', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
                'label_block' => true,
                'separator'=> 'before',
				'default' => [
                    'url' => Utils::get_placeholder_image_src()
                ],
				'placeholder' => __( 'انتخاب عکس', 'Bina-extension' ),
			]
        );
		$this->add_control(
			'show_social_icon',
			[
				'label' => __( 'نمایش آیکون شبکه اجتماعی', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'Bina-extension' ),
				'label_off' => __( 'Hide', 'Bina-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
	/*	$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'portfolio_title', [
				'label' => __( 'نام شبکه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'نام شبکه اجتماعی' , 'Bina-extension' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'portfolio_icon',
			[
				'label' => __( 'آیکون', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-telegram',
					'library' => 'solid',
				],
			]
		);
        
        // portfolio Icon Link
		$repeater->add_control(
			'portfolio_icon_link',
			[
				'label' => __( 'لینک شبکه اجتماعی', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'نمایش لینک', 'Bina-extension' ),
			]
        );

		$this->add_control(
			'portfolio_social_list',
			[
				'label' => __( 'شبکه اجتماعی', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ portfolio_title }}}',
				'condition' => [
					'show_social_icon' => 'yes'
				]
			]
		);*/
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		// portfoliop Area Background Options
		$this->add_control(
			'portfoliop_area_back_heading',
			[
				'label' => __( 'رنگ زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		// portfoliop Area Background Color
        $this->add_control(
			'portfoliop_area_backh',
			[
				'label' => __( 'رنگ زمینه متن شناور', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} .single_portfolio_content' => 'background-color: {{VALUE}}',
				],
			]
        );
// portfoliop Area Background Color

        // Sub Title Options
		$this->add_control(
			'portfoliop_subtitle_heading',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'portfoliop_subtitl_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .single_portfolio_content_inner span' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'portfoliop_subtitl_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .single_portfolio_content_inner span',
			]
        );
        
        // Title Options
		$this->add_control(
			'title_heading',
			[
				'label' => __( 'سمت', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Title Color
        $this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .single_portfolio_content_inner h2 a' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .single_portfolio_content_inner h2 a',
			]
        );

		

        // portfoliop Icon Color
        $this->add_control(
			'portfoliop_icon_color',
			[
				'label' => __( 'رنگ آیکون', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} .single_portfolio_icon i' => 'color: {{VALUE}}',
				],
			]
        );

		

        $this->end_controls_section();
	}

	/**
	 * Render portfolio widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $portfolio_style = $settings['portfolio_style'];
        $portfolio_title = $settings['portfolio_title'];
		$portfolio_takhasos = $settings['portfolio_takhasos'];
		$show_social_icon = $settings['show_social_icon'];
        $portfoliop_image = $settings['portfoliop_image']['url'];

		
    ?>
	<div class="single_portfolio">
    <div class="single_portfolio_inner">
        <div class="single_portfolio_thumb">
            <a href="#"><img src="<?php echo $portfoliop_image; ?>" alt="" /></a>
        </div>
    </div>
    <div class="single_portfolio_content">
        <div class="single_portfolio_icon">
            <a class="portfolio-icon venobox vbox-item" data-gall="myportfolio" href="<?php echo $portfoliop_image; ?>"><i class="fa fa-search-plus"></i></a>
        </div>
        <div class="single_portfolio_content_inner">
            <span><?php echo $portfolio_title; ?></span>
            <h2><a href="#"><?php echo $portfolio_takhasos; ?></a></h2>
        </div>
    </div>
</div>



<?php
	}

}