<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Controls_Manager;
use \Elementor\Widget_Base;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Background;;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;


class Pori_Price_bina extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'pori-prices';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return esc_html__( 'قیمت گذاری', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-price-table';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @return array Widget categories.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'settings_section',
			[
				'label' => esc_html__( 'تنظیمات عمومی', 'Bina-extension' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'title', [
			'label'       => esc_html__( 'عنوان', 'Bina-extension' ),
			'type'        => Controls_Manager::TEXT,
			'default'     => esc_html__( 'پلن اول', 'Bina-extension' ),
			'description' => esc_html__( 'عنوان', 'Bina-extension' )
		] );
		$this->add_control( 'featured', [
			'label'       => esc_html__( 'ویژه', 'Bina-extension' ),
			'type'        => Controls_Manager::SWITCHER,
			'default'     => 'no',
			'description' => esc_html__( 'فعال سازی پلن ویژه', 'Bina-extension' )
		] );
		$this->add_control( 'price', [
			'label'       => esc_html__( 'قیمت', 'Bina-extension' ),
			'type'        => Controls_Manager::TEXT,
			'default'     => esc_html__( '85', 'Bina-extension' ),
			'description' => esc_html__( 'قیمت', 'Bina-extension' )
		] );
		$this->add_control( 'sign', [
			'label'       => esc_html__( 'واحد پولی', 'Bina-extension' ),
			'type'        => Controls_Manager::TEXT,
			'default'     => esc_html__( 'تومان', 'Bina-extension' ),
			'description' => esc_html__( 'واحد پولی', 'Bina-extension' )
		] );
		$this->add_control( 'month', [
			'label'       => esc_html__( 'ماه', 'Bina-extension' ),
			'type'        => Controls_Manager::TEXT,
			'default'     => esc_html__( '/ماهیانه', 'Bina-extension' ),
			'description' => esc_html__( 'ماه', 'Bina-extension' )
		] );
		$this->add_control( 'btn_text', [
			'label'       => esc_html__( 'عنوان دکمه', 'Bina-extension' ),
			'type'        => Controls_Manager::TEXT,
			'default'     => esc_html__( 'خرید', 'Bina-extension' ),
			'description' => esc_html__( 'عنوان دکمه', 'Bina-extension' )
		] );
		$this->add_control( 'btn_link', [
			'label'       => esc_html__( 'لینک دکمه', 'Bina-extension' ),
			'type'        => Controls_Manager::URL,
			'default'     => array(
				'url' => '#'
			),
			'description' => esc_html__( 'لینک', 'Bina-extension' )
		] );

		$this->add_control( 'feature_items', [
			'label'   => esc_html__( 'آیتم ویژه', 'Bina-extension' ),
			'type'    => Controls_Manager::REPEATER,
			'default' => [
				[
					'feature' => esc_html__( 'سئو', 'Bina-extension' )
				],
			],
			'fields'  => [
				[
					'name'        => 'feature',
					'label'       => esc_html__( 'ویژه', 'Bina-extension' ),
					'type'        => Controls_Manager::TEXT,
					'description' => esc_html__( 'آیتم', 'Bina-extension' ),
					'default'     => esc_html__( 'سئو', 'Bina-extension' )
				]
			],
		] );
		$this->end_controls_section();

		$this->start_controls_section( 'styling_section', [
			'label' => esc_html__( 'تنظیمات', 'Bina-extension' ),
			'tab'   => Controls_Manager::TAB_STYLE
		] );
		$this->add_control( 'title_color', [
			'label'     => esc_html__( 'رنگ عنوان', 'Bina-extension' ),
			'type'     => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .single-price-plan-02 .price-header .name" => "color: {{VALUE}}"
			]
		] );
		$this->add_control( 'price_color', [
			'label'     => esc_html__( 'رنگ قیمت', 'Bina-extension' ),
			'type'     => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .single-price-plan-02 .price-header .price-wrap .price" => "color: {{VALUE}}"
			]
		] );
		$this->add_control( 'month_color', [
			'label'     => esc_html__( 'رنگ ماه', 'Bina-extension' ),
			'type'     => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .single-price-plan-02 .price-header .price-wrap .month" => "color: {{VALUE}}"
			]
		] );
		$this->add_control( 'features_color', [
			'label'     => esc_html__( 'رنگ ویژه', 'Bina-extension' ),
			'type'     => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .single-price-plan-02 .price-body ul" => "color: {{VALUE}}"
			]
		] );
		$this->end_controls_section();

		/* button styling start */
		$this->start_controls_section( 'button_styling_section', [
			'label' => esc_html__( 'استایل دکمه', 'Bina-extension' ),
			'tab'   => Controls_Manager::TAB_STYLE
		] );
		$this->start_controls_tabs(
			'button_style_tabs'
		);

		$this->start_controls_tab(
			'button_style_normal_tab',
			[
				'label' => __( 'عادی', 'Bina-extension' ),
			]
		);
		$this->add_control( 'button_normal_color', [
			'label'     => esc_html__( 'رنگ', 'Bina-extension' ),
			'type'      => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .single-price-plan-02 .price-footer .boxed-btn" => "color: {{VALUE}}"
			]
		] );
		$this->add_group_control( Group_Control_Background::get_type(), [
			'label'    => esc_html__( 'رنگ زمینه', 'Bina-extension' ),
			'name'     => 'button_normal_bg_color',
			'selector' => "{{WRAPPER}} .single-price-plan-02 .price-footer .boxed-btn"
		] );
		$this->add_group_control( Group_Control_Border::get_type(), [
			'label'    => esc_html__( 'حاشیه', 'Bina-extension' ),
			'name'     => 'button_normal_border',
			'selector' => "{{WRAPPER}} .single-price-plan-02 .price-footer .boxed-btn"
		] );

		$this->end_controls_tab();

		$this->start_controls_tab(
			'button_style_hover_tab',
			[
				'label' => __( 'شناور', 'Bina-extension' ),
			]
		);
		$this->add_control( 'button_hover_color', [
			'label'     => esc_html__( 'رنگ', 'Bina-extension' ),
			'type'      => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .single-price-plan-02 .price-footer .boxed-btn:hover" => "color: {{VALUE}}"
			]
		] );
		$this->add_group_control( Group_Control_Background::get_type(), [
			'label'    => esc_html__( 'رنگ دکمه', 'Bina-extension' ),
			'name'     => 'button_hover_bg_color',
			'selector' => "{{WRAPPER}} .single-price-plan-02 .price-footer .boxed-btn:hover"
		] );
		$this->add_group_control( Group_Control_Border::get_type(), [
			'label'    => esc_html__( 'حاشیه', 'Bina-extension' ),
			'name'     => 'button_hover_border',
			'selector' => "{{WRAPPER}} .single-price-plan-02 .price-footer .boxed-btn:hover"
		] );

		$this->end_controls_tab();

		$this->end_controls_tabs();
		$this->add_control( 'button_divider', [
			'type' => Controls_Manager::DIVIDER
		] );
		$this->add_responsive_control( 'button_border_radius', [
			'label'     => esc_html__( 'حاشیه لبه', 'Bina-extension' ),
			'type'      => Controls_Manager::DIMENSIONS,
			'units'     => [ 'px', '%', 'em' ],
			'selectors' => [
				"{{WRAPPER}} .single-price-plan-02 .price-footer .boxed-btn" => "border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"
			]
		] );
		$this->end_controls_section();
		/* button styling end */

		/* border color start */
		$this->start_controls_section( 'hover_border_section', [
			'label' => esc_html__( 'حاشیه شناور', 'Bina-extension' ),
			'tab'   => Controls_Manager::TAB_STYLE
		] );

		$this->add_group_control( Group_Control_Background::get_type(), [
			'name'     => 'hover_background',
			'label'    => esc_html__( 'فعال سازی رنگ حاشیه', 'Bina-extension' ),
			'selector' => "{{WRAPPER}} .single-price-plan-02:after"
		] );

		$this->end_controls_section();
		/* border color end */


		/* button styling start */
		$this->start_controls_section( 'typography_section', [
			'label' => esc_html__( 'فونت', 'Bina-extension' ),
			'tab'   => Controls_Manager::TAB_STYLE
		] );
		$this->add_group_control( Group_Control_Typography::get_type(), [
			'name'     => 'title_typography',
			'label'    => esc_html__( 'فونت عنوان', 'Bina-extension' ),
			'selector' => "{{WRAPPER}} .single-price-plan-02 .price-header .name"
		] );
		$this->add_group_control( Group_Control_Typography::get_type(), [
			'name'     => 'price_typography',
			'label'    => esc_html__( 'فونت قیمت', 'Bina-extension' ),
			'selector' => "{{WRAPPER}} .single-price-plan-02 .price-header .price-wrap"
		] );
		$this->add_group_control( Group_Control_Typography::get_type(), [
			'name'     => 'features_typography',
			'label'    => esc_html__( 'فونت ویژه', 'Bina-extension' ),
			'selector' => "{{WRAPPER}} .single-price-plan-02 .price-body ul"
		] );
		$this->add_group_control( Group_Control_Typography::get_type(), [
			'name'     => 'button_typography',
			'label'    => esc_html__( 'فونت دکمه', 'Bina-extension' ),
			'selector' => "{{WRAPPER}} .single-price-plan-02 .price-footer .boxed-btn"
		] );
		$this->end_controls_section();
		/* button styling end */
	}

	/**
	 * Render Elementor widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings          = $this->get_settings_for_display();
		$all_feature_items = $settings['feature_items'];
		$featured          = $settings['featured'] == 'yes' ? 'featured' : '';
		?>
        <div class="single-price-plan-02 <?php echo esc_attr( $featured ); ?>">
            <div class="price-header">
                <h4 class="name"><?php echo esc_html( $settings['title'] ); ?></h4>
                <div class="price-wrap">
                    <span class="price"><?php echo esc_html( $settings['sign'] ); ?><?php echo esc_html( $settings['price'] ); ?></span>
                    <span class="month"><?php echo esc_html( $settings['month'] ); ?></span>
                </div>
            </div>
            <div class="price-body">
                <ul>
					<?php foreach ( $all_feature_items as $item ): ?>
                        <li><?php echo esc_html( $item['feature'] ) ?></li>
					<?php endforeach; ?>
                </ul>
            </div>
            <div class="price-footer">
                <a href="<?php echo esc_url( $settings['btn_link']['url'] ); ?>"
                   class="boxed-btn"><?php echo esc_html( $settings['btn_text'] ); ?></a>
            </div>
        </div>
		<?php
	}
}