<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Icons_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Widget_Base;
use \Elementor\Repeater;

class Pori_Price2_bina extends Widget_Base {
	
	//use ElementsCommonFunctions;
	public function get_name() {
		return 'pori-pricing-table';
	}

	public function get_title() {
		return esc_html__( 'قیمت گذاری دو', 'Bina-ext' );
	}

	public function get_icon() {
		return 'eicon-price-table';
	}

	public function get_categories() {
		return [ 'Bina-category' ];
	}

	

	protected function register_controls() {
		$pori_secondary_color = get_option( 'pori_secondary_color_option', '#00d8d8' );

		/**
  		 * Pricing Table Feature
  		 */
  		$this->start_controls_section(
  			'pori_section_pricing_table_feature',
  			[
  				'label' => esc_html__( 'مورد ها', 'Bina-ext' )
  			]
		);
		  
		$pricing_repeater = new Repeater();

		$pricing_repeater->add_control(
			'pori_pricing_table_item',
			[
				'name'        => 'pori_pricing_table_item',
				'label'       => esc_html__( 'لیست آیتم ها', 'Bina-ext' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => esc_html__( 'آیتم', 'Bina-ext' ),
				'dynamic' => [
					'active' => true,
				]
			]
		);
		
		$pricing_repeater->add_control(
			'pori_pricing_table_list_icon',
			[
				'name'        => 'pori_pricing_table_list_icon',
				'label'       => esc_html__( 'آیکون', 'Bina-ext' ),
				'type'        => Controls_Manager::ICONS,
				'default'     => [
					'value'   => 'fas fa-check',
					'library' => 'fa-solid'
				]
			]
		);
		
		$pricing_repeater->add_control(
			'pori_pricing_table_icon_mood',
			[
				'name'         => 'pori_pricing_table_icon_mood',
				'label'        => esc_html__( 'این مورد فعال باشد؟', 'Bina-ext' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes'
			]
        );

  		$this->add_control(
			'pori_pricing_table_items',
			[
				'type'        => Controls_Manager::REPEATER,
				'fields'  => $pricing_repeater->get_controls(),
				'seperator'   => 'before',
				'default'     => [
					[ 'pori_pricing_table_item' => esc_html__( 'کاملا ریسپانسیو', 'Bina-ext' ) ],
					[ 'pori_pricing_table_item' => esc_html__( 'سئو شده', 'Bina-ext' ) ],
					[ 'pori_pricing_table_item' => esc_html__( 'تولید محتوا', 'Bina-ext' ) ],
					[ 	
						'pori_pricing_table_item'      => esc_html__( 'رفع ایراد کلی', 'Bina-ext' ),
						'pori_pricing_table_icon_mood' => 'no'
					],
					[ 
						'pori_pricing_table_item'      => esc_html__( 'متصل کردن به گوگل', 'Bina-ext' ),
						'pori_pricing_table_icon_mood' => 'no'
					]
				],	
				'title_field' => '{{pori_pricing_table_item}}'
			]	
		);

		$this->end_controls_section();
		  
		/**
  		 * Pricing Table Promo label
  		 */
  		$this->start_controls_section(
			'pori_section_pricing_table_promo_section',
			[
				'label' => esc_html__( 'پیشنهاد ویژه', 'Bina-ext' )
			]
		);

		$this->add_control(
			'pori_pricing_table_promo_enable',
			[
				'label'        => esc_html__( 'پیشنهاد ویژه فعال باشد؟', 'Bina-ext' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'no'
			]
		);

		$this->add_control(
			'pori_pricing_table_promo_title',
			[
				'label'       => esc_html__( 'عنوان', 'Bina-ext' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => false,
				'default'     => esc_html__( 'پیشنهاد ویژه', 'Bina-ext' ),
				'condition'   => [
					'pori_pricing_table_promo_enable' => 'yes'
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'pori_pricing_table_promo_position',
			[
				'label'        => __( 'موقعیت', 'Bina-ext' ),
				'type'         => Controls_Manager::SELECT,
				'default'      => 'promo_top',
				'options'      => [
					'promo_top'    => __( 'بالا', 'Bina-ext' ),
					'promo_bottom' => __( 'پایین', 'Bina-ext' ),
				],
				'condition'    => [
					'pori_pricing_table_promo_enable' => 'yes'
				]
			]
		);

		$this->end_controls_section();

  		/**
  		 * Pricing Table Settings
  		 */
  		$this->start_controls_section(
  			'pori_section_pricing_table_settings',
  			[
  				'label' => esc_html__( 'سربرگ', 'Bina-ext' )
  			]
  		);

  		$this->add_control(
			'pori_pricing_table_title',
			[
				'label'       => esc_html__( 'عنوان', 'Bina-ext' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => false,
				'default'     => esc_html__( 'پایه', 'Bina-ext' ),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'pori_pricing_table_subtitle',
			[
				'label'       => esc_html__( 'زیر عنوان', 'Bina-ext' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'pori_pricing_table_featured',
			[
				'label'        => esc_html__( 'ویژه باشد؟', 'Bina-ext' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'no'
			]
		);

		$this->add_control(
			'pori_pricing_table_featured_type',
			[
				'label'     => esc_html__( 'نوع استایل', 'Bina-ext' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'text-badge',
				'options'   => [
					'text-badge' => __( 'متن', 'Bina-ext' ),
					'icon-badge' => __( 'آیکون', 'Bina-ext' )
				],
				'condition' => [
					'pori_pricing_table_featured' => 'yes'
				]
			]
		);

		$this->add_control(
			'pori_pricing_table_featured_tag_text',
			[
				'label'       => esc_html__( 'متن', 'Bina-ext' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => false,
				'default'     => esc_html__( 'ویژه', 'Bina-ext' ),
				'condition'   => [
					'pori_pricing_table_featured'      => 'yes',
					'pori_pricing_table_featured_type' => 'text-badge'
				]
			]
		);

  		$this->end_controls_section();

  		$this->start_controls_section(
  			'pori_section_pricing_table_price',
  			[
  				'label' => esc_html__( 'قیمت', 'Bina-ext' )
  			]
		);

		$this->add_control(
			'pori_pricing_table_price',
			[
				'label'       => esc_html__( 'قیمت', 'Bina-ext' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => false,
				'default'     => esc_html__( '50', 'Bina-ext' )
			]
		);
		
  		$this->add_control(
			'pori_pricing_table_price_cur',
			[
				'label'       => esc_html__( 'واحد پولی', 'Bina-ext' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => false,
				'default'     => esc_html__( 'تومان', 'Bina-ext' )
			]
		);

		$this->add_control(
			'pori_pricing_table_price_cur_position',
			[
				'label'       => esc_html__( 'موقعیت واحد پولی', 'Bina-ext' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'	  => false,
				'label_block' => false,
				'default'     => 'pori-pricing-cur-left',
				'options'     => [
					'pori-pricing-cur-left' => [
						'title' => __( 'چپ', 'Bina-ext' ),
						'icon'  => 'eicon-angle-left'
					],
					'pori-pricing-cur-right' => [
						'title' => __( 'راست', 'Bina-ext' ),
						'icon'  => 'eicon-angle-right'
					]
				]
			]
		);

		$this->add_control(
			'pori_pricing_table_price_by',
			[
				'label'       => esc_html__( 'مدت', 'Bina-ext' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => false,
				'default'     => esc_html__( 'ماهیانه', 'Bina-ext' )
			]
		);

		$this->add_control(
			'pori_pricing_table_period_separator',
			[
				'label'       => esc_html__( 'جداککنده', 'Bina-ext' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => false,
				'default'     => esc_html__( '/', 'Bina-ext' )
			]
		);

		

		$this->add_control(
			'pori_pricing_table_price_subtitle',
			[
				'label'       => esc_html__( 'توضیحات', 'Bina-ext' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);

  		$this->end_controls_section();

  		

  		/**
  		 * Pricing Table Footer
  		 */
  		$this->start_controls_section(
  			'pori_section_pricing_table_button',
  			[
  				'label' => esc_html__( 'دکمه', 'Bina-ext' )
  			]
		);
		  

		$this->add_control(
			'pori_pricing_table_btn_position',
			[
				'label'   => esc_html__( 'موقعیت', 'Bina-ext' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'bottom',
				'options' => [
					'middle' => __( 'بالا', 'Bina-ext' ),
					'bottom' => __( 'پایین', 'Bina-ext' )
				]
			]
		);

		$this->add_control(
			'pori_pricing_table_btn',
			[
				'label'       => esc_html__( 'متن', 'Bina-ext' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => esc_html__( 'انتخاب پلن', 'Bina-ext' )
			]
		);

		$this->add_control(
			'pori_pricing_table_btn_link',
			[
				'label'       => esc_html__( 'لینک', 'Bina-ext' ),
				'type'        => Controls_Manager::URL,
				'label_block' => true,
				'default'     => [
					'url'         => 'https://porii.ir',
					'is_external' => ''
     			],
     			'show_external' => true
			]
		);

		$this->end_controls_section();
		  
		  /**
  		 * Pricing Table Note
  		 */
  		$this->start_controls_section(
			'pori_section_pricing_table_note',
			[
				'label' => esc_html__( 'نکته', 'Bina-ext' )
			]
		);

		$this->add_control(
			'pori_pricing_table_note_text',
			[
				'label' => __( 'متن', 'Bina-ext' ),
				'type' => Controls_Manager::TEXTAREA,
				'rows' => 5,
			]
		);

		$this->end_controls_section();

  	
		/**
		 * -------------------------------------------
		 * Tab Style (Pricing Table Style)
		 * -------------------------------------------
		 */

		$this->start_controls_section(
			'pori_section_pricing_tables_styles_presets',
			[
				'label' => esc_html__( 'کلیت', 'Bina-ext' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_responsive_control(
			'pori_section_pricing_tables_min_height',
			[
				'label'       => esc_html__( 'ارتفاع', 'Bina-ext' ),
				'type'        => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px'     => [
						'min'  => 0,
						'max'  => 2000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .pori-pricing-table-badge-wrapper' => 'min-height: {{SIZE}}{{UNIT}};'
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'pori_pricing_table_bg_color_simple',
				'label' => __( 'زمینه', 'Bina-ext' ),
				'types' => [ 'classic', 'gradient' ],
				'fields_options'  => [
					'background'  => [
						'default' => 'classic'
					],
					'color'       => [
						'default' => '#ffffff'
					]
				],
				'selector' => '{{WRAPPER}} .pori-pricing-table-badge-wrapper',
				'condition' => [
					'pori_pricing_table_header_type' => 'simple'
				]
			]
		);
				
		$this->add_control(
			'pori_pricing_table_bg_color',
			[
				'label'     => esc_html__( 'رنگ زمینه', 'Bina-ext' ),
				'seperator' => 'before',
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .pori-pricing-table-badge-wrapper' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .pori-pricing-table-header .pori-pricing-table-header-curved svg path' => 'fill: {{VALUE}};'
				],
				'condition' => [
					'pori_pricing_table_header_type' => 'curved-header'
				]
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_content_padding',
			[
				'label'      => __( 'فضای داخلی', 'Bina-ext' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'      => '45',
					'right'    => '30',
					'bottom'   => '45',
					'left'     => '30',
					'isLinked' => false
				],
				'selectors' => [
					'{{WRAPPER}} .pori-pricing-table-badge-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'pori_pricing_table_content_border',
				'selector' => '{{WRAPPER}} .pori-pricing-table-badge-wrapper'
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_content_border_radius',
			[
				'label'      => __( 'حاشیه لبه', 'Bina-ext' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '10',
                    'right'    => '10',
                    'bottom'   => '10',
                    'left'     => '10',
                    'unit'     => 'px'
                ],
				'selectors'  => [
					'{{WRAPPER}} .pori-pricing-table-badge-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .pori-pricing-table-header' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} 0 0;',
					'{{WRAPPER}} .pori-pricing-table-header .pori-pricing-table-header-svg' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} 0 0;'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'pori_pricing_table_content_box_shadow',
				'selector' => '{{WRAPPER}} .pori-pricing-table-badge-wrapper',
				'fields_options'         => [
		            'box_shadow_type'    => [
		                'default'        =>'yes'
		            ],
		            'box_shadow'         => [
		                'default'        => [
		                    'horizontal' => 0,
		                    'vertical'   => 13,
		                    'blur'       => 33,
		                    'spread'     => 0,
		                    'color'      => 'rgba(51,77,128,0.08)'
		                ]
		            ]
	            ]
			]
		);

		$content_align = is_rtl() ? 'right' : 'left';

		$this->add_control(
			'pori_pricing_table_content_alignment',
			[
				'label'         => __( 'چینش', 'Bina-ext' ),
				'type'          => Controls_Manager::CHOOSE,
				'toggle'        => false,
				'separator'     => 'after',
				'default'       => $content_align,
				'options'       => [
					'left'      => [
						'title' => __( 'چپ', 'Bina-ext' ),
						'icon'  => 'eicon-text-align-left'
					],
					'center'    => [
						'title' => __( 'وسط', 'Bina-ext' ),
						'icon'  => 'eicon-text-align-center'
					],
					'right'     => [
						'title' => __( 'راست', 'Bina-ext' ),
						'icon'  => 'eicon-text-align-right'
					]
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'pori_pricing_table_transition_shadow',
				'label'    => __( 'سایه شناور', 'Bina-ext' ),
				'selector' => '{{WRAPPER}} .pori-pricing-table-wrapper:hover .pori-pricing-table-badge-wrapper',
				'fields_options'      => [
		            'box_shadow_type' => [
		                'default'     =>'yes'
		            ],
		            'box_shadow'  => [
		                'default' => [
		                    'horizontal' => 0,
		                    'vertical'   => 20,
		                    'blur'       => 40,
		                    'spread'     => 0,
		                    'color'      => 'rgba(51,77,128,0.2)'
		                ]
		            ]
	            ]
			]
		);

		$this->add_control(
			'pori_pricing_table_transition_type',
			[
				'label'   => __( 'استایل شناور', 'Bina-ext' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'none'              =>  __( 'هیچ', 'Bina-ext' ),
					'transition_top'    =>  __( 'رو به بالا', 'Bina-ext' ),
					'transition_bottom' => __( 'رو به پایین', 'Bina-ext' ),
					'transition_zoom'   => __( 'بزرگنمایی', 'Bina-ext' )
				],
				'default' => 'none'
			]
		);

		
		$this->end_controls_section();

		/**
		 * -------------------------------------------
		 * Style (Promo label)
		 * -------------------------------------------
		 */
		$this->start_controls_section(
			'pori_section_pricing_table_promo_style',
			[
				'label'     => esc_html__( 'پیشنهاد ویژه', 'Bina-ext' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'pori_pricing_table_promo_enable' => 'yes'
				]
			]
		);

		$this->add_control(
			'pori_pricing_table_promo_alignment',
			[
				'label'     => __( 'چینش', 'Bina-ext' ),
				'type'      => Controls_Manager::CHOOSE,
				'toggle'    => false,
				'options'   => [
					'left'      => [
						'title' => __( 'چپ', 'Bina-ext' ),
						'icon'  => 'eicon-text-align-left'
					],
					'center'    => [
						'title' => __( 'وسط', 'Bina-ext' ),
						'icon'  => 'eicon-text-align-center'
					],
					'right'     => [
						'title' => __( 'راست', 'Bina-ext' ),
						'icon'  => 'eicon-text-align-right'
					]
				],
				'default'   => 'center',
				'selectors' => [
					'{{WRAPPER}} .pori-pricing-table-promo-label' => 'text-align: {{VALUE}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'pori_pricing_table_promo_background',
				'types'     => [ 'classic', 'gradient' ],
				'fields_options'  => [
					'background'  => [
						'default' => 'classic'
					],
					'color'       => [
						'default' => '#ffffff'
					]
				],
				'selector'  => '{{WRAPPER}} .pori-pricing-table-promo-label',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'pori_pricing_table_promo_typography',
				'label'    => __( 'فونت', 'Bina-ext' ),
				'selector' => '{{WRAPPER}} .pori-pricing-table-promo-label',
			]
		);

		$this->add_control(
			'pori_pricing_table_promo_text-color',
			[
				'label'     => esc_html__( 'رنگ متن', 'Bina-ext' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .pori-pricing-table-promo-label' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_promo_padding',
			[
				'label'      => __( 'فضای داخلی', 'Bina-ext' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'      => '15',
					'right'    => '30',
					'bottom'   => '15',
					'left'     => '30',
					'unit'     => 'px',
					'isLinked' => false,
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-pricing-table-promo-label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_promo_radius',
			[
				'label'      => __( 'حاشیه لبه', 'Bina-ext' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'isLinked' => true
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-pricing-table-promo-label' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->end_controls_section();

		/**
		 * -------------------------------------------
		 * Style (Header)
		 * -------------------------------------------
		 */
		$this->start_controls_section(
			'pori_section_pricing_table_title_header_settings',
			[
				'label' => esc_html__( 'سربرگ', 'Bina-ext' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control(
			'pori_pricing_table_header_type',
			[
				'label'   => esc_html__( 'نوع سربرگ', 'Bina-ext' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'simple',
				'options' => [
					'simple'        => __( 'عادی', 'Bina-ext' ),
					'curved-header' => __( 'انحنا دار', 'Bina-ext' )
				]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'pori_pricing_table_header_background',
				'types'     => [ 'classic', 'gradient' ],
				'selector'  => '{{WRAPPER}} .pori-pricing-table-header',
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_header_padding',
			[
				'label'      => __( 'فضای داخلی', 'Bina-ext' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .pori-pricing-table-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_header_margin',
			[
				'label'      => __( 'فضای خارجی', 'Bina-ext' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '20',
					'left'     => '0',
					'isLinked' => false
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-pricing-table-header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_header_border_radius',
			[
				'label'      => __( 'حاشیه لبه', 'Bina-ext' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'isLinked' => false
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-pricing-table-header' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'pori_pricing_table_header_border',
				'selector'  => '{{WRAPPER}} .pori-pricing-table-header',
				'condition' => [
					'pori_pricing_table_header_type' => 'simple'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'pori_pricing_table_header_shadow',
				'selector' => '{{WRAPPER}} .pori-pricing-table-header',
				'condition' => [
					'pori_pricing_table_header_type' => 'simple'
				]
			]
		);

		$this->end_controls_section();

		/**
		 * -------------------------------------------
		 * Style (Title)
		 * -------------------------------------------
		 */
		$this->start_controls_section(
			'pori_section_pricing_table_title_style_settings',
			[
				'label' => esc_html__( 'عنوان سربرگ', 'Bina-ext' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control(
			'pori_section_pricing_table_title_heading',
			[
				'label'     => esc_html__( 'عنوان', 'Bina-ext' ),
				'type'      => Controls_Manager::HEADING,
				'separator' =>  'before'
			]
		);

		$this->add_control(
			'pori_pricing_table_title_color',
			[
				'label'     => esc_html__( 'رنگ', 'Bina-ext' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#8a8d91',
				'selectors' => [
					'{{WRAPPER}} .pori-pricing-table-title' => 'color: {{VALUE}};'
				]
			]
		);


		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'pori_pricing_table_title_typography',
				'selector' => '{{WRAPPER}} .pori-pricing-table-title',
				'fields_options'   => [
					'font_size'    => [
		                'default'  => [
		                    'unit' => 'px',
		                    'size' => 15
		                ]
		            ],
		            'font_weight'  => [
		                'default'  => '400'
		            ]
	            ]
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_title_margin',
			[
				'label'      => esc_html__( 'فضای خارجی', 'Bina-ext' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'default'    => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '20',
					'left'     => '0',
					'isLinked' => false
				],
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .pori-pricing-table-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		/**
		 * -------------------------------------------
		 * Style (Sub Title)
		 * -------------------------------------------
		 */

		$this->add_control(
			'pori_section_pricing_table_subtitletitle_heading',
			[
				'label'     => esc_html__( 'زیر عنوان', 'Bina-ext' ),
				'type'      => Controls_Manager::HEADING,
				'separator' =>  'before'
			]
		);

		$this->add_control(
			'pori_pricing_table_subtitle_color',
			[
				'label'     => esc_html__( 'رنگ', 'Bina-ext' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000000',
				'selectors' => [
					'{{WRAPPER}} .pori-pricing-table-subtitle' => 'color: {{VALUE}};'
				]
			]
		);


		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'pori_pricing_table_subtitle_typography',
				'selector' => '{{WRAPPER}} .pori-pricing-table-subtitle'
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_subtitle_margin',
			[
				'label'   => esc_html__( 'فضای خارجی', 'Bina-ext' ),
				'type'    => Controls_Manager::DIMENSIONS,
				'default' => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '10',
					'left'     => '0',
					'isLinked' => false
				],
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .pori-pricing-table-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->end_controls_section();

		/**
		 * -------------------------------------------
		 * Style (Pricing)
		 * -------------------------------------------
		 */
		$this->start_controls_section(
			'pori_section_pricing_table_price_style_settings',
			[
				'label' => esc_html__( 'قیمت گذاری', 'Bina-ext' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control(
			'pori_pricing_table_price_box_separator',
			[
				'label'        => esc_html__( 'فعال سازی جدا کننده', 'Bina-ext' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'ON', 'Bina-ext' ),
				'label_off'    => __( 'OFF', 'Bina-ext' ),
				'return_value' => 'yes',
				'default'      => 'yes'
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_price_box_separator_height',
			[
				'label'     => esc_html__( 'ارتفاع جداکننده', 'Bina-ext' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => '1',
				'selectors' => [
					'{{WRAPPER}} .pori-price-bottom-separator' => 'height: {{VALUE}}px;'
				],
				'condition' => [
					'pori_pricing_table_price_box_separator' => 'yes'
				]
				
			]
		);

		$this->add_control(
			'pori_pricing_table_price_box_separator_color',
			[
				'label'     => esc_html__( 'رنگ', 'Bina-ext' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#e5e5e5',
				'selectors' => [
					'{{WRAPPER}} .pori-price-bottom-separator'  => 'background-color: {{VALUE}};'
				],
				'condition' => [
					'pori_pricing_table_price_box_separator' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_price_box_separator_spacing',
			[
				'label'       => esc_html__( 'فضا', 'Bina-ext' ),
				'type'        => Controls_Manager::SLIDER,
				'default'     => [
					'size'    => 30
				],
				'range'       => [
					'px'      => [
						'max' => 50
					]
				],
				'selectors'   => [
					'{{WRAPPER}} .pori-price-bottom-separator' => 'margin: {{SIZE}}px 0;'
				],
				'condition'   => [
					'pori_pricing_table_price_box_separator' => 'yes'
				]
			]
		);

		

		

		


		$this->add_control(
			'pori_pricing_table_price_tag_heading',
			[
				'label'     => esc_html__( 'قیمت', 'Bina-ext' ),
				'type'      => Controls_Manager::HEADING,
				'separator' =>  'before'
			]
		);

		$this->add_control(
			'pori_pricing_table_pricing_color',
			[
				'label'     => esc_html__( 'رنگ', 'Bina-ext' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#132c47',
				'selectors' => [
					'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-price p.pori-pricing-table-new-price'  => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'pori_pricing_table_price_tag_typography',
				'selector' => '{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-price p.pori-pricing-table-new-price',
				'fields_options'   => [
					'font_size'    => [
		                'default'  => [
		                    'unit' => 'px',
		                    'size' => 48
		                ]
		            ],
		            'font_weight'  => [
		                'default'  => '600'
		            ],
		              'letter_spacing' => [
		                'default'      => [
		                    'unit'     => 'px',
		                    'size'     => -3.2
		                ]
		            ]
	            ]
			]
		);

	

		$this->add_control(
			'pori_pricing_table_pricing_curency_heading',
			[
				'label'     => esc_html__( 'واحد پولی', 'Bina-ext' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_control(
			'pori_pricing_table_pricing_curency_spacing',
			[
				'label' => __( 'فضا', 'Bina-ext' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'label_off' => __( 'Default', 'Bina-ext' ),
				'label_on' => __( 'Custom', 'Bina-ext' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		$this->start_popover();

			$this->add_responsive_control(
				'pori_pricing_table_pricing_curency_bottom_spacing',
				[
					'label'      => esc_html__( 'فاصله از پایین', 'Bina-ext' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range'      => [
						'px'     => [
							'min'  => -100,
							'max'  => 100,
							'step' => 1
						],
					],
					'selectors'  => [
						'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-price span.pori-pricing-table-currency' => 'top: {{SIZE}}{{UNIT}};'
					],
				]
			);

            $this->add_responsive_control(
				'pori_pricing_table_pricing_curency_right_spacing',
				[
					'label'      => esc_html__( 'فاصله از راست', 'Bina-ext' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range'      => [
						'px'     => [
							'min'  => 0,
							'max'  => 200,
							'step' => 1
						],
					],
					'selectors'  => [
						'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-price span.pori-pricing-table-currency' => 'margin-right: {{SIZE}}{{UNIT}};'
					],
				]
			);

        $this->end_popover();

		$this->add_control(
			'pori_pricing_table_pricing_curency_color',
			[
				'label'     => esc_html__( 'رنگ', 'Bina-ext' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-price span.pori-pricing-table-currency' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'pori_pricing_table_price_curency_typography',
				'selector' => '{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-price span.pori-pricing-table-currency',
			]
		);

		$this->add_control(
			'pori_pricing_table_pricing_period_heading',
			[
				'label'     => esc_html__( 'مدت', 'Bina-ext' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_control(
			'pori_pricing_table_pricing_period_color',
			[
				'label'     => esc_html__( 'رنگ', 'Bina-ext' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#132c47',
				'selectors' => [
					'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-price span.pori-price-period' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'pori_pricing_table_price_preiod_typography',
				'selector' => '{{WRAPPER}} .pori-pricing-table-wrapper .pori-price-period',
				'fields_options'   => [
					'font_size'    => [
		                'default'  => [
		                    'unit' => 'px',
		                    'size' => 20
		                ]
		            ],
		            'font_weight'  => [
		                'default'  => '600'
		            ],
		              'letter_spacing' => [
		                'default'      => [
		                    'unit'     => 'px',
		                    'size'     => 0
		                ]
		            ]
	            ]
			]
		);

		$this->add_control(
			'pori_pricing_table_price_subtitle_heading',
			[
				'label'     => esc_html__( 'زیر عنوان', 'Bina-ext' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_control(
			'pori_pricing_table_price_subtitle_color',
			[
				'label'     => esc_html__( 'رنگ متن', 'Bina-ext' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-price-subtitle' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'pori_pricing_table_price_subtitle_typography',
				'selector' => '{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-price-subtitle',
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_price_subtitle_margin',
			[
				'label'      => __( 'فضای خارجی', 'Bina-ext' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'    => '',
					'right'  => '',
					'bottom' => '',
					'left'   => '',
					'unit'   => 'px',
					'islinked' => true
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-price-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);

		$this->end_controls_section();


		/**
		 * -------------------------------------------
		 * Style (Feature List)
		 * -------------------------------------------
		 */
		$this->start_controls_section(
			'pori_section_pricing_table_style_featured_list_settings',
			[
				'label' => esc_html__( 'لیست ویژگی ها', 'Bina-ext' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'pori_pricing_table_list_item_typography',
				'selector' => '{{WRAPPER}} .pori-pricing-table-features li'
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_featured_list_icon_size',
			[
				'label'       => esc_html__( 'سایز آیکون', 'Bina-ext' ),
				'type'        => Controls_Manager::SLIDER,
				'default'     => [
					'size'    => 12
				],
				'range'       => [
					'px'      => [
						'max' => 24
					]
				],
				'selectors'   => [
					'{{WRAPPER}} .pori-pricing-li-icon' => 'font-size: {{SIZE}}px;'
				]
			]
		);

		$icon_gap = is_rtl() ? 'left' : 'right';

		$this->add_responsive_control(
			'pori_pricing_table_featured_list_icon_space',
			[
				'label'       => esc_html__( 'فضا', 'Bina-ext' ),
				'type'        => Controls_Manager::SLIDER,
				'default'     => [
					'size'    => 7
				],
				'range'       => [
					'px'      => [
						'max' => 24
					]
				],
				'selectors'   => [
					'{{WRAPPER}} .pori-pricing-table-features li .pori-pricing-li-icon' => 'margin-'.$icon_gap.': {{SIZE}}px;'
				]
			]
		);

		$this->add_control(
			'pori_pricing_table_list_item_icon_color',
			[
				'label'     => esc_html__( 'رنگ', 'Bina-ext' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => $pori_secondary_color,
				'selectors' => [
					'{{WRAPPER}} .pori-pricing-table-features li span.pori-pricing-li-icon' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_control(
			'pori_pricing_table_list_item_color',
			[
				'label'     => esc_html__( 'Item Color', 'Bina-ext' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#132c47',
				'selectors' => [
					'{{WRAPPER}} .pori-pricing-table-features li' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_list_padding',
			[
				'label'      => __( 'فضای داخلی', 'Bina-ext' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'      => '10',
					'right'    => '0',
					'bottom'   => '10',
					'left'     => '0',
					'isLinked' => false
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-pricing-table-features li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_control(
			'pori_pricing_table_list_border_bottom',
			[
				'label'        => __( 'جداکننده مورد ها', 'Bina-ext' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'Bina-ext' ),
				'label_off'    => __( 'Hide', 'Bina-ext' ),
				'return_value' => 'yes',
				'default'      => 'no'
			]
		);

		$this->add_control(
			'pori_pricing_table_list_border_bottom_style',
			[
				'label'     => __( 'رنگ', 'Bina-ext' ),
				'type'      => Controls_Manager::COLOR,
				'defailt'   => '#e5e5e5',
				'selectors' => [
					'{{WRAPPER}} .list-border-bottom li:not(:last-child)' => 'border-bottom:1px solid {{VALUE}};'
				],
				'condition' => [
					'pori_pricing_table_list_border_bottom' => 'yes'
				]
			]
		);

		$this->add_control(
			'pori_pricing_table_list_disable_item_styling',
			[
				'label'     => esc_html__( 'مورد های غیر فعال', 'Bina-ext' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_control(
			'pori_pricing_table_list_disable_item_icon_color',
			[
				'label'     => esc_html__( 'رنگ آیکون', 'Bina-ext' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#a6a9ad',
				'selectors' => [
					'{{WRAPPER}} .pori-pricing-table-features li.pori-pricing-table-features-disable span.pori-pricing-li-icon' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_control(
			'pori_pricing_table_list_disable_item_color',
			[
				'label'     => esc_html__( 'رنگ مورد', 'Bina-ext' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#a6a9ad',
				'selectors' => [
					'{{WRAPPER}} .pori-pricing-table-features li.pori-pricing-table-features-disable' => 'color: {{VALUE}};'
				]
			]
		);

		$this->end_controls_section();

		/**
		 * -------------------------------------------
		 * Tab Style (Pricing Table Featured Tag Style)
		 * -------------------------------------------
		 */
		$this->start_controls_section(
			'pori_section_pricing_table_featured_tag_settings',
			[
				'label'     => esc_html__( 'ویژه', 'Bina-ext' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'pori_pricing_table_featured' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_featured_tag_font_size',
			[
				'label'       => esc_html__( 'فونت', 'Bina-ext' ),
				'type'        => Controls_Manager::SLIDER,
				'default'     => [
					'size'    => 12
				],
				'range'       => [
					'px'      => [
						'max' => 40
					]
				],
				'selectors'   => [
					'{{WRAPPER}} .text-badge'   => 'font-size: {{SIZE}}px;',
					'{{WRAPPER}} .icon-badge i' => 'font-size: {{SIZE}}px;'
				]
			]
		);

		$this->add_control(
			'pori_pricing_table_featured_tag_text_color',
			[
				'label'     => esc_html__( 'رنگ', 'Bina-ext' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .text-badge'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .icon-badge i' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'pori_pricing_table_featured_text_badge_background',
				'types'     => [ 'classic', 'gradient' ],
				'selector'  => '{{WRAPPER}} .text-badge',
				'condition' => [
					'pori_pricing_table_featured_type' => 'text-badge'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'pori_pricing_table_featured_icon_badge_background',
				'types'     => [ 'classic', 'gradient' ],
				'selector'  => '{{WRAPPER}} .icon-badge',
				'condition' => [
					'pori_pricing_table_featured_type' => 'icon-badge'
				]
			]
		);

		$this->end_controls_section();

		/**
		 * -------------------------------------------
		 * Tab Style (Button Style)
		 * -------------------------------------------
		 */
		$this->start_controls_section(
			'pori_section_pricing_table_btn_style_settings',
			[
				'label' => esc_html__( 'دکمه', 'Bina-ext' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'pori_pricing_table_btn_typography',
				'selector' => '{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-action'
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_button_border_radius',
			[
				'label'      => __( 'حاشیه لبه', 'Bina-ext' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'    => '4',
					'right'  => '4',
					'bottom' => '4',
					'left'   => '4'
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-action' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_button_padding',
			[
				'label'      => __( 'فضای داخلی', 'Bina-ext' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'      => '12',
					'right'    => '30',
					'bottom'   => '12',
					'left'     => '30',
					'isLinked' => false
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-action' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_pricing_table_button_margin',
			[
				'label'      => __( 'فضای خارجی', 'Bina-ext' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'      => '30',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'isLinked' => false
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-action' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->start_controls_tabs( 'pori_pricing_table_button_tabs' );

			// Normal State Tab
			$this->start_controls_tab( 'pori_pricing_table_btn_normal', [ 'label' => esc_html__( 'Normal', 'Bina-ext' ) ] );

			$this->add_control(
				'pori_pricing_table_btn_normal_text_color',
				[
					'label'     => esc_html__( 'رنگ متن', 'Bina-ext' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#ffffff',
					'selectors' => [
						'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-action' => 'color: {{VALUE}};'
					]
				]
			);

			$this->add_control(
				'pori_pricing_table_btn_normal_bg_color',
				[
					'label'     => esc_html__( 'رنگ زمینه', 'Bina-ext' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => $pori_secondary_color,
					'selectors' => [
						'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-action' => 'background-color: {{VALUE}};'
					]
				]
			);

			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'            => 'pori_pricing_table_btn_normal_border',
					'fields_options'  => [
						'border'      => [
							'default' => 'solid'
                    	],
	                    'width'       => [
	                        'default' => [
	                            'top'    => '1',
	                            'right'  => '1',
	                            'bottom' => '1',
	                            'left'   => '1'
	                        ]
	                    ],
	                    'color'       => [
	                        'default' => $pori_secondary_color
	                    ]
	                ],
					'selector'        => '{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-action'
				]
			);

			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'pori_pricing_table_btn_box_shadow',
					'selector' => '{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-action'
				]
			);

			$this->end_controls_tab();

			// Hover State Tab
			$this->start_controls_tab( 'pori_pricing_table_btn_hover', [ 'label' => esc_html__( 'Hover', 'Bina-ext' ) ] );

			$this->add_control(
				'pori_pricing_table_btn_hover_text_color',
				[
					'label'     => esc_html__( 'رنگ متن', 'Bina-ext' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => $pori_secondary_color,
					'selectors' => [
						'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-action:hover' => 'color: {{VALUE}};'
					]
				]
			);

			$this->add_control(
				'pori_pricing_table_btn_hover_bg_color',
				[
					'label'     => esc_html__( 'رنگ زمینه', 'Bina-ext' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#ffffff',
					'selectors' => [
						'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-action:hover' => 'background-color: {{VALUE}};'
					]
				]
			);

			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'            => 'pori_pricing_table_btn_hover_border',
					'fields_options'  => [
						'border'      => [
							'default' => 'solid'
                    	],
	                    'width'       => [
	                        'default' => [
	                            'top'    => '1',
	                            'right'  => '1',
	                            'bottom' => '1',
	                            'left'   => '1'
	                        ]
	                    ],
	                    'color'       => [
	                        'default' => $pori_secondary_color
	                    ]
	                ],
					'selector'        => '{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-action:hover'
				]
			);

			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'pori_pricing_table_btn_box_shadow_hover',
					'selector' => '{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-action:hover'
				]
			);

			$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		/**
		 * -------------------------------------------
		 * Tab Style (Note Style)
		 * -------------------------------------------
		 */
		$this->start_controls_section(
			'pori_section_pricing_table_note_style',
			[
				'label' => esc_html__( 'نکته', 'Bina-ext' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control(
			'pori_pricing_table_note_alignment',
			[
				'label'         => __( 'چینش', 'Bina-ext' ),
				'type'          => Controls_Manager::CHOOSE,
				'toggle'        => false,
				'default'		=> 'center',
				'options'       => [
					'left'      => [
						'title' => __( 'جپ', 'Bina-ext' ),
						'icon'  => 'eicon-text-align-left'
					],
					'center'    => [
						'title' => __( 'وسط', 'Bina-ext' ),
						'icon'  => 'eicon-text-align-center'
					],
					'right'     => [
						'title' => __( 'راست', 'Bina-ext' ),
						'icon'  => 'eicon-text-align-right'
					]
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-note' => 'text-align: {{VALUE}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_section_pricing_table_note_padding',
			[
				'label'      => __( 'فضای داخلی', 'Bina-ext' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'      => '10',
					'right'    => '10',
					'bottom'   => '10',
					'left'     => '10',
					'isLinked' => false
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-note' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_section_pricing_table_note_margin',
			[
				'label'      => __( 'فضای خارجی', 'Bina-ext' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'      => '',
					'right'    => '',
					'bottom'   => '',
					'left'     => '',
					'isLinked' => false
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-note' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'pori_section_pricing_table_note_background',
				'label' => __( 'زمینه', 'Bina-ext' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-note',
			]
		);

		$this->add_control(
			'pori_section_pricing_table_note_text_color',
			[
				'label'     => esc_html__( 'Text Color', 'Bina-ext' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-note' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'pori_section_pricing_table_note_text_typography',
				'label'    => __( 'فونت', 'Bina-ext' ),
				'selector' => '{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-note',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'pori_section_pricing_table_note_border',
				'selector' => '{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-note'
			]
		);

		$this->add_responsive_control(
			'pori_section_pricing_table_note_border_radius',
			[
				'label'      => __( 'حاشیه لبه', 'Bina-ext' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'isLinked' => false
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-pricing-table-wrapper .pori-pricing-table-note' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->end_controls_section();

	}

	private function pricing_table_currency( $currency ) {
		return $currency ? '<span '.$this->get_render_attribute_string( 'pori_pricing_table_price_cur' ).'>'.esc_html( $currency ).'</span>' : '';
	}

	protected function render() {
		$settings      = $this->get_settings_for_display();
		$title         = $settings['pori_pricing_table_title'];
		$sub_title     = $settings['pori_pricing_table_subtitle'];
		$price         = $settings['pori_pricing_table_price'];
		$separator     = $settings['pori_pricing_table_period_separator'];
		$price_by      = $settings['pori_pricing_table_price_by'];
		$featured_text = $settings['pori_pricing_table_featured_tag_text'];

		$this->add_render_attribute( 
			'pori_pricing_table_wrapper', 
			[ 
				'class' => [ 
					'pori-pricing-table-wrapper', 
					'pori-pricing-table', 
					esc_attr( $settings['pori_pricing_table_content_alignment'] ), 
					esc_attr( $settings['pori_pricing_table_transition_type'] )
				]
			]
		);
	
		$this->add_render_attribute( 'pori_pricing_table_featured_tag_text', 'class', 'pori-pricing-featured-tag-text' );
		$this->add_inline_editing_attributes( 'pori_pricing_table_featured_tag_text', 'basic' );

		$this->add_render_attribute( 'pori_pricing_table_promo_title', 'class', 'pori-pricing-table-promo-label' );
		$this->add_inline_editing_attributes( 'pori_pricing_table_promo_title', 'basic' );

		$this->add_render_attribute( 'pori_pricing_table_title', 'class', 'pori-pricing-table-title' );
		$this->add_inline_editing_attributes( 'pori_pricing_table_title', 'basic' );

		$this->add_render_attribute( 'pori_pricing_table_subtitle', 'class', 'pori-pricing-table-subtitle' );
		$this->add_inline_editing_attributes( 'pori_pricing_table_subtitle', 'intermediate' );

		$this->add_render_attribute( 'pori_pricing_table_box_value', 'class', [ 'pori-pricing-table-price', 'pori-discount-price-'.$settings['pori_pricing_table_discount_price'] ] );

		if( 'yes' === $settings['pori_pricing_table_price_box'] ){
			$this->add_render_attribute( 'pori_pricing_table_box_value', 'class', 'price-box' );
		}

		$this->add_render_attribute( 'pori_pricing_table_price_cur', 'class', 'pori-pricing-table-currency' );
		$this->add_inline_editing_attributes( 'pori_pricing_table_price_cur', 'basic' );

		$this->add_render_attribute( 'pori_pricing_table_period_separator', 'class', 'pori-pricing-table-currency-separator' );
		$this->add_inline_editing_attributes( 'pori_pricing_table_period_separator', 'none' );

		$this->add_render_attribute( 'pori_pricing_table_price_by', 'class', 'pori-pricing-table-price-by' );
		$this->add_inline_editing_attributes( 'pori_pricing_table_price_by', 'basic' );

		$this->add_render_attribute( 'pori_pricing_table_price', 'class', 'pori-pricing-table-price' );
		$this->add_inline_editing_attributes( 'pori_pricing_table_price', 'basic' );

		$this->add_render_attribute( 'pori_pricing_table_features', 'class', 'pori-pricing-table-features' );
		if( 'yes' === $settings['pori_pricing_table_list_border_bottom'] ){
			$this->add_render_attribute( 'pori_pricing_table_features', 'class', 'list-border-bottom' );
		}

        $this->add_render_attribute( 'pori_pricing_table_btn_link', 'class', 'pori-pricing-table-action' );
		if( $settings['pori_pricing_table_btn_link']['url'] ) {
            $this->add_render_attribute( 'pori_pricing_table_btn_link', 'href', esc_url( $settings['pori_pricing_table_btn_link']['url'] ) );
	        if( $settings['pori_pricing_table_btn_link']['is_external'] ) {
	            $this->add_render_attribute( 'pori_pricing_table_btn_link', 'target', '_blank' );
	        }
	        if( $settings['pori_pricing_table_btn_link']['nofollow'] ) {
	            $this->add_render_attribute( 'pori_pricing_table_btn_link', 'rel', 'nofollow' );
	        }
        }

        $this->add_inline_editing_attributes( 'pori_pricing_table_btn', 'none' );

		?>

		<div <?php echo $this->get_render_attribute_string( 'pori_pricing_table_wrapper' ); ?>>
			<?php if( 'promo_top' === $settings['pori_pricing_table_promo_position'] ) { 
				if( 'yes' === $settings['pori_pricing_table_promo_enable'] ) { ?>
					<span <?php echo $this->get_render_attribute_string( 'pori_pricing_table_promo_title' ); ?>><?php echo $settings['pori_pricing_table_promo_title']; ?></span>
				<?php } ?>
			<?php } ?>
			<div class="pori-pricing-table-badge-wrapper">

				<?php if ( 'yes' === $settings['pori_pricing_table_featured'] ) { ?>
					<span class="pori-pricing-table-badge <?php echo esc_attr( $settings['pori_pricing_table_featured_type'] ); ?>">
						<?php if( 'text-badge' === $settings['pori_pricing_table_featured_type'] && !empty( $featured_text ) ) { ?>
							<span <?php echo $this->get_render_attribute_string( 'pori_pricing_table_featured_tag_text' ); ?>>
								<?php echo esc_html( $featured_text ); ?>
							</span>
						<?php } ?>
						<?php if( 'icon-badge' === $settings['pori_pricing_table_featured_type'] ) { ?>
							<i class="demo-icon eicon-star"></i>
						<?php } ?>
					</span>
				<?php } ?>

				<div class="pori-pricing-table-header">
					<?php do_action( 'pori_pricing_table_header_wrapper_before' ); ?>

					<?php $title ? printf( '<h4 '.$this->get_render_attribute_string( 'pori_pricing_table_title' ).'>%s</h4>', wp_kses_post( $title ) ) : '';
					$sub_title ? printf( '<div '.$this->get_render_attribute_string( 'pori_pricing_table_subtitle' ).'>%s</div>', wp_kses_post( $sub_title ) ) : ''; ?>

					<div <?php echo $this->get_render_attribute_string( 'pori_pricing_table_box_value' ); ?>>
						<?php if( 'yes' === $settings['pori_pricing_table_discount_price'] ) { ?>
							<p class="pori-pricing-table-regular-price">				
								<span class="pori-pricing-table-regular-price-cur"><?php echo $settings['pori_pricing_table_regular_price_cur']; ?></span>
								<span class="pori-pricing-table-regular-price-text"><?php echo $settings['pori_pricing_table_regular_price']; ?></span>
							</p>
						<?php } ?>
						<p class="pori-pricing-table-new-price">							
							<?php if( 'pori-pricing-cur-left' === $settings['pori_pricing_table_price_cur_position'] ) : ?>
								<?php echo $this->pricing_table_currency( $settings['pori_pricing_table_price_cur'] ); ?>
							<?php endif; ?>

							<?php $price ? printf( '<span '.$this->get_render_attribute_string( 'pori_pricing_table_price' ).'>%s</span>', esc_html( $price ) ) : ''; ?>

							<?php if( 'pori-pricing-cur-right' === $settings['pori_pricing_table_price_cur_position'] ) : ?>
								<?php echo $this->pricing_table_currency( $settings['pori_pricing_table_price_cur'] ); ?>
							<?php endif; ?>

							<?php if( $separator || $price_by ) : ?>
								<span class="pori-price-period">
									<?php $separator ? printf( '<span '.$this->get_render_attribute_string( 'pori_pricing_table_period_separator' ).'>%s</span>', esc_html( $separator ) ) : ''; ?>
									<?php $price_by ? printf( '<span '.$this->get_render_attribute_string( 'pori_pricing_table_price_by' ).'>%s</span>', esc_html( $price_by ) ) : ''; ?>
								</span>
							<?php endif; ?>
						</p>
					</div>

					<?php if( !empty( $settings['pori_pricing_table_price_subtitle'] ) ){ ?>
						<span class="pori-pricing-table-price-subtitle"><?php echo $settings['pori_pricing_table_price_subtitle']; ?></span>
					<?php } ?>

					<?php if ( 'yes' === $settings['pori_pricing_table_price_box_separator'] ) : ?>
						<div class="pori-price-bottom-separator"></div>
					<?php endif; ?>

					<?php if( 'curved-header' === $settings['pori_pricing_table_header_type'] ) { ?>
						<div class="pori-pricing-table-header-curved">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 370 20">
								<path class="st0" d="M0 20h185C70 20 0 0 0 0v20zM185 20h185V0s-70 20-185 20z" />
							</svg>
						</div>
					<?php } ?>

					<?php do_action( 'pori_pricing_table_header_wrapper_after' ); ?>
				</div>
				
				 <?php if( 'middle' === $settings['pori_pricing_table_btn_position'] && !empty( $settings['pori_pricing_table_btn'] ) ) {
					$this->pricing_table_btn();
				}

				do_action( 'pori_pricing_table_content_wrapper_before' ); ?>

				<?php if ( is_array( $settings['pori_pricing_table_items'] ) ) : ?>
					<ul <?php echo $this->get_render_attribute_string( 'pori_pricing_table_features' ); ?>>
						<?php foreach( $settings['pori_pricing_table_items'] as $index => $item ) : ?> 

							<?php $each_pricing_item = 'link_' . $index;
							$icon_mod = 'yes' !== $item['pori_pricing_table_icon_mood'] ? 'pori-pricing-table-features-disable' : 'pori-pricing-table-features-enable';
							$this->add_render_attribute( $each_pricing_item, 'class', [
								esc_attr( $icon_mod ),
								'elementor-repeater-item-'.esc_attr( $item['_id'] )
							] );

							$pricing_item = $this->get_repeater_setting_key( 'pori_pricing_table_item', 'pori_pricing_table_items', $index );
							$this->add_render_attribute( $pricing_item, 'class', 'pori-pricing-item' );
							$this->add_inline_editing_attributes( $pricing_item, 'intermediate' );
							$price = $item['pori_pricing_table_item']; ?>

							<li <?php $this->get_render_attribute_string( $each_pricing_item ); ?>>
								<?php if ( !empty( $item['pori_pricing_table_list_icon']['value'] ) ) { ?>
									<span class="pori-pricing-li-icon">
										<?php Icons_Manager::render_icon( $item['pori_pricing_table_list_icon'] ); ?>
									</span>
								<?php } ?>
								<?php $price ? printf( '<span '.$this->get_render_attribute_string( $pricing_item ).'>%s</span>', esc_html( $price ) ) : ''; ?>
							</li>

						<?php endforeach; ?>
					</ul>
				<?php endif; ?>

				<?php do_action( 'pori_pricing_table_content_wrapper_after' ); ?>

				<?php if( 'bottom' === $settings['pori_pricing_table_btn_position'] && !empty( $settings['pori_pricing_table_btn'] ) ) { ?>
					<?php $this->pricing_table_btn(); ?>
				<?php } ?> 
				<?php if( !empty( $settings['pori_pricing_table_note_text'] ) ){ ?>
					<div class="pori-pricing-table-note"><?php echo $settings['pori_pricing_table_note_text']; ?></div>
				<?php } ?>
			</div>
			<?php if( 'promo_bottom' === $settings['pori_pricing_table_promo_position'] ) {
				if( 'yes' === $settings['pori_pricing_table_promo_enable'] ) { ?>
					<span <?php echo $this->get_render_attribute_string( 'pori_pricing_table_promo_title' ); ?>><?php echo $settings['pori_pricing_table_promo_title']; ?></span>
				<?php } ?>
			<?php } ?>
		</div>
		<?php
	}

	/**
     * Render pricing table widget output in the editor.
     *
     * Written as a Backbone JavaScript template and used to generate the live preview.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function content_template() {
    	?>
    	<#
			view.addRenderAttribute( 'pori_pricing_table_wrapper', {
				'class': [ 
					'pori-pricing-table-wrapper', 
					'pori-pricing-table', 
					settings.pori_pricing_table_content_alignment, 
					settings.pori_pricing_table_transition_type
				]
			} );
		
			view.addRenderAttribute( 'pori_pricing_table_featured_tag_text', 'class', 'pori-pricing-featured-tag-text' );
			view.addInlineEditingAttributes( 'pori_pricing_table_featured_tag_text', 'basic' );

			view.addRenderAttribute( 'pori_pricing_table_title', 'class', 'pori-pricing-table-title' );
			view.addInlineEditingAttributes( 'pori_pricing_table_title', 'basic' );

			view.addRenderAttribute( 'pori_pricing_table_subtitle', 'class', 'pori-pricing-table-subtitle' );
			view.addInlineEditingAttributes( 'pori_pricing_table_subtitle', 'intermediate' );

			view.addRenderAttribute( 'pori_pricing_table_box_value', {
				'class': [ 
					'pori-pricing-table-price', 
					'pori-pricing-table-'+settings.pori_pricing_table_discount_price, 
				]
			} );

			if( 'yes' === settings.pori_pricing_table_price_box ) {
				view.addRenderAttribute( 'pori_pricing_table_box_value', 'class', 'price-box' );
			}

			view.addRenderAttribute( 'pori_pricing_table_price_cur', 'class', 'pori-pricing-table-currency' );
			view.addInlineEditingAttributes( 'pori_pricing_table_price_cur', 'basic' );

			view.addRenderAttribute( 'pori_pricing_table_period_separator', 'class', 'pori-pricing-table-currency-separator' );
			view.addInlineEditingAttributes( 'pori_pricing_table_period_separator', 'none' );

			view.addRenderAttribute( 'pori_pricing_table_price_by', 'class', 'pori-pricing-table-price-by' );
			view.addInlineEditingAttributes( 'pori_pricing_table_price_by', 'basic' );

			view.addRenderAttribute( 'pori_pricing_table_price', 'class', 'pori-pricing-table-price' );
			view.addInlineEditingAttributes( 'pori_pricing_table_price', 'basic' );

			view.addRenderAttribute( 'pori_pricing_table_features', 'class', 'pori-pricing-table-features' );
			if( 'yes' === settings.pori_pricing_table_list_border_bottom ){
				view.addRenderAttribute( 'pori_pricing_table_features', 'class', 'list-border-bottom' );
			}

			view.addRenderAttribute( 'pori_pricing_table_btn_link', 'class', 'pori-pricing-table-action' );
	        view.addInlineEditingAttributes( 'pori_pricing_table_btn', 'none' );

	        var target = settings.pori_pricing_table_btn_link.is_external ? ' target="_blank"' : '';
            var nofollow = settings.pori_pricing_table_btn_link.nofollow ? ' rel="nofollow"' : '';
    	#>

    	<div {{{ view.getRenderAttributeString( 'pori_pricing_table_wrapper' ) }}}>
			<# if( 'promo_top' === settings.pori_pricing_table_promo_position ) { #>
				<# if( 'yes' === settings.pori_pricing_table_promo_enable ) { #>
					<span class="pori-pricing-table-promo-label">{{{ settings.pori_pricing_table_promo_title }}}</span>
				<# } #>
			<# } #>
    		<div class="pori-pricing-table-badge-wrapper">
				<# if ( 'yes' === settings.pori_pricing_table_featured ) { #>
					<span class="pori-pricing-table-badge {{{ settings.pori_pricing_table_featured_type }}}">
						<# if( 'text-badge' === settings.pori_pricing_table_featured_type && settings.pori_pricing_table_featured_tag_text ) { #>
							<span {{{ view.getRenderAttributeString( 'pori_pricing_table_featured_tag_text' ) }}}>
								{{{ settings.pori_pricing_table_featured_tag_text }}}
							</span>
						<# } #>
						<# if( 'icon-badge' === settings.pori_pricing_table_featured_type ) { #>
							<i class="demo-icon eicon-star"></i>
						<# } #>
					</span>
				<# } #>	

				<div class="pori-pricing-table-header">
					<# if ( settings.pori_pricing_table_title ) { #>
			    		<h4 {{{ view.getRenderAttributeString( 'pori_pricing_table_title' ) }}}>
			    			{{{ settings.pori_pricing_table_title }}}
			    		</h4>
			    	<# } #>

					<# if ( settings.pori_pricing_table_subtitle ) { #>
			    		<div {{{ view.getRenderAttributeString( 'pori_pricing_table_subtitle' ) }}}>
			    			{{{ settings.pori_pricing_table_subtitle }}}
			    		</div>
			    	<# } #>

			    	<div {{{ view.getRenderAttributeString( 'pori_pricing_table_box_value' ) }}}>
						<# if( 'yes' === settings.pori_pricing_table_discount_price ) { #>
							<p class="pori-pricing-table-regular-price">					
								<span class="pori-pricing-table-regular-price-cur">{{{ settings.pori_pricing_table_regular_price_cur }}}</span>
								<span class="pori-pricing-table-regular-price-text">{{{ settings.pori_pricing_table_regular_price }}}</span>
							</p>
						<# } #>
			    		<p class="pori-pricing-table-new-price">	
			    			<# if ( 'pori-pricing-cur-left' === settings.pori_pricing_table_price_cur_position && settings.pori_pricing_table_price_cur ) { #>
			    				<span {{{ view.getRenderAttributeString( 'pori_pricing_table_price_cur' ) }}}>
			    					{{{ settings.pori_pricing_table_price_cur }}}
			    				</span>
							<# } #>

							<# if ( settings.pori_pricing_table_price ) { #>
					    		<span {{{ view.getRenderAttributeString( 'pori_pricing_table_price' ) }}}>
					    			{{{ settings.pori_pricing_table_price }}}
					    		</span>
					    	<# } #>

					    	<# if ( 'pori-pricing-cur-right' === settings.pori_pricing_table_price_cur_position && settings.pori_pricing_table_price_cur ) { #>	
			    				<span {{{ view.getRenderAttributeString( 'pori_pricing_table_price_cur' ) }}}>
			    					{{{ settings.pori_pricing_table_price_cur }}}
			    				</span>
							<# } #>
							<# if ( settings.pori_pricing_table_period_separator || settings.pori_pricing_table_price_by ) { #>
								<span class="pori-price-period">
									<# if ( settings.pori_pricing_table_period_separator ) { #>
										<span {{{ view.getRenderAttributeString( 'pori_pricing_table_period_separator' ) }}}>
											{{{ settings.pori_pricing_table_period_separator }}}
										</span>
									<# } #>
									<# if ( settings.pori_pricing_table_price_by ) { #>
										<span {{{ view.getRenderAttributeString( 'pori_pricing_table_price_by' ) }}}>
											{{{ settings.pori_pricing_table_price_by }}}
										</span>
									<# } #>
								</span>
							<# } #>
						</p>	
					</div>

					<# if( settings.pori_pricing_table_price_subtitle ){ #>
						<span class="pori-pricing-table-price-subtitle">{{{ settings.pori_pricing_table_price_subtitle }}}</span>
					<# } #>

					<# if ( 'yes' === settings.pori_pricing_table_price_box_separator ) { #>
						<div class="pori-price-bottom-separator"></div>
					<# } #>
					<# if ( 'curved-header' === settings.pori_pricing_table_header_type ) { #>
						<div class="pori-pricing-table-header-curved">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 370 20">
								<path class="st0" d="M0 20h185C70 20 0 0 0 0v20zM185 20h185V0s-70 20-185 20z" />
							</svg>
						</div>
					<# } #>
				</div>

				<# if ( 'middle' === settings.pori_pricing_table_btn_position && settings.pori_pricing_table_btn ) { #>
					<a href="{{{ settings.pori_pricing_table_btn_link.url }}}" {{{ view.getRenderAttributeString( 'pori_pricing_table_btn_link' ) }}}{{{ target }}}{{{ nofollow }}}>
						<span {{{ view.getRenderAttributeString( 'pori_pricing_table_btn' ) }}}>
							{{{ settings.pori_pricing_table_btn }}}
						</span>
					</a>
				<# } #>

				<# if ( settings.pori_pricing_table_items.length ) { #>
					<ul {{{ view.getRenderAttributeString( 'pori_pricing_table_features' ) }}}>
						<# _.each( settings.pori_pricing_table_items, function( item, index ) {
						    var pricingItem = view.getRepeaterSettingKey( 'pori_pricing_table_item', 'pori_pricing_table_items', index );
						    view.addRenderAttribute( pricingItem, 'class', 'pori-pricing-item' );
						    view.addInlineEditingAttributes( pricingItem, 'intermediate' );

						    var eachPricingItem = 'link_' + index;
						    var iconMod = 'yes' !== item.pori_pricing_table_icon_mood ? 'pori-pricing-table-features-disable' : 'pori-pricing-table-features-enable';
						    view.addRenderAttribute( eachPricingItem, {
								'class': [ 
									iconMod,
									'elementor-repeater-item-' + item._id 
								]
							} );

							var iconHTML = elementor.helpers.renderIcon( view, item.pori_pricing_table_list_icon, { 'aria-hidden': true }, 'i' , 'object' );
						#>
	                   		<li {{{ view.getRenderAttributeString( eachPricingItem ) }}}>
	                   			<# if ( iconHTML.value ) { #>
	                                <span class="pori-pricing-li-icon">
	                                    {{{ iconHTML.value }}}
	                                </span>
	                            <# } #>
	     						<# if ( item.pori_pricing_table_item ) { #>
	                                <span {{{ view.getRenderAttributeString( pricingItem ) }}}>
	                                    {{{ item.pori_pricing_table_item }}}
	                                </span>
	                            <# } #>
							</li>
	                    <# } ); #>
					</ul>
				<# } #>

				<# if ( 'bottom' === settings.pori_pricing_table_btn_position && settings.pori_pricing_table_btn ) { #>
					<a href="{{{ settings.pori_pricing_table_btn_link.url }}}" {{{ view.getRenderAttributeString( 'pori_pricing_table_btn_link' ) }}}{{{ target }}}{{{ nofollow }}}>
						<span {{{ view.getRenderAttributeString( 'pori_pricing_table_btn' ) }}}>
							{{{ settings.pori_pricing_table_btn }}}
						</span>
					</a>
				<# } #>
				<div class="pori-pricing-table-note">{{{ settings.pori_pricing_table_note_text }}}</div>
    		
    		</div>
			<# if( 'promo_bottom' === settings.pori_pricing_table_promo_position ) { #>
				<# if( 'yes' === settings.pori_pricing_table_promo_enable ) { #>
					<span class="pori-pricing-table-promo-label">{{{ settings.pori_pricing_table_promo_title }}}</span>
				<# } #>
			<# } #>
    	</div>
    	<?php
    }

    private function pricing_table_btn() {
		?>
		<a <?php echo $this->get_render_attribute_string( 'pori_pricing_table_btn_link' ); ?>>
			<span <?php echo $this->get_render_attribute_string( 'pori_pricing_table_btn' ); ?>>
				<?php echo esc_html( $this->get_settings_for_display( 'pori_pricing_table_btn' ) ); ?>
			</span>
		</a>
		<?php
	}
}