<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor project Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_project_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve project widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'project';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve project widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'پروژه', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve project widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-parallax';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the project widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register project widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		

        // project Sub Title
		$this->add_control(
			'adad',
			[
				'label' => __( 'عدد', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'placeholder' => __( 'عدد', 'Bina-extension' ),
				'default'     => esc_html__( '85' ),
                'separator'=> 'before',
			]
        );
        
        // project Title
		$this->add_control(
			'project_title',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default'     => esc_html__( ' پروژه های تکمیل شده' ),
				'placeholder' => __( 'پروژه های تکمیل شده', 'Bina-extension' ),
			]
        );
// Teamp Image
$this->add_control(
	'Teamp_image',
	[
		'label' => __( 'انتخاب عکس', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::MEDIA,
		'label_block' => true,
		'separator'=> 'before',
		'default' => [
			'url' => Utils::get_placeholder_image_src()
		],
		'placeholder' => __( 'انتخاب عکس', 'Bina-extension' ),
	]
);
$this->add_control(
	'Teamp_image2',
	[
		'label' => __( '2 انتخاب عکس', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::MEDIA,
		'label_block' => true,
		'separator'=> 'before',
		'default' => [
			'url' => Utils::get_placeholder_image_src()
		],
		'placeholder' => __( 'انتخاب عکس', 'Bina-extension' ),
	]
);
$this->add_control(
	'Teamp_image3',
	[
		'label' => __( '3 انتخاب عکس', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::MEDIA,
		'label_block' => true,
		'separator'=> 'before',
		'default' => [
			'url' => Utils::get_placeholder_image_src()
		],
		'placeholder' => __( 'انتخاب عکس', 'Bina-extension' ),
	]
);
		
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		
        // Sub Title Options
		$this->add_control(
			'projecte_subtitle_heading',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'projecte_subtitl_color',
			[
				'label' => __( 'رنگ عدد', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .box-amat-content span' => 'color: {{VALUE}}',
				],
			]
        );
		// Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'projecte_subtitl_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .box-amat-content label',
			]
        );
        $this->add_control(
			'projecte_subtitl_colofr',
			[
				'label' => __( 'رنگ عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .box-amat-content label' => 'color: {{VALUE}}',
				],
			]
        );
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'projecte_subtitl_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .box-amat-content span label',
			]
        );
        
        // Title Separator Color
        $this->add_control(
			'title_separator_color',
			[
				'label' => __( 'رنگ زمینه محتوا', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} .box-amat' => 'background-color: {{VALUE}}',
				],
			]
        );
		
        
        $this->end_controls_section();
	}

	/**
	 * Render project widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $project_style = $settings['project_style'];
        $adad = $settings['adad'];
        $project_title = $settings['project_title'];
		$Teamp_image = $settings['Teamp_image']['url'];
		$Teamp_image2 = $settings['Teamp_image2']['url'];
		$Teamp_image3 = $settings['Teamp_image3']['url'];
		
    ?>
	
	
   <div class="col-lg-12">
    <div class="row">
        <div class="col-sm-6">
            <img class="img-fluid border-radius mb-4 mt-4" src="<?php echo $Teamp_image; ?>" alt="" />
            <img class="img-fluid border-radius mb-4 mb-sm-0" src="<?php echo $Teamp_image2; ?>" alt="" />
        </div>
        <div class="col-sm-6">
            <img class="img-fluid border-radius mb-4" src="<?php echo $Teamp_image3; ?>" alt="" />
            <div class="box-amat">
                <div class="box-amat-content">
                    <span><?php echo $adad; ?></span>
                    <label><?php echo $project_title; ?></label>
                </div>
            </div>
        </div>
    </div>
</div>


<?php
	}

}