<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
/**
 * Elementor service Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_service_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve service widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'service';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve service widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'خدمات', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve service widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-wrench';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the service widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register service widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		// service Title
		$this->add_control(
			'service_title',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default'     => esc_html__( 'قالب بینا', 'Bina-extension' ),
				
			]
        );
		$this->add_control( 'icon', [
			'label'       => esc_html__( 'آیکون', 'Bina-extension' ),
			'type'        => Controls_Manager::ICONS,
			
			'description' => esc_html__( 'انتخاب آیکون', 'Bina-extension' )
		] );
        // service Sub Title
		$this->add_control(
			'service_desc',
			[
				'label' => __( 'توضیحات', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'لورم ایپیسوم متن ساختگی', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
        $this->add_control(
			'readmore',
			[
				'label' => __( 'عنوان دکمه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default'     => esc_html__( 'بیشتر بخوانید', 'Bina-extension' ),
				
			]
        );
		$this->add_control(
			'readmore_url',
			[
				'label' => __( 'لینک', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
                'label_block' => true,
				//'default'     => esc_html__( 'https://porii.ir', 'Bina-extension' ),
			]
        );
        

		
		
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		// servicep Area Background Options
		$this->add_control(
			'servicep_area_back_heading',
			[
				'label' => __( ' زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		// servicep Area Background Color
        $this->add_control(
			'servicep_area_back',
			[
				'label' => __( 'رنگ زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .service_pori-grd' => 'background-color: {{VALUE}}',
				],
			]
        );

        // Sub Title Options
		$this->add_control(
			'servicep_subtitle_heading',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'servicep_subtitl_color',
			[
				'label' => __( 'رنگ عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} .service_pori-grd_title a' => 'color: {{VALUE}}',
				],
			]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'عنوان',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .service_pori-grd_title a',
			]
        );
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'توضیحات',
				'label' => __( 'فونت توضیحات', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .service_pori-grd_text p',
			]
        );
        
        

        // Title Color
        $this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => 'tomato',
				'selectors' => [
					'{{WRAPPER}} .service_pori-grd_text p' => 'color: {{VALUE}}',
				],
			]
        );
        
        

		// Title Separator Color
        $this->add_control(
			'title_separator_color',
			[
				'label' => __( 'رنگ زمینه آیکون شناور', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} .service_pori-grd:hover .service_pori-grd_icon:before' => 'background-color: {{VALUE}}',
				],
			]
        );
        
        

		

		
        $this->end_controls_section();
	}

	/**
	 * Render service widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $service_style = $settings['service_style'];
        $service_title = $settings['service_title'];
		$readmore = $settings['readmore'];
		$readmore_url = $settings['readmore_url']['url'];
		$service_title_hover = $settings['service_title_hover'];
		$service_desc = $settings['service_desc'];
		$service_desc_hover = $settings['service_desc_hover'];
		$icon = $settings['icon']['value'];
        

		
    ?>
	
	<div class="service_pori-grd wow flipInY animated" data-wow-delay="0ms" data-wow-duration="1500ms" style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: flipInY;">
    <div class="service_pori-grd_content">
        <div class="service_pori-grd_icon">
            <i class="<?php echo $icon; ?>"></i>
            
        </div>
        <div class="service_pori-grd_title pt-4">
            <h4><a href="#"><?php echo $service_title; ?></a></h4>
        </div>
        <div class="service_pori-grd_text pt-15">
            <p><?php echo $service_desc; ?></p>
        </div>
        <div class="service_pori-grd_button pt-3">
            <div class="button style-four">
                <a href="<?php echo $readmore_url; ?>"><?php echo $readmore; ?></a>
            </div>
        </div>
    </div>
</div>





<?php
	}

}