<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor service Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_service2_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve service widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'service2';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve service widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'خدمات-مدرن', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve service widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-device-wide';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the service widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register service widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		// service Title
		$this->add_control(
			'service_title',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default'     => esc_html__( 'قالب بینا', 'Bina-extension' ),
				
			]
        );
		$this->add_control( 'icon', [
			'label'       => esc_html__( 'آیکون', 'Bina-extension' ),
			'type'        => Controls_Manager::ICONS,
			
			'description' => esc_html__( 'انتخاب آیکون', 'Bina-extension' )
		] );
        // service Sub Title
		$this->add_control(
			'category',
			[
				'label' => __( 'دسته بندی', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default'     => esc_html__( 'سئو', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
        $this->add_control(
			'readmore',
			[
				'label' => __( 'عنوان دکمه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default'     => esc_html__( 'بیشتر بخوانید', 'Bina-extension' ),
				
			]
        );
		$this->add_control(
			'readmore_url',
			[
				'label' => __( 'لینک', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
                'label_block' => true,
				//'default'     => esc_html__( 'https://porii.ir', 'Bina-extension' ),
			]
        );
        

		
		
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		// servicep Area Background Options
		$this->add_control(
			'servicep_area_back_heading',
			[
				'label' => __( ' زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		// servicep Area Background Color
        $this->add_control(
			'servicep_area_back',
			[
				'label' => __( 'رنگ زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#2371ff',
				'selectors' => [
					'{{WRAPPER}} .pori-serv-item.active' => 'background-color: {{VALUE}}',
				],
			]
        );
		$this->add_control(
			'servicep_areas_back',
			[
				'label' => __( 'رنگ زمینه شناور', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#3b3663',
				'selectors' => [
					'{{WRAPPER}} .pori-serv-item:hover, .pori-serv-item.active' => 'background-color: {{VALUE}}',
				],
			]
        );
        // Sub Title Options
		$this->add_control(
			'servicep_subtitle_heading',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'servicep_subtitl_color',
			[
				'label' => __( 'رنگ عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .pori-serv-item.active .pori-serv-content > span' => 'color: {{VALUE}}',
				],
			]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'عنوان',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-serv-item.active .pori-serv-content > span',
			]
        );
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'عنوان دسته بندی',
				'label' => __( 'فونت ', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-serv-content > h5',
			]
        );
        
        

        // Title Color
        $this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .pori-serv-content > h5' => 'color: {{VALUE}}',
				],
			]
        );
        
		$this->add_control(
			'title_colocr',
			[
				'label' => __( 'رنگ آیکون', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#ffc500',
				'selectors' => [
					'{{WRAPPER}} .pori-serv-item.active .pori-serv-icon , .pori-serv-item.active .pori-serv-content > .read-more i' => 'color: {{VALUE}}',
				],
			]
        );
		$this->add_control(
			'title_colorx',
			[
				'label' => __( 'رنگ خط', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#ffc500',
				'selectors' => [
					'{{WRAPPER}} .pori-serv-item::before' => 'background-color: {{VALUE}}',
				],
			]
        );
        
// Sub Title Typography 
$this->add_group_control(
	\Elementor\Group_Control_Typography::get_type(),
	[
		'name' => 'عنوان بیشتر بخوانید',
		'label' => __( 'فونت ', 'Bina-extension' ),
		'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
		'selector' => '{{WRAPPER}} .pori-serv-content > .read-more',
	]
);



// Title Color
$this->add_control(
	'title_color',
	[
		'label' => __( 'رنگ', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'scheme' => [
			'type' => \Elementor\Core\Schemes\Color::get_type(),
			'value' => \Elementor\Core\Schemes\Color::COLOR_1,
		],
		'default' => '#fff',
		'selectors' => [
			'{{WRAPPER}} .pori-serv-content > .read-more' => 'color: {{VALUE}}',
		],
	]
);
		
        
        

		

		
        $this->end_controls_section();
	}

	/**
	 * Render service widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $service_style = $settings['service_style'];
        $service_title = $settings['service_title'];
		$readmore = $settings['readmore'];
		$readmore_url = $settings['readmore_url']['url'];
		$service_title_hover = $settings['service_title_hover'];
		$category = $settings['category'];
		
		$icon = $settings['icon']['value'];
        

		
    ?>
	
	<div class="pori-serv-item active">
		<div class="pori-serv-icon">
			<i class="<?php echo $icon; ?>"></i>
		</div>
		<div class="pori-serv-content">
			<span><?php echo $category; ?></span>
			<h5><a href="#"><?php echo $service_title; ?></a></h5>
			<a href="<?php echo $readmore_url; ?>" class="read-more"><?php echo $readmore; ?> <i class="fas fa-arrow-alt-circle-left pr-10"></i></a>
		</div>
	</div>







<?php
	}

}