<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor service Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_service5_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve service widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'service5';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve service widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'خدمات-سفارشی', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve service widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-lottie';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the service widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register service widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		// service Title
		$this->add_control(
			'service_title',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default'     => esc_html__( 'قالب بینا', 'Bina-extension' ),
				
			]
        );
		
        // service Sub Title
		$this->add_control(
			'decr',
			[
				'label' => __( 'توضیحات', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'لورم ایپیسوم متن ساختگی طراحان می باشد', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
		// Teamp Image
		$this->add_control(
			'Teamp_image',
			[
				'label' => __( 'انتخاب عکس', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
                'label_block' => true,
                'separator'=> 'before',
				'default' => [
                    'url' => Utils::get_placeholder_image_src()
                ],
				'placeholder' => __( 'انتخاب عکس', 'Bina-extension' ),
			]
        );
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		// servicep Area Background Options
		$this->add_control(
			'servicep_area_back_heading',
			[
				'label' => __( ' زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		// servicep Area Background Color
        $this->add_control(
			'servicep_area_back',
			[
				'label' => __( 'رنگ زمینه شناور', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .service-chalchala .hover-flip-content' => 'background-color: {{VALUE}}',
				],
			]
        );
		$this->add_control(
			'servicep_areas_back',
			[
				'label' => __( 'رنگ زمینه عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#ffc500',
				'selectors' => [
					'{{WRAPPER}} .service-title-riqo ' => 'background-color: {{VALUE}}',
				],
			]
        );
        // Sub Title Options
		$this->add_control(
			'servicep_subtitle_heading',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'servicep_subtitl_color',
			[
				'label' => __( 'رنگ عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .service-chalchala .hover-flip-content h2' => 'color: {{VALUE}}',
				],
			]
        );
		// Title Color
        $this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ توضیحات', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .service-chalchala .hover-flip-content p' => 'color: {{VALUE}}',
				],
			]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'فونت',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .service-chalchala .hover-flip-content h2 , .service-chalchala .hover-flip-content p',
			]
        );
        $this->end_controls_section();
	}

	/**
	 * Render service widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $service_style = $settings['service_style'];
        $service_title = $settings['service_title'];
		$readmore = $settings['readmore'];
		$readmore_url = $settings['readmore_url']['url'];
		$service_title_hover = $settings['service_title_hover'];
		$decr = $settings['decr'];
		$Teamp_image = $settings['Teamp_image']['url'];
		$icon = $settings['icon']['value'];
        

		
    ?>
<div class="service-chalchala bg-cover">
	<div class="img-bg-sr"><img src="<?php echo $Teamp_image;?>" /></div>
    <div class="hover-flip-content text-right">
        <div class="icon">
            <h1><?php echo $readmore;?></h1>
        </div>
        <h2><?php echo $service_title;?></h2>
        <p><?php echo $decr;?></p>
    </div>
</div>
<div class="service-title-riqo">
 <h4><?php echo $service_title;?></h4>
</div>

	
<?php
	}

}