<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor servicepez Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_servicepez_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve servicepez widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'servicepez';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve servicepez widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'خدمات پزشکی', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve servicepez widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-wrench';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the servicepez widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register servicepez widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		// servicepez Title
		$this->add_control(
			'servicepez_title',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default'     => esc_html__( 'قالب بینا', 'Bina-extension' ),
				
			]
        );
		// portfoliop Image
		$this->add_control(
			'servicepez_pic',
			[
				'label' => __( 'انتخاب عکس', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
                'label_block' => true,
                'separator'=> 'before',
				'default' => [
                    'url' => Utils::get_placeholder_image_src()
                ],
				'placeholder' => __( 'انتخاب عکس', 'Bina-extension' ),
			]
        );
		$this->add_control( 'icon', [
			'label'       => esc_html__( 'آیکون', 'Bina-extension' ),
			'type'        => Controls_Manager::ICONS,
			
			'description' => esc_html__( 'انتخاب آیکون', 'Bina-extension' )
		] );
        // servicepez Sub Title
		$this->add_control(
			'servicepez_desc',
			[
				'label' => __( 'توضیحات', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'لورم ایپیسوم متن ساختگی', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
        $this->add_control(
			'readmore',
			[
				'label' => __( 'عنوان دکمه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default'     => esc_html__( 'بیشتر بخوانید', 'Bina-extension' ),
				
			]
        );
		$this->add_control(
			'readmore_url',
			[
				'label' => __( 'لینک', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
                'label_block' => true,
				//'default'     => esc_html__( 'https://porii.ir', 'Bina-extension' ),
			]
        );
        

		
		
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		// servicepezp Area Background Options
		$this->add_control(
			'servicepezp_area_back_heading',
			[
				'label' => __( ' زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		

        // Sub Title Options
		$this->add_control(
			'servicepezp_subtitle_heading',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'servicepezp_subtitl_color',
			[
				'label' => __( 'رنگ عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .doki-service-title' => 'color: {{VALUE}}',
				],
			]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'عنوان',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .doki-service-title',
			]
        );
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'توضیحات',
				'label' => __( 'فونت توضیحات', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .doki-service-content p',
			]
        );
        
        

        // Title Color
        $this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .doki-service-content p' => 'color: {{VALUE}}',
				],
			]
        );
        
        // servicepezp Area Background Color
        $this->add_control(
			'servicepezp_area_back',
			[
				'label' => __( 'رنگ بیشتر بخوانید', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#00b761',
				'selectors' => [
					'{{WRAPPER}} .doki-service-btn-a' => 'color: {{VALUE}}',
				],
			]
        );

		// Title Separator Color
        $this->add_control(
			'title_separator_color',
			[
				'label' => __( 'رنگ زمینه آیکون ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#00b761',
				'selectors' => [
					'{{WRAPPER}} .doki-service-icon-wrapper' => 'background-color: {{VALUE}}',
				],
			]
        );
        
        

		

		
        $this->end_controls_section();
	}

	/**
	 * Render servicepez widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $servicepez_style = $settings['servicepez_style'];
        $servicepez_title = $settings['servicepez_title'];
		$readmore = $settings['readmore'];
		$readmore_url = $settings['readmore_url']['url'];
		$servicepez_pic = $settings['servicepez_pic']['url'];
		$servicepez_desc = $settings['servicepez_desc'];
		$servicepez_desc_hover = $settings['servicepez_desc_hover'];
		$icon = $settings['icon']['value'];
        

		
    ?>
	
<div class="creativesplanet-post-item">
		<div class="creativesplanet-box-content">
			<div class="creativesplanet-box-content-inner">
				<div class="doki-service-image-icon-wrapper">	
					<div class="doki-featured-wrapper"><img loading="lazy" src="<?php echo $servicepez_pic; ?>" class="attachment-doki-img-770x500 size-doki-img-770x500 wp-post-image" alt="" width="770" height="500"></div>	
					<div class="doki-service-icon-wrapper">	
					<i class="<?php echo $icon; ?>"></i></div>
				</div>
				<div class="doki-content-inner">		  
				<h3 class="doki-service-title"><?php echo $servicepez_title; ?></h3> 
		<div class="doki-service-content"><p><?php echo $servicepez_desc; ?></p>
</div>
					 
				</div>		
				<div class="doki-service-btn">
					<a class="doki-service-btn-a" href="<?php echo $readmore_url; ?>"><?php echo $readmore; ?><i class="fa fa-arrow-left"></i></a>
				</div>
			</div>
		</div>
	</div>

<?php
	}

}