<?php 
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
// Elementor Classes
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use \Elementor\Widget_Base;
use Elementor\Icons_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Gradient;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class pori_slider_bina extends Widget_Base {
	public function get_name() {
        return 'pori-slider';
    }
    public function get_title() {
        return esc_html__('اسلایدر', 'Bina-extension');
    }
    public function get_icon() {
        return 'eicon-slides';
    }

    public function get_categories() {
        return array('Bina-category');
    }
   
    protected function _register_controls() {
        /********************************************
                    CONTENT SECTION       
        ********************************************/
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('محتوا', 'Element Booster'),
            ]
        );
       

        $repeater = new Repeater();
        $repeater->add_control(
            'itm_heading',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('عنوان', 'Bina-extension'),
                'label_block' => true,
                'default'     => esc_html__( 'قالب بینا', 'Bina-extension' ),
                            
            ]
        ); 
        $repeater->add_control(
            'itm_subheading',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('زیر عنوان', 'Bina-extension'),
                'label_block' => true,
                'default'     => esc_html__( 'فناوری', 'Bina-extension' ),               
            ]
        ); 
        $repeater->add_control(
            'itm_description',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label' => esc_html__('توضیحات', 'Bina-extension'),
                'label_block' => true,
                'default'     => esc_html__( 'لورم ایپیسوم متن ساختگی طراحان می باشد که در قالب بینا استفاده می شود', 'Bina-extension' ),              
            ]
        ); 
        
        $repeater->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'itm_background_img',
                'label' => esc_html__( 'عکس زمینه', 'Bina-extension' ),
                'dynamic' => ['active' => true],
                'types' => [ 'classic'],
                'default' => ['url' => Utils::get_placeholder_image_src()],
                'fields_options' => ['background' => ['default' => 'classic'],'image' =>['default' =>['url' => '']], 'position' => ['default' =>'center center'],'size' =>['default' =>'cover'], 'color' => ['default' => Controls_Manager::HIDDEN]],
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}',
            ]
        );
        $repeater->add_control(
            'itm_ovl_clr',
            [
                'label' => esc_html__('رنگ روکش زمینه', 'Bina-extension'),
                'type' => Controls_Manager::COLOR,
                'separator' => 'before',
                'default' => 'transparent',
                'selectors' => ['{{WRAPPER}} {{CURRENT_ITEM}}:before' => 'background: {{VALUE}};'],                             
            ]
        );
        $repeater->add_control(
            'itm_thumbnail',
            [
                'label' => esc_html__('عکس نمونه', 'Bina-extension'),
                'type' => Controls_Manager::MEDIA,
                'separator' => 'before',
                'default' => ['url' => Utils::get_placeholder_image_src()],
            ]
        );

        $this->add_control(
            'itm_list',
            [
                'label' => esc_html__('لیست محتوا', 'Bina-extension'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [],
                #'condition' => ['content_source' => ['manual']],                 
                'title_field' => '{{{ itm_heading }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'global_section',
            [
                'label' => esc_html__('تنظیمات عمومی', 'Element Booster'),        
            ]
        );

        $this->add_control(
            'nav_layout',
            [
                'label' => esc_html__('چینش نماینگر', 'Bina-extension'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => [
                    'none'    =>  esc_html__('هیچ','Bina-extension'), 
                    'side'    =>  esc_html__('بغل','Bina-extension'), 
                    'bottom'  =>  esc_html__('پایین','Bina-extension'), 
                ],
                'default' => 'Bottom',
            ]
        );
        $this->add_control(
            'nav_style',
            [
                'label' => esc_html__('استایل نماینگر', 'Bina-extension'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => [
                    'style_1'    =>  esc_html__('1','Bina-extension'), 
                    'style_2'    =>  esc_html__('2','Bina-extension'), 
                ],
                'condition' => ['nav_layout!' => ['none']], 
                'default' => 'style_1',
            ]
        );
        $this->add_control(
            'autoplay_enabled',
            [
                'label' => esc_html__( 'پخش خودکار', 'Bina-extension' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true
            ]
        );
        $this->add_control(
            'autoplay_speed',
            [
                'label' => esc_html__('سرعت پخش', 'Bina-extension'),
                'type' => Controls_Manager::NUMBER,
                'min' => '1', 
                'dynamic' => ['active' => true],
                'condition' => ['autoplay_enabled' => ['yes']],
                'default' => '4'
            ]
        );
        $this->end_controls_section();
        /********************************************
                    STYLE SECTION       
        ********************************************/
        /*FONT*/
        $this->start_controls_section(
            'font_section',
            [
                'label' => esc_html__('تنظیمات فونت', 'Element Booster'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'heading_font',
                'label' => esc_html__('فونت عنوان', 'Bina-extension'),
                'fields_options' => [
                    'font_size' => ['default' =>['size' => 46,'unit' => 'px']],
                    'line_height' => ['default' =>['size' => 1.2,'unit' => 'em']],
                    'font_weight' => ['default' => '600'],
                    'typography' => ['default' => 'custom'],
                ],
                'selector' => '{{WRAPPER}} .pori-slide-headings h3',
            ]
        ); 
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subheading_font',
                'label' => esc_html__('فونت زیر عنوان', 'Bina-extension'),
                'fields_options' => [
                    'font_size' => ['default' =>['size' => 18,'unit' => 'px']],
                    'font_weight' => ['default' => '600'],
                    'typography' => ['default' => 'custom'],
                ],
                'selector' => '{{WRAPPER}} .pori-slide-sbhds',
            ]
        );  
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_font',
                'label' => esc_html__('فونت توضیحات', 'Bina-extension'),
                'fields_options' => [
                    'font_size' => ['default' =>['size' => 15,'unit' => 'px']],
                    'line_height' => ['default' =>['size' => 1.7,'unit' => 'em']],
                    'typography' => ['default' => 'custom'],
                ],
                'selector' => '{{WRAPPER}} .pori-slide-txts',
            ]
        ); 
        
        $this->end_controls_section();

        /*FONT COLOR*/
        $this->start_controls_section(
            'font_color_section',
            [
                'label' => esc_html__('رنگ', 'Element Booster'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
            'subheading_color',
            [
                'label' => esc_html__('زیر عنوان', 'Bina-extension'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => ['{{WRAPPER}} .pori-sliders-itm-subh' => 'color: {{VALUE}};'],
            ]
        );
        $this->add_control(
            'description_color',
            [
                'label' => esc_html__('توضیحات', 'Bina-extension'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => ['{{WRAPPER}} .pori-sliders-itm-txt' => 'color: {{VALUE}};'],
            ]
        );
        $this->add_control(
            'link_color',
            [
                'label' => esc_html__('عنوان', 'Bina-extension'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => ['{{WRAPPER}} .pori-sliders-itm-heading' => 'color: {{VALUE}};'],
            ]
        );
        $this->end_controls_section();

        /*NAVIGATION*/
        $this->start_controls_section(
            'styling_section_colors',
            [
                'label' => esc_html__('رنگ هدایت گر ها', 'Element Booster'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );        
        $this->add_control(
            'nav_color',
            [
                'label' => esc_html__('نماینگر', 'Bina-extension'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffc500',
                'selectors' => ['{{WRAPPER}} .pori-slide-nav' => 'color: {{VALUE}};'],
            ]
        );    
               
        $this->add_control(
            'navarrow_bg',
            [
                'label' => esc_html__('رنگ زمینه فلش', 'Bina-extension'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffc500',
                'selectors' => ['{{WRAPPER}} .pori-slide-btn' => 'background: {{VALUE}};'],
            ]
        ); 
        $this->add_control(
            'navarrow_color',
            [
                'label' => esc_html__('رنگ فلش', 'Bina-extension'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => ['{{WRAPPER}} .pori-slide-btn' => 'color: {{VALUE}};'],
            ]
        ); 
        $this->end_controls_section();

        /*Distances*/
        $this->start_controls_section(
            'content_distances_styling',
            [
                'label' => esc_html__('موقعیت محتوا', 'Bina-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'content_width',
            [
                'type' => Controls_Manager::NUMBER,
                'label' => esc_html__('عرض محتوا (%)', 'Bina-extension'),
                'label_block' => true,
                'min' => 10,'max' => 100,
                'default' => 100,
                'selectors' => [
                    '{{WRAPPER}} .pori-sliders-itm-ins' => 'width: {{VALUE}}%;',
                ],
            ]
        );
        $this->add_control(
            'content_paddings',
            [
                'label' => esc_html__( 'فاصله داخلی محتوا (%)', 'Bina-extension' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['%'],
                'dynamic' => ['active' => true],
                'default' => ['left' => '2','top' => '0','right' => '2','bottom' => '0','isLinked' => false],
                'selectors' => [
                    '{{WRAPPER}} .pori-sliders-itm-ins' => 'padding: {{TOP}}% {{RIGHT}}% {{BOTTOM}}% {{LEFT}}%;',
                ],
            ]
        );


        $this->add_control(
            'heading_margin',
            [
                'label' => esc_html__( 'فاصله خارجی عنوان', 'Bina-extension' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px'],
                'dynamic' => ['active' => true],
                'separator' => 'after',
                'default' => ['left' => '0','top' => '0','right' => '0','bottom' => '0','isLinked' => false],
                'selectors' => [
                    '{{WRAPPER}} .pori-slide-headings' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'subheading_margin',
            [
                'label' => esc_html__( 'فاصله خارجی زیر عنوان', 'Bina-extension' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px'],
                'dynamic' => ['active' => true],
                'default' => ['left' => '0','top' => '0','right' => '0','bottom' => '0','isLinked' => false],
                'selectors' => [
                    '{{WRAPPER}} .pori-slide-sbhds' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        ); 
        $this->add_control(
            'description_margin',
            [
                'label' => esc_html__( 'فاصله خارجی توضیحات', 'Bina-extension' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px'],
                'dynamic' => ['active' => true],
                'default' => ['left' => '0','top' => '20','right' => '0','bottom' => '0','isLinked' => false],
                'selectors' => [
                    '{{WRAPPER}} .pori-slide-txts' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        ); 
        $this->add_control(
            'link_margin',
            [
                'label' => esc_html__( 'فاصله خارجی لینک', 'Bina-extension' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px'],
                'dynamic' => ['active' => true],
                'default' => ['left' => '0','top' => '20','right' => '0','bottom' => '0','isLinked' => false],
                'selectors' => [
                    '{{WRAPPER}} .pori-sliders-itm-more' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );     
     
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $output = $navigations = $backgrounds = $headings = $subheadings = $descriptions = $links = $thumbnails = '';
            
        if($settings['itm_list']):
            foreach($settings['itm_list'] as $key => $sitem):
                $key = $key + 1;              
                $item_attr = ($key == 1) ?  ' data-situation="active" ' : ' data-situation="inactive" ';
                $thumb_attr = ($key == 1) ?  ' data-hidden="false" ' : ' data-hidden="true" ';
                $item_attr .= ' data-index="'.$key.'" ';
                
                $navigations .= '<div class="pori-slide-nav-btn pori-slide-itm" '.$item_attr.' onclick="pori_bina_trigger(this,\'none\')"></div>';
                $backgrounds .= '<div class="pori-slide-im-itm pori-tr-8 pori-slide-itm elementor-repeater-item-'.$sitem['_id'].'" '.$item_attr.'></div>';
                $headings .= '<h3 class="pori-sliders-itm-heading pori-fs pori-slide-itm-txtanm pori-slide-itm pori-tr-3" '.$item_attr.'>'.$sitem['itm_heading'].'</h3>';
                $subheadings .= '<div class="pori-sliders-itm-subh pori-slide-itm-txtanm pori-fs pori-slide-itm pori-tr-3" '.$item_attr.'>'.$sitem['itm_subheading'].'</div>';
                $descriptions .= '<div class="pori-sliders-itm-txt pori-fs pori-slide-itm-txtanm pori-slide-itm pori-tr-3" '.$item_attr.'>'.$sitem['itm_description'].'</div>';
                $thumbnails .= '<div class="pori-sliders-itm-img pori-slide-itm pori-tr-3" '.$item_attr.' '.$thumb_attr.' style="background-image: url('.$sitem['itm_thumbnail']['url'].')"></div>';
            endforeach;
        endif;
        
        $play_attr = ($settings['autoplay_enabled'] == 'yes') ? ' data-play="'.esc_attr($settings['autoplay_speed']).'" data-loading="done" ' : '';

        $output .= '<div class="pori-slider" data-nav-pos="'.esc_attr($settings['nav_layout']).'" data-current="1" data-length="'.sizeof($settings['itm_list']).'" '.$play_attr.'>';
            $output .= ($settings['autoplay_enabled'] == 'yes') ? '<div class="pori-slide-load-ctn"><div class="pori-slide-load-bar" style="-webkit-animation-duration:'.$settings['autoplay_speed'].'s; animation-duration:'.$settings['autoplay_speed'].'s;"></div></div>' : '';
            $output .= '<div class="pori-slide-nav" data-nav-style="'.esc_attr($settings['nav_style']).'">';
               $output .= $navigations;
            $output .= '</div>';

            $output .= '<div class="pori-slide-images">';
               $output .= $backgrounds;            
            $output .= '</div>';

            $output .= '<div class="pori-slide-content">';            
                $output .= '<div class="pori-sliders-itm">';
                    $output .= '<div class="pori-sliders-itm-ins">';
                        $output .= '<div class="pori-slide-headings pori-slide-txtanm-ctn pori-fs">';                        
                            $output .= $headings;            
                        $output .= '</div>';
                       $output .= '<div class="pori-sliders-itm-info pori-fs">';
                            $output .= '<div class="pori-sliders-itm-left">';
                                $output .= '<div class="pori-slide-thumbs">';
                                    $output .= $thumbnails;            
                                $output .= '</div>';
                                $output .= '<div class="pori-sliders-itm-nav-btns pori-fs">';
                                    $output .= '<div class="pori-slide-btn pori-slide-btn-prv pori-tr-2" onclick="pori_bina_trigger(this,\'previous\')"></div>';
                                    $output .= '<div class="pori-slide-btn pori-slide-btn-nxt pori-tr-2" onclick="pori_bina_trigger(this,\'next\')"></div>';
                                $output .= '</div>';
                            $output .= '</div>';
                            $output .= '<div class="pori-sliders-itm-content">';
                                $output .= '<div class="pori-slide-sbhds pori-slide-txtanm-ctn pori-fs">';
                                    $output .= $subheadings;                                    
                                $output .= '</div>';
                                $output .= '<div class="pori-slide-txts pori-slide-txtanm-ctn pori-fs">';
                                    $output .= $descriptions;                                    
                                $output .= '</div>';
                                $output .= '<div class="pori-sliders-itm-more pori-fs">';
                                    $output .= '<div class="pori-sliders-link">';
                                        $output .= $links;                                    
                                    $output .= '</div>';
                                $output .= '</div>';
                            $output .= '</div>';
                    $output .= '</div>';
                $output .= '</div>';
            $output .= '</div>';
        $output .= '</div>';


        echo apply_filters('pori_fullscreencontentslider_output', $output, $settings);
    }

}