<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use Elementor\Icons_Manager;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography ;
/**
 * Elementor Team Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_Price3_bina extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Team widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'Teamf';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Team widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'تیم اصلی', 'Bina-ext' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Team widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-user-circle-o';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Team widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register Team widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-ext' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);



        // Team Sub Title
		$this->add_control(
			'Team_desc',
			[
				'label' => __( 'تخصص - توضیحات', 'Bina-ext' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'مدیریت تیم', 'Bina-ext' ),
				'placeholder' => __( 'توضیحات', 'Bina-ext' ),
                'separator'=> 'before',
			]
        );
        
        // Team Title
		$this->add_control(
			'Team_title',
			[
				'label' => __( 'نام', 'Bina-ext' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
				'default'     => esc_html__( 'پوریا زمانی', 'Bina-ext' ),
				'placeholder' => __( 'نام', 'Bina-ext' ),
			]
        );

		

		// axs Box Icon
		$this->add_control( 'icon', [
			'label'       => esc_html__( 'آیکون', 'Bina-ext' ),
			'type'        => Controls_Manager::ICONS,
			
			'description' => esc_html__( 'انتخاب آیکون', 'Bina-ext' )
		] );
		

		// axs Image
		$this->add_control(
			'axs_image',
			[
				'label' => __( 'انتخاب عکس', 'Bina-ext' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'separator'=> 'before',
				'default' => [
                    'url' => Utils::get_placeholder_image_src()
                ],
				'placeholder' => __( 'انتخاب عکس', 'Bina-ext' ),
			]
        );
		
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-ext' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

		// axs Area Background Options
		$this->add_control(
			'axs_area_back_heading',
			[
				'label' => __( 'رنگ زمینه', 'Bina-ext' ),
				'type' => Controls_Manager::HEADING,
			]
		);

		// axs Area Background Color
        $this->add_control(
			'axs_area_back',
			[
				'label' => __( 'رنگ زمینه ', 'Bina-ext' ),
				'type' => Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\color::get_type(),
					'value' => \Elementor\Core\Schemes\color::COLOR_1,
                ],
                'default' => '#f5f5f5',
				'selectors' => [
					'{{WRAPPER}} .pori-hover-container .pori-hover-info-back' => 'background-color: {{VALUE}}',
				],
			]
        );

        // Sub Title Options
		$this->add_control(
			'axs_subtitle_heading',
			[
				'label' => __( 'تخصص', 'Bina-ext' ),
				'type' => Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'axs_subtitl_color',
			[
				'label' => __( 'رنگ', 'Bina-ext' ),
				'type' => Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\color::get_type(),
					'value' => \Elementor\Core\Schemes\color::COLOR_1,
                ],
                'default' => '#777',
				'selectors' => [
					'{{WRAPPER}} .pori-hover-description' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Sub Title Typography 
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'axs_subtitl_typography',
				'label' => __( 'فونت', 'Bina-ext' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-hover-description',
			]
        );
        
        // Title Options
		$this->add_control(
			'title_heading',
			[
				'label' => __( 'عنوان', 'Bina-ext' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Title Color
        $this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ نام', 'Bina-ext' ),
				'type' => Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\color::get_type(),
					'value' => \Elementor\Core\Schemes\color::COLOR_1,
                ],
                'default' => 'tomato',
				'selectors' => [
					'{{WRAPPER}} .pori-hover-title' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Title Typography 
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'فونت', 'Bina-ext' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-hover-title',
			]
        );

		
        
        // Team Options
		$this->add_control(
			'Team_heading',
			[
				'label' => __( 'تیم', 'Bina-ext' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // axs Icon Color
        $this->add_control(
			'axs_icon_color',
			[
				'label' => __( 'رنگ آیکون', 'Bina-ext' ),
				'type' => Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\color::get_type(),
					'value' => \Elementor\Core\Schemes\color::COLOR_1,
                ],
                'default' => '#333',
				'selectors' => [
					'{{WRAPPER}} .pori-hover-info-wrap .pori-hover-title-wrap' => 'color: {{VALUE}}',
				],
			]
        );

		// axs Icon Size
		$this->add_control(
			'axs_icon_size',
			[
				'label' => __( 'سایز', 'plugin-domain' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => 'px',
				'range' => [
					'px' => [
						'min' => 20,
						'max' => 100,
						'step' => 5,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 26,
				],
				'selectors' => [
					'{{WRAPPER}} .pori-hover-info-wrap .pori-hover-title-wrap' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);    
        // Team Title Typography 
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'axs_title_typography',
				'label' => __( 'فونت', 'Bina-ext' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .axs-box h5',
			]
        );



        $this->end_controls_section();
	}

	/**
	 * Render Team widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $Team_style = $settings['Team_style'];
        $Team_title = $settings['Team_title'];
		$Team_desc = $settings['Team_desc'];
		$icon = $settings['icon']['value'];
        $axs_image = $settings['axs_image']['url'];

		
    ?>
	
    <div class="pori-hover-container">
    <div class="pori-hover-list">
        <div class="pori-hover-item-wrap">
            <div class="pori-hover-item style14">
                <div class="pori-hover-img-wrap">
                    <!-- <div class="pori-hover-img-inner-wrap"></div> -->
                    <img class="pori-hover-img" src="<?php echo $axs_image; ?>"  />
                </div>
                <div class="pori-hover-info-wrap">
                    <div class="pori-hover-info-back">
                        <div class="pori-hover-content">
                            <div class="pori-hover-content-wrap">
                                <div class="pori-hover-title-wrap">
                                    <li class=" <?php echo $icon; ?>" ></li>

                                    <h4 class="pori-hover-title">
                                        <?php echo $Team_title; ?>
                                    </h4>
                                </div>

                                <div class="pori-hover-description">
                                    <p><?php echo $Team_desc; ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
	}

}