<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
use \Elementor\Icons_Manager;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
/**
 * Elementor Team Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_Team4_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Team widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'Team4';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Team widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'اعضا تیم', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Team widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-user-circle-o';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Team widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register Team widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		
// Team Title
$this->add_control(
	'Team_title',
	[
		'label' => __( 'نام', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::TEXT,
		'label_block' => true,
		'default'     => esc_html__( 'پوریا زمانی', 'Bina-extension' ),
		'placeholder' => __( 'مثل : پوریا زمانی', 'Bina-extension' ),
	]
);
        // Team Sub Title
		$this->add_control(
			'Team_takhasos',
			[
				'label' => __( 'عنوان شغلی', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default'     => esc_html__( 'مدیر تیم', 'Bina-extension' ),
				'placeholder' => __( 'سئو', 'Bina-extension' ),
                'separator'=> 'before',
			]
        );
        
        // Teamp Image
		$this->add_control(
			'Teamp_image',
			[
				'label' => __( 'انتخاب عکس', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
                'label_block' => true,
                'separator'=> 'before',
				'default' => [
                    'url' => Utils::get_placeholder_image_src()
                ],
				'placeholder' => __( 'انتخاب عکس', 'Bina-extension' ),
			]
        );
		$this->add_control(
			'show_social_icon',
			[
				'label' => __( 'نمایش آیکون شبکه اجتماعی', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'Bina-extension' ),
				'label_off' => __( 'Hide', 'Bina-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'team_title', [
				'label' => __( 'نام شبکه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'نام شبکه اجتماعی' , 'Bina-extension' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'team_icon',
			[
				'label' => __( 'آیکون', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-telegram',
					'library' => 'solid',
				],
			]
		);
        
        // Team Icon Link
		$repeater->add_control(
			'team_icon_link',
			[
				'label' => __( 'لینک شبکه اجتماعی', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'نمایش لینک', 'Bina-extension' ),
			]
        );

		$this->add_control(
			'team_social_list',
			[
				'label' => __( 'شبکه اجتماعی', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ team_title }}}',
				'condition' => [
					'show_social_icon' => 'yes'
				]
			]
		);
		$this->add_control(
			'show_social_icon2',
			[
				'label' => __( 'نمایش آیکون شبکه اجتماعی راست', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'Bina-extension' ),
				'label_off' => __( 'Hide', 'Bina-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'team_title2', [
				'label' => __( 'نام شبکه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'نام شبکه اجتماعی' , 'Bina-extension' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'team_icon2',
			[
				'label' => __( 'آیکون', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-telegram',
					'library' => 'solid',
				],
			]
		);
        
        // Team Icon Link
		$repeater->add_control(
			'team_icon_link2',
			[
				'label' => __( 'لینک شبکه اجتماعی', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'نمایش لینک', 'Bina-extension' ),
			]
        );

		$this->add_control(
			'team_social_list2',
			[
				'label' => __( 'شبکه اجتماعی راست', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ team_title2 }}}',
				'condition' => [
					'show_social_icon2' => 'yes'
				]
			]
		);
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		// Teamp Area Background Options
		$this->add_control(
			'Teamp_area_back_heading',
			[
				'label' => __( 'رنگ زمینه', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		// Teamp Area Background Color
        $this->add_control(
			'Teamp_area_backh',
			[
				'label' => __( 'رنگ زمینه تخصص', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#ffc500',
				'selectors' => [
					'{{WRAPPER}} .pori-user-team .member-details span' => 'background-color: {{VALUE}}',
				],
			]
        );
// Teamp Area Background Color
$this->add_control(
	'Teamp_area_back',
	[
		'label' => __( 'رنگ عنوان نام', 'Bina-extension' ),
		'type' => \Elementor\Controls_Manager::COLOR,
		'scheme' => [
			'type' => \Elementor\Core\Schemes\Color::get_type(),
			'value' => \Elementor\Core\Schemes\Color::COLOR_1,
		],
		'default' => '#fff',
		'selectors' => [
			'{{WRAPPER}} .pori-user-team .member-details h3' => 'background-color: {{VALUE}}',
		],
	]
);
        // Sub Title Options
		$this->add_control(
			'Teamp_subtitle_heading',
			[
				'label' => __( 'رنگ  و فونت متن', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'Teamp_subtitl_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .pori-user-team .member-details h3' => 'color: {{VALUE}}',
				],
			]
        );
        // Sub Title Color
        $this->add_control(
			'Teamp_subtitll_color',
			[
				'label' => __( 'رنگ تخصص', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .pori-user-team .member-details span' => 'color: {{VALUE}}',
				],
			]
        );
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Teamp_subtitl_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-user-team .member-details span , .pori-user-team .member-details h3',
			]
        );
        $this->end_controls_section();
	}

	/**
	 * Render Team widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $Team_style = $settings['Team_style'];
        $Team_title = $settings['Team_title'];
		$Team_takhasos = $settings['Team_takhasos'];
		$show_social_icon = $settings['show_social_icon'];
		$show_social_icon2 = $settings['show_social_icon2'];
        $Teamp_image = $settings['Teamp_image']['url'];

		
    ?>


<div class="pori-user-team">
    <div class="member-img">
        <img src="<?php echo $Teamp_image; ?>" alt="member" />
    </div>
    <div class="member-details">
        <span><?php echo $Team_takhasos; ?></span>
        <h3><?php echo $Team_title; ?></h3>
    </div>
	
    <div class="social-icons">
	
        <div class="plus-icon"><i class="fal fa-plus"></i></div>
		<?php if ($show_social_icon === 'yes') { ?>
        <div class="top">
		<?php if ($settings['team_social_list']) {
          foreach ($settings['team_social_list'] as $item) { ?>
            <a href="<?php echo $item['team_icon_link']['url']; ?>"><i class="<?php echo $item['team_icon']['value']; ?>"></i></a>
			<?php } }?>
        </div>
		<?php } ?>
		<?php if ($show_social_icon2 === 'yes') { ?>
		
        <div class="right">
		<?php if ($settings['team_social_list2']) {
          foreach ($settings['team_social_list2'] as $item) { ?>
		<a href="<?php echo $item['team_icon_link2']['url']; ?>"><i class="<?php echo $item['team_icon2']['value']; ?>"></i></a>
		<?php } }?>
        </div>
		<?php } ?>
    </div>
	
</div>
<?php
	}
}