<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Background;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Css_Filter;
use \Elementor\Icons_Manager;
use \Elementor\Utils;
use \Elementor\Widget_Base;


class pori_testi_bina extends Widget_Base { 

    public function get_name() {
		return 'pori-testimonial';
	}

	public function get_title() {
		return esc_html__( 'نظرات', 'pori-addons-elementor' );
	}

	public function get_icon() {
		return 'eicon-testimonial';
	}

	public function get_categories() {
		return [ 'Bina-category' ];
	}

	
		
	protected function register_controls() {

		/**
		 * Testimonial Content Section
		 */

		$this->start_controls_section(
			'pori_testimonial_section',
			[
				'label' => esc_html__( 'محتوا', 'pori-addons-elementor' )
			]
		);

		$this->add_control(
			'pori_testimonial_image',
			[
				'label'   => __( 'عکس', 'pori-addons-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src()
				]
			]
		);
		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name'      => 'testimonial_thumbnail',
				'default'   => 'medium_large',
				'condition' => [
					'pori_testimonial_image[url]!' => ''
				],
			]
		);

		$this->add_control(
			'pori_testimonial_description',
			[
				'label'   => esc_html__( 'نظرات', 'pori-addons-elementor' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.', 'pori-addons-elementor' ),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'pori_testimonial_name',
			[
				'label'   => esc_html__( 'نام', 'pori-addons-elementor' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'پوریا زمانی', 'pori-addons-elementor' ),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'pori_testimonial_url',
			[
				'label' => __( 'لینک', 'pori-addons-elementor' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://porii.ir', 'pori-addons-elementor' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);

		$this->add_control(
			'pori_testimonial_designation',
			[
				'label'   => esc_html__( 'سمت', 'pori-addons-elementor' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'مدیر عامل', 'pori-addons-elementor' ),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'pori_testimonial_enable_rating',
			[
				'label'   => esc_html__( 'نمایش امتیاز', 'pori-addons-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'no'
			]
		);

		$this->add_control(
			'pori_testimonial_rating_icon',
			[
				'label' => __( 'Rating Icon', 'pori-addons-elementor' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => false,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
				'skin' => 'inline',
				'exclude_inline_options' => ['svg'],
				'condition' => [
					'pori_testimonial_enable_rating' => 'yes'
				]
			]
		);

		$rating_number = range( 1, 5 );
        $rating_number = array_combine( $rating_number, $rating_number );

		$this->add_control(
		  	'pori_testimonial_rating_number',
		  	[
				'label'   => __( 'عدد امتیاز', 'pori-addons-elementor' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 5,
				'options' => $rating_number,
				'condition' => [
					'pori_testimonial_enable_rating' => 'yes'
				]
		  	]
		);

		$this-> end_controls_section();

		/**
		 * Testimonial Container Style Section
		 */

		$this->start_controls_section(
			'pori_testimonial_container_section_style',
			[
				'label' => esc_html__( 'کلیت', 'pori-addons-elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control(
			'pori_testimonial_layout',
			[
				'label' => __( 'نوع', 'pori-addons-elementor' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'layout-1',
				'options' => [
					'layout-1'  => __( '1', 'pori-addons-elementor' ),
					'layout-2' => __( '2', 'pori-addons-elementor' ),
				],
			]
		);

		$this->add_control(
			'pori_testimonial_container_alignment',
			[
				'label'   => __( 'چینش', 'pori-addons-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'toggle'  => false,
				'default' => 'pori-testimonial-align-left',
				'options' => [
					'pori-testimonial-align-left'   => [
						'title' => __( 'Left', 'pori-addons-elementor' ),
						'icon'  => 'eicon-arrow-left'
					],
					'pori-testimonial-align-center' => [
						'title' => __( 'Center', 'pori-addons-elementor' ),
						'icon'  => 'eicon-arrow-up'
					],
					'pori-testimonial-align-right'  => [
						'title' => __( 'Right', 'pori-addons-elementor' ),
						'icon'  => 'eicon-arrow-right'
					],
					'pori-testimonial-align-bottom' => [
						'title' => __( 'Bottom', 'pori-addons-elementor' ),
						'icon'  => 'eicon-arrow-down'
					]
				]
			]
		);

		$this->add_responsive_control(
			'pori_testimonial_container_padding',
			[
				'label'      => __( 'فاصله', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'separator'  => 'before',
				'default'    => [
					'top'    => '20',
					'right'  => '20',
					'bottom' => '20',
					'left'   => '20'
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-testimonial-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_testimonial_container_radius',
			[
				'label'      => __( 'حاشیه لبه', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'    => '10',
					'right'  => '10',
					'bottom' => '10',
					'left'   => '10'
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-testimonial-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->start_controls_tabs( 'pori_testimonial_container_tabs' );

			$this->start_controls_tab( 'pori_testimonial_container_normal', [ 'label' => esc_html__( 'Normal', 'pori-addons-elementor' ) ] );

				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name'      => 'pori_testimonial_container_background',
						'types'     => [ 'classic', 'gradient' ],
						'selector'  => '{{WRAPPER}} .pori-testimonial-wrapper'
					]
				);

				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name'            => 'pori_testimonial_container_border',
						'fields_options'  => [
							'border'      => [
								'default' => 'solid'
							],
							'width'          => [
								'default'    => [
									'top'    => '1',
									'right'  => '1',
									'bottom' => '1',
									'left'   => '1'
								]
							],
							'color'       => [
								'default' => '#e3e3e3'
							]
						],
						'selector'        => '{{WRAPPER}} .pori-testimonial-wrapper'
					]
				);

				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name'     => 'pori_testimonial_container_box_shadow',
						'selector' => '{{WRAPPER}} .pori-testimonial-wrapper'
					]
				);

			$this->end_controls_tab();
	
			$this->start_controls_tab( 'pori_testimonial_container_hover', [ 'label' => esc_html__( 'Hover', 'pori-addons-elementor' ) ] );

				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name'      => 'pori_testimonial_container_background_hover',
						'types'     => [ 'classic' ],
						'selector'  => '{{WRAPPER}} .pori-testimonial-wrapper:hover'
					]
				);

				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name'            => 'pori_testimonial_container_border_hover',
						'fields_options'  => [
							'border'      => [
								'default' => 'solid'
							],
							'عرض'          => [
								'default'    => [
									'top'    => '1',
									'right'  => '1',
									'bottom' => '1',
									'left'   => '1'
								]
							],
							'color'       => [
								'default' => '#e3e3e3'
							]
						],
						'selector'        => '{{WRAPPER}} .pori-testimonial-wrapper:hover'
					]
				);

				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name'     => 'pori_testimonial_container_box_shadow_hover',
						'selector' => '{{WRAPPER}} .pori-testimonial-wrapper:hover'
					]
				);

			$this->end_controls_tab();

		$this->end_controls_tabs();	

		$this->add_control(
			'pori_testimonial_container_transition_top',
            [
				'label'        => __( 'افکت پرش', 'pori-addons-elementor' ),
				'type'         =>  Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'pori-addons-elementor' ),
				'label_off'    => __( 'Hide', 'pori-addons-elementor' ),
				'separator'   => 'before',
				'return_value' => 'yes',
				'default'      => 'yes'
			]
        );

		$this-> end_controls_section();

		/**
		 * testimonial Review Image style
		 */
		$this->start_controls_section(
			'pori_testimonial_image_style',
			[
				'label' => esc_html__( 'عکس', 'pori-addons-elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control(
			'pori_testimonial_image_box',
			[
				'label'        => __( 'جعبه عکس', 'pori-addons-elementor' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'ON', 'pori-addons-elementor' ),
				'label_off'    => __( 'OFF', 'pori-addons-elementor' ),
				'return_value' => 'yes',
				'default'      => 'yes'
			]
		);

		$this->add_responsive_control(
			'pori_testimonial_image_box_height',
			[
				'label'       => __( 'ارتفاع', 'pori-addons-elementor' ),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => [ 'px' ],
				'range'       => [
					'px'      => [
						'min' => 0,
						'max' => 500
					]
				],
				'default'     => [
					'unit'    => 'px',
					'size'    => 80
				],
				'selectors'   => [
					'{{WRAPPER}} .pori-testimonial-thumb'=> 'height: {{SIZE}}{{UNIT}};'
				],
				'condition'   => [
					'pori_testimonial_image_box' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'pori_testimonial_image_box_width',
			[
				'label'       => __( 'عرض', 'pori-addons-elementor' ),
				'type'        => Controls_Manager::SLIDER,
				'separator'   => 'after',
				'range'       => [
					'px'      => [
						'min' => 0,
						'max' => 500
					]
				],
				'default'     => [
					'unit'    => 'px',
					'size'    => 80
				],
				'selectors'   => [
					'{{WRAPPER}} .pori-testimonial-thumb'=> 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .pori-testimonial-image-align-left .pori-testimonial-thumb, {{WRAPPER}} .pori-testimonial-image-align-right .pori-testimonial-thumb'=> 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .pori-testimonial-image-align-left .pori-testimonial-reviewer, {{WRAPPER}} .pori-testimonial-image-align-right .pori-testimonial-reviewer'=> 'width: calc( 100% - {{SIZE}}{{UNIT}} );',
					'{{WRAPPER}} .pori-testimonial-wrapper.pori-testimonial-align-left .pori-testimonial-content-wrapper-arrow::before'=> 'left: calc( {{SIZE}}{{UNIT}} / 2 );',
					'{{WRAPPER}} .pori-testimonial-wrapper.pori-testimonial-align-right .pori-testimonial-content-wrapper-arrow::before'=> 'right: calc(( {{SIZE}}{{UNIT}} / 2) - 10px);'
				],
				'condition'   => [
					'pori_testimonial_image_box' => 'yes'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'pori_testimonial_image_box_border',
				'selector'  => '{{WRAPPER}} .pori-testimonial-thumb',
				'condition' => [
					'pori_testimonial_image_box' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'pori_testimonial_image_box_radius',
			[
				'label'      => __( 'حاشیه لبه', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'    => '50',
					'right'  => '50',
					'bottom' => '50',
					'left'   => '50',
					'unit'   => '%'
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-testimonial-thumb'     => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .pori-testimonial-thumb img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'pori_testimonial_image_box_shadow',
				'selector' => '{{WRAPPER}} .pori-testimonial-thumb'
			]
		);

		$this->add_responsive_control(
			'pori_testimonial_image_box_margin_bottom',
			[
				'label'       => __( 'فاصله از پایین', 'pori-addons-elementor' ),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => [ 'px' ],
				'range'       => [
					'px'      => [
						'min' => -500,
						'max' => 500
					]
				],
				'default'     => [
					'unit'    => 'px',
					'size'    => 0
				],
				'selectors'   => [
					'{{WRAPPER}} .pori-testimonial-thumb'=> 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
				'condition'   => [
					'pori_testimonial_container_alignment' => 'pori-testimonial-align-bottom'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			[
				'name' => 'pori_testimonial_image_box_css_filter',
				'selector' => '{{WRAPPER}} .pori-testimonial-thumb img',
			]
		);

		$this-> end_controls_section();

		/**
		 * Testimonial Testimonial Style Section
		 */
		$this->start_controls_section(
			'pori_testimonial_description_style',
			[
				'label' => esc_html__( 'نظرات', 'pori-addons-elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'pori_testimonial_description_typography',
				'selector' => '{{WRAPPER}} .pori-testimonial-description'
			]
		);

		$this->add_control(
			'pori_testimonial_description_color',
			[
				'label'     => __( 'رنگ متن', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#001659',
				'selectors' => [
					'{{WRAPPER}} .pori-testimonial-description' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_control(
			'pori_testimonial_description_bg_color',
			[
				'label'     => __( 'رنگ زمینه', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pori-testimonial-content-wrapper'               => 'background: {{VALUE}};',
					'{{WRAPPER}} .pori-testimonial-content-wrapper-arrow::before' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_testimonial_description_radius',
			[
				'label'      => __( 'حاشیه لبه', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'    => '0',
					'right'  => '0',
					'bottom' => '0',
					'left'   => '0'
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-testimonial-content-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_testimonial_description_spacing_bottom',
			[
				'label'       => __( 'فاصله پایین', 'pori-addons-elementor' ),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => [ 'px' ],
				'range'       => [
					'px'      => [
						'min' => 0,
						'max' => 100
					]
				],
				'default'     => [
					'unit'    => 'px',
					'size'    => 20
				],
				'selectors'   => [
					'{{WRAPPER}} .pori-testimonial-content-wrapper' => 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
				'condition' => [
					'pori_testimonial_layout' => 'layout-1'
				]
			]
		);

		$this->add_responsive_control(
			'pori_testimonial_description_spacing_top',
			[
				'label'       => __( 'فاصله بالا', 'pori-addons-elementor' ),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => [ 'px' ],
				'range'       => [
					'px'      => [
						'min' => 0,
						'max' => 100
					]
				],
				'default'     => [
					'unit'    => 'px',
					'size'    => 20
				],
				'selectors'   => [
					'{{WRAPPER}} .pori-testimonial-content-wrapper' => 'margin-top: {{SIZE}}{{UNIT}};'
				],
				'condition' => [
					'pori_testimonial_layout' => 'layout-2'
				]
			]
		);

		$this->add_responsive_control(
			'pori_testimonial_description_padding',
			[
				'label'      => __( 'فاصله', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'    => '0',
					'right'  => '0',
					'bottom' => '0',
					'left'   => '0'
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-testimonial-content-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'pori_testimonial_description_box_shadow',
				'selector' => '{{WRAPPER}} .pori-testimonial-content-wrapper'
			]
		);

		$this->add_control(
			'pori_testimonial_description_arrow_enable',
			[
				'label'        => __( 'نمایش پیکان', 'pori-addons-elementor' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'ON', 'pori-addons-elementor' ),
				'label_off'    => __( 'OFF', 'pori-addons-elementor' ),
				'return_value' => 'yes',
				'default'      => 'no',
				'separator'    => 'before'
			]
		);

		$this-> end_controls_section();

		/**
		 * Testimonial Rating Style Section
		 */
		$this->start_controls_section(
			'pori_testimonial_rating_style',
			[
				'label'     => esc_html__( 'امتیاز', 'pori-addons-elementor' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'pori_testimonial_enable_rating' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'pori_testimonial_rating_size',
			[
				'label'       => __( 'سایز آیکون', 'pori-addons-elementor' ),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => [ 'px', '%' ],
				'range'       => [
					'px'      => [
						'min' => 0,
						'max' => 50
					]
				],
				'default'     => [
					'unit'    => 'px',
					'size'    => 20
				],
				'selectors'   => [
					'{{WRAPPER}} .pori-testimonial-ratings li i' => 'font-size: {{SIZE}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_testimonial_rating_icon_margin',
			[
				'label'       => __( 'فاصله آیکون', 'pori-addons-elementor' ),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => [ 'px', '%' ],
				'range'       => [
					'px'      => [
						'min' => 0,
						'max' => 30
					]
				],
				'default'     => [
					'unit'    => 'px',
					'size'    => 5
				],
				'selectors'   => [
					'{{WRAPPER}} .pori-testimonial-ratings li:not(:last-child) i' => 'margin-right: {{SIZE}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_testimonial_rating_margin',
			[
				'label'        => __( 'حاشیه', 'pori-addons-elementor' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'default'      => [
					'top'      => '20',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'isLinked' => false
				],
				'selectors'    => [
					'{{WRAPPER}} .pori-testimonial-ratings' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		

		$this->start_controls_tabs( 'pori_testimonial_rating_tabs' );

			// normal state rating
			$this->start_controls_tab( 'pori_testimonial_rating_normal', [ 'label' => esc_html__( 'Normal', 'pori-addons-elementor' ) ] );

				$this->add_control(
					'pori_testimonial_rating_normal_color',
					[
						'label'     => __( 'رنگ', 'pori-addons-elementor' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '#222222',
						'selectors' => [
							'{{WRAPPER}} .pori-testimonial-ratings li i' => 'color: {{VALUE}};'
						]
					]
				);

			$this->end_controls_tab();

			// hover state rating
			$this->start_controls_tab( 'pori_testimonial_rating_active', [ 'label' => esc_html__( 'Active', 'pori-addons-elementor' ) ] );

				$this->add_control(
					'pori_testimonial_rating_active_color',
					[
						'label'     => __( 'رنگ', 'pori-addons-elementor' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '#ffc600',
						'selectors' => [
							'{{WRAPPER}} .pori-testimonial-ratings li.pori-testimonial-ratings-active i' => 'color: {{VALUE}};'
						]
					]
				);

			$this->end_controls_tab();

		$this->end_controls_tabs();

		$this-> end_controls_section();

		/**
		 * Testimonial Riviewer Style Section
		 */
		$this->start_controls_section(
			'pori_testimonial_reviewer_style',
			[
				'label' => esc_html__( 'نظر دهنده', 'pori-addons-elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_responsive_control(
			'pori_testimonial_reviewer_padding',
			[
				'label'      => __( 'فاصله', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'    => '0',
					'right'  => '0',
					'bottom' => '0',
					'left'   => '0'
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-testimonial-reviewer-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_testimonial_reviewer_spacing',
			[
				'label'       => __( 'فضا', 'pori-addons-elementor' ),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => [ 'px' ],
				'range'       => [
					'px'      => [
						'min' => 0,
						'max' => 100
					]
				],
				'default'     => [
					'unit'    => 'px',
					'size'    => 20
				],
				'selectors'   => [
					'{{WRAPPER}} .pori-testimonial-wrapper.pori-testimonial-align-left .pori-testimonial-reviewer-wrapper .pori-testimonial-reviewer' => 'padding-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .pori-testimonial-wrapper.pori-testimonial-align-right .pori-testimonial-reviewer-wrapper .pori-testimonial-reviewer' => 'padding-right: {{SIZE}}{{UNIT}};'
				],
				'condition'   => [
					'pori_testimonial_container_alignment' => ['pori-testimonial-align-left', 'pori-testimonial-align-right']
				]
			]
		);

		/**
		 * Testimonial Title Style Section
		 */
		$this->add_control(
			'pori_testimonial_title_style',
			[
				'label'     => __( 'عنوان نظر دهنده', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'             => 'pori_testimonial_title_typography',
				'selector'         => '{{WRAPPER}} .pori-testimonial-name',
				'fields_options'   => [
					'font_size'    => [
		                'default'  => [
		                    'unit' => 'px',
		                    'size' => 22
		                ]
		            ],
		            'font_weight'  => [
		                'default'  => '600'
		            ]
	            ]
			]
		);

		$this->start_controls_tabs( 'pori_testimonial_title_tabs' );

			// normal state rating
			$this->start_controls_tab( 'pori_testimonial_title_normal', [ 'label' => esc_html__( 'Normal', 'pori-addons-elementor' ) ] );

				$this->add_control(
					'pori_testimonial_title_color',
					[
						'label'     => __( 'رنگ', 'pori-addons-elementor' ),
						'type'      => Controls_Manager::COLOR,
						'default'   => '#000000',
						'selectors' => [
							'{{WRAPPER}} .pori-testimonial-name' => 'color: {{VALUE}};'
						]
					]
				);

			$this->end_controls_tab();

			// hover state rating
			$this->start_controls_tab( 'pori_testimonial_title_hover', [ 'label' => esc_html__( 'Hover', 'pori-addons-elementor' ) ] );

				$this->add_control(
					'pori_testimonial_title_color_hover',
					[
						'label'     => __( 'رنگ', 'pori-addons-elementor' ),
						'type'      => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .pori-testimonial-name:hover' => 'color: {{VALUE}};'
						]
					]
				);

			$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_responsive_control(
			'pori_testimonial_title_margin',
			[
				'label'      => __( 'حاشیه', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'    => '0',
					'right'  => '0',
					'bottom' => '0',
					'left'   => '0'
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-testimonial-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		// Testimonial Designation Style Section
		$this->add_control(
			'pori_testimonial_designation_style',
			[
				'label'     => __( 'سمت', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'             => 'pori_testimonial_designation_typography',
				'selector'         => '{{WRAPPER}} .pori-testimonial-designation',
				'fields_options'   => [
					'font_size'    => [
		                'default'  => [
		                    'unit' => 'px',
		                    'size' => 14
		                ]
		            ],
		            'font_weight'  => [
		                'default'  => '600'
		            ]
	            ]
			]
		);

		$this->add_control(
			'pori_testimonial_designation_color',
			[
				'label'     => __( 'رنگ', 'pori-addons-elementor' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#333333',
				'selectors' => [
					'{{WRAPPER}} .pori-testimonial-designation' => 'color: {{VALUE}};'
				]
			]
		);

		$this->add_responsive_control(
			'pori_testimonial_designation_margin',
			[
				'label'      => __( 'حاشیه', 'pori-addons-elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'    => '0',
					'right'  => '0',
					'bottom' => '0',
					'left'   => '0'
				],
				'selectors'  => [
					'{{WRAPPER}} .pori-testimonial-designation' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this-> end_controls_section();
	}

	private function render_testimonial_rating( $ratings ) {
		$settings = $this->get_settings_for_display();
		
		for( $i = 1; $i <= 5; $i++ ) {
			if( $ratings >= $i ) {
				$rating_active_class = '<li class="pori-testimonial-ratings-active"><i class="'.$settings['pori_testimonial_rating_icon']['value'].'"></i></li>';
			} else {
				$rating_active_class = '<li><i class="'.$settings['pori_testimonial_rating_icon']['value'].'"></i></li>';
			}
			echo $rating_active_class;
		}
	}

	private function render_testimonial_image( $image_url ) {
		$output = '';
		if ( !empty( $image_url ) ) :
			$output .= '<div class="pori-testimonial-thumb">';
				$output .= $image_url;
			$output .= '</div>';
		endif;
		return $output;
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$testimonial_image_url_html = Group_Control_Image_Size::get_attachment_image_html( $settings, 'testimonial_thumbnail', 'pori_testimonial_image' );
		$transition_top = '';

		$target = $settings['pori_testimonial_url']['is_external'] ? ' target="_blank"' : '';
		$nofollow = $settings['pori_testimonial_url']['nofollow'] ? ' rel="nofollow"' : '';

		$this->add_inline_editing_attributes( 'pori_testimonial_name', 'basic' );
		$this->add_render_attribute( 'pori_testimonial_name', 'class', 'pori-testimonial-name' );

		$this->add_inline_editing_attributes( 'pori_testimonial_designation', 'basic' );
		$this->add_render_attribute( 'pori_testimonial_designation', 'class', 'pori-testimonial-designation' );

		$this->add_inline_editing_attributes( 'pori_testimonial_description', 'intermediate' );
		$this->add_render_attribute( 'pori_testimonial_description', 'class', 'pori-testimonial-description' );

		$this->add_render_attribute( 'pori_testimonial_content_wrapper', 'class', 'pori-testimonial-content-wrapper' );

		if ( 'yes' === $settings['pori_testimonial_description_arrow_enable'] ){
			$this->add_render_attribute( 'pori_testimonial_content_wrapper', 'class', 'pori-testimonial-content-wrapper-arrow' );
		}
		if ( 'yes' === $settings['pori_testimonial_container_transition_top'] ){
			$transition_top = 'pori-testimonial-transition-top-'.$settings['pori_testimonial_container_transition_top'];
		}
		?>

		<div class="pori-testimonial-wrapper <?php echo esc_attr( $settings['pori_testimonial_container_alignment'] ).' '.$transition_top; ?>">
			<div class="pori-testimonial-wrapper-inner <?php echo $settings['pori_testimonial_layout']; ?>">
			<?php
				if( 'layout-1' === $settings['pori_testimonial_layout'] ) { ?>

					<div <?php echo $this->get_render_attribute_string( 'pori_testimonial_content_wrapper' ); ?>>
					<?php
						if ( !empty( $settings['pori_testimonial_description'] ) ) : ?>
							<p <?php echo $this->get_render_attribute_string( 'pori_testimonial_description' ); ?>><?php echo wp_kses_post( $settings['pori_testimonial_description'] ); ?></p>
							<?php
							if ( 'yes' === $settings['pori_testimonial_enable_rating'] ) : ?>
								<ul class="pori-testimonial-ratings">
									<?php echo $this->render_testimonial_rating( $settings['pori_testimonial_rating_number'] ); ?>
								</ul>
							<?php	
							endif;
						endif;
						?>
					</div>
					<?php	
				}
				?>
				<div class="pori-testimonial-reviewer-wrapper">
				<?php
					if( 'pori-testimonial-align-bottom' !== $settings['pori_testimonial_container_alignment'] ) :
						echo $this->render_testimonial_image( $testimonial_image_url_html );
					endif;
					?>
					<div class="pori-testimonial-reviewer">
					<?php
						if ( !empty( $settings['pori_testimonial_name'] ) ) : ?>
							<a href="<?php echo $settings['pori_testimonial_url']['url']; ?>" <?php echo $target; ?> <?php echo $nofollow; ?>>
								<h4 <?php echo $this->get_render_attribute_string( 'pori_testimonial_name' ); ?>><?php echo ( $settings['pori_testimonial_name'] ); ?></h4>
							</a>
						<?php	
						endif;
						if ( !empty( $settings['pori_testimonial_designation'] ) ) : ?>
							<span <?php echo $this->get_render_attribute_string( 'pori_testimonial_designation' ); ?>><?php echo ( $settings['pori_testimonial_designation'] ); ?></span>
						<?php	
						endif;
						?>
					</div>					

					<?php	
					if( 'pori-testimonial-align-bottom' === $settings['pori_testimonial_container_alignment'] ) :
						echo $this->render_testimonial_image( $testimonial_image_url_html );
					endif;
					?>
				</div>
				<?php
				if( 'layout-2' === $settings['pori_testimonial_layout'] ) { ?>

					<div <?php echo $this->get_render_attribute_string( 'pori_testimonial_content_wrapper' ); ?>>
					<?php
						if ( !empty( $settings['pori_testimonial_description'] ) ) : ?>
							<p <?php echo $this->get_render_attribute_string( 'pori_testimonial_description' ); ?>><?php echo wp_kses_post( $settings['pori_testimonial_description'] ); ?></p>
							<?php
							if ( 'yes' === $settings['pori_testimonial_enable_rating'] ) : ?>
								<ul class="pori-testimonial-ratings">
								<?php
									$this->render_testimonial_rating( $settings['pori_testimonial_rating_number'] ); ?>
								</ul>
							<?php	
							endif;
						endif;
						?>
					</div>
				<?php	
				}
				?>
			</div>
		</div>
	<?php	
	}
	
	/**
     * Render testimonial widget output in the editor.
     *
     * Written as a Backbone JavaScript template and used to generate the live preview.
     *
     * @since 1.0.0
     * @access protected
     */
	protected function content_template() {
		?>
		<#
			view.addRenderAttribute( 'pori_testimonial_content_wrapper', 'class', 'pori-testimonial-content-wrapper' );
			if ( 'yes' === settings.pori_testimonial_description_arrow_enable ) {
	        	view.addRenderAttribute( 'pori_testimonial_content_wrapper', 'class', 'pori-testimonial-content-wrapper-arrow' );
	      	}

	      	view.addInlineEditingAttributes( 'pori_testimonial_name', 'basic' );
	      	view.addRenderAttribute( 'pori_testimonial_name', 'class', 'pori-testimonial-name' );

	      	view.addInlineEditingAttributes( 'pori_testimonial_designation', 'basic' );
			view.addRenderAttribute( 'pori_testimonial_designation', 'class', 'pori-testimonial-designation' );

	      	view.addInlineEditingAttributes( 'pori_testimonial_description', 'intermediate' );
	      	view.addRenderAttribute( 'pori_testimonial_description', 'class', 'pori-testimonial-description' );

			var target = settings.pori_testimonial_url.is_external ? ' target="_blank"' : '';
			var nofollow = settings.pori_testimonial_url.nofollow ? ' rel="nofollow"' : '';

	      	if ( settings.pori_testimonial_image.url || settings.pori_testimonial_image.id ) {
				var image = {
					id: settings.pori_testimonial_image.id,
					url: settings.pori_testimonial_image.url,
					size: settings.testimonial_thumbnail_size,
					dimension: settings.testimonial_thumbnail_custom_dimension,
					model: view.getEditModel()
				};

				var imageURL = elementor.imagesManager.getImageUrl( image );
			}

			if ( 'yes' === settings.pori_testimonial_container_transition_top ){
				var transition_top = 'pori-testimonial-transition-top-' + settings.pori_testimonial_container_transition_top ;
			}
		#>

		<div class="pori-testimonial-wrapper {{ settings.pori_testimonial_container_alignment }} {{ transition_top }}">
	        <div class="pori-testimonial-wrapper-inner {{ settings.pori_testimonial_layout }}">
				<# if( 'layout-1' === settings.pori_testimonial_layout ){ #>
					<div {{{ view.getRenderAttributeString( 'pori_testimonial_content_wrapper' ) }}}>
						<# if ( settings.pori_testimonial_description ) { #>
							<p {{{ view.getRenderAttributeString( 'pori_testimonial_description' ) }}}>
								{{{ settings.pori_testimonial_description }}}
							</p>
							<# if ( 'yes' === settings.pori_testimonial_enable_rating ) { #>
								
								<ul class="pori-testimonial-ratings">
									<#
										var $ratings = settings.pori_testimonial_rating_number;
										var $rating_active_class = '';
										for( var $i = 1; $i <= 5; $i++ ) {
											if( $ratings >= $i ) { #>
											<li class="pori-testimonial-ratings-active"><i class="{{ settings.pori_testimonial_rating_icon.value }}"></i></li>
											<# } else { #>
											<li><i class="{{ settings.pori_testimonial_rating_icon.value }}"></i></li>
											<# }
										} 
									#>
								</ul>

							<# } #>
						<# } #>
					</div>
				<# } #>

	            <div class="pori-testimonial-reviewer-wrapper">
					<# if( 'pori-testimonial-align-bottom' !== settings.pori_testimonial_container_alignment ) { #>	
						<# if ( imageURL ) { #>
					    	<div class="pori-testimonial-thumb">
								<img src="{{{ imageURL }}}">
							</div>
						<# } #>
					<# } #>

					<div class="pori-testimonial-reviewer">
						<# if ( settings.pori_testimonial_name ) { #>
							<a href="{{ settings.pori_testimonial_url.url }}"{{ target }}{{ nofollow }}>
								<h4 {{{ view.getRenderAttributeString( 'pori_testimonial_name' ) }}}>
									{{{ settings.pori_testimonial_name }}}
								</h4>
							</a>
						<# } #>
						<# if ( settings.pori_testimonial_designation ) { #>
							<span  {{{ view.getRenderAttributeString( 'pori_testimonial_designation' ) }}}>
								{{{ settings.pori_testimonial_designation }}}
							</span>
						<# } #>
					</div>

					<# if( 'pori-testimonial-align-bottom' === settings.pori_testimonial_container_alignment ) { #>
						<# if ( imageURL ) { #>
					    	<div class="pori-testimonial-thumb">
								<img src="{{{ imageURL }}}">
							</div>
						<# } #>
					<# } #>					
	        	</div>
				<# if( 'layout-2' === settings.pori_testimonial_layout ){ #>
					<div {{{ view.getRenderAttributeString( 'pori_testimonial_content_wrapper' ) }}}>
						<# if ( settings.pori_testimonial_description ) { #>
							<p {{{ view.getRenderAttributeString( 'pori_testimonial_description' ) }}}>
								{{{ settings.pori_testimonial_description }}}
							</p>
							<# if ( 'yes' === settings.pori_testimonial_enable_rating ) { #>
								
								<ul class="pori-testimonial-ratings">
									<#
										var $ratings = settings.pori_testimonial_rating_number;
										var $rating_active_class = '';
										for( var $i = 1; $i <= 5; $i++ ) {
											if( $ratings >= $i ) { #>
											<li class="pori-testimonial-ratings-active"><i class="{{ settings.pori_testimonial_rating_icon.value }}"></i></li>
											<# } else { #>
											<li><i class="{{ settings.pori_testimonial_rating_icon.value }}"></i></li>
											<# }
										}
									#>
								</ul>

							<# } #>
						<# } #>
					</div>
				<# } #>
	        </div>
	    </div>
		<?php
	}
}