<?php
/*
 * Bina wordpress theme / bina addon ext
 * Author: pouria zamani
 * URL: https://porii.ir
 */
/**
 * Elementor sarh Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Pori_title2_bina extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve sarh widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'sarh2';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve sarh widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'عنوان دو', 'Bina-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve sarh widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-archive-title';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the sarh widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'Bina-category' ];
	}

	/**
	 * Register sarh widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		

        // sarh Sub Title
		$this->add_control(
			'sarh_sub_title',
			[
				'label' => __( 'زیر عنوان', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'placeholder' => __( 'زیر عنوان', 'Bina-extension' ),
				'default'     => esc_html__( 'قالب شرکتی بینا کاملا ریسپانسیو و حرفه ای' ),
                'separator'=> 'before',
			]
        );
        // sarh Sub Title
		$this->add_control(
			'sarh_sub_title2',
			[
				'label' => __( 'زیر عنوان رنگی', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'placeholder' => __( 'زیر عنوان', 'Bina-extension' ),
				'default'     => esc_html__( 'خدمات' ),
                'separator'=> 'before',
			]
        );
        // sarh Title
		$this->add_control(
			'sarh_title',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default'     => esc_html__( ' فناوری آی تی چیست' ),
				'placeholder' => __( 'Write sarh Title Here', 'Bina-extension' ),
			]
        );

		
        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل', 'Bina-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
        );

		
        // Sub Title Options
		$this->add_control(
			'sarhe_subtitle_heading',
			[
				'label' => __( 'زیر عنوان', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Sub Title Color
        $this->add_control(
			'sarhe_subtitl_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#001957',
				'selectors' => [
					'{{WRAPPER}} .pori-element-content-heading' => 'color: {{VALUE}}',
				],
			]
        );
        // Sub Title Color
        $this->add_control(
			'sarhe_subtitbl_color',
			[
				'label' => __( 'رنگ کلمه رنگی', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#ffc500',
				'selectors' => [
					'{{WRAPPER}} .pori-element-content-heading span' => 'color: {{VALUE}}',
				],
			]
        );
        // Sub Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'sarhe_subtitl_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-element-content-heading ,.pori-element-content-heading span',
			]
        );
        
        // Title Options
		$this->add_control(
			'title_heading',
			[
				'label' => __( 'عنوان', 'Bina-extension' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
		);

        // Title Color
        $this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ', 'Bina-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
                ],
                'default' => '#001957',
				'selectors' => [
					'{{WRAPPER}} .pori-element-subhead' => 'color: {{VALUE}}',
				],
			]
        );
        
        // Title Typography 
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'فونت', 'Bina-extension' ),
				'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .pori-element-subhead',
			]
        );

		
        
        $this->end_controls_section();
	}

	/**
	 * Render sarh widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HporiL.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $sarh_sub_title = $settings['sarh_sub_title'];
		$sarh_sub_title2 = $settings['sarh_sub_title2'];
        $sarh_title = $settings['sarh_title'];
       

		
    ?>
	
<div class="pori-content-header">
	<h4 class="pori-element-subhead">
		<?php echo $sarh_title; ?>
	</h4>
		<h2 class="pori-element-content-heading">
			<?php echo $sarh_sub_title; ?>
			<span><?php echo $sarh_sub_title2; ?></span>
		</h2>
</div>	


<?php
	}

}